/* toolitem.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Port from original sugar-toolkit project.
 * File:   src/sugar/graphics/toolbutton.py
 *         src/sugar/graphics/toggletoolbutton.py
 *         src/sugar/graphics/radiotoolbutton.py
 * Commit: 161aec771e058416d672c36b3129cc4a1a11c7e2
 *
 * Copyright (C) 2007, Red Hat, Inc.
 * Copyright (C) 2008, One Laptop Per Child
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

public class Sugar.ToolButton : Gtk.ToolButton {
    public Invoker invoker { get; private set; }

    /** Set a simple palette with just a single label */
    public string tooltip {
        get {
            return _tooltip;
        }
        set {
            _tooltip = value;
            if (invoker.palette == null)
                invoker.palette = new Palette ();
            invoker.palette.primary_text = tooltip;
            label = tooltip;
        }
    }

    public string? accelerator {
        get { return _accelerator.name; }
        set { _accelerator.name = value; }
    }

    public new string? icon_name {
        set {
            if (value == null)
                icon_widget = null;
            else {
                var icon = new Icon ();
                icon.file = value;
                icon.show ();
                set_icon_widget (icon);
            }
        }
    }

    public Icon? icon {
        get {
            return icon_widget as Icon;
        }
    }

    construct {
        _accelerator = new Accelerator (this, "clicked");
        invoker = new Invoker (new ToolConnector (this));
    }

    public override void clicked () {
        invoker.popdown ();
    }

    public override void hierarchy_changed (Gtk.Widget? previous_toplevel) {
        if (child != null)
            child.state = Gtk.StateType.NORMAL;
    }

    public override bool expose_event (Gdk.EventExpose event) {
        _expose_event (this, invoker, event);
        return base.expose_event (event);
    }

    private Accelerator _accelerator;
    private string _tooltip;
}

public class Sugar.ComboToolButton : Sugar.ToolButton {
    public Gtk.RadioAction action {
        get {
            return _action;
        }
        set {
            if (action != null) {
                action.notify["sensitive"].disconnect (_action_sensitive_cb);
                action.changed.disconnect (_action_changed_cb);
            }

            _action = value;

            if (action != null) {
                action.notify["sensitive"].connect (_action_sensitive_cb);
                action.changed.connect (_action_changed_cb);
                _on_action_update ();
            }
        }
    }

    public override void clicked () {
        if (invoker.is_up && (invoker.palette_window == null ||
                        invoker.palette_window.secondary_visible))
            invoker.popdown ();
        else
            invoker.popup ();
    }

    private void _action_sensitive_cb (Object sender, ParamSpec param) {
        _on_action_update ();
    }

    private void _action_changed_cb (Gtk.RadioAction current) {
        _on_action_update ();
    }

    private void _on_action_update () {
        foreach (var i in action.get_group ()) {
            if (i.value == i.current_value)
                icon_name = i.icon_name;
            i.sensitive = action.sensitive;
        }

        if (icon != null) {
            icon.sensitive = action.sensitive;
            icon.queue_draw ();
        }
    }

    private Gtk.RadioAction _action;
}

public class Sugar.ToggleToolButton : Gtk.ToggleToolButton {
    public Invoker invoker { get; private set; }

    /** Set a simple palette with just a single label */
    public string tooltip {
        get {
            return _tooltip;
        }
        set {
            _tooltip = value;
            if (invoker.palette == null)
                invoker.palette = new Palette ();
            invoker.palette.primary_text = tooltip;
            label = tooltip;
        }
    }

    public string? accelerator {
        get { return _accelerator.name; }
        set { _accelerator.name = value; }
    }

    public new string? icon_name {
        set {
            if (value == null)
                icon_widget = null;
            else {
                var icon = new Icon ();
                icon.file = value;
                icon.show ();
                set_icon_widget (icon);
            }
        }
    }

    public Icon? icon {
        get {
            return icon_widget as Icon;
        }
    }

    construct {
        _accelerator = new Accelerator (this, "clicked");
        invoker = new Invoker (new ToolConnector (this));
    }

    public override void clicked () {
        invoker.popdown ();
    }

    public override void hierarchy_changed (Gtk.Widget? previous_toplevel) {
        if (child != null)
            child.state = Gtk.StateType.NORMAL;
    }

    public override bool expose_event (Gdk.EventExpose event) {
        _expose_event (this, invoker, event);
        return base.expose_event (event);
    }

    private Accelerator _accelerator;
    private string _tooltip;
}

public class Sugar.RadioToolButton : Gtk.RadioToolButton {
    public Invoker invoker { get; private set; }

    /** Set a simple palette with just a single label */
    public string tooltip {
        get {
            return _tooltip;
        }
        set {
            _tooltip = value;
            if (invoker.palette == null)
                invoker.palette = new Palette ();
            invoker.palette.primary_text = tooltip;
            label = tooltip;
        }
    }

    public string? accelerator {
        get { return _accelerator.name; }
        set { _accelerator.name = value; }
    }

    public new string? icon_name {
        set {
            if (value == null)
                icon_widget = null;
            else {
                var icon = new Icon ();
                icon.file = value;
                icon.show ();
                set_icon_widget (icon);
            }
        }
    }

    public Icon? icon {
        get {
            return icon_widget as Icon;
        }
    }

    construct {
        _accelerator = new Accelerator (this, "clicked");
        invoker = new Invoker (new ToolConnector (this));
    }

    public override void clicked () {
        invoker.popdown ();
    }

    public override void hierarchy_changed (Gtk.Widget? previous_toplevel) {
        if (child != null)
            child.state = Gtk.StateType.NORMAL;
    }

    public override bool expose_event (Gdk.EventExpose event) {
        _expose_event (this, invoker, event);
        return base.expose_event (event);
    }

    private Accelerator _accelerator;
    private string _tooltip;
}

namespace Sugar {
    private void _expose_event (Gtk.ToolItem item, Invoker invoker,
            Gdk.EventExpose event) {
        if (invoker.palette_window != null && invoker.is_up)
            invoker.connector.draw_rectangle (event, invoker.palette_window);
        else if (item.child.state == Gtk.StateType.PRELIGHT)
            Gtk.paint_box (item.child.style, event.window,
                    Gtk.StateType.PRELIGHT, Gtk.ShadowType.NONE, event.area,
                    item.child, "toolbutton-prelight",
                    item.allocation.x, item.allocation.y,
                    item.allocation.width, item.allocation.height);
    }
}
