/* activity.c generated by valac 0.12.1, the Vala compiler
 * generated from activity.vala, do not modify */

/* activity.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/toolkit.h"
#include <polyol/ds.h>
#include <polyol/shell.h>
#include <polyol/collab.h>
#include <polyol/env.h>
#include <stdlib.h>
#include <string.h>
#include <polyol/gui.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_array_free0(var) ((var == NULL) ? NULL : (var = (g_array_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SugarActivityPrivate {
	SugarJobject* _jobject;
	SugarShell* _shell;
	SugarJournal* _journal;
	SugarConnection* _connection;
	gboolean _resumed;
};


static gpointer sugar_activity_parent_class = NULL;

#define SUGAR_ACTIVITY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_ACTIVITY, SugarActivityPrivate))
enum  {
	SUGAR_ACTIVITY_DUMMY_PROPERTY,
	SUGAR_ACTIVITY_JOBJECT,
	SUGAR_ACTIVITY_SHELL,
	SUGAR_ACTIVITY_JOURNAL,
	SUGAR_ACTIVITY_CONNECTION,
	SUGAR_ACTIVITY_RESUMED
};
static void sugar_activity_set_shell (SugarActivity* self, SugarShell* value);
static void sugar_activity_set_journal (SugarActivity* self, SugarJournal* value);
static void sugar_activity_set_jobject (SugarActivity* self, SugarJobject* value);
static void sugar_activity_set_connection (SugarActivity* self, SugarConnection* value);
static void _lambda0_ (SugarActivity* self);
static void __lambda0__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _sugar_activity_scope_changed_cb (SugarActivity* self, SugarShareScope prev_state, const gchar* _error_);
static void __sugar_activity_scope_changed_cb_sugar_connection_scope_changed (SugarConnection* _sender, SugarShareScope prev_scope, const gchar* _error_, gpointer self);
static void sugar_activity_real_dispose (GObject* base);
static void sugar_activity_real_write_file (SugarActivity* self, const gchar* file_path, gboolean transfer_ownership);
static void sugar_activity_finalize (GObject* obj);
static void _vala_sugar_activity_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_activity_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create activity instance
     *
     * @param use_journal   is activity going to (re)store Journal objects
     *                      if true, jobject will be set
     * @param use_sharing   is activity going to be shared
     *                      if true, connection will be set
     */
static void _lambda0_ (SugarActivity* self) {
	const gchar* _tmp0_ = NULL;
	_tmp0_ = sugar_jobject_get_title (self->priv->_jobject);
	sugar_connection_set_title (self->priv->_connection, _tmp0_);
}


static void __lambda0__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda0_ (self);
}


static void __sugar_activity_scope_changed_cb_sugar_connection_scope_changed (SugarConnection* _sender, SugarShareScope prev_scope, const gchar* _error_, gpointer self) {
	_sugar_activity_scope_changed_cb (self, prev_scope, _error_);
}


SugarActivity* sugar_activity_construct (GType object_type, gboolean use_journal, gboolean use_sharing) {
	SugarActivity * self = NULL;
	gboolean _tmp0_;
	SugarShell* _tmp1_ = NULL;
	SugarShell* _tmp2_;
	SugarJournal* _tmp3_ = NULL;
	SugarJournal* _tmp4_;
	self = (SugarActivity*) g_object_new (object_type, NULL);
	_tmp0_ = sugar_environ_get_initialized ();
	g_assert (_tmp0_);
	_tmp1_ = sugar_shell_new ();
	_tmp2_ = _tmp1_;
	sugar_activity_set_shell (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = sugar_journal_new ();
	_tmp4_ = _tmp3_;
	sugar_activity_set_journal (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	if (use_journal) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = sugar_environ_get_object_id ();
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_ = NULL;
			SugarJobject* _tmp7_ = NULL;
			SugarJobject* _tmp8_;
			_tmp6_ = sugar_environ_get_object_id ();
			_tmp7_ = sugar_jobject_find (_tmp6_);
			_tmp8_ = _tmp7_;
			sugar_activity_set_jobject (self, _tmp8_);
			_g_object_unref0 (_tmp8_);
		}
		if (self->priv->_jobject != NULL) {
			const gchar* _tmp9_ = NULL;
			_tmp9_ = sugar_jobject_get_uid (self->priv->_jobject);
			g_debug ("activity.vala:79: Journal entry %s was found", _tmp9_);
			self->priv->_resumed = TRUE;
		} else {
			SugarJobject* _tmp10_ = NULL;
			SugarJobject* _tmp11_;
			g_debug ("activity.vala:82: Create new Journal entry");
			_tmp10_ = sugar_jobject_create ();
			_tmp11_ = _tmp10_;
			sugar_activity_set_jobject (self, _tmp11_);
			_g_object_unref0 (_tmp11_);
		}
	}
	if (use_sharing) {
		SugarConnection* _tmp12_ = NULL;
		SugarConnection* _tmp13_;
		gboolean _tmp17_;
		_tmp12_ = sugar_connection_new ();
		_tmp13_ = _tmp12_;
		sugar_activity_set_connection (self, _tmp13_);
		_g_object_unref0 (_tmp13_);
		if (self->priv->_jobject != NULL) {
			const gchar* _tmp14_ = NULL;
			gboolean _tmp15_;
			g_signal_connect_object ((GObject*) self->priv->_jobject, "notify::title", (GCallback) __lambda0__g_object_notify, self, 0);
			_tmp14_ = sugar_jobject_get_title (self->priv->_jobject);
			sugar_connection_set_title (self->priv->_connection, _tmp14_);
			_tmp15_ = sugar_activity_get_resumed (self);
			if (_tmp15_) {
				SugarShareScope _tmp16_;
				_tmp16_ = sugar_jobject_get_share_scope (self->priv->_jobject);
				sugar_connection_set_scope (self->priv->_connection, _tmp16_);
			}
			g_signal_connect_object (self->priv->_connection, "scope-changed", (GCallback) __sugar_activity_scope_changed_cb_sugar_connection_scope_changed, self, 0);
		}
		_tmp17_ = sugar_activity_get_resumed (self);
		if (!_tmp17_) {
			gboolean _tmp18_;
			_tmp18_ = sugar_connection_get_shared (self->priv->_connection);
			if (!_tmp18_) {
				g_debug ("activity.vala:102: Activity isn't shared, will start in private mode");
			} else {
				g_debug ("activity.vala:104: Activity is already shared, will join");
				sugar_connection_set_scope (self->priv->_connection, SUGAR_SHARE_SCOPE_PUBLIC);
			}
		}
	}
	return self;
}


SugarActivity* sugar_activity_new (gboolean use_journal, gboolean use_sharing) {
	return sugar_activity_construct (SUGAR_TYPE_ACTIVITY, use_journal, use_sharing);
}


static void sugar_activity_real_dispose (GObject* base) {
	SugarActivity * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (SugarActivity*) base;
	if (self->priv->_jobject != NULL) {
		gboolean _tmp2_;
		_tmp2_ = sugar_activity_get_resumed (self);
		_tmp1_ = !_tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = sugar_jobject_get_uid (self->priv->_jobject);
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = sugar_jobject_get_uid (self->priv->_jobject);
		sugar_journal_show_object (self->priv->_journal, _tmp4_);
	}
	G_OBJECT_CLASS (sugar_activity_parent_class)->dispose (G_OBJECT (self));
}


/**
     * Write file to Journal object
     *
     * Makes sense only if Activity object was created with Journal support
     * i.e. use_journal constructor argument was true.
     *
     * @param file_path             path to the file to write
     * @param transfer_ownership    should sugar-datastore take ownership
     *                              of passed file_path
     */
static void sugar_activity_real_write_file (SugarActivity* self, const gchar* file_path, gboolean transfer_ownership) {
	GArray* _tmp0_ = NULL;
	GArray* _tmp1_;
	GArray* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_path != NULL);
	g_return_if_fail (self->priv->_jobject != NULL);
	_tmp0_ = sugar_get_preview (&_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	_tmp2_ = _tmp1_;
	sugar_jobject_set_preview (self->priv->_jobject, _tmp2_);
	_g_array_free0 (_tmp2_);
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("activity.vala:133: Cannot get preview: %s", _error_->message);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	sugar_jobject_write_file (self->priv->_jobject, file_path, transfer_ownership);
}


void sugar_activity_write_file (SugarActivity* self, const gchar* file_path, gboolean transfer_ownership) {
	SugarJobject* _tmp0_ = NULL;
	_tmp0_ = sugar_activity_get_jobject (self);
	g_return_if_fail (_tmp0_ != NULL);
	SUGAR_ACTIVITY_GET_CLASS (self)->write_file (self, file_path, transfer_ownership);
}


static void _sugar_activity_scope_changed_cb (SugarActivity* self, SugarShareScope prev_state, const gchar* _error_) {
	SugarShareScope _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_connection_get_scope (self->priv->_connection);
	sugar_jobject_set_share_scope (self->priv->_jobject, _tmp0_);
}


SugarJobject* sugar_activity_get_jobject (SugarActivity* self) {
	SugarJobject* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_jobject;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void sugar_activity_set_jobject (SugarActivity* self, SugarJobject* value) {
	SugarJobject* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_jobject);
	self->priv->_jobject = _tmp0_;
	g_object_notify ((GObject *) self, "jobject");
}


SugarShell* sugar_activity_get_shell (SugarActivity* self) {
	SugarShell* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_shell;
	return result;
}


static void sugar_activity_set_shell (SugarActivity* self, SugarShell* value) {
	SugarShell* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_shell);
	self->priv->_shell = _tmp0_;
	g_object_notify ((GObject *) self, "shell");
}


SugarJournal* sugar_activity_get_journal (SugarActivity* self) {
	SugarJournal* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_journal;
	return result;
}


static void sugar_activity_set_journal (SugarActivity* self, SugarJournal* value) {
	SugarJournal* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_journal);
	self->priv->_journal = _tmp0_;
	g_object_notify ((GObject *) self, "journal");
}


SugarConnection* sugar_activity_get_connection (SugarActivity* self) {
	SugarConnection* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_connection;
	return result;
}


static void sugar_activity_set_connection (SugarActivity* self, SugarConnection* value) {
	SugarConnection* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_connection);
	self->priv->_connection = _tmp0_;
	g_object_notify ((GObject *) self, "connection");
}


gboolean sugar_activity_get_resumed (SugarActivity* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_resumed;
	return result;
}


static void sugar_activity_class_init (SugarActivityClass * klass) {
	sugar_activity_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarActivityPrivate));
	G_OBJECT_CLASS (klass)->dispose = sugar_activity_real_dispose;
	SUGAR_ACTIVITY_CLASS (klass)->write_file = sugar_activity_real_write_file;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_activity_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_activity_set_property;
	G_OBJECT_CLASS (klass)->finalize = sugar_activity_finalize;
	/**
	     * Journal object activity was launched to change
	     *
	     * Property could be null if Activity object was created without Journal
	     * support i.e. use_journal constructor argument was false.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ACTIVITY_JOBJECT, g_param_spec_object ("jobject", "jobject", "jobject", SUGAR_TYPE_JOBJECT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Object to interact with Sugar Shell
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ACTIVITY_SHELL, g_param_spec_object ("shell", "shell", "shell", SUGAR_TYPE_SHELL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Object to interact with Sugar Journal
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ACTIVITY_JOURNAL, g_param_spec_object ("journal", "journal", "journal", SUGAR_TYPE_JOURNAL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Activity sharing session
	     *
	     * Property could be null if Activity object was created without sharing
	     * support i.e. use_sharing constructor argument was false.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ACTIVITY_CONNECTION, g_param_spec_object ("connection", "connection", "connection", SUGAR_TYPE_CONNECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Was activity resumed from Journal entry or not
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ACTIVITY_RESUMED, g_param_spec_boolean ("resumed", "resumed", "resumed", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void sugar_activity_instance_init (SugarActivity * self) {
	self->priv = SUGAR_ACTIVITY_GET_PRIVATE (self);
}


static void sugar_activity_finalize (GObject* obj) {
	SugarActivity * self;
	self = SUGAR_ACTIVITY (obj);
	_g_object_unref0 (self->priv->_jobject);
	_g_object_unref0 (self->priv->_shell);
	_g_object_unref0 (self->priv->_journal);
	_g_object_unref0 (self->priv->_connection);
	G_OBJECT_CLASS (sugar_activity_parent_class)->finalize (obj);
}


/**
 * High level class that accumulates non-GUI objects needed for regular activity
 *
 * Besides, Activity follows regular sugar workflows. It could be useful for
 * native sugar activities. In other cases, classes like Jobject, Shell etc.
 * could be used directly.
 */
GType sugar_activity_get_type (void) {
	static volatile gsize sugar_activity_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_activity_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarActivityClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_activity_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarActivity), 0, (GInstanceInitFunc) sugar_activity_instance_init, NULL };
		GType sugar_activity_type_id;
		sugar_activity_type_id = g_type_register_static (G_TYPE_OBJECT, "SugarActivity", &g_define_type_info, 0);
		g_once_init_leave (&sugar_activity_type_id__volatile, sugar_activity_type_id);
	}
	return sugar_activity_type_id__volatile;
}


static void _vala_sugar_activity_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarActivity * self;
	self = SUGAR_ACTIVITY (object);
	switch (property_id) {
		case SUGAR_ACTIVITY_JOBJECT:
		g_value_set_object (value, sugar_activity_get_jobject (self));
		break;
		case SUGAR_ACTIVITY_SHELL:
		g_value_set_object (value, sugar_activity_get_shell (self));
		break;
		case SUGAR_ACTIVITY_JOURNAL:
		g_value_set_object (value, sugar_activity_get_journal (self));
		break;
		case SUGAR_ACTIVITY_CONNECTION:
		g_value_set_object (value, sugar_activity_get_connection (self));
		break;
		case SUGAR_ACTIVITY_RESUMED:
		g_value_set_boolean (value, sugar_activity_get_resumed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_activity_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarActivity * self;
	self = SUGAR_ACTIVITY (object);
	switch (property_id) {
		case SUGAR_ACTIVITY_JOBJECT:
		sugar_activity_set_jobject (self, g_value_get_object (value));
		break;
		case SUGAR_ACTIVITY_SHELL:
		sugar_activity_set_shell (self, g_value_get_object (value));
		break;
		case SUGAR_ACTIVITY_JOURNAL:
		sugar_activity_set_journal (self, g_value_get_object (value));
		break;
		case SUGAR_ACTIVITY_CONNECTION:
		sugar_activity_set_connection (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



