#!/usr/bin/env python

from __init__ import *

import unittest
import gtk
import gobject

import env, collab


class StateTest(unittest.TestCase):

    def testSimpleSet(self):
        set_activity_id(0)
        conn = collab.Connection()
        self.assertEqual (env.SHARE_SCOPE_PRIVATE, conn.props.scope)

        for scope in [env.SHARE_SCOPE_INVITE_ONLY, env.SHARE_SCOPE_PUBLIC]:
            states = []
            scope_changing = []
            state_changed = []

            set_activity_id(scope)
            conn = collab.Connection()

            def state_cb(_, __):
                states.append(conn.props.scope)
            conn.connect('notify::scope', state_cb)

            def state_changing_cb(_, __):
                scope_changing.append(conn.props.scope_changing)
            conn.connect('notify::scope-changing', state_changing_cb)

            def state_changed_cb(_, prev_state, error):
                state_changed.append((conn.props.scope, prev_state))
            conn.connect('scope-changed', state_changed_cb)

            conn.props.scope = scope;
            gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
            gtk.main ()

            self.assertEqual (True, conn.props.initiator)
            self.assertEqual ([scope], states)
            self.assertEqual ([True, False], scope_changing)
            self.assertEqual ([(scope, env.SHARE_SCOPE_PRIVATE)],
                    state_changed)

    def testPrivateToPublic(self):
        states = []
        scope_changing = []
        state_changed = []

        set_activity_id(40)
        conn = collab.Connection()

        def state_cb(_, __):
            states.append(conn.props.scope)
        conn.connect('notify::scope', state_cb)

        def state_changing_cb(_, __):
            scope_changing.append(conn.props.scope_changing)
        conn.connect('notify::scope-changing', state_changing_cb)

        def state_changed_cb(_, prev_state, error):
            state_changed.append((conn.props.scope, prev_state))
        conn.connect('scope-changed', state_changed_cb)

        prev_state = env.SHARE_SCOPE_PRIVATE

        for i in range(3):
            del states[:]
            del scope_changing[:]
            del state_changed[:]

            conn.props.scope = env.SHARE_SCOPE_INVITE_ONLY;
            gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
            gtk.main ()

            conn.props.scope = env.SHARE_SCOPE_PUBLIC;
            gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
            gtk.main ()

            self.assertEqual (
                    [env.SHARE_SCOPE_INVITE_ONLY,
                     env.SHARE_SCOPE_PUBLIC], states)
            self.assertEqual ([True, False] * 2, scope_changing)
            self.assertEqual ([
                    (env.SHARE_SCOPE_INVITE_ONLY, prev_state),
                    (env.SHARE_SCOPE_PUBLIC, env.SHARE_SCOPE_INVITE_ONLY)],
                    state_changed)

            prev_state = env.SHARE_SCOPE_PUBLIC

    def testPrivateToPublicToOffline(self):
        states = []
        scope_changing = []
        state_changed = []

        set_activity_id(20)
        conn = collab.Connection()
        def state_cb(_, __):
            states.append(conn.props.scope)
        conn.connect('notify::scope', state_cb)

        def state_changing_cb(_, __):
            scope_changing.append(conn.props.scope_changing)
        conn.connect('notify::scope-changing', state_changing_cb)

        def state_changed_cb(_, prev_state, error):
            state_changed.append((conn.props.scope, prev_state))
        conn.connect('scope-changed', state_changed_cb)

        orig_states = [env.SHARE_SCOPE_INVITE_ONLY,
                       env.SHARE_SCOPE_PRIVATE,
                       env.SHARE_SCOPE_PUBLIC,
                       env.SHARE_SCOPE_PRIVATE,
                       env.SHARE_SCOPE_INVITE_ONLY,
                       env.SHARE_SCOPE_PUBLIC,
                       env.SHARE_SCOPE_PRIVATE,
                       env.SHARE_SCOPE_PUBLIC,
                       env.SHARE_SCOPE_INVITE_ONLY,
                       env.SHARE_SCOPE_PRIVATE]

        for scope in orig_states:
            conn.props.scope = scope
            gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
            gtk.main ()

        self.assertEqual (orig_states, states)
        self.assertEqual ([True, False] * len(orig_states), scope_changing)
        self.assertEqual ([
                (env.SHARE_SCOPE_INVITE_ONLY, env.SHARE_SCOPE_PRIVATE),
                (env.SHARE_SCOPE_PRIVATE, env.SHARE_SCOPE_INVITE_ONLY),
                (env.SHARE_SCOPE_PUBLIC,  env.SHARE_SCOPE_PRIVATE),
                (env.SHARE_SCOPE_PRIVATE, env.SHARE_SCOPE_PUBLIC),
                (env.SHARE_SCOPE_INVITE_ONLY, env.SHARE_SCOPE_PRIVATE),
                (env.SHARE_SCOPE_PUBLIC,  env.SHARE_SCOPE_INVITE_ONLY),
                (env.SHARE_SCOPE_PRIVATE, env.SHARE_SCOPE_PUBLIC),
                (env.SHARE_SCOPE_PUBLIC,  env.SHARE_SCOPE_PRIVATE),
                (env.SHARE_SCOPE_INVITE_ONLY, env.SHARE_SCOPE_PUBLIC),
                (env.SHARE_SCOPE_PRIVATE, env.SHARE_SCOPE_INVITE_ONLY)],
                state_changed)

    def testJoinOnTheSameSP(self):
        states_1 = []
        states_2 = []

        set_activity_id(30)
        conn_1 = collab.Connection()
        def state_1_cb(_, __):
            states_1.append(conn_1.props.scope)
        conn_1.connect('notify::scope', state_1_cb)

        set_activity_id(30)
        conn_2 = collab.Connection()
        def state_2_cb(_, __):
            states_2.append(conn_2.props.scope)
        conn_2.connect('notify::scope', state_2_cb)

        conn_1.props.scope = env.SHARE_SCOPE_PUBLIC;
        gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
        gtk.main ()

        self.assertEqual (True, conn_1.props.initiator)
        self.assertEqual ([env.SHARE_SCOPE_PUBLIC], states_1)
        self.assertEqual ([], states_2)

        conn_2.props.scope = env.SHARE_SCOPE_PUBLIC;
        gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
        gtk.main ()

        self.assertEqual (False, conn_2.props.initiator)
        self.assertEqual ([env.SHARE_SCOPE_PUBLIC], states_1)
        self.assertEqual ([env.SHARE_SCOPE_PUBLIC], states_2)


if __name__ == '__main__':
    unittest.main()
