/* environ.c generated by valac 0.12.1, the Vala compiler
 * generated from environ.vala, do not modify */

/* environ.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/env.h"
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SugarParamSpecEnviron SugarParamSpecEnviron;

struct _SugarParamSpecEnviron {
	GParamSpec parent_instance;
};


static gpointer sugar_environ_parent_class = NULL;
static gboolean sugar_environ__sync_dbus;
static gboolean sugar_environ__sync_dbus = FALSE;
static gchar* sugar_environ__bundle_id;
static gchar* sugar_environ__bundle_id = NULL;
static gchar* sugar_environ__activity_id;
static gchar* sugar_environ__activity_id = NULL;
static gchar* sugar_environ__object_id;
static gchar* sugar_environ__object_id = NULL;
static XID sugar_environ__window;
static XID sugar_environ__window = 0;
static SugarActivityInfo sugar_environ__activity;
static SugarActivityInfo sugar_environ__activity = {0};

enum  {
	SUGAR_ENVIRON_DUMMY_PROPERTY
};
static SugarEnviron* sugar_environ_new (void);
static SugarEnviron* sugar_environ_construct (GType object_type);
static void sugar_environ_finalize (SugarEnviron* obj);

static const GOptionEntry SUGAR_ENVIRON__entries[4] = {{"bundle-id", 'b', 0, G_OPTION_ARG_STRING, &sugar_environ__bundle_id, NULL, NULL}, {"activity-id", 'a', 0, G_OPTION_ARG_STRING, &sugar_environ__activity_id, NULL, NULL}, {"object-id", 'o', 0, G_OPTION_ARG_STRING, &sugar_environ__object_id, NULL, NULL}, {NULL}};

/**
     * Initialize Polyol environment
     *
     * @param argv  argv strings array that was passed to the main ();
     *              on success, parsed values will be removed from argv
     * @return      true if sugar mode was detected and properly initialized
     *
     * The rest of Polyol can be called after invoking this function and only if
     * it returned true.
     *
     * This function will Initialize internal data basing on command line
     * arguments sugar-activity command passes to the activity process.
     * These options are:
     *
     *  -b BUNDLE_ID, --bundle-id=BUNDLE_ID
     *      identifier of the activity bundle
     *      required for successful parsing
     *
     *  -a ACTIVITY_ID, --activity-id=ACTIVITY_ID
     *      identifier of the activity instance
     *      required for successful parsing
     *
     *  -o OBJECT_ID, --object-id=OBJECT_ID
     *      identifier of the associated journal entry
     *      optional, absence means activity session without or with new
     *      journal entry
     */
gboolean sugar_init (gchar*** argv, int* argv_length1) {
	gboolean result = FALSE;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* options;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	if ((*argv) == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_option_context_new ("");
	options = _tmp0_;
	g_option_context_set_help_enabled (options, FALSE);
	g_option_context_set_ignore_unknown_options (options, TRUE);
	g_option_context_add_main_entries (options, SUGAR_ENVIRON__entries, NULL);
	g_option_context_parse (options, argv_length1, argv, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_OPTION_ERROR) {
			goto __catch7_g_option_error;
		}
		_g_option_context_free0 (options);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	goto __finally7;
	__catch7_g_option_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("environ.vala:191: Command line options error: %s", _error_->message);
		result = FALSE;
		_g_error_free0 (_error_);
		_g_option_context_free0 (options);
		return result;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (options);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp2_ = sugar_environ_get_activity_id ();
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = sugar_environ_get_bundle_id ();
		_tmp1_ = _tmp3_ == NULL;
	}
	if (_tmp1_) {
		g_message ("environ.vala:196: %s", "Sugar mode was not detected, pass --activity-id and " "--bundle-id to enable it");
		result = FALSE;
		_g_option_context_free0 (options);
		return result;
	}
	_tmp4_ = sugar_environ_get_activity_id ();
	_tmp5_ = sugar_environ_get_object_id ();
	_tmp6_ = sugar_environ_get_bundle_id ();
	g_debug ("Activity command line arguments: activity_id=%s object_id=%s " "bundle_id=%s", _tmp4_, _tmp5_, _tmp6_);
	result = TRUE;
	_g_option_context_free0 (options);
	return result;
}


/**
     * Setup X properties for activity main window
     *
     * Valid sugar activity should call this function for main X window.
     *
     * @param display   X display to setup properties for
     * @param window    activity main window to setup properties for
     */
void sugar_environ_set_window (Display* display, Window window) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (display != NULL);
	sugar_environ__window = (XID) window;
	_tmp0_ = sugar_environ_get_bundle_id ();
	if (_tmp0_ != NULL) {
		Atom _tmp1_;
		Atom _tmp2_;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_;
		_tmp1_ = XInternAtom (display, "_SUGAR_BUNDLE_ID", FALSE);
		_tmp2_ = XInternAtom (display, "STRING", FALSE);
		_tmp3_ = sugar_environ_get_bundle_id ();
		_tmp4_ = sugar_environ_get_bundle_id ();
		_tmp5_ = strlen (_tmp4_);
		XChangeProperty (display, window, _tmp1_, _tmp2_, 8, (gint) PropModeReplace, (guchar*) _tmp3_, (gint) _tmp5_);
	} else {
		g_warning ("environ.vala:225: _SUGAR_BUNDLE_ID X property was not set");
	}
	_tmp6_ = sugar_environ_get_activity_id ();
	if (_tmp6_ != NULL) {
		Atom _tmp7_;
		Atom _tmp8_;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_;
		_tmp7_ = XInternAtom (display, "_SUGAR_ACTIVITY_ID", FALSE);
		_tmp8_ = XInternAtom (display, "STRING", FALSE);
		_tmp9_ = sugar_environ_get_activity_id ();
		_tmp10_ = sugar_environ_get_activity_id ();
		_tmp11_ = strlen (_tmp10_);
		XChangeProperty (display, window, _tmp7_, _tmp8_, 8, (gint) PropModeReplace, (guchar*) _tmp9_, (gint) _tmp11_);
	} else {
		g_warning ("environ.vala:234: _SUGAR_ACTIVITY_ID X property was not set");
	}
}


static SugarEnviron* sugar_environ_construct (GType object_type) {
	SugarEnviron* self = NULL;
	self = (SugarEnviron*) g_type_create_instance (object_type);
	return self;
}


static SugarEnviron* sugar_environ_new (void) {
	return sugar_environ_construct (SUGAR_TYPE_ENVIRON);
}


gboolean sugar_environ_get_initialized (void) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	_tmp1_ = sugar_environ_get_activity_id ();
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = sugar_environ_get_bundle_id ();
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


const gchar* sugar_environ_get_activity_id (void) {
	const gchar* result;
	result = sugar_environ__activity_id;
	return result;
}


const gchar* sugar_environ_get_bundle_id (void) {
	const gchar* result;
	result = sugar_environ__bundle_id;
	return result;
}


const gchar* sugar_environ_get_object_id (void) {
	const gchar* result;
	result = sugar_environ__object_id;
	return result;
}


void sugar_environ_get_activity (SugarActivityInfo* result) {
	if (sugar_environ__activity.bundle_id == NULL) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* path;
		gboolean _tmp2_ = FALSE;
		_tmp0_ = g_getenv ("SUGAR_BUNDLE_PATH");
		_tmp1_ = g_strdup (_tmp0_);
		path = _tmp1_;
		if (path == NULL) {
			_tmp2_ = TRUE;
		} else {
			SugarActivityInfo _tmp3_ = {0};
			gboolean _tmp4_;
			_tmp4_ = sugar_activity_info_get (path, &_tmp3_);
			sugar_activity_info_destroy (&sugar_environ__activity);
			sugar_environ__activity = _tmp3_;
			_tmp2_ = !_tmp4_;
		}
		if (_tmp2_) {
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = g_strdup ("unknown.activity");
			_g_free0 (sugar_environ__activity.bundle_id);
			sugar_environ__activity.bundle_id = _tmp5_;
			_tmp6_ = g_strdup ("Unknown Activity");
			_g_free0 (sugar_environ__activity.name);
			sugar_environ__activity.name = _tmp6_;
			_tmp7_ = g_strdup ("application-octet-stream");
			_g_free0 (sugar_environ__activity.icon);
			sugar_environ__activity.icon = _tmp7_;
		}
		_g_free0 (path);
	}
	*result = sugar_environ__activity;
	return;
}


const gchar* sugar_environ_get_activity_root (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* path;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_getenv ("SUGAR_ACTIVITY_ROOT");
	path = _tmp0_;
	if (path == NULL) {
		_tmp1_ = ".";
	} else {
		_tmp1_ = path;
	}
	result = _tmp1_;
	return result;
}


XID sugar_environ_get_window (void) {
	XID result;
	result = sugar_environ__window;
	return result;
}


gboolean sugar_environ_get_secure_mode (void) {
	gboolean result;
	gboolean _tmp0_;
	_tmp0_ = g_file_test ("/etc/olpc-security", G_FILE_TEST_EXISTS);
	result = _tmp0_;
	return result;
}


gboolean sugar_environ_get_sync_dbus (void) {
	gboolean result;
	result = sugar_environ__sync_dbus;
	return result;
}


void sugar_environ_set_sync_dbus (gboolean value) {
	sugar_environ__sync_dbus = value;
}


static void sugar_value_environ_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void sugar_value_environ_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sugar_environ_unref (value->data[0].v_pointer);
	}
}


static void sugar_value_environ_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sugar_environ_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer sugar_value_environ_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* sugar_value_environ_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SugarEnviron* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sugar_environ_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* sugar_value_environ_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SugarEnviron** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sugar_environ_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* sugar_param_spec_environ (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SugarParamSpecEnviron* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SUGAR_TYPE_ENVIRON), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer sugar_value_get_environ (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_TYPE_ENVIRON), NULL);
	return value->data[0].v_pointer;
}


void sugar_value_set_environ (GValue* value, gpointer v_object) {
	SugarEnviron* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_TYPE_ENVIRON));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUGAR_TYPE_ENVIRON));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sugar_environ_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sugar_environ_unref (old);
	}
}


void sugar_value_take_environ (GValue* value, gpointer v_object) {
	SugarEnviron* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_TYPE_ENVIRON));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUGAR_TYPE_ENVIRON));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sugar_environ_unref (old);
	}
}


static void sugar_environ_class_init (SugarEnvironClass * klass) {
	sugar_environ_parent_class = g_type_class_peek_parent (klass);
	SUGAR_ENVIRON_CLASS (klass)->finalize = sugar_environ_finalize;
}


static void sugar_environ_instance_init (SugarEnviron * self) {
	self->ref_count = 1;
}


static void sugar_environ_finalize (SugarEnviron* obj) {
	SugarEnviron * self;
	self = SUGAR_ENVIRON (obj);
}


/**
 * Various sugar environment settings
 */
GType sugar_environ_get_type (void) {
	static volatile gsize sugar_environ_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_environ_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { sugar_value_environ_init, sugar_value_environ_free_value, sugar_value_environ_copy_value, sugar_value_environ_peek_pointer, "p", sugar_value_environ_collect_value, "p", sugar_value_environ_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SugarEnvironClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_environ_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarEnviron), 0, (GInstanceInitFunc) sugar_environ_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType sugar_environ_type_id;
		sugar_environ_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SugarEnviron", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&sugar_environ_type_id__volatile, sugar_environ_type_id);
	}
	return sugar_environ_type_id__volatile;
}


gpointer sugar_environ_ref (gpointer instance) {
	SugarEnviron* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void sugar_environ_unref (gpointer instance) {
	SugarEnviron* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SUGAR_ENVIRON_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



