/* gtk-2.16.c
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>

const gchar *gtk_action_get_label (GtkAction *action) {
    g_return_val_if_fail (GTK_IS_ACTION (action), NULL);
    static GValue prop_value = { };
    if (!G_IS_VALUE(&prop_value))
        g_value_init (&prop_value, G_TYPE_STRING);
    g_object_get_property (G_OBJECT(action), "label", &prop_value);
    return g_value_get_string (&prop_value);
}

const gchar *gtk_action_get_icon_name (GtkAction *action) {
    g_return_val_if_fail (GTK_IS_ACTION (action), NULL);
    static GValue prop_value = { };
    if (!G_IS_VALUE(&prop_value))
        g_value_init (&prop_value, G_TYPE_STRING);
    g_object_get_property (G_OBJECT(action), "icon-name", &prop_value);
    return g_value_get_string (&prop_value);
}

void gtk_action_set_icon_name (GtkAction *action, const gchar *icon_name) {
    g_return_if_fail (GTK_IS_ACTION (action));
    g_object_set (action, "icon-name", icon_name, NULL);
}
