/* paintbin.c generated by valac 0.12.1, the Vala compiler
 * generated from paintbin.vala, do not modify */

/* paintbin.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/gui.h"
#include <polyol/env.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define SUGAR_PAINT_BIN_TYPE__CORNERS (sugar_paint_bin__corners_get_type ())
#define SUGAR_PAINT_BIN__CORNERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_PAINT_BIN_TYPE__CORNERS, SugarPaintBin_Corners))
#define SUGAR_PAINT_BIN__CORNERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_PAINT_BIN_TYPE__CORNERS, SugarPaintBin_CornersClass))
#define SUGAR_PAINT_BIN_IS__CORNERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_PAINT_BIN_TYPE__CORNERS))
#define SUGAR_PAINT_BIN_IS__CORNERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_PAINT_BIN_TYPE__CORNERS))
#define SUGAR_PAINT_BIN__CORNERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_PAINT_BIN_TYPE__CORNERS, SugarPaintBin_CornersClass))

typedef struct _SugarPaintBin_Corners SugarPaintBin_Corners;
typedef struct _SugarPaintBin_CornersClass SugarPaintBin_CornersClass;

#define SUGAR_PAINT_BIN_TYPE__CORNERID (sugar_paint_bin__cornerid_get_type ())
#define SUGAR_PAINT_BIN__CORNERID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_PAINT_BIN_TYPE__CORNERID, SugarPaintBin_CornerId))
#define SUGAR_PAINT_BIN__CORNERID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_PAINT_BIN_TYPE__CORNERID, SugarPaintBin_CornerIdClass))
#define SUGAR_PAINT_BIN_IS__CORNERID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_PAINT_BIN_TYPE__CORNERID))
#define SUGAR_PAINT_BIN_IS__CORNERID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_PAINT_BIN_TYPE__CORNERID))
#define SUGAR_PAINT_BIN__CORNERID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_PAINT_BIN_TYPE__CORNERID, SugarPaintBin_CornerIdClass))

typedef struct _SugarPaintBin_CornerId SugarPaintBin_CornerId;
typedef struct _SugarPaintBin_CornerIdClass SugarPaintBin_CornerIdClass;
#define _sugar_paint_bin__corners_unref0(var) ((var == NULL) ? NULL : (var = (sugar_paint_bin__corners_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sugar_paint_bin__cornerid_unref0(var) ((var == NULL) ? NULL : (var = (sugar_paint_bin__cornerid_unref (var), NULL)))
typedef struct _SugarPaintBin_CornersPrivate SugarPaintBin_CornersPrivate;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _SugarPaintBin_CornerIdPrivate SugarPaintBin_CornerIdPrivate;
typedef struct _SugarPaintBinParamSpec_CornerId SugarPaintBinParamSpec_CornerId;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _SugarPaintBinParamSpec_Corners SugarPaintBinParamSpec_Corners;

struct _SugarPaintBinPrivate {
	gboolean _draw_box;
	SugarPaintBin_Corners* _corners;
	gint _radius;
	gint _padding_top;
	gint _padding_bottom;
	gint _padding_left;
	gint _padding_right;
	gboolean _reload_corners;
};

struct _SugarPaintBin_Corners {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SugarPaintBin_CornersPrivate * priv;
	cairo_surface_t* right_bottom;
	cairo_surface_t* left_bottom;
	cairo_surface_t* left_top;
	cairo_surface_t* right_top;
	gint radius;
	GdkColor color;
};

struct _SugarPaintBin_CornersClass {
	GTypeClass parent_class;
	void (*finalize) (SugarPaintBin_Corners *self);
};

struct _SugarPaintBin_CornerId {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SugarPaintBin_CornerIdPrivate * priv;
	guint color;
	gint radius;
};

struct _SugarPaintBin_CornerIdClass {
	GTypeClass parent_class;
	void (*finalize) (SugarPaintBin_CornerId *self);
};

struct _SugarPaintBinParamSpec_CornerId {
	GParamSpec parent_instance;
};

struct _SugarPaintBinParamSpec_Corners {
	GParamSpec parent_instance;
};


static gpointer sugar_paint_bin_parent_class = NULL;
static SugarLRU* sugar_paint_bin__corners_cache;
static SugarLRU* sugar_paint_bin__corners_cache = NULL;
static gpointer sugar_paint_bin__cornerid_parent_class = NULL;
static gpointer sugar_paint_bin__corners_parent_class = NULL;

static gpointer sugar_paint_bin__corners_ref (gpointer instance);
static void sugar_paint_bin__corners_unref (gpointer instance);
static GParamSpec* sugar_paint_bin_param_spec__corners (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void sugar_paint_bin_value_set__corners (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void sugar_paint_bin_value_take__corners (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer sugar_paint_bin_value_get__corners (const GValue* value) G_GNUC_UNUSED;
static GType sugar_paint_bin__corners_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SUGAR_PAINT_BIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_PAINT_BIN, SugarPaintBinPrivate))
enum  {
	SUGAR_PAINT_BIN_DUMMY_PROPERTY,
	SUGAR_PAINT_BIN_DRAW_BOX,
	SUGAR_PAINT_BIN_RADIUS,
	SUGAR_PAINT_BIN_PADDING_TOP,
	SUGAR_PAINT_BIN_PADDING_BOTTOM,
	SUGAR_PAINT_BIN_PADDING_LEFT,
	SUGAR_PAINT_BIN_PADDING_RIGHT,
	SUGAR_PAINT_BIN_PADDING,
	SUGAR_PAINT_BIN_CHILD_X,
	SUGAR_PAINT_BIN_CHILD_Y,
	SUGAR_PAINT_BIN_CHILD_WIDTH,
	SUGAR_PAINT_BIN_CHILD_HEIGHT
};
static gpointer sugar_paint_bin__cornerid_ref (gpointer instance);
static void sugar_paint_bin__cornerid_unref (gpointer instance);
static GParamSpec* sugar_paint_bin_param_spec__cornerid (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void sugar_paint_bin_value_set__cornerid (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void sugar_paint_bin_value_take__cornerid (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer sugar_paint_bin_value_get__cornerid (const GValue* value) G_GNUC_UNUSED;
static GType sugar_paint_bin__cornerid_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static guint sugar_paint_bin__cornerid_hash (SugarPaintBin_CornerId* x);
static gboolean sugar_paint_bin__cornerid_cmp (SugarPaintBin_CornerId* x, SugarPaintBin_CornerId* y);
static void sugar_paint_bin_real_style_set (GtkWidget* base, GtkStyle* previous_style);
static void sugar_paint_bin_real_size_request (GtkWidget* base, GtkRequisition* requisition);
static gint sugar_paint_bin_get__inscribing_gap (SugarPaintBin* self);
static void sugar_paint_bin_real_size_allocate (GtkWidget* base, GdkRectangle* allocation);
static void sugar_paint_bin_real_realize (GtkWidget* base);
static void sugar_paint_bin_real_map (GtkWidget* base);
static gboolean sugar_paint_bin_real_expose_event (GtkWidget* base, GdkEventExpose* event);
static SugarPaintBin_CornerId* sugar_paint_bin__cornerid_new (SugarPaintBin* bin);
static SugarPaintBin_CornerId* sugar_paint_bin__cornerid_construct (GType object_type, SugarPaintBin* bin);
static SugarPaintBin_Corners* sugar_paint_bin__corners_new (SugarPaintBin* bin);
static SugarPaintBin_Corners* sugar_paint_bin__corners_construct (GType object_type, SugarPaintBin* bin);
static void _sugar_paint_bin_whether_to_resize (SugarPaintBin* self, gint* padding, gint value);
static GObject * sugar_paint_bin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	SUGAR_PAINT_BIN__CORNERID_DUMMY_PROPERTY
};
static void sugar_paint_bin__cornerid_finalize (SugarPaintBin_CornerId* obj);
enum  {
	SUGAR_PAINT_BIN__CORNERS_DUMMY_PROPERTY
};
static cairo_surface_t* _sugar_paint_bin__corners_setup_serface (SugarPaintBin_Corners* self, gint x, gint y, gdouble angle_start, gdouble angle_stop);
static void sugar_paint_bin__corners_finalize (SugarPaintBin_Corners* obj);
static void sugar_paint_bin_finalize (GObject* obj);
static void _vala_sugar_paint_bin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_paint_bin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void sugar_paint_bin_real_style_set (GtkWidget* base, GtkStyle* previous_style) {
	SugarPaintBin * self;
	self = (SugarPaintBin*) base;
	GTK_WIDGET_CLASS (sugar_paint_bin_parent_class)->style_set ((GtkWidget*) SUGAR_BIN (self), previous_style);
	self->priv->_reload_corners = TRUE;
}


static void sugar_paint_bin_real_size_request (GtkWidget* base, GtkRequisition* requisition) {
	SugarPaintBin * self;
	GtkRequisition _requisition = {0};
	GtkRequisition _tmp0_ = {0};
	gint _tmp1_;
	gint _tmp2_;
	gint gap;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	self = (SugarPaintBin*) base;
	GTK_WIDGET_CLASS (sugar_paint_bin_parent_class)->size_request ((GtkWidget*) SUGAR_BIN (self), &_tmp0_);
	_requisition = _tmp0_;
	_tmp1_ = sugar_paint_bin_get_radius (self);
	_tmp2_ = sugar_paint_bin_get__inscribing_gap (self);
	gap = (_tmp1_ - _tmp2_) * 2;
	_tmp3_ = sugar_paint_bin_get_padding_left (self);
	_tmp4_ = sugar_paint_bin_get_padding_right (self);
	_requisition.width = _requisition.width + ((_tmp3_ + _tmp4_) + gap);
	_tmp5_ = sugar_paint_bin_get_padding_top (self);
	_tmp6_ = sugar_paint_bin_get_padding_bottom (self);
	_requisition.height = _requisition.height + ((_tmp5_ + _tmp6_) + gap);
	if (requisition) {
		*requisition = _requisition;
	}
}


static void sugar_paint_bin_real_size_allocate (GtkWidget* base, GdkRectangle* allocation) {
	SugarPaintBin * self;
	gboolean _tmp0_;
	GtkWidget* _tmp1_ = NULL;
	self = (SugarPaintBin*) base;
	((GtkWidget*) self)->allocation = (GtkAllocation) (*allocation);
	_tmp0_ = GTK_WIDGET_REALIZED ((GtkWidget*) self);
	if (_tmp0_) {
		gdk_window_move_resize (((GtkWidget*) self)->window, (*allocation).x, (*allocation).y, (*allocation).width, (*allocation).height);
	}
	_tmp1_ = sugar_bin_get_child ((SugarBin*) self);
	if (_tmp1_ != NULL) {
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		GdkRectangle _tmp6_ = {0};
		GdkRectangle child_allocation;
		GtkWidget* _tmp7_ = NULL;
		_tmp2_ = sugar_container_get_child_x ((SugarContainer*) self);
		_tmp3_ = sugar_container_get_child_y ((SugarContainer*) self);
		_tmp4_ = sugar_container_get_child_width ((SugarContainer*) self);
		_tmp5_ = sugar_container_get_child_height ((SugarContainer*) self);
		_tmp6_.x = _tmp2_;
		_tmp6_.y = _tmp3_;
		_tmp6_.width = _tmp4_;
		_tmp6_.height = _tmp5_;
		child_allocation = _tmp6_;
		_tmp7_ = sugar_bin_get_child ((SugarBin*) self);
		gtk_widget_size_allocate (_tmp7_, &child_allocation);
	}
	self->priv->_reload_corners = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void sugar_paint_bin_real_realize (GtkWidget* base) {
	SugarPaintBin * self;
	GdkWindow* _tmp0_ = NULL;
	GdkColormap* _tmp1_ = NULL;
	gint _tmp2_;
	GdkWindowAttr _tmp3_ = {0};
	GdkWindowAttr _tmp4_ = {0};
	GdkWindow* _tmp5_ = NULL;
	GtkStyle* _tmp6_ = NULL;
	GtkStyle* _tmp7_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	self = (SugarPaintBin*) base;
	GTK_WIDGET_SET_FLAGS ((GtkWidget*) self, GTK_REALIZED);
	_tmp0_ = gtk_widget_get_parent_window ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_colormap ((GtkWidget*) self);
	_tmp2_ = gtk_widget_get_events ((GtkWidget*) self);
	memset (&_tmp3_, 0, sizeof (GdkWindowAttr));
	_tmp3_.window_type = GDK_WINDOW_CHILD;
	_tmp3_.x = ((GtkWidget*) self)->allocation.x;
	_tmp3_.y = ((GtkWidget*) self)->allocation.y;
	_tmp3_.width = ((GtkWidget*) self)->allocation.width;
	_tmp3_.height = ((GtkWidget*) self)->allocation.height;
	_tmp3_.wclass = GDK_INPUT_OUTPUT;
	_tmp3_.colormap = _tmp1_;
	_tmp3_.event_mask = _tmp2_ | GDK_EXPOSURE_MASK;
	_tmp4_ = _tmp3_;
	_tmp5_ = gdk_window_new (_tmp0_, &_tmp4_, (gint) ((GDK_WA_X | GDK_WA_Y) | GDK_WA_COLORMAP));
	_g_object_unref0 (((GtkWidget*) self)->window);
	((GtkWidget*) self)->window = _tmp5_;
	gdk_window_set_user_data (((GtkWidget*) self)->window, self);
	_tmp6_ = gtk_widget_get_style ((GtkWidget*) self);
	gtk_style_attach (_tmp6_, ((GtkWidget*) self)->window);
	_tmp7_ = gtk_widget_get_style ((GtkWidget*) self);
	gtk_style_set_background (_tmp7_, ((GtkWidget*) self)->window, GTK_STATE_NORMAL);
	_tmp8_ = sugar_bin_get_child ((SugarBin*) self);
	if (_tmp8_ != NULL) {
		GtkWidget* _tmp9_ = NULL;
		_tmp9_ = sugar_bin_get_child ((SugarBin*) self);
		gtk_widget_set_parent_window (_tmp9_, ((GtkWidget*) self)->window);
	}
}


static void sugar_paint_bin_real_map (GtkWidget* base) {
	SugarPaintBin * self;
	gboolean _tmp0_ = FALSE;
	GtkWidget* _tmp1_ = NULL;
	self = (SugarPaintBin*) base;
	GTK_WIDGET_SET_FLAGS ((GtkWidget*) self, GTK_MAPPED);
	_tmp1_ = sugar_bin_get_child ((SugarBin*) self);
	if (_tmp1_ != NULL) {
		GtkWidget* _tmp2_ = NULL;
		gboolean _tmp3_;
		_tmp2_ = sugar_bin_get_child ((SugarBin*) self);
		_tmp3_ = gtk_widget_get_visible (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkWidget* _tmp4_ = NULL;
		_tmp4_ = sugar_bin_get_child ((SugarBin*) self);
		gtk_widget_map (_tmp4_);
	}
	gdk_window_show (((GtkWidget*) self)->window);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean sugar_paint_bin_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	SugarPaintBin * self;
	gboolean result = FALSE;
	GtkStyle* _tmp0_ = NULL;
	GdkGC* _tmp1_;
	GdkGC* fg;
	GtkStyle* _tmp2_ = NULL;
	GdkGC* _tmp3_;
	GdkGC* bg;
	gboolean _tmp4_;
	gint left;
	gint top;
	gint _tmp6_;
	gint right;
	gint _tmp7_;
	gint bottom;
	gint _tmp8_;
	gboolean _tmp22_;
	self = (SugarPaintBin*) base;
	_tmp0_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_->bg_gc[GTK_STATE_NORMAL]);
	fg = _tmp1_;
	_tmp2_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp3_ = _g_object_ref0 (_tmp2_->bg_gc[GTK_STATE_INSENSITIVE]);
	bg = _tmp3_;
	gdk_draw_rectangle ((GdkDrawable*) ((GtkWidget*) self)->window, bg, TRUE, 0, 0, ((GtkWidget*) self)->allocation.width, ((GtkWidget*) self)->allocation.height);
	_tmp4_ = sugar_paint_bin_get_draw_box (self);
	if (!_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = GTK_WIDGET_CLASS (sugar_paint_bin_parent_class)->expose_event ((GtkWidget*) SUGAR_BIN (self), event);
		result = _tmp5_;
		_g_object_unref0 (bg);
		_g_object_unref0 (fg);
		return result;
	}
	left = SUGAR_CONTAINER_CLASS (sugar_paint_bin_parent_class)->get_child_x ((SugarContainer*) SUGAR_BIN (self));
	top = SUGAR_CONTAINER_CLASS (sugar_paint_bin_parent_class)->get_child_y ((SugarContainer*) SUGAR_BIN (self));
	_tmp6_ = sugar_paint_bin_get_radius (self);
	right = (left + SUGAR_CONTAINER_CLASS (sugar_paint_bin_parent_class)->get_child_width ((SugarContainer*) SUGAR_BIN (self))) - _tmp6_;
	_tmp7_ = sugar_paint_bin_get_radius (self);
	bottom = (top + SUGAR_CONTAINER_CLASS (sugar_paint_bin_parent_class)->get_child_height ((SugarContainer*) SUGAR_BIN (self))) - _tmp7_;
	_tmp8_ = sugar_paint_bin_get_radius (self);
	if (_tmp8_ <= 0) {
		gdk_draw_rectangle ((GdkDrawable*) ((GtkWidget*) self)->window, fg, TRUE, left, top, SUGAR_CONTAINER_CLASS (sugar_paint_bin_parent_class)->get_child_width ((SugarContainer*) SUGAR_BIN (self)), SUGAR_CONTAINER_CLASS (sugar_paint_bin_parent_class)->get_child_height ((SugarContainer*) SUGAR_BIN (self)));
	} else {
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		cairo_t* _tmp21_ = NULL;
		cairo_t* cr;
		if (self->priv->_reload_corners) {
			gint _tmp9_;
			_tmp9_ = sugar_paint_bin_get_radius (self);
			if (_tmp9_ > 0) {
				SugarPaintBin_CornerId* _tmp10_ = NULL;
				SugarPaintBin_CornerId* key;
				gpointer _tmp11_ = NULL;
				_tmp10_ = sugar_paint_bin__cornerid_new (self);
				key = _tmp10_;
				_tmp11_ = sugar_lru_get (sugar_paint_bin__corners_cache, key);
				_sugar_paint_bin__corners_unref0 (self->priv->_corners);
				self->priv->_corners = (SugarPaintBin_Corners*) _tmp11_;
				if (self->priv->_corners == NULL) {
					SugarPaintBin_Corners* _tmp12_ = NULL;
					_tmp12_ = sugar_paint_bin__corners_new (self);
					_sugar_paint_bin__corners_unref0 (self->priv->_corners);
					self->priv->_corners = _tmp12_;
					sugar_lru_set (sugar_paint_bin__corners_cache, key, self->priv->_corners);
				}
				_sugar_paint_bin__cornerid_unref0 (key);
			}
			self->priv->_reload_corners = FALSE;
		}
		_tmp13_ = sugar_paint_bin_get_radius (self);
		_tmp14_ = sugar_paint_bin_get_radius (self);
		_tmp15_ = sugar_paint_bin_get_radius (self);
		gdk_draw_rectangle ((GdkDrawable*) ((GtkWidget*) self)->window, fg, TRUE, left + _tmp13_, top, SUGAR_CONTAINER_CLASS (sugar_paint_bin_parent_class)->get_child_width ((SugarContainer*) SUGAR_BIN (self)) - (_tmp14_ * 2), _tmp15_);
		_tmp16_ = sugar_paint_bin_get_radius (self);
		_tmp17_ = sugar_paint_bin_get_radius (self);
		gdk_draw_rectangle ((GdkDrawable*) ((GtkWidget*) self)->window, fg, TRUE, left, top + _tmp16_, SUGAR_CONTAINER_CLASS (sugar_paint_bin_parent_class)->get_child_width ((SugarContainer*) SUGAR_BIN (self)), SUGAR_CONTAINER_CLASS (sugar_paint_bin_parent_class)->get_child_height ((SugarContainer*) SUGAR_BIN (self)) - (_tmp17_ * 2));
		_tmp18_ = sugar_paint_bin_get_radius (self);
		_tmp19_ = sugar_paint_bin_get_radius (self);
		_tmp20_ = sugar_paint_bin_get_radius (self);
		gdk_draw_rectangle ((GdkDrawable*) ((GtkWidget*) self)->window, fg, TRUE, left + _tmp18_, bottom, SUGAR_CONTAINER_CLASS (sugar_paint_bin_parent_class)->get_child_width ((SugarContainer*) SUGAR_BIN (self)) - (_tmp19_ * 2), _tmp20_);
		_tmp21_ = gdk_cairo_create ((GdkDrawable*) ((GtkWidget*) self)->window);
		cr = _tmp21_;
		cairo_set_source_surface (cr, self->priv->_corners->right_bottom, (gdouble) right, (gdouble) bottom);
		cairo_paint (cr);
		cairo_set_source_surface (cr, self->priv->_corners->left_bottom, (gdouble) left, (gdouble) bottom);
		cairo_paint (cr);
		cairo_set_source_surface (cr, self->priv->_corners->left_top, (gdouble) left, (gdouble) top);
		cairo_paint (cr);
		cairo_set_source_surface (cr, self->priv->_corners->right_top, (gdouble) right, (gdouble) top);
		cairo_paint (cr);
		_cairo_destroy0 (cr);
	}
	_tmp22_ = GTK_WIDGET_CLASS (sugar_paint_bin_parent_class)->expose_event ((GtkWidget*) SUGAR_BIN (self), event);
	result = _tmp22_;
	_g_object_unref0 (bg);
	_g_object_unref0 (fg);
	return result;
}


static void _sugar_paint_bin_whether_to_resize (SugarPaintBin* self, gint* padding, gint value) {
	g_return_if_fail (self != NULL);
	if ((*padding) != value) {
		*padding = value;
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
}


SugarPaintBin* sugar_paint_bin_construct (GType object_type) {
	SugarPaintBin * self = NULL;
	self = (SugarPaintBin*) sugar_bin_construct (object_type);
	return self;
}


SugarPaintBin* sugar_paint_bin_new (void) {
	return sugar_paint_bin_construct (SUGAR_TYPE_PAINT_BIN);
}


gboolean sugar_paint_bin_get_draw_box (SugarPaintBin* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_draw_box;
	return result;
}


void sugar_paint_bin_set_draw_box (SugarPaintBin* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_draw_box = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "draw-box");
}


gint sugar_paint_bin_get_radius (SugarPaintBin* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_radius;
	return result;
}


void sugar_paint_bin_set_radius (SugarPaintBin* self, gint value) {
	g_return_if_fail (self != NULL);
	_sugar_paint_bin_whether_to_resize (self, &self->priv->_radius, value);
	g_object_notify ((GObject *) self, "radius");
}


gint sugar_paint_bin_get_padding_top (SugarPaintBin* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_top;
	return result;
}


void sugar_paint_bin_set_padding_top (SugarPaintBin* self, gint value) {
	g_return_if_fail (self != NULL);
	_sugar_paint_bin_whether_to_resize (self, &self->priv->_padding_top, value);
	g_object_notify ((GObject *) self, "padding-top");
}


gint sugar_paint_bin_get_padding_bottom (SugarPaintBin* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_bottom;
	return result;
}


void sugar_paint_bin_set_padding_bottom (SugarPaintBin* self, gint value) {
	g_return_if_fail (self != NULL);
	_sugar_paint_bin_whether_to_resize (self, &self->priv->_padding_bottom, value);
	g_object_notify ((GObject *) self, "padding-bottom");
}


gint sugar_paint_bin_get_padding_left (SugarPaintBin* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_left;
	return result;
}


void sugar_paint_bin_set_padding_left (SugarPaintBin* self, gint value) {
	g_return_if_fail (self != NULL);
	_sugar_paint_bin_whether_to_resize (self, &self->priv->_padding_left, value);
	g_object_notify ((GObject *) self, "padding-left");
}


gint sugar_paint_bin_get_padding_right (SugarPaintBin* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_right;
	return result;
}


void sugar_paint_bin_set_padding_right (SugarPaintBin* self, gint value) {
	g_return_if_fail (self != NULL);
	_sugar_paint_bin_whether_to_resize (self, &self->priv->_padding_right, value);
	g_object_notify ((GObject *) self, "padding-right");
}


void sugar_paint_bin_set_padding (SugarPaintBin* self, gint value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_padding_top != value) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->priv->_padding_bottom != value;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->_padding_left != value;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_padding_right != value;
	}
	if (_tmp0_) {
		self->priv->_padding_top = value;
		self->priv->_padding_bottom = value;
		self->priv->_padding_left = value;
		self->priv->_padding_right = value;
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
	g_object_notify ((GObject *) self, "padding");
}


static gint sugar_paint_bin_real_get_child_x (SugarContainer* base) {
	gint result;
	SugarPaintBin* self;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (SugarPaintBin*) base;
	_tmp0_ = sugar_paint_bin_get_padding_left (self);
	_tmp1_ = sugar_paint_bin_get_radius (self);
	_tmp2_ = sugar_paint_bin_get__inscribing_gap (self);
	result = ((SUGAR_CONTAINER_CLASS (sugar_paint_bin_parent_class)->get_child_x ((SugarContainer*) SUGAR_BIN (self)) + _tmp0_) + _tmp1_) - _tmp2_;
	return result;
}


static gint sugar_paint_bin_real_get_child_y (SugarContainer* base) {
	gint result;
	SugarPaintBin* self;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (SugarPaintBin*) base;
	_tmp0_ = sugar_paint_bin_get_padding_top (self);
	_tmp1_ = sugar_paint_bin_get_radius (self);
	_tmp2_ = sugar_paint_bin_get__inscribing_gap (self);
	result = ((SUGAR_CONTAINER_CLASS (sugar_paint_bin_parent_class)->get_child_y ((SugarContainer*) SUGAR_BIN (self)) + _tmp0_) + _tmp1_) - _tmp2_;
	return result;
}


static gint sugar_paint_bin_real_get_child_width (SugarContainer* base) {
	gint result;
	SugarPaintBin* self;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	self = (SugarPaintBin*) base;
	_tmp0_ = sugar_paint_bin_get_padding_left (self);
	_tmp1_ = sugar_paint_bin_get_padding_right (self);
	_tmp2_ = sugar_paint_bin_get_radius (self);
	_tmp3_ = sugar_paint_bin_get__inscribing_gap (self);
	_tmp4_ = MAX (0, ((SUGAR_CONTAINER_CLASS (sugar_paint_bin_parent_class)->get_child_width ((SugarContainer*) SUGAR_BIN (self)) - _tmp0_) - _tmp1_) - ((_tmp2_ - _tmp3_) * 2));
	result = _tmp4_;
	return result;
}


static gint sugar_paint_bin_real_get_child_height (SugarContainer* base) {
	gint result;
	SugarPaintBin* self;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	self = (SugarPaintBin*) base;
	_tmp0_ = sugar_paint_bin_get_padding_top (self);
	_tmp1_ = sugar_paint_bin_get_padding_bottom (self);
	_tmp2_ = sugar_paint_bin_get_radius (self);
	_tmp3_ = sugar_paint_bin_get__inscribing_gap (self);
	_tmp4_ = MAX (0, ((SUGAR_CONTAINER_CLASS (sugar_paint_bin_parent_class)->get_child_height ((SugarContainer*) SUGAR_BIN (self)) - _tmp0_) - _tmp1_) - ((_tmp2_ - _tmp3_) * 2));
	result = _tmp4_;
	return result;
}


static gint sugar_paint_bin_get__inscribing_gap (SugarPaintBin* self) {
	gint result;
	gint _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = sugar_paint_bin_get_radius (self);
	_tmp1_ = pow ((gdouble) _tmp0_, (gdouble) 2);
	_tmp2_ = sqrt (_tmp1_ / 2.0);
	result = (gint) _tmp2_;
	return result;
}


static GObject * sugar_paint_bin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarPaintBin * self;
	parent_class = G_OBJECT_CLASS (sugar_paint_bin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_PAINT_BIN (obj);
	GTK_WIDGET_UNSET_FLAGS ((GtkWidget*) self, GTK_NO_WINDOW);
	return obj;
}


static SugarPaintBin_CornerId* sugar_paint_bin__cornerid_construct (GType object_type, SugarPaintBin* bin) {
	SugarPaintBin_CornerId* self = NULL;
	GtkStyle* _tmp0_ = NULL;
	GdkColor gdk_color;
	gint _tmp1_;
	g_return_val_if_fail (bin != NULL, NULL);
	self = (SugarPaintBin_CornerId*) g_type_create_instance (object_type);
	_tmp0_ = gtk_widget_get_style ((GtkWidget*) bin);
	gdk_color = _tmp0_->bg[GTK_STATE_NORMAL];
	self->color = (((guint) (gdk_color.red & 0xFF)) | ((guint) ((gdk_color.green & 0xFF) << 8))) | ((guint) ((gdk_color.blue & 0xFF) << 16));
	_tmp1_ = sugar_paint_bin_get_radius (bin);
	self->radius = _tmp1_;
	return self;
}


static SugarPaintBin_CornerId* sugar_paint_bin__cornerid_new (SugarPaintBin* bin) {
	return sugar_paint_bin__cornerid_construct (SUGAR_PAINT_BIN_TYPE__CORNERID, bin);
}


static guint sugar_paint_bin__cornerid_hash (SugarPaintBin_CornerId* x) {
	guint result = 0U;
	g_return_val_if_fail (x != NULL, 0U);
	result = x->color + x->radius;
	return result;
}


static gboolean sugar_paint_bin__cornerid_cmp (SugarPaintBin_CornerId* x, SugarPaintBin_CornerId* y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (x != NULL, FALSE);
	g_return_val_if_fail (y != NULL, FALSE);
	if (x->color == y->color) {
		_tmp0_ = x->radius == y->radius;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void sugar_paint_bin_value__cornerid_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void sugar_paint_bin_value__cornerid_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sugar_paint_bin__cornerid_unref (value->data[0].v_pointer);
	}
}


static void sugar_paint_bin_value__cornerid_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sugar_paint_bin__cornerid_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer sugar_paint_bin_value__cornerid_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* sugar_paint_bin_value__cornerid_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SugarPaintBin_CornerId* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sugar_paint_bin__cornerid_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* sugar_paint_bin_value__cornerid_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SugarPaintBin_CornerId** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sugar_paint_bin__cornerid_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* sugar_paint_bin_param_spec__cornerid (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SugarPaintBinParamSpec_CornerId* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SUGAR_PAINT_BIN_TYPE__CORNERID), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer sugar_paint_bin_value_get__cornerid (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_PAINT_BIN_TYPE__CORNERID), NULL);
	return value->data[0].v_pointer;
}


static void sugar_paint_bin_value_set__cornerid (GValue* value, gpointer v_object) {
	SugarPaintBin_CornerId* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_PAINT_BIN_TYPE__CORNERID));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUGAR_PAINT_BIN_TYPE__CORNERID));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sugar_paint_bin__cornerid_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sugar_paint_bin__cornerid_unref (old);
	}
}


static void sugar_paint_bin_value_take__cornerid (GValue* value, gpointer v_object) {
	SugarPaintBin_CornerId* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_PAINT_BIN_TYPE__CORNERID));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUGAR_PAINT_BIN_TYPE__CORNERID));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sugar_paint_bin__cornerid_unref (old);
	}
}


static void sugar_paint_bin__cornerid_class_init (SugarPaintBin_CornerIdClass * klass) {
	sugar_paint_bin__cornerid_parent_class = g_type_class_peek_parent (klass);
	SUGAR_PAINT_BIN__CORNERID_CLASS (klass)->finalize = sugar_paint_bin__cornerid_finalize;
}


static void sugar_paint_bin__cornerid_instance_init (SugarPaintBin_CornerId * self) {
	self->ref_count = 1;
}


static void sugar_paint_bin__cornerid_finalize (SugarPaintBin_CornerId* obj) {
	SugarPaintBin_CornerId * self;
	self = SUGAR_PAINT_BIN__CORNERID (obj);
}


static GType sugar_paint_bin__cornerid_get_type (void) {
	static volatile gsize sugar_paint_bin__cornerid_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_paint_bin__cornerid_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { sugar_paint_bin_value__cornerid_init, sugar_paint_bin_value__cornerid_free_value, sugar_paint_bin_value__cornerid_copy_value, sugar_paint_bin_value__cornerid_peek_pointer, "p", sugar_paint_bin_value__cornerid_collect_value, "p", sugar_paint_bin_value__cornerid_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SugarPaintBin_CornerIdClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_paint_bin__cornerid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarPaintBin_CornerId), 0, (GInstanceInitFunc) sugar_paint_bin__cornerid_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType sugar_paint_bin__cornerid_type_id;
		sugar_paint_bin__cornerid_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SugarPaintBin_CornerId", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&sugar_paint_bin__cornerid_type_id__volatile, sugar_paint_bin__cornerid_type_id);
	}
	return sugar_paint_bin__cornerid_type_id__volatile;
}


static gpointer sugar_paint_bin__cornerid_ref (gpointer instance) {
	SugarPaintBin_CornerId* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void sugar_paint_bin__cornerid_unref (gpointer instance) {
	SugarPaintBin_CornerId* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SUGAR_PAINT_BIN__CORNERID_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static SugarPaintBin_Corners* sugar_paint_bin__corners_construct (GType object_type, SugarPaintBin* bin) {
	SugarPaintBin_Corners* self = NULL;
	gint _tmp0_;
	GtkStyle* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	cairo_surface_t* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	cairo_surface_t* _tmp5_ = NULL;
	g_return_val_if_fail (bin != NULL, NULL);
	self = (SugarPaintBin_Corners*) g_type_create_instance (object_type);
	_tmp0_ = sugar_paint_bin_get_radius (bin);
	self->radius = _tmp0_;
	_tmp1_ = gtk_widget_get_style ((GtkWidget*) bin);
	self->color = _tmp1_->bg[GTK_STATE_NORMAL];
	_tmp2_ = _sugar_paint_bin__corners_setup_serface (self, 0, 0, 0.0, G_PI / 2.0);
	_cairo_surface_destroy0 (self->right_bottom);
	self->right_bottom = _tmp2_;
	_tmp3_ = _sugar_paint_bin__corners_setup_serface (self, self->radius, 0, G_PI / 2.0, G_PI);
	_cairo_surface_destroy0 (self->left_bottom);
	self->left_bottom = _tmp3_;
	_tmp4_ = _sugar_paint_bin__corners_setup_serface (self, self->radius, self->radius, G_PI, G_PI * 1.5);
	_cairo_surface_destroy0 (self->left_top);
	self->left_top = _tmp4_;
	_tmp5_ = _sugar_paint_bin__corners_setup_serface (self, 0, self->radius, G_PI * 1.5, G_PI * 2.0);
	_cairo_surface_destroy0 (self->right_top);
	self->right_top = _tmp5_;
	return self;
}


static SugarPaintBin_Corners* sugar_paint_bin__corners_new (SugarPaintBin* bin) {
	return sugar_paint_bin__corners_construct (SUGAR_PAINT_BIN_TYPE__CORNERS, bin);
}


static cairo_surface_t* _sugar_paint_bin__corners_setup_serface (SugarPaintBin_Corners* self, gint x, gint y, gdouble angle_start, gdouble angle_stop) {
	cairo_surface_t* result = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* surface;
	cairo_t* _tmp1_ = NULL;
	cairo_t* cr;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, self->radius, self->radius);
	surface = _tmp0_;
	_tmp1_ = cairo_create (surface);
	cr = _tmp1_;
	gdk_cairo_set_source_color (cr, &self->color);
	cairo_move_to (cr, (gdouble) x, (gdouble) y);
	cairo_arc (cr, (gdouble) x, (gdouble) y, (gdouble) self->radius, angle_start, angle_stop);
	cairo_fill (cr);
	result = surface;
	_cairo_destroy0 (cr);
	return result;
}


static void sugar_paint_bin_value__corners_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void sugar_paint_bin_value__corners_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sugar_paint_bin__corners_unref (value->data[0].v_pointer);
	}
}


static void sugar_paint_bin_value__corners_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sugar_paint_bin__corners_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer sugar_paint_bin_value__corners_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* sugar_paint_bin_value__corners_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SugarPaintBin_Corners* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sugar_paint_bin__corners_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* sugar_paint_bin_value__corners_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SugarPaintBin_Corners** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sugar_paint_bin__corners_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* sugar_paint_bin_param_spec__corners (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SugarPaintBinParamSpec_Corners* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SUGAR_PAINT_BIN_TYPE__CORNERS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer sugar_paint_bin_value_get__corners (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_PAINT_BIN_TYPE__CORNERS), NULL);
	return value->data[0].v_pointer;
}


static void sugar_paint_bin_value_set__corners (GValue* value, gpointer v_object) {
	SugarPaintBin_Corners* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_PAINT_BIN_TYPE__CORNERS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUGAR_PAINT_BIN_TYPE__CORNERS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sugar_paint_bin__corners_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sugar_paint_bin__corners_unref (old);
	}
}


static void sugar_paint_bin_value_take__corners (GValue* value, gpointer v_object) {
	SugarPaintBin_Corners* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_PAINT_BIN_TYPE__CORNERS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUGAR_PAINT_BIN_TYPE__CORNERS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sugar_paint_bin__corners_unref (old);
	}
}


static void sugar_paint_bin__corners_class_init (SugarPaintBin_CornersClass * klass) {
	sugar_paint_bin__corners_parent_class = g_type_class_peek_parent (klass);
	SUGAR_PAINT_BIN__CORNERS_CLASS (klass)->finalize = sugar_paint_bin__corners_finalize;
}


static void sugar_paint_bin__corners_instance_init (SugarPaintBin_Corners * self) {
	self->ref_count = 1;
}


static void sugar_paint_bin__corners_finalize (SugarPaintBin_Corners* obj) {
	SugarPaintBin_Corners * self;
	self = SUGAR_PAINT_BIN__CORNERS (obj);
	_cairo_surface_destroy0 (self->right_bottom);
	_cairo_surface_destroy0 (self->left_bottom);
	_cairo_surface_destroy0 (self->left_top);
	_cairo_surface_destroy0 (self->right_top);
}


static GType sugar_paint_bin__corners_get_type (void) {
	static volatile gsize sugar_paint_bin__corners_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_paint_bin__corners_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { sugar_paint_bin_value__corners_init, sugar_paint_bin_value__corners_free_value, sugar_paint_bin_value__corners_copy_value, sugar_paint_bin_value__corners_peek_pointer, "p", sugar_paint_bin_value__corners_collect_value, "p", sugar_paint_bin_value__corners_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SugarPaintBin_CornersClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_paint_bin__corners_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarPaintBin_Corners), 0, (GInstanceInitFunc) sugar_paint_bin__corners_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType sugar_paint_bin__corners_type_id;
		sugar_paint_bin__corners_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SugarPaintBin_Corners", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&sugar_paint_bin__corners_type_id__volatile, sugar_paint_bin__corners_type_id);
	}
	return sugar_paint_bin__corners_type_id__volatile;
}


static gpointer sugar_paint_bin__corners_ref (gpointer instance) {
	SugarPaintBin_Corners* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void sugar_paint_bin__corners_unref (gpointer instance) {
	SugarPaintBin_Corners* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SUGAR_PAINT_BIN__CORNERS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void sugar_paint_bin_class_init (SugarPaintBinClass * klass) {
	SugarLRU* _tmp0_ = NULL;
	sugar_paint_bin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarPaintBinPrivate));
	GTK_WIDGET_CLASS (klass)->style_set = sugar_paint_bin_real_style_set;
	GTK_WIDGET_CLASS (klass)->size_request = sugar_paint_bin_real_size_request;
	GTK_WIDGET_CLASS (klass)->size_allocate = sugar_paint_bin_real_size_allocate;
	GTK_WIDGET_CLASS (klass)->realize = sugar_paint_bin_real_realize;
	GTK_WIDGET_CLASS (klass)->map = sugar_paint_bin_real_map;
	GTK_WIDGET_CLASS (klass)->expose_event = sugar_paint_bin_real_expose_event;
	SUGAR_CONTAINER_CLASS (klass)->get_child_x = sugar_paint_bin_real_get_child_x;
	SUGAR_CONTAINER_CLASS (klass)->get_child_y = sugar_paint_bin_real_get_child_y;
	SUGAR_CONTAINER_CLASS (klass)->get_child_width = sugar_paint_bin_real_get_child_width;
	SUGAR_CONTAINER_CLASS (klass)->get_child_height = sugar_paint_bin_real_get_child_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_paint_bin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_paint_bin_set_property;
	G_OBJECT_CLASS (klass)->constructor = sugar_paint_bin_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar_paint_bin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_PAINT_BIN_DRAW_BOX, g_param_spec_boolean ("draw-box", "draw-box", "draw-box", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_PAINT_BIN_RADIUS, g_param_spec_int ("radius", "radius", "radius", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_PAINT_BIN_PADDING_TOP, g_param_spec_int ("padding-top", "padding-top", "padding-top", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_PAINT_BIN_PADDING_BOTTOM, g_param_spec_int ("padding-bottom", "padding-bottom", "padding-bottom", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_PAINT_BIN_PADDING_LEFT, g_param_spec_int ("padding-left", "padding-left", "padding-left", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_PAINT_BIN_PADDING_RIGHT, g_param_spec_int ("padding-right", "padding-right", "padding-right", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_PAINT_BIN_PADDING, g_param_spec_int ("padding", "padding", "padding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), SUGAR_PAINT_BIN_CHILD_X, "child-x");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SUGAR_PAINT_BIN_CHILD_Y, "child-y");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SUGAR_PAINT_BIN_CHILD_WIDTH, "child-width");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SUGAR_PAINT_BIN_CHILD_HEIGHT, "child-height");
	_tmp0_ = sugar_lru_new (SUGAR_PAINT_BIN_TYPE__CORNERID, (GBoxedCopyFunc) sugar_paint_bin__cornerid_ref, sugar_paint_bin__cornerid_unref, SUGAR_PAINT_BIN_TYPE__CORNERS, (GBoxedCopyFunc) sugar_paint_bin__corners_ref, sugar_paint_bin__corners_unref, 50, (GHashFunc) sugar_paint_bin__cornerid_hash, (GEqualFunc) sugar_paint_bin__cornerid_cmp);
	sugar_paint_bin__corners_cache = _tmp0_;
}


static void sugar_paint_bin_instance_init (SugarPaintBin * self) {
	gint _tmp0_;
	self->priv = SUGAR_PAINT_BIN_GET_PRIVATE (self);
	self->priv->_draw_box = TRUE;
	_tmp0_ = sugar_metrics_get (SUGAR_DEFAULT_PADDING);
	self->priv->_radius = _tmp0_;
	self->priv->_padding_top = 0;
	self->priv->_padding_bottom = 0;
	self->priv->_padding_left = 0;
	self->priv->_padding_right = 0;
	self->priv->_reload_corners = TRUE;
}


static void sugar_paint_bin_finalize (GObject* obj) {
	SugarPaintBin * self;
	self = SUGAR_PAINT_BIN (obj);
	_sugar_paint_bin__corners_unref0 (self->priv->_corners);
	G_OBJECT_CLASS (sugar_paint_bin_parent_class)->finalize (obj);
}


/**
 * Bin container with rounded corners
 */
GType sugar_paint_bin_get_type (void) {
	static volatile gsize sugar_paint_bin_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_paint_bin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarPaintBinClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_paint_bin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarPaintBin), 0, (GInstanceInitFunc) sugar_paint_bin_instance_init, NULL };
		GType sugar_paint_bin_type_id;
		sugar_paint_bin_type_id = g_type_register_static (SUGAR_TYPE_BIN, "SugarPaintBin", &g_define_type_info, 0);
		g_once_init_leave (&sugar_paint_bin_type_id__volatile, sugar_paint_bin_type_id);
	}
	return sugar_paint_bin_type_id__volatile;
}


static void _vala_sugar_paint_bin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarPaintBin * self;
	self = SUGAR_PAINT_BIN (object);
	switch (property_id) {
		case SUGAR_PAINT_BIN_DRAW_BOX:
		g_value_set_boolean (value, sugar_paint_bin_get_draw_box (self));
		break;
		case SUGAR_PAINT_BIN_RADIUS:
		g_value_set_int (value, sugar_paint_bin_get_radius (self));
		break;
		case SUGAR_PAINT_BIN_PADDING_TOP:
		g_value_set_int (value, sugar_paint_bin_get_padding_top (self));
		break;
		case SUGAR_PAINT_BIN_PADDING_BOTTOM:
		g_value_set_int (value, sugar_paint_bin_get_padding_bottom (self));
		break;
		case SUGAR_PAINT_BIN_PADDING_LEFT:
		g_value_set_int (value, sugar_paint_bin_get_padding_left (self));
		break;
		case SUGAR_PAINT_BIN_PADDING_RIGHT:
		g_value_set_int (value, sugar_paint_bin_get_padding_right (self));
		break;
		case SUGAR_PAINT_BIN_CHILD_X:
		g_value_set_int (value, sugar_container_get_child_x ((SugarContainer*) self));
		break;
		case SUGAR_PAINT_BIN_CHILD_Y:
		g_value_set_int (value, sugar_container_get_child_y ((SugarContainer*) self));
		break;
		case SUGAR_PAINT_BIN_CHILD_WIDTH:
		g_value_set_int (value, sugar_container_get_child_width ((SugarContainer*) self));
		break;
		case SUGAR_PAINT_BIN_CHILD_HEIGHT:
		g_value_set_int (value, sugar_container_get_child_height ((SugarContainer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_paint_bin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarPaintBin * self;
	self = SUGAR_PAINT_BIN (object);
	switch (property_id) {
		case SUGAR_PAINT_BIN_DRAW_BOX:
		sugar_paint_bin_set_draw_box (self, g_value_get_boolean (value));
		break;
		case SUGAR_PAINT_BIN_RADIUS:
		sugar_paint_bin_set_radius (self, g_value_get_int (value));
		break;
		case SUGAR_PAINT_BIN_PADDING_TOP:
		sugar_paint_bin_set_padding_top (self, g_value_get_int (value));
		break;
		case SUGAR_PAINT_BIN_PADDING_BOTTOM:
		sugar_paint_bin_set_padding_bottom (self, g_value_get_int (value));
		break;
		case SUGAR_PAINT_BIN_PADDING_LEFT:
		sugar_paint_bin_set_padding_left (self, g_value_get_int (value));
		break;
		case SUGAR_PAINT_BIN_PADDING_RIGHT:
		sugar_paint_bin_set_padding_right (self, g_value_get_int (value));
		break;
		case SUGAR_PAINT_BIN_PADDING:
		sugar_paint_bin_set_padding (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



