#!/usr/bin/env python

from dbus.service import method, signal
from dbus.connection import Connection as TPConnection
from dbus.gobject_service import ExportedGObject
import gobject

IFACE = "test.messenger"
PATH = "/test/messenger"

class Messenger(ExportedGObject):

    def __init__(self, tube, prefix):
        self._tube = tube
        self._tp_conn = TPConnection(tube.props.address)
        self._prefix = prefix

        ExportedGObject.__init__(self, self._tp_conn, PATH)

        self._tube.connect('notify::me', self.__notify_me_cb)
        self._tube.connect('buddy-appeared', self.__buddy_appeared_cb)

    @signal(IFACE, signature='')
    def ping(self):
        print self._prefix, 'send ping from %s' % self._tube.props.me.props.name

    @method(dbus_interface=IFACE, in_signature='', out_signature='',
            sender_keyword='sender',
            async_callbacks=('async_cb', 'async_err_cb'))
    def pong(self, sender, async_cb, async_err_cb):
        print self._prefix, 'pong received from %s' % sender
        while True:
            pass

    @method(dbus_interface=IFACE, in_signature='', out_signature='',
            sender_keyword='sender')
    def hello(self, sender=None):
        print self._prefix, 'hello received from %s' % sender

    def __notify_me_cb(self, pspec, param):
        self._tp_conn.add_signal_receiver(self.__ping_cb, 'ping',
                IFACE, path=PATH, sender_keyword='sender')
        self.ping()

    def __buddy_appeared_cb(self, tube, buddy):

        print self._prefix, '> %s' % buddy.props.name


        if self._tube.props.me is not None and \
                buddy.props.name == self._tube.props.me.props.name:
            return
        self._tp_conn.get_object(buddy.props.name, PATH).hello()

    def __ping_cb(self, sender=None):
        if sender == self._tube.props.me.props.name:
            return
        print self._prefix, 'ping received from %s' % sender

        def reply_handler():
            print self._prefix, 'pong finished'
        def error_handler(e):
            print self._prefix, 'pong error', e

        self._tp_conn.get_object(sender, PATH).pong()
        #        reply_handler=reply_handler,
        #        error_handler=error_handler)

        print self._prefix, '> ping received from %s' % sender
