#!/usr/bin/env python

import __init__
import gtk
import env, gui

def box_new(icon_name):
    box = gtk.HBox()

    icon = gui.Icon()
    icon.props.file = icon_name
    box.add(icon)

    icon = gui.Icon()
    icon.props.icon_size = gtk.ICON_SIZE_LARGE_TOOLBAR
    icon.props.xo_color = env.profile_get_color()
    icon.props.pulsing = True
    icon.props.file = icon_name

    icon_box = gtk.EventBox()
    icon_box.add(icon)
    box.add(icon_box)

    connector = gui.WidgetConnector(icon_box)
    connector.props.palette_position = gui.PALETTE_POSITION_AT_CURSOR
    invoker = gui.Invoker(connector)
    def cb(__):
        palette = gui.Palette()
        palette.props.secondary = gtk.Button('!!!')
        invoker.props.palette = palette

        menu = gui.EmbeddedMenu(connector)
        palette.props.secondary = menu

        submenu = gui.EmbeddedSubMenu(connector)
        item = gtk.MenuItem(label='sub');
        item.show()
        submenu.insert(item, 0)

        item = gtk.MenuItem(label='item #4');
        item.show()
        submenu.insert(item, 0)

        submenu2 = gui.EmbeddedSubMenu(connector)
        item = gtk.MenuItem(label='sub');
        item.show()
        submenu2.insert(item, 0)

        item = gtk.MenuItem(label='item #5');
        item.props.submenu = submenu2
        item.show()
        submenu.insert(item, 0)

        item = gtk.MenuItem(label='item #6');
        item.show()
        submenu.insert(item, 0)

        item = gtk.MenuItem(label='item #1');
        item.show()
        menu.insert(item, 0)

        item = gtk.MenuItem(label='item #2');
        item.props.submenu = submenu
        item.show()
        menu.insert(item, 0)

        item = gtk.MenuItem(label='item #3');
        item.show()
        menu.insert(item, 0)
    invoker.connect('palette-request', cb)

    icon = gui.Icon()
    icon.props.pixel_size = 100
    icon.props.file = icon_name
    icon.set_state(gtk.STATE_INSENSITIVE)
    box.add(icon)

    icon = gui.Icon()
    icon.props.file = icon_name
    box.add(icon)

    return box

window = gtk.Window()
window.connect('destroy', lambda sender: gtk.main_quit())

box = gtk.VBox()
window.add(box)

box.add(box_new('gimp'))
box.add(box_new('activity-journal'))
box.add(box_new('/usr/share/icons/gnome/scalable/emblems/emblem-urgent.svg'))

window.show_all()
gtk.main()
