#!/usr/bin/env python

import __init__
import gtk
import env, gui

def roundbox_new (padding, radius, fg, bg, draw_box):
    box = gui.PaintBin()
    box.props.draw_box = draw_box

    box.props.radius = radius
    box.props.padding = padding
    box.props.border_width = 10

    box.modify_bg(gtk.STATE_NORMAL, fg)
    if bg is not None:
        box.modify_bg(gtk.STATE_INSENSITIVE, bg)

    button = gtk.Button('WWW')
    def cb(sender):
        box.props.padding = padding * 2
    button.connect('clicked', cb)
    box.add(button)

    return box

def box_new(padding, radius):
    box = gtk.HBox()

    box.pack_start(roundbox_new(padding, radius,
            gui.color_type_to_rgb(env.COLOR_BLACK),
            gui.color_type_to_rgb(env.COLOR_WHITE), False))
    box.pack_start(roundbox_new(padding, radius,
            gui.color_type_to_rgb(env.COLOR_BLACK),
            gui.color_type_to_rgb(env.COLOR_WHITE), True))
    box.pack_start(roundbox_new(padding, radius,
            gui.color_type_to_rgb(env.COLOR_BLACK),
            None, True))
    box.pack_start(roundbox_new(padding, radius,
            gui.color_to_rgb(env.profile_get_color().stroke),
            gui.color_to_rgb(env.profile_get_color().fill), True))
    box.pack_start(
            gtk.VBox())

    return box

window = gtk.Window()
window.connect('destroy', lambda sender: gtk.main_quit())

box = gtk.VBox()
window.add(box)

box.add(box_new(0, env.DEFAULT_PADDING))
box.add(box_new(env.DEFAULT_PADDING, env.DEFAULT_PADDING))
box.add(box_new(30, 30))

window.show_all()
gtk.main()
