#!/usr/bin/env python

from __init__ import *

import unittest
import gtk
import gobject

import env, collab


class KillTest(unittest.TestCase):

    def testKill(self):
        states = []
        scope_changing = []

        set_activity_id(0)
        conn = collab.Connection()
        def state_cb(_, __):
            states.append(conn.props.scope)
        conn.connect('notify::scope', state_cb)

        def state_changing_cb(_, __):
            scope_changing.append(conn.props.scope_changing)
        conn.connect('notify::scope-changing', state_changing_cb)

        conn.props.scope = env.SHARE_SCOPE_PUBLIC;
        gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
        gtk.main ()

        kill_ps()
        gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
        gtk.main ()

        self.assertEqual (
                [env.SHARE_SCOPE_PUBLIC,
                 env.SHARE_SCOPE_PRIVATE], states)
        self.assertEqual ([True, False], scope_changing)

        conn.props.scope = env.SHARE_SCOPE_INVITE_ONLY;
        gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
        gtk.main ()

        self.assertEqual (
                [env.SHARE_SCOPE_PUBLIC,
                 env.SHARE_SCOPE_PRIVATE,
                 env.SHARE_SCOPE_INVITE_ONLY], states)
        self.assertEqual ([True, False] * 2, scope_changing)


if __name__ == '__main__':
    unittest.main()
