/* style.c generated by valac 0.12.1, the Vala compiler
 * generated from style.vala, do not modify */

/* style.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/env.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gconf/gconf-client.h>
#include <float.h>
#include <math.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _sugar_color_free0(var) ((var == NULL) ? NULL : (var = (sugar_color_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))


gdouble sugar_metrics__zoom_factor = 0.0;

static gdouble _sugar_metrics_get (gint type);
static gdouble _sugar_metrics_get_zoom_factor (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const SugarColor SUGAR_COLOR__colors[11] = {{1.0, (guint16) 0x0000, (guint16) 0x0000, (guint16) 0x0000}, {1.0, (guint16) 0xFFFF, (guint16) 0xFFFF, (guint16) 0xFFFF}, {0.0, (guint16) 0xFFFF, (guint16) 0xFFFF, (guint16) 0xFFFF}, {1.0, (guint16) 0xC0C0, (guint16) 0xC0C0, (guint16) 0xC0C0}, {1.0, (guint16) 0xA6A6, (guint16) 0xA6A6, (guint16) 0xA6A6}, {1.0, (guint16) 0x2828, (guint16) 0x2828, (guint16) 0x2828}, {1.0, (guint16) 0x8080, (guint16) 0x8080, (guint16) 0x8080}, {1.0, (guint16) 0x9D9D, (guint16) 0x9F9F, (guint16) 0xA1A1}, {1.0, (guint16) 0x7575, (guint16) 0x7575, (guint16) 0x7575}, {1.0, (guint16) 0xE5E5, (guint16) 0xE5E5, (guint16) 0xE5E5}, {1.0, (guint16) 0xE7E7, (guint16) 0xE7E7, (guint16) 0xE7E7}};
static const SugarXoColor SUGAR_XO_COLOR__white = {{1.0, (guint16) 0xFFFF, (guint16) 0xFFFF, (guint16) 0xFFFF}, {1.0, (guint16) 0x4141, (guint16) 0x4141, (guint16) 0x4141}};
static const SugarXoColor SUGAR_XO_COLOR__insensitive = {{1.0, (guint16) 0xFFFF, (guint16) 0xFFFF, (guint16) 0xFFFF}, {1.0, (guint16) 0xE2E2, (guint16) 0xE2E2, (guint16) 0xE2E2}};
static const SugarFont SUGAR_FONT__fonts[2] = {{"%s %f"}, {"%s bold %f"}};
static const SugarMetrics SUGAR_METRICS__values[20] = {{FALSE, 2.0}, {TRUE, 24.0}, {}, {TRUE, 15.0}, {TRUE, 6.0}, {TRUE, 75.0}, {TRUE, 2.0}, {TRUE, 55.0}, {TRUE, 55.0 * 0.5}, {TRUE, 55.0 * 1.5}, {TRUE, 55.0 * 2.0}, {TRUE, 55.0 * 2.75}, {TRUE, 9.0}, {TRUE, 75.0}, {}, {}, {TRUE, 150.0 - (15.0 * 2.0)}, {TRUE, 10.0}, {TRUE, 24.0}, {TRUE, 24.0}};

void sugar_color_get (gint type, SugarColor* result) {
	g_return_if_fail ((type >= 0) && (type < SUGAR_COLOR_LAST));
	*result = SUGAR_COLOR__colors[type];
	return;
}


gchar* sugar_color_to_string (SugarColor *self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	_tmp0_ = sugar_color_get_html (&(*self));
	result = _tmp0_;
	return result;
}


/**
         * Parse color from string in #RRGGBB format
         */
static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gpointer _sugar_color_dup0 (gpointer self) {
	return self ? sugar_color_dup (self) : NULL;
}


SugarColor* sugar_color_from_string (const gchar* color_string) {
	SugarColor* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* color;
	gchar _tmp1_;
	gint _tmp3_;
	SugarColor _tmp7_ = {0};
	SugarColor _result_;
	SugarColor* _tmp8_;
	g_return_val_if_fail (color_string != NULL, NULL);
	_tmp0_ = string_strip (color_string);
	color = _tmp0_;
	_tmp1_ = string_get (color, (glong) 0);
	if (_tmp1_ == '#') {
		gchar* _tmp2_ = NULL;
		_tmp2_ = string_substring (color, (glong) 1, (glong) (-1));
		_g_free0 (color);
		color = _tmp2_;
	}
	_tmp3_ = strlen (color);
	if (_tmp3_ != 6) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp4_ = string_to_string (color_string);
		_tmp5_ = g_strconcat ("Color '", _tmp4_, "' is not in #RRGGBB format", NULL);
		_tmp6_ = _tmp5_;
		g_warning ("style.vala:105: %s", _tmp6_);
		_g_free0 (_tmp6_);
		result = NULL;
		_g_free0 (color);
		return result;
	}
	_result_ = _tmp7_;
	sscanf (color, "%02hx%02hx%02hx", &_result_.red, &_result_.green, &_result_.blue);
	_result_.red = _result_.red | ((guint16) (_result_.red << 8));
	_result_.green = _result_.green | ((guint16) (_result_.green << 8));
	_result_.blue = _result_.blue | ((guint16) (_result_.blue << 8));
	_result_.alpha = 1.0;
	_tmp8_ = _sugar_color_dup0 (&_result_);
	result = _tmp8_;
	_g_free0 (color);
	return result;
}


guint32 sugar_color_get_integer (SugarColor* self) {
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = ((((guint32) ((*self).alpha * 255)) + ((((guint32) (*self).blue) & 0xFF) << 8)) + ((((guint32) (*self).green) & 0xFF) << 16)) + ((((guint32) (*self).red) & 0xFF) << 24);
	return result;
}


gchar* sugar_color_get_html (SugarColor* self) {
	gchar* result;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("#%02x%02x%02x", (guint) ((*self).red & 0xFF), (guint) ((*self).green & 0xFF), (guint) ((*self).blue & 0xFF));
	result = _tmp0_;
	return result;
}


gchar* sugar_color_get_svg (SugarColor* self) {
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if ((*self).alpha == 0.0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("none");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_ = NULL;
		_tmp1_ = sugar_color_get_html (&(*self));
		result = _tmp1_;
		return result;
	}
}


SugarColor* sugar_color_dup (const SugarColor* self) {
	SugarColor* dup;
	dup = g_new0 (SugarColor, 1);
	memcpy (dup, self, sizeof (SugarColor));
	return dup;
}


void sugar_color_free (SugarColor* self) {
	g_free (self);
}


GType sugar_color_get_type (void) {
	static volatile gsize sugar_color_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_color_type_id__volatile)) {
		GType sugar_color_type_id;
		sugar_color_type_id = g_boxed_type_register_static ("SugarColor", (GBoxedCopyFunc) sugar_color_dup, (GBoxedFreeFunc) sugar_color_free);
		g_once_init_leave (&sugar_color_type_id__volatile, sugar_color_type_id);
	}
	return sugar_color_type_id__volatile;
}


gchar* sugar_xo_color_to_string (SugarXoColor *self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	_tmp0_ = sugar_color_to_string (&(*self).stroke);
	_tmp1_ = _tmp0_;
	_tmp2_ = sugar_color_to_string (&(*self).fill);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp1_, ",", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}


static gpointer _sugar_xo_color_dup0 (gpointer self) {
	return self ? sugar_xo_color_dup (self) : NULL;
}


SugarXoColor* sugar_xo_color_from_string (const gchar* color_string) {
	SugarXoColor* result = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** pair;
	gint pair_length1;
	gint _pair_size_;
	SugarColor* _tmp7_ = NULL;
	SugarColor* stroke;
	SugarColor* _tmp11_ = NULL;
	SugarColor* fill;
	SugarXoColor _tmp15_ = {0};
	SugarXoColor _result_;
	SugarXoColor* _tmp16_;
	g_return_val_if_fail (color_string != NULL, NULL);
	if (g_strcmp0 (color_string, "white") == 0) {
		SugarXoColor* _tmp0_;
		_tmp0_ = _sugar_xo_color_dup0 (&SUGAR_XO_COLOR__white);
		result = _tmp0_;
		return result;
	} else {
		if (g_strcmp0 (color_string, "insensitive") == 0) {
			SugarXoColor* _tmp1_;
			_tmp1_ = _sugar_xo_color_dup0 (&SUGAR_XO_COLOR__insensitive);
			result = _tmp1_;
			return result;
		}
	}
	_tmp3_ = _tmp2_ = g_strsplit (color_string, ",", 0);
	pair = _tmp3_;
	pair_length1 = _vala_array_length (_tmp2_);
	_pair_size_ = _vala_array_length (_tmp2_);
	if (pair_length1 != 2) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp4_ = string_to_string (color_string);
		_tmp5_ = g_strconcat ("Wrong XoColor pair '", _tmp4_, "'", NULL);
		_tmp6_ = _tmp5_;
		g_warning ("style.vala:165: %s", _tmp6_);
		_g_free0 (_tmp6_);
		result = NULL;
		pair = (_vala_array_free (pair, pair_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp7_ = sugar_color_from_string (pair[0]);
	stroke = _tmp7_;
	if (stroke == NULL) {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp8_ = string_to_string (color_string);
		_tmp9_ = g_strconcat ("Fail to parse stroke color from '", _tmp8_, "'", NULL);
		_tmp10_ = _tmp9_;
		g_warning ("style.vala:171: %s", _tmp10_);
		_g_free0 (_tmp10_);
		result = NULL;
		_sugar_color_free0 (stroke);
		pair = (_vala_array_free (pair, pair_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp11_ = sugar_color_from_string (pair[1]);
	fill = _tmp11_;
	if (fill == NULL) {
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		_tmp12_ = string_to_string (color_string);
		_tmp13_ = g_strconcat ("Fail to parse fill color from '", _tmp12_, "'", NULL);
		_tmp14_ = _tmp13_;
		g_warning ("style.vala:177: %s", _tmp14_);
		_g_free0 (_tmp14_);
		result = NULL;
		_sugar_color_free0 (fill);
		_sugar_color_free0 (stroke);
		pair = (_vala_array_free (pair, pair_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_result_ = _tmp15_;
	_result_.stroke = *stroke;
	_result_.fill = *fill;
	_tmp16_ = _sugar_xo_color_dup0 (&_result_);
	result = _tmp16_;
	_sugar_color_free0 (fill);
	_sugar_color_free0 (stroke);
	pair = (_vala_array_free (pair, pair_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


SugarXoColor* sugar_xo_color_dup (const SugarXoColor* self) {
	SugarXoColor* dup;
	dup = g_new0 (SugarXoColor, 1);
	memcpy (dup, self, sizeof (SugarXoColor));
	return dup;
}


void sugar_xo_color_free (SugarXoColor* self) {
	g_free (self);
}


GType sugar_xo_color_get_type (void) {
	static volatile gsize sugar_xo_color_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_xo_color_type_id__volatile)) {
		GType sugar_xo_color_type_id;
		sugar_xo_color_type_id = g_boxed_type_register_static ("SugarXoColor", (GBoxedCopyFunc) sugar_xo_color_dup, (GBoxedFreeFunc) sugar_xo_color_free);
		g_once_init_leave (&sugar_xo_color_type_id__volatile, sugar_xo_color_type_id);
	}
	return sugar_xo_color_type_id__volatile;
}


void sugar_font_get (gint type, SugarFont* result) {
	SugarFont _tmp0_;
	SugarFont _tmp1_ = {0};
	g_return_if_fail ((type >= 0) && (type < SUGAR_FONT_LAST));
	sugar_font_copy (&SUGAR_FONT__fonts[type], &_tmp1_);
	_tmp0_ = _tmp1_;
	*result = _tmp0_;
	return;
}


gchar* sugar_font_get_name (SugarFont* self) {
	gchar* result;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gdouble _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sugar_font_get_face (&(*self));
	_tmp1_ = _tmp0_;
	_tmp2_ = sugar_font_get_size (&(*self));
	_tmp3_ = g_strdup_printf ((*self)._format, _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gdouble sugar_font_get_size (SugarFont* self) {
	gdouble result;
	GConfClient* _tmp0_ = NULL;
	GConfClient* _tmp1_;
	GConfClient* conf;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = gconf_client_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	conf = _tmp1_;
	_tmp2_ = gconf_client_get_float (conf, "/desktop/sugar/font/default_size", &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (conf);
		goto __catch0_g_error;
	}
	result = _tmp3_;
	_g_object_unref0 (conf);
	return result;
	_g_object_unref0 (conf);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_debug ("style.vala:216: Cannot get font size setting: %s.", e->message);
		result = (gdouble) 10;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0.0;
}


gchar* sugar_font_get_face (SugarFont* self) {
	gchar* result;
	GConfClient* _tmp0_ = NULL;
	GConfClient* _tmp1_;
	GConfClient* conf;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gconf_client_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	conf = _tmp1_;
	_tmp2_ = gconf_client_get_string (conf, "/desktop/sugar/font/default_face", &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (conf);
		goto __catch1_g_error;
	}
	result = _tmp3_;
	_g_object_unref0 (conf);
	return result;
	_g_object_unref0 (conf);
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_debug ("style.vala:228: Cannot get font face setting: %s.", e->message);
		_tmp4_ = g_strdup ("Bitstream Vera Sans");
		result = _tmp4_;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


void sugar_font_copy (const SugarFont* self, SugarFont* dest) {
	dest->_format = g_strdup (self->_format);
}


void sugar_font_destroy (SugarFont* self) {
	_g_free0 ((*self)._format);
}


SugarFont* sugar_font_dup (const SugarFont* self) {
	SugarFont* dup;
	dup = g_new0 (SugarFont, 1);
	sugar_font_copy (self, dup);
	return dup;
}


void sugar_font_free (SugarFont* self) {
	sugar_font_destroy (self);
	g_free (self);
}


GType sugar_font_get_type (void) {
	static volatile gsize sugar_font_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_font_type_id__volatile)) {
		GType sugar_font_type_id;
		sugar_font_type_id = g_boxed_type_register_static ("SugarFont", (GBoxedCopyFunc) sugar_font_dup, (GBoxedFreeFunc) sugar_font_free);
		g_once_init_leave (&sugar_font_type_id__volatile, sugar_font_type_id);
	}
	return sugar_font_type_id__volatile;
}


gint sugar_metrics_zoom (gdouble units) {
	gint result = 0;
	gdouble _tmp0_;
	_tmp0_ = _sugar_metrics_get (SUGAR_ZOOM_FACTOR);
	result = (gint) (_tmp0_ * units);
	return result;
}


gint sugar_metrics_get (gint type) {
	gint result = 0;
	gdouble _tmp0_;
	g_return_val_if_fail ((type >= 0) && (type < SUGAR_METRICS_LAST), 0);
	_tmp0_ = _sugar_metrics_get (type);
	result = (gint) _tmp0_;
	return result;
}


static gdouble _sugar_metrics_get (gint type) {
	gdouble result = 0.0;
	if (SUGAR_METRICS__values[type].value == 0.0) {
		switch (type) {
			case SUGAR_ZOOM_FACTOR:
			{
				gdouble _tmp0_;
				_tmp0_ = _sugar_metrics_get_zoom_factor ();
				result = _tmp0_;
				return result;
			}
			case SUGAR_TOOLBOX_TAB_VBORDER:
			{
				gint _tmp1_;
				gdouble _tmp2_;
				gdouble _tmp3_;
				_tmp1_ = sugar_metrics_zoom ((gdouble) 36);
				_tmp2_ = _sugar_metrics_get (SUGAR_FONT_NORMAL_H);
				_tmp3_ = _sugar_metrics_get (SUGAR_FOCUS_LINE_WIDTH);
				result = (_tmp1_ - _tmp2_) - (_tmp3_ / 2);
				return result;
			}
			case SUGAR_TOOLBOX_TAB_HBORDER:
			{
				gint _tmp4_;
				gdouble _tmp5_;
				_tmp4_ = sugar_metrics_zoom ((gdouble) 15);
				_tmp5_ = _sugar_metrics_get (SUGAR_FOCUS_LINE_WIDTH);
				result = (_tmp4_ - _tmp5_) - 1;
				return result;
			}
			default:
			{
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				_tmp6_ = g_strdup_printf ("%i", type);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strconcat ("Empty value for metrics type ", _tmp7_, NULL);
				_tmp9_ = _tmp8_;
				g_warning ("style.vala:319: %s", _tmp9_);
				_g_free0 (_tmp9_);
				_g_free0 (_tmp7_);
				result = (gdouble) 0;
				return result;
			}
		}
	} else {
		if (SUGAR_METRICS__values[type].scaled) {
			gint _tmp10_;
			_tmp10_ = sugar_metrics_zoom (SUGAR_METRICS__values[type].value);
			result = (gdouble) _tmp10_;
			return result;
		} else {
			result = SUGAR_METRICS__values[type].value;
			return result;
		}
	}
}


static gdouble _sugar_metrics_get_zoom_factor (void) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	const gchar* sugar_scale;
	if (sugar_metrics__zoom_factor > 0.0) {
		result = sugar_metrics__zoom_factor;
		return result;
	}
	_tmp0_ = g_getenv ("SUGAR_SCALING");
	sugar_scale = _tmp0_;
	if (sugar_scale == NULL) {
		sugar_metrics__zoom_factor = 1.0;
	} else {
		gint _tmp1_;
		gint scale;
		_tmp1_ = atoi (sugar_scale);
		scale = _tmp1_;
		if (scale > 0) {
			sugar_metrics__zoom_factor = scale / 100.0;
		} else {
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp2_ = string_to_string (sugar_scale);
			_tmp3_ = g_strconcat ("Invalid scaling SUGAR_SCALING=", _tmp2_, ".", NULL);
			_tmp4_ = _tmp3_;
			g_warning ("style.vala:342: %s", _tmp4_);
			_g_free0 (_tmp4_);
			sugar_metrics__zoom_factor = 1.0;
		}
	}
	result = sugar_metrics__zoom_factor;
	return result;
}


gdouble sugar_metrics_get_factor (void) {
	gdouble result;
	gdouble _tmp0_;
	_tmp0_ = _sugar_metrics_get (SUGAR_ZOOM_FACTOR);
	result = _tmp0_;
	return result;
}


SugarMetrics* sugar_metrics_dup (const SugarMetrics* self) {
	SugarMetrics* dup;
	dup = g_new0 (SugarMetrics, 1);
	memcpy (dup, self, sizeof (SugarMetrics));
	return dup;
}


void sugar_metrics_free (SugarMetrics* self) {
	g_free (self);
}


GType sugar_metrics_get_type (void) {
	static volatile gsize sugar_metrics_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_metrics_type_id__volatile)) {
		GType sugar_metrics_type_id;
		sugar_metrics_type_id = g_boxed_type_register_static ("SugarMetrics", (GBoxedCopyFunc) sugar_metrics_dup, (GBoxedFreeFunc) sugar_metrics_free);
		g_once_init_leave (&sugar_metrics_type_id__volatile, sugar_metrics_type_id);
	}
	return sugar_metrics_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



