/* palette.c generated by valac 0.12.1, the Vala compiler
 * generated from palette.vala, do not modify */

/* palette.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Port from original sugar-toolkit project.
 * File:   src/sugar/graphics/palette.py
 * Commit: 927c576e318a3aebd3217b35e1d4cf73582f0e4f
 *
 * Copyright (C) 2007, Eduardo Silva <edsiper@gmail.com>
 * Copyright (C) 2008, One Laptop Per Child
 * Copyright (C) 2009, Tomeu Vizoso
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/gui.h"
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <polyol/env.h>
#include <gdk/gdk.h>
#include <pango/pango.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SugarPalettePrivate {
	gchar* _primary_text;
	gchar* _secondary_text;
	SugarIcon* _icon;
	gboolean _icon_visible;
	GtkEventBox* _icon_box;
	GtkAlignment* _label_alignment;
	GtkAccelLabel* _label;
	GtkLabel* _secondary_label;
	GtkVBox* _secondary_box;
	SugarBin* _secondary;
	SugarTrigger* _menu_trigger;
};


static gpointer sugar_palette_parent_class = NULL;
static SugarMenuContainerIface* sugar_palette_sugar_menu_container_parent_iface = NULL;

#define SUGAR_PALETTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_PALETTE, SugarPalettePrivate))
enum  {
	SUGAR_PALETTE_DUMMY_PROPERTY,
	SUGAR_PALETTE_MENU_TRIGGER,
	SUGAR_PALETTE_PRIMARY_TEXT,
	SUGAR_PALETTE_SECONDARY_TEXT,
	SUGAR_PALETTE_TEXT_MAXLEN,
	SUGAR_PALETTE_ICON,
	SUGAR_PALETTE_ICON_VISIBLE,
	SUGAR_PALETTE_SECONDARY,
	SUGAR_PALETTE_SECONDARY_VISIBLE
};
static void sugar_palette_real_size_request (GtkWidget* base, GtkRequisition* requisition);
static void sugar_palette_real_realize (GtkWidget* base);
static void _sugar_palette_update_accept_focus (SugarPalette* self);
static void sugar_palette_real_style_set (GtkWidget* base, GtkStyle* previous_style);
static void sugar_palette_real_show (GtkWidget* base);
static void _sugar_palette_show_icon (SugarPalette* self);
static void _sugar_palette_hide_icon (SugarPalette* self);
static gboolean _sugar_palette_icon_button_release_event_cb (SugarPalette* self, GdkEventButton* event);
static void _sugar_palette_menu_trigger_activate_cb (SugarPalette* self, GtkWidget* initiator);
static GObject * sugar_palette_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void __sugar_palette_menu_trigger_activate_cb_sugar_trigger_activate (SugarTrigger* _sender, GtkWidget* initiator, gpointer self);
static gboolean __sugar_palette_icon_button_release_event_cb_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void sugar_palette_finalize (GObject* obj);
static void _vala_sugar_palette_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_palette_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void sugar_palette_real_size_request (GtkWidget* base, GtkRequisition* requisition) {
	SugarPalette * self;
	GtkRequisition _requisition = {0};
	GtkRequisition _tmp0_ = {0};
	GtkRequisition label_requisition = {0};
	GtkRequisition _tmp1_ = {0};
	guint _tmp2_;
	guint _tmp3_;
	gint label_width;
	gint _tmp4_;
	self = (SugarPalette*) base;
	GTK_WIDGET_CLASS (sugar_palette_parent_class)->size_request ((GtkWidget*) SUGAR_PALETTE_WINDOW (self), &_tmp0_);
	_requisition = _tmp0_;
	gtk_widget_size_request ((GtkWidget*) self->priv->_label_alignment, &_tmp1_);
	label_requisition = _tmp1_;
	_tmp2_ = gtk_accel_label_get_accel_width (self->priv->_label);
	_tmp3_ = gtk_container_get_border_width ((GtkContainer*) self);
	label_width = (label_requisition.width + ((gint) _tmp2_)) + (((gint) _tmp3_) * 2);
	_tmp4_ = MAX (_requisition.width, label_width);
	_requisition.width = _tmp4_;
	if (requisition) {
		*requisition = _requisition;
	}
}


static void sugar_palette_real_realize (GtkWidget* base) {
	SugarPalette * self;
	self = (SugarPalette*) base;
	GTK_WIDGET_CLASS (sugar_palette_parent_class)->realize ((GtkWidget*) SUGAR_PALETTE_WINDOW (self));
	_sugar_palette_update_accept_focus (self);
}


static void sugar_palette_real_style_set (GtkWidget* base, GtkStyle* previous_style) {
	SugarPalette * self;
	GtkStyle* _tmp0_ = NULL;
	self = (SugarPalette*) base;
	GTK_WIDGET_CLASS (sugar_palette_parent_class)->style_set ((GtkWidget*) SUGAR_PALETTE_WINDOW (self), previous_style);
	_tmp0_ = gtk_widget_get_style ((GtkWidget*) self);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) _tmp0_->xthickness);
}


static void sugar_palette_real_show (GtkWidget* base) {
	SugarPalette * self;
	SugarConnector* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GObject* _tmp2_;
	self = (SugarPalette*) base;
	_tmp0_ = sugar_palette_window_get_connector ((SugarPaletteWindow*) self);
	_tmp1_ = sugar_connector_get_subject (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_accel_label_set_accel_widget (self->priv->_label, GTK_IS_WIDGET (_tmp2_) ? ((GtkWidget*) _tmp2_) : NULL);
	GTK_WIDGET_CLASS (sugar_palette_parent_class)->show ((GtkWidget*) SUGAR_PALETTE_WINDOW (self));
}


static void _sugar_palette_show_icon (SugarPalette* self) {
	gint _tmp0_;
	GtkContainer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_metrics_get (SUGAR_DEFAULT_SPACING);
	gtk_alignment_set_padding (self->priv->_label_alignment, (guint) 0, (guint) 0, (guint) 0, (guint) _tmp0_);
	_tmp1_ = gtk_widget_get_parent ((GtkWidget*) self->priv->_icon_box);
	gtk_widget_show ((GtkWidget*) _tmp1_);
}


static void _sugar_palette_hide_icon (SugarPalette* self) {
	GtkContainer* _tmp0_ = NULL;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) self->priv->_icon_box);
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = sugar_metrics_get (SUGAR_DEFAULT_SPACING);
	_tmp2_ = sugar_metrics_get (SUGAR_DEFAULT_SPACING);
	gtk_alignment_set_padding (self->priv->_label_alignment, (guint) 0, (guint) 0, (guint) _tmp1_, (guint) _tmp2_);
}


static void _sugar_palette_update_accept_focus (SugarPalette* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = GTK_WIDGET_REALIZED ((GtkWidget*) self);
	if (_tmp0_) {
		GtkWidget* _tmp1_ = NULL;
		_tmp1_ = sugar_palette_window_get_secondary ((SugarPaletteWindow*) self);
		gdk_window_set_accept_focus (((GtkWidget*) self)->window, _tmp1_ != NULL);
	}
}


static gboolean _sugar_palette_icon_button_release_event_cb (SugarPalette* self, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_activate ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static void _sugar_palette_menu_trigger_activate_cb (SugarPalette* self, GtkWidget* initiator) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (initiator != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	g_signal_emit_by_name (self, "activate-menu", initiator);
}


SugarPalette* sugar_palette_construct (GType object_type) {
	SugarPalette * self = NULL;
	self = (SugarPalette*) sugar_palette_window_construct (object_type);
	return self;
}


SugarPalette* sugar_palette_new (void) {
	return sugar_palette_construct (SUGAR_TYPE_PALETTE);
}


static SugarTrigger* sugar_palette_real_get_menu_trigger (SugarMenuContainer* base) {
	SugarTrigger* result;
	SugarPalette* self;
	self = (SugarPalette*) base;
	result = self->priv->_menu_trigger;
	return result;
}


const gchar* sugar_palette_get_primary_text (SugarPalette* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_primary_text;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void sugar_palette_set_primary_text (SugarPalette* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_primary_text);
	self->priv->_primary_text = _tmp0_;
	if (value != NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp1_ = string_to_string (value);
		_tmp2_ = g_strconcat ("<b>", _tmp1_, "</b>", NULL);
		_tmp3_ = _tmp2_;
		gtk_label_set_markup ((GtkLabel*) self->priv->_label, _tmp3_);
		_g_free0 (_tmp3_);
		gtk_widget_show ((GtkWidget*) self->priv->_label);
	}
	g_object_notify ((GObject *) self, "primary-text");
}


const gchar* sugar_palette_get_secondary_text (SugarPalette* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_secondary_text;
	return result;
}


static gchar* string_delimit (const gchar* self, const gchar* delimiters, gchar new_delimiter) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strdelimit (_result_, delimiters, new_delimiter);
	result = _result_;
	return result;
}


void sugar_palette_set_secondary_text (SugarPalette* self, const gchar* value) {
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_secondary_text);
	self->priv->_secondary_text = _tmp0_;
	_tmp1_ = sugar_palette_get_secondary_text (self);
	if (_tmp1_ == NULL) {
		gtk_widget_hide ((GtkWidget*) self->priv->_secondary_label);
	} else {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp2_ = sugar_palette_get_secondary_text (self);
		_tmp3_ = string_delimit (_tmp2_, "\n", '\0');
		_tmp4_ = _tmp3_;
		gtk_label_set_text (self->priv->_secondary_label, _tmp4_);
		_g_free0 (_tmp4_);
		gtk_widget_show ((GtkWidget*) self->priv->_secondary_label);
	}
	g_object_notify ((GObject *) self, "secondary-text");
}


void sugar_palette_set_text_maxlen (SugarPalette* self, gint value) {
	g_return_if_fail (self != NULL);
	gtk_label_set_max_width_chars ((GtkLabel*) self->priv->_label, value);
	gtk_label_set_max_width_chars (self->priv->_secondary_label, value);
	g_object_notify ((GObject *) self, "text-maxlen");
}


SugarIcon* sugar_palette_get_icon (SugarPalette* self) {
	SugarIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_icon;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void sugar_palette_set_icon (SugarPalette* self, SugarIcon* value) {
	SugarIcon* _tmp0_ = NULL;
	SugarIcon* _tmp2_;
	SugarIcon* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_palette_get_icon (self);
	if (_tmp0_ != NULL) {
		SugarIcon* _tmp1_ = NULL;
		_tmp1_ = sugar_palette_get_icon (self);
		gtk_container_remove ((GtkContainer*) self->priv->_icon_box, (GtkWidget*) _tmp1_);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_icon);
	self->priv->_icon = _tmp2_;
	_tmp3_ = sugar_palette_get_icon (self);
	if (_tmp3_ == NULL) {
		_sugar_palette_hide_icon (self);
	} else {
		SugarIcon* _tmp4_ = NULL;
		SugarIcon* _tmp5_ = NULL;
		SugarIcon* _tmp6_ = NULL;
		_tmp4_ = sugar_palette_get_icon (self);
		sugar_icon_set_icon_size (_tmp4_, GTK_ICON_SIZE_LARGE_TOOLBAR);
		_tmp5_ = sugar_palette_get_icon (self);
		gtk_container_add ((GtkContainer*) self->priv->_icon_box, (GtkWidget*) _tmp5_);
		_tmp6_ = sugar_palette_get_icon (self);
		gtk_widget_show ((GtkWidget*) _tmp6_);
		_sugar_palette_show_icon (self);
	}
	g_object_notify ((GObject *) self, "icon");
}


gboolean sugar_palette_get_icon_visible (SugarPalette* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_icon_visible;
	return result;
}


void sugar_palette_set_icon_visible (SugarPalette* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	SugarIcon* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->_icon_visible = value;
	_tmp1_ = sugar_palette_get_icon (self);
	if (_tmp1_ != NULL) {
		gboolean _tmp2_;
		_tmp2_ = sugar_palette_get_icon_visible (self);
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_sugar_palette_show_icon (self);
	} else {
		_sugar_palette_hide_icon (self);
	}
	g_object_notify ((GObject *) self, "icon-visible");
}


static GtkWidget* sugar_palette_real_get_secondary (SugarPaletteWindow* base) {
	GtkWidget* result;
	SugarPalette* self;
	GtkWidget* _tmp0_ = NULL;
	self = (SugarPalette*) base;
	_tmp0_ = sugar_bin_get_child (self->priv->_secondary);
	result = _tmp0_;
	return result;
}


static void sugar_palette_real_set_secondary (SugarPaletteWindow* base, GtkWidget* value) {
	SugarPalette* self;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	self = (SugarPalette*) base;
	_tmp0_ = sugar_palette_window_get_secondary ((SugarPaletteWindow*) self);
	if (value == _tmp0_) {
		return;
	}
	_tmp1_ = sugar_palette_window_get_secondary ((SugarPaletteWindow*) self);
	if (_tmp1_ != NULL) {
		GtkWidget* _tmp2_ = NULL;
		_tmp2_ = sugar_palette_window_get_secondary ((SugarPaletteWindow*) self);
		gtk_container_remove ((GtkContainer*) self->priv->_secondary, _tmp2_);
	}
	if (value == NULL) {
		sugar_palette_window_set_secondary_visible ((SugarPaletteWindow*) self, FALSE);
	} else {
		gtk_widget_show (value);
		gtk_container_add ((GtkContainer*) self->priv->_secondary, value);
	}
	_sugar_palette_update_accept_focus (self);
	g_object_notify ((GObject *) self, "secondary");
}


static gboolean sugar_palette_real_get_secondary_visible (SugarPaletteWindow* base) {
	gboolean result;
	SugarPalette* self;
	gboolean _tmp0_;
	self = (SugarPalette*) base;
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self->priv->_secondary_box);
	result = _tmp0_;
	return result;
}


static void sugar_palette_real_set_secondary_visible (SugarPaletteWindow* base, gboolean value) {
	SugarPalette* self;
	self = (SugarPalette*) base;
	gtk_widget_set_visible ((GtkWidget*) self->priv->_secondary_box, value);
	g_object_notify ((GObject *) self, "secondary-visible");
}


static void __sugar_palette_menu_trigger_activate_cb_sugar_trigger_activate (SugarTrigger* _sender, GtkWidget* initiator, gpointer self) {
	_sugar_palette_menu_trigger_activate_cb (self, initiator);
}


static gboolean __sugar_palette_icon_button_release_event_cb_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _sugar_palette_icon_button_release_event_cb (self, event);
	return result;
}


static GObject * sugar_palette_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarPalette * self;
	GtkVBox* _tmp0_ = NULL;
	GtkVBox* palette_box;
	SugarTrigger* _tmp1_ = NULL;
	GtkHBox* _tmp2_ = NULL;
	GtkHBox* primary_box;
	gint _tmp3_;
	guint _tmp4_;
	GtkHBox* _tmp5_ = NULL;
	GtkHBox* icon_box;
	gint _tmp6_;
	GtkEventBox* _tmp7_ = NULL;
	GtkVBox* _tmp8_ = NULL;
	GtkVBox* labels_box;
	GtkAlignment* _tmp9_ = NULL;
	gint _tmp10_;
	gint _tmp11_;
	GtkAccelLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkVBox* _tmp14_ = NULL;
	GtkHSeparator* _tmp15_ = NULL;
	GtkHSeparator* separator;
	SugarBin* _tmp16_ = NULL;
	gint _tmp17_;
	gint _tmp18_;
	parent_class = G_OBJECT_CLASS (sugar_palette_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_PALETTE (obj);
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	palette_box = g_object_ref_sink (_tmp0_);
	gtk_widget_show ((GtkWidget*) palette_box);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) palette_box);
	_tmp1_ = sugar_trigger_new ();
	_g_object_unref0 (self->priv->_menu_trigger);
	self->priv->_menu_trigger = _tmp1_;
	g_signal_connect_object (self->priv->_menu_trigger, "activate", (GCallback) __sugar_palette_menu_trigger_activate_cb_sugar_trigger_activate, self, 0);
	_tmp2_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	primary_box = g_object_ref_sink (_tmp2_);
	_tmp3_ = sugar_metrics_get (SUGAR_GRID_CELL_SIZE);
	_tmp4_ = gtk_container_get_border_width ((GtkContainer*) self);
	gtk_widget_set_size_request ((GtkWidget*) primary_box, -1, _tmp3_ - (((gint) _tmp4_) * 2));
	gtk_widget_show ((GtkWidget*) primary_box);
	gtk_box_pack_start ((GtkBox*) palette_box, (GtkWidget*) primary_box, FALSE, TRUE, (guint) 0);
	_tmp5_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	icon_box = g_object_ref_sink (_tmp5_);
	_tmp6_ = sugar_metrics_get (SUGAR_GRID_CELL_SIZE);
	gtk_widget_set_size_request ((GtkWidget*) icon_box, _tmp6_, -1);
	gtk_box_pack_start ((GtkBox*) primary_box, (GtkWidget*) icon_box, FALSE, TRUE, (guint) 0);
	_tmp7_ = (GtkEventBox*) gtk_event_box_new ();
	_g_object_unref0 (self->priv->_icon_box);
	self->priv->_icon_box = g_object_ref_sink (_tmp7_);
	g_signal_connect_object ((GtkWidget*) self->priv->_icon_box, "button-release-event", (GCallback) __sugar_palette_icon_button_release_event_cb_gtk_widget_button_release_event, self, 0);
	gtk_widget_show ((GtkWidget*) self->priv->_icon_box);
	gtk_box_pack_start ((GtkBox*) icon_box, (GtkWidget*) self->priv->_icon_box, TRUE, TRUE, (guint) 0);
	_tmp8_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	labels_box = g_object_ref_sink (_tmp8_);
	gtk_widget_show ((GtkWidget*) labels_box);
	_tmp9_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 1.0f, 0.33f);
	_g_object_unref0 (self->priv->_label_alignment);
	self->priv->_label_alignment = g_object_ref_sink (_tmp9_);
	_tmp10_ = sugar_metrics_get (SUGAR_DEFAULT_SPACING);
	_tmp11_ = sugar_metrics_get (SUGAR_DEFAULT_SPACING);
	gtk_alignment_set_padding (self->priv->_label_alignment, (guint) 0, (guint) 0, (guint) _tmp10_, (guint) _tmp11_);
	gtk_container_add ((GtkContainer*) self->priv->_label_alignment, (GtkWidget*) labels_box);
	gtk_widget_show ((GtkWidget*) self->priv->_label_alignment);
	gtk_box_pack_start ((GtkBox*) primary_box, (GtkWidget*) self->priv->_label_alignment, TRUE, TRUE, (guint) 0);
	_tmp12_ = (GtkAccelLabel*) gtk_accel_label_new ("");
	_g_object_unref0 (self->priv->_label);
	self->priv->_label = g_object_ref_sink (_tmp12_);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->_label, 0.0f, 0.5f);
	gtk_label_set_ellipsize ((GtkLabel*) self->priv->_label, PANGO_ELLIPSIZE_MIDDLE);
	gtk_box_pack_start ((GtkBox*) labels_box, (GtkWidget*) self->priv->_label, TRUE, TRUE, (guint) 0);
	_tmp13_ = (GtkLabel*) gtk_label_new (NULL);
	_g_object_unref0 (self->priv->_secondary_label);
	self->priv->_secondary_label = g_object_ref_sink (_tmp13_);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->_secondary_label, 0.0f, 0.5f);
	gtk_label_set_ellipsize (self->priv->_secondary_label, PANGO_ELLIPSIZE_END);
	gtk_box_pack_start ((GtkBox*) labels_box, (GtkWidget*) self->priv->_secondary_label, TRUE, TRUE, (guint) 0);
	sugar_palette_set_text_maxlen (self, 60);
	_tmp14_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_g_object_unref0 (self->priv->_secondary_box);
	self->priv->_secondary_box = g_object_ref_sink (_tmp14_);
	gtk_box_pack_start ((GtkBox*) palette_box, (GtkWidget*) self->priv->_secondary_box, TRUE, TRUE, (guint) 0);
	_tmp15_ = (GtkHSeparator*) gtk_hseparator_new ();
	separator = g_object_ref_sink (_tmp15_);
	gtk_widget_show ((GtkWidget*) separator);
	gtk_box_pack_start ((GtkBox*) self->priv->_secondary_box, (GtkWidget*) separator, TRUE, TRUE, (guint) 0);
	_tmp16_ = sugar_bin_new ();
	_g_object_unref0 (self->priv->_secondary);
	self->priv->_secondary = g_object_ref_sink (_tmp16_);
	_tmp17_ = sugar_metrics_get (SUGAR_DEFAULT_SPACING);
	sugar_container_set_border_top ((SugarContainer*) self->priv->_secondary, _tmp17_);
	_tmp18_ = sugar_metrics_get (SUGAR_DEFAULT_SPACING);
	sugar_container_set_border_bottom ((SugarContainer*) self->priv->_secondary, _tmp18_);
	gtk_widget_show ((GtkWidget*) self->priv->_secondary);
	gtk_box_pack_start ((GtkBox*) self->priv->_secondary_box, (GtkWidget*) self->priv->_secondary, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (separator);
	_g_object_unref0 (labels_box);
	_g_object_unref0 (icon_box);
	_g_object_unref0 (primary_box);
	_g_object_unref0 (palette_box);
	return obj;
}


static void sugar_palette_class_init (SugarPaletteClass * klass) {
	sugar_palette_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarPalettePrivate));
	GTK_WIDGET_CLASS (klass)->size_request = sugar_palette_real_size_request;
	GTK_WIDGET_CLASS (klass)->realize = sugar_palette_real_realize;
	GTK_WIDGET_CLASS (klass)->style_set = sugar_palette_real_style_set;
	GTK_WIDGET_CLASS (klass)->show = sugar_palette_real_show;
	SUGAR_PALETTE_WINDOW_CLASS (klass)->get_secondary = sugar_palette_real_get_secondary;
	SUGAR_PALETTE_WINDOW_CLASS (klass)->set_secondary = sugar_palette_real_set_secondary;
	SUGAR_PALETTE_WINDOW_CLASS (klass)->get_secondary_visible = sugar_palette_real_get_secondary_visible;
	SUGAR_PALETTE_WINDOW_CLASS (klass)->set_secondary_visible = sugar_palette_real_set_secondary_visible;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_palette_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_palette_set_property;
	G_OBJECT_CLASS (klass)->constructor = sugar_palette_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar_palette_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SUGAR_PALETTE_MENU_TRIGGER, "menu-trigger");
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_PALETTE_PRIMARY_TEXT, g_param_spec_string ("primary-text", "primary-text", "primary-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_PALETTE_SECONDARY_TEXT, g_param_spec_string ("secondary-text", "secondary-text", "secondary-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_PALETTE_TEXT_MAXLEN, g_param_spec_int ("text-maxlen", "text-maxlen", "text-maxlen", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_PALETTE_ICON, g_param_spec_object ("icon", "icon", "icon", SUGAR_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_PALETTE_ICON_VISIBLE, g_param_spec_boolean ("icon-visible", "icon-visible", "icon-visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), SUGAR_PALETTE_SECONDARY, "secondary");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SUGAR_PALETTE_SECONDARY_VISIBLE, "secondary-visible");
	g_signal_new ("activate_menu", SUGAR_TYPE_PALETTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GTK_TYPE_WIDGET);
}


static void sugar_palette_sugar_menu_container_interface_init (SugarMenuContainerIface * iface) {
	sugar_palette_sugar_menu_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_menu_trigger = sugar_palette_real_get_menu_trigger;
}


static void sugar_palette_instance_init (SugarPalette * self) {
	self->priv = SUGAR_PALETTE_GET_PRIVATE (self);
	self->priv->_icon_visible = TRUE;
}


static void sugar_palette_finalize (GObject* obj) {
	SugarPalette * self;
	self = SUGAR_PALETTE (obj);
	_g_free0 (self->priv->_primary_text);
	_g_free0 (self->priv->_secondary_text);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->_icon_box);
	_g_object_unref0 (self->priv->_label_alignment);
	_g_object_unref0 (self->priv->_label);
	_g_object_unref0 (self->priv->_secondary_label);
	_g_object_unref0 (self->priv->_secondary_box);
	_g_object_unref0 (self->priv->_secondary);
	_g_object_unref0 (self->priv->_menu_trigger);
	G_OBJECT_CLASS (sugar_palette_parent_class)->finalize (obj);
}


GType sugar_palette_get_type (void) {
	static volatile gsize sugar_palette_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_palette_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarPaletteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_palette_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarPalette), 0, (GInstanceInitFunc) sugar_palette_instance_init, NULL };
		static const GInterfaceInfo sugar_menu_container_info = { (GInterfaceInitFunc) sugar_palette_sugar_menu_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType sugar_palette_type_id;
		sugar_palette_type_id = g_type_register_static (SUGAR_TYPE_PALETTE_WINDOW, "SugarPalette", &g_define_type_info, 0);
		g_type_add_interface_static (sugar_palette_type_id, SUGAR_TYPE_MENU_CONTAINER, &sugar_menu_container_info);
		g_once_init_leave (&sugar_palette_type_id__volatile, sugar_palette_type_id);
	}
	return sugar_palette_type_id__volatile;
}


static void _vala_sugar_palette_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarPalette * self;
	self = SUGAR_PALETTE (object);
	switch (property_id) {
		case SUGAR_PALETTE_MENU_TRIGGER:
		g_value_set_object (value, sugar_menu_container_get_menu_trigger ((SugarMenuContainer*) self));
		break;
		case SUGAR_PALETTE_PRIMARY_TEXT:
		g_value_set_string (value, sugar_palette_get_primary_text (self));
		break;
		case SUGAR_PALETTE_SECONDARY_TEXT:
		g_value_set_string (value, sugar_palette_get_secondary_text (self));
		break;
		case SUGAR_PALETTE_ICON:
		g_value_set_object (value, sugar_palette_get_icon (self));
		break;
		case SUGAR_PALETTE_ICON_VISIBLE:
		g_value_set_boolean (value, sugar_palette_get_icon_visible (self));
		break;
		case SUGAR_PALETTE_SECONDARY:
		g_value_set_object (value, sugar_palette_window_get_secondary ((SugarPaletteWindow*) self));
		break;
		case SUGAR_PALETTE_SECONDARY_VISIBLE:
		g_value_set_boolean (value, sugar_palette_window_get_secondary_visible ((SugarPaletteWindow*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_palette_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarPalette * self;
	self = SUGAR_PALETTE (object);
	switch (property_id) {
		case SUGAR_PALETTE_PRIMARY_TEXT:
		sugar_palette_set_primary_text (self, g_value_get_string (value));
		break;
		case SUGAR_PALETTE_SECONDARY_TEXT:
		sugar_palette_set_secondary_text (self, g_value_get_string (value));
		break;
		case SUGAR_PALETTE_TEXT_MAXLEN:
		sugar_palette_set_text_maxlen (self, g_value_get_int (value));
		break;
		case SUGAR_PALETTE_ICON:
		sugar_palette_set_icon (self, g_value_get_object (value));
		break;
		case SUGAR_PALETTE_ICON_VISIBLE:
		sugar_palette_set_icon_visible (self, g_value_get_boolean (value));
		break;
		case SUGAR_PALETTE_SECONDARY:
		sugar_palette_window_set_secondary ((SugarPaletteWindow*) self, g_value_get_object (value));
		break;
		case SUGAR_PALETTE_SECONDARY_VISIBLE:
		sugar_palette_window_set_secondary_visible ((SugarPaletteWindow*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



