#!/usr/bin/env python

import __init__
import unittest
import gtk
import gui

class AnimatorTest(unittest.TestCase):

    def testDefault(self):
        anim = gui.Animator(1, 10, 0.0, 1.0, gui.ANIMATION_TYPE_OUT_EXPO);
        frames = []

        def cb(sender, frame):
            if frames:
                self.assertTrue(frame > frames[-1])
            frames.append(frame)
        anim.connect ('next-frame', cb)

        def cb(sender, aborted):
            gtk.main_quit()
        anim.connect ('completed', cb)

        anim.start()
        gtk.main ()

    def testStartStop(self):
        anim = gui.Animator(1, 10, 0.3, 0.6, gui.ANIMATION_TYPE_OUT_EXPO);
        frames = []

        def cb(sender, frame):
            self.assertTrue(frame >= 0.3)
            self.assertTrue(frame <= 0.6)
            if frames:
                self.assertTrue(frame > frames[-1])
            frames.append(frame)
        anim.connect ('next-frame', cb)

        def cb(sender, aborted):
            gtk.main_quit()
        anim.connect ('completed', cb)

        anim.start()
        gtk.main ()

if __name__ == '__main__':
    unittest.main()
