include (Util)

add_custom_target (
    distclean
    COMMAND ${CMAKE_MAKE_PROGRAM} clean
    COMMAND find "\\(" -name CMakeFiles -o -name CMakeCache.txt
                -o -name cmake_install.cmake -o -name Makefile
                -o -name '*.py?' -o -name '*.so*'
                -o -name '*.pc' -o -name '*.stamp' "\\)"
                -prune -exec rm -rf {} "\\;" )

set (_project_name ${CMAKE_PROJECT_NAME}-${MAJOR_VERSION}.${MINOR_VERSION})

add_custom_target (
    dist
    COMMAND rm -rf .tmp-dist
    COMMAND mkdir -p .tmp-dist/${_project_name}
    COMMAND cd ${CMAKE_SOURCE_DIR} &&
            ${CMAKE_MAKE_PROGRAM} &&
            find "\\(" -name CMakeFiles -o -name CMakeCache.txt
                -o -name .tmp-dist -o -name cmake_install.cmake
                -o -name Makefile -o -name '.git*' -o -name '*.py?'
                -o -name '*.so*' -o -name '*.tar.*' -o -name tmp
                -o -name .sweets -o -name '*.pc' "\\)"
                -prune -o -type f -exec cp --parents -dp {}
                ${CMAKE_BINARY_DIR}/.tmp-dist/${_project_name}/ "\\;"
    COMMAND tar czpf \$\${DESTDIR-.}/${_project_name}.tar.gz -C .tmp-dist
                ${_project_name} \;
            rm -rf .tmp-dist)

add_custom_target (
    distcheck
    COMMAND ${CMAKE_COMMAND} ${CMAKE_SOURCE_DIR}
    COMMAND ${CMAKE_MAKE_PROGRAM} clean
    COMMAND ${CMAKE_MAKE_PROGRAM}
    COMMAND ${CMAKE_MAKE_PROGRAM} dist)
