from argtypes import ArgType, matcher

class CairoSurfaceArg(ArgType):

    before = ('    %(name)s = &((PycairoSurface*)(py_%(name)s))->surface;\n')

    def write_param(self, ptype, pname, pdflt, pnull, info):
        info.varlist.add('PyObject', '*py_' + pname)
        info.varlist.add('cairo_surface_t', '*'+pname)
        info.add_parselist('O', ['&py_'+pname], [pname])
        info.arglist.append(pname)
        info.codebefore.append (self.before % { 'name' : pname, 'namecopy' : 'NULL' })


    def write_return(self, ptype, ownsreturn, info):
        info.varlist.add('cairo_surface_t', '*ret')
        info.codeafter.append('    if (ret)\n'
                              '        return PycairoSurface_FromSurface(ret, NULL);\n'
                              '    else {\n'
                              '        Py_INCREF(Py_None);\n'
                              '        return Py_None;\n'
                              '    }');

matcher.register('cairo_surface_t*', CairoSurfaceArg())

