#!/usr/bin/env python

import __init__
import sys
import gtk
import random
import env, gui

window = gtk.Window()

box = gtk.VBox()
window.add(box)

toolbar = gtk.HBox()
box.pack_start(toolbar, False)

refill = gtk.Button('Refill')
def cb(sender):
    global LABEL
    LABEL = LABEL == '!' and '?' or '!'
    table.refill()
refill.connect('clicked', cb)
toolbar.add(refill)

frame_size = gtk.Button('frame_size')
def cb(sender):
    table.props.frame_width = 5
    table.props.frame_height = 5
frame_size.connect('clicked', cb)
toolbar.add(frame_size)

cell_size = gtk.Button('cell_size')
def cb(sender):
    table.props.cell_width = 100
    table.props.cell_height = 100
cell_size.connect('clicked', cb)
toolbar.add(cell_size)

cell_count = gtk.Button('cell_count')
def cb(sender):
    table.props.cell_count = table.props.cell_count == 100 and 10 or 100
cell_count.connect('clicked', cb)
toolbar.add(cell_count)

go_top = gtk.Button('go_top')
def cb(sender):
    table.scroll_to_cell(0, False)
go_top.connect('clicked', cb)
toolbar.add(go_top)

go_bottom = gtk.Button('go_bottom')
def cb(sender):
    table.scroll_to_cell(table.props.cell_count - 1, False)
go_bottom.connect('clicked', cb)
toolbar.add(go_bottom)

editable = gtk.Button('hover')
def cb(sender):
    table.props.hover_selection = not table.props.hover_selection
editable.connect('clicked', cb)
toolbar.add(editable)

editable = gtk.Button('orientation')
def cb(sender):
    if table.props.orientation == gtk.ORIENTATION_VERTICAL:
        table.props.orientation = gtk.ORIENTATION_HORIZONTAL
    else:
        table.props.orientation = gtk.ORIENTATION_VERTICAL
editable.connect('clicked', cb)
toolbar.add(editable)

scrolled = gtk.ScrolledWindow()
scrolled.set_policy(gtk.POLICY_ALWAYS, gtk.POLICY_ALWAYS)
box.pack_end(scrolled)

LABEL = '?'

class Cell(gtk.EventBox):

    def __init__(self):
        print 'Cell.__init__'

        gtk.EventBox.__init__(self)

        box = gtk.VBox()
        box.props.border_width = 10
        self.add(box)

        entry = gtk.Entry()
        box.add(entry)

        self.button = gtk.Button()
        box.add(self.button)

        def cb(sender):
            box.remove(entry)
            button = gtk.Button("!!!")
            button.show()
            box.add(button)
            #table.scroll_to_cell(self.seek_to, False)
        self.button.connect('clicked', cb)

        self.show_all()

    def do_fill_in(self, table, cell_num):
        self.seek_to = random.randint(0, table.props.cell_count - 1)

        self.button.props.label = '#%s Goto %s%s' % \
                (cell_num, self.seek_to, LABEL)

    def select(self, flag):
        if flag:
            self.modify_bg(gtk.STATE_NORMAL,
                    gui.color_type_to_rgb(env.COLOR_SELECTION_GREY))
        else:
            self.modify_bg(gtk.STATE_NORMAL,
                    gui.color_type_to_rgb(env.COLOR_WHITE))

class Table(gui.HomogeneTable):

    def do_new_cell(self):
        return Cell()

    def do_fill_cell(self, cell, index):
        cell.do_fill_in(self, index)

    def do_highlight_cell(self, cell, selected):
        cell.select(selected)

table = Table()
table.modify_bg(gtk.STATE_NORMAL, gui.color_type_to_rgb(env.COLOR_WHITE))
scrolled.add(table)

window.show_all()

def cb(__):
    global table, scrolled
    gtk.main_quit()
    scrolled.remove(table)
    table = None
    import gc
    gc.collect()
window.connect('destroy', cb)

gtk.main()
