#!/usr/bin/env python

import os
import gobject
os.environ['GTK2_RC_FILES'] = '/usr/share/sugar/data/sugar-72.gtkrc'

import gtk
from sugar.graphics.palette import Palette, ToolInvoker as _ToolInvoker
from sugar.graphics.icon import Icon

class HintPalette(Palette):

    def __init__(self):
        Palette.__init__(self, 60)
        self.props.primary_text = 'primary_text'

class MenuPalette(Palette):

    def __init__(self):
        Palette.__init__(self, 60)
        self.props.primary_text = 'primary_text primary_text primary_text'
        self.props.secondary_text = 'secondary_text'

        item = gtk.MenuItem(label='1');
        item.show()
        self.menu.insert(item, 0)

        submenu = gtk.Menu()
        item = gtk.MenuItem(label='4');
        item.show()
        submenu.insert(item, 0)

        item = gtk.MenuItem(label='2');
        item.props.submenu = submenu
        item.show()
        self.menu.insert(item, 0)

        item = gtk.MenuItem(label='3');
        item.show()
        self.menu.insert(item, 0)

class ContentPalette(Palette):

    def __init__(self):
        Palette.__init__(self, 60)
        self.props.primary_text = 'primary_text'
        self.props.secondary_text = 'secondary_text'

        box = gtk.VBox()
        self.set_content(box)

        item = gtk.MenuItem()
        item.props.label = '#1'
        item.select()
        box.pack_start(item)

        item = gtk.SeparatorMenuItem()
        box.pack_start(item)

        image = gtk.Image()
        image.props.icon_name = 'go-right'
        image.set_size_request(20, 20)
        image.show()

        item = gtk.ImageMenuItem()
        #item.props.label = '#2'
        item.set_image(image)
        box.pack_start(item)

        box.show_all()

class MenuContentPalette(Palette):

    def __init__(self):
        Palette.__init__(self, 60)
        self.props.primary_text = 'primary_text primary_text primary_text'
        self.props.secondary_text = 'secondary_text'

        item = gtk.MenuItem(label='1');
        item.show()
        self.menu.insert(item, 0)

        submenu = gtk.Menu()
        item = gtk.MenuItem(label='4');
        item.show()
        submenu.insert(item, 0)

        item = gtk.MenuItem(label='2');
        item.props.submenu = submenu
        item.show()
        self.menu.insert(item, 0)

        item = gtk.MenuItem(label='3');
        item.show()
        self.menu.insert(item, 0)

        button = gtk.Button('!!!')
        button.show()
        self.set_content(button)

class ToolInvoker(_ToolInvoker):

    def __init__(self, klass, widget):
        _ToolInvoker.__init__(self)
        self.attach_tool (widget)
        self.props.palette = klass ()

class Toolbar(gtk.Toolbar):
    def __init__(self):
        gtk.Toolbar.__init__(self)

    def do_size_request(self, requisition):
        gtk.Toolbar.do_size_request(self, requisition)
        requisition.width = 100;

    def do_allocate(self, x, y, width, height, req_width, req_height,
            origin_changed):
        print '!'
        x += 50
        width -= 100
        req_width -= 100
        #gtk.Toolbar.do_allocate(self, x, y, width, height, req_width,
        #        req_height, origin_changed)


def toolbar_new(horizontal = True):
    tool_bar = Toolbar()

    if not horizontal:
        tool_bar.props.orientation = gtk.ORIENTATION_VERTICAL

    button = gtk.ToolButton()
    button.props.icon_name = 'go-left'
    button.foo_invoker = ToolInvoker(HintPalette, button)
    tool_bar.insert (button, -1);

    def cb(sender):
        print '>', tool_bar.allocation
    button.connect('clicked', cb)

    button = gtk.ToolButton()
    button.props.icon_name = 'go-right'
    button.foo_invoker = ToolInvoker(MenuPalette, button)
    tool_bar.insert (button, -1);

    button = gtk.SeparatorToolItem()
    button.set_expand(True)
    tool_bar.insert (button, -1);

    button = gtk.ToolButton()
    button.props.icon_name = 'go-up'
    button.foo_invoker = ToolInvoker(ContentPalette, button)
    tool_bar.insert (button, -1);

    button = gtk.ToolButton()
    button.props.icon_name = 'go-down'
    button.foo_invoker = ToolInvoker(MenuContentPalette, button)
    tool_bar.insert (button, -1);

    return tool_bar

window = gtk.Window()
window.connect('destroy', lambda sender: gtk.main_quit())

vbox = gtk.VBox()
window.add(vbox)

vbox.pack_start(toolbar_new(), False)
vbox.pack_end(toolbar_new(), False)

hbox = gtk.HBox()
vbox.pack_start(hbox)

hbox.pack_start(toolbar_new(False), False)
hbox.pack_end(toolbar_new(False), False)

box = gtk.VBox()

scrolled = gtk.ScrolledWindow()
scrolled.set_policy(gtk.POLICY_ALWAYS, gtk.POLICY_ALWAYS)
scrolled.add(box)
hbox.pack_end(scrolled)


image = gtk.Image()
image.props.icon_name = 'go-right'
image.set_size_request(20, 20)
image.show()

item = gtk.ImageMenuItem()
item.props.label = '#3'
item.set_image(image)
box.pack_start(item, False)

button = gtk.Button('!!!')
def cb(sender):
    print item.size_request()
    box.pack_start(item, False)

    def timeout_cb():
        print button.props.visible, button.allocation, button.window
        print box.props.visible, box.allocation
        print item.props.visible, item.allocation

        box.remove(item)


    gobject.timeout_add(1000, timeout_cb)
button.connect('clicked', cb)
box.pack_start(button, False)


window.show_all()

box.remove(item)


gtk.main()
