/* datetime.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Port from original sugar-toolkit project.
 * File:   src/sugar/util.py
 * Commit: 2a52c9493bc5a749e0c06ec5df60b963f1594ca2
 *
 * Copyright (C) 2006-2007 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

public class Sugar.DateTime {
    public static string to_elapsed_string (time_t timestamp, max_levels = 2) {
        int levels = 0;
        string time_period;

        var elapsed_seconds = time_t () - timestamp;

        foreach (var unit in _Units.values) {

            for name_singular
              , name_plural, factor in units:

                var elapsed_units = elapsed_seconds / unit.factor;
            if (elapsed_units > 0) {
                if (levels > 0)
                    time_period += _(", ");

                key = ''.join ((os.environ['LANG'], name_singular,
                                str (elapsed_units)))
                        if key
                  in _i18n_timestamps_cache:
                    time_period += _i18n_timestamps_cache[key]
                  else:
                        translation = gettext.dngettext ('sugar-toolkit',
                                name_singular,
                                name_plural,
                                elapsed_units) % elapsed_units
                                _i18n_timestamps_cache[key] = translation
                                time_period += translation
                                elapsed_seconds -= elapsed_units * unit.factor}

                        if time_period
                          !='':
                            levels += 1 if levels
                              == max_levels:
                                break if levels
                                  == 0:
                                    return NOW return ELAPSED % time_period}

                                    private struct _Units {
                                    public string name_singular;
                                    public string name_plural;
                                    public int factor;

                                    public const _Units[] values = {
                                        { "%d year", "%d years",
                                                356 * 24 * 60 * 60 },
                                        { "%d month", "%d months",
                                                30 * 24 * 60 * 60 },
                                        { "%d week", "%d weeks",
                                                7 * 24 * 60 * 60 },
                                        { "%d day", "%d days", 24 * 60 * 60 },
                                        { "%d hour", "%d hours", 60 * 60 },
                                        { "%d minute", "%d minutes", 60 }
                                    };
                                    }
# TRANS: Indicating time passed, eg. "[10 day, 5 hours] ago",
# "[2 minutes] in the past", or "[3 years, 1 month] earlier"
                ELAPSED = _('%s ago')
# Explanation of the following hack:
# The xgettext utility extracts plural forms by reading the strings included as
# parameters of ngettext(). As our plurals are not passed to ngettext()
# straight away because there needs to be a calculation before we know which
# strings need to be used, then we need to call ngettext() in a fake way so
# xgettext will pick them up as plurals.
              def ngettext (singular, plural, n):
                pass
# TRANS: Relative dates (eg. 1 month and 5 days).
                        ngettext ('%d year', '%d years', 1)
                        ngettext ('%d month', '%d months', 1)
                        ngettext ('%d week', '%d weeks', 1)
                        ngettext ('%d day', '%d days', 1)
                        ngettext ('%d hour', '%d hours', 1)
                        ngettext ('%d minute', '%d minutes', 1) del ngettext
# End of plurals hack
# gettext perfs hack (#7959)
            _i18n_timestamps_cache = LRU (60)}
