/* palettewindow.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Port from original sugar-toolkit project.
 * File:   src/sugar/graphics/palettewindow.py
 * Commit: c684950ecff34e910e6da5840737a469f95a0e79
 *
 * Copyright (C) 2007, Eduardo Silva <edsiper@gmail.com>
 * Copyright (C) 2008, One Laptop Per Child
 * Copyright (C) 2009, Tomeu Vizoso
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

public class Sugar.PaletteWindow : Gtk.Window {
    public Connector connector { get; set; }

    public virtual Gtk.Widget? secondary {
        get { return null; }
        set { }
    }

    public virtual bool secondary_visible {
        get { return false; }
        set { }
    }

    construct {
        set_decorated (false);
        set_resizable (false);
        // Just assume xthickness and ythickness are the same
        set_border_width (style.xthickness);

        var accel_group = new Gtk.AccelGroup ();
        set_data ("sugar-accel-group", accel_group);
        add_accel_group (accel_group);
    }

    public Gdk.Rectangle get_rect () {
        return _reveal_rect;
    }

    public void reveal () {
        Gtk.Requisition palette_size;
        size_request (out palette_size);

        int x, y;
        connector.get_palette_pos (palette_size, out x, out y);

        _reveal_rect.x = x;
        _reveal_rect.y = y;
        _reveal_rect.width = palette_size.width;
        _reveal_rect.height = palette_size.height;

        move (x, y);
        show ();
        // have to invoke move twice, WM could ignore before-show move request
        move (x, y);
    }

    public override void realize () {
        base.realize ();
        window.set_type_hint (Gdk.WindowTypeHint.DIALOG);
    }

    public override void size_request (out Gtk.Requisition requisition) {
        base.size_request (out requisition);
        requisition.width = int.max (requisition.width,
                Metrics.get (Metrics.GRID_CELL_SIZE) * 2);
    }

    public override void size_allocate (Gdk.Rectangle allocation) {
        base.size_allocate (allocation);

        if (_old_alloc != allocation)
            queue_draw ();

        /* We need to store old allocation because when size_allocate
         * is called widget.allocation is already updated.
         * Gtk.Window resizing is different from normal containers:
         * the X window is resized, widget.allocation is updated from
         * the configure request handler and finally size_allocate is called. */
        _old_alloc = allocation;
    }

    public override bool expose_event (Gdk.EventExpose event) {
        Gtk.PositionType gap_side = Gtk.PositionType.TOP;
        int gap_start = 0, gap_size = 0;

        if (connector != null && Connector.get_box_gap (get_rect (),
                        connector.get_rect (), out gap_side, out gap_start,
                        out gap_size))
            Gtk.paint_box_gap (style, event.window, Gtk.StateType.PRELIGHT,
                    Gtk.ShadowType.IN, event.area, this, "palette",
                    0, 0, allocation.width, allocation.height,
                    gap_side, gap_start, gap_size);
        else
            Gtk.paint_box (style, event.window, Gtk.StateType.PRELIGHT,
                    Gtk.ShadowType.IN, event.area, this, "palette",
                    0, 0, allocation.width, allocation.height);

        // Ignore the Gtk.Window expose handler which redraws everything
        foreach (var child in get_children ())
            propagate_expose (child, event);

        return true;
    }

    public override bool key_press_event (Gdk.EventKey event) {
        if (connector != null && event.keyval == 0xff1b /* XK_Escape */ )
            connector.popdown ();
        return false;
    }

    private Gdk.Rectangle _old_alloc;
    private Gdk.Rectangle _reveal_rect;
}
