/* activity_widgets.c generated by valac 0.12.1, the Vala compiler
 * generated from activity_widgets.vala, do not modify */

/* activity_widgets.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/toolkit.h"
#include <polyol/ds.h>
#include <polyol/gui.h>
#include <polyol/env.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <polyol/collab.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SugarActivityButtonPrivate {
	SugarJobject* _jobject;
};

struct _SugarActivityToolbarButtonPrivate {
	SugarTitleEntry* _title;
	SugarKeepButton* _keep;
};

struct _SugarKeepButtonPrivate {
	SugarJobject* _jobject;
};

struct _SugarShareButtonPrivate {
	SugarConnection* _connection;
};

struct _SugarTitleEntryPrivate {
	GtkEntry* _entry;
	SugarJobject* _jobject;
	guint _timeout;
};


static gpointer sugar_activity_button_parent_class = NULL;
static gpointer sugar_activity_toolbar_button_parent_class = NULL;
static gpointer sugar_stop_button_parent_class = NULL;
static gpointer sugar_undo_button_parent_class = NULL;
static gpointer sugar_redo_button_parent_class = NULL;
static gpointer sugar_copy_button_parent_class = NULL;
static gpointer sugar_paste_button_parent_class = NULL;
static gpointer sugar_keep_button_parent_class = NULL;
static gpointer sugar_share_button_parent_class = NULL;
static gpointer sugar_title_entry_parent_class = NULL;

#define SUGAR_ACTIVITY_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_ACTIVITY_BUTTON, SugarActivityButtonPrivate))
enum  {
	SUGAR_ACTIVITY_BUTTON_DUMMY_PROPERTY
};
static void _sugar_activity_button_notify_title_cb (SugarActivityButton* self, GObject* sender, GParamSpec* param);
static void __sugar_activity_button_notify_title_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void sugar_activity_button_finalize (GObject* obj);
#define SUGAR_ACTIVITY_TOOLBAR_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_ACTIVITY_TOOLBAR_BUTTON, SugarActivityToolbarButtonPrivate))
enum  {
	SUGAR_ACTIVITY_TOOLBAR_BUTTON_DUMMY_PROPERTY,
	SUGAR_ACTIVITY_TOOLBAR_BUTTON_TITLE,
	SUGAR_ACTIVITY_TOOLBAR_BUTTON_KEEP
};
static void sugar_activity_toolbar_button_set_title (SugarActivityToolbarButton* self, SugarTitleEntry* value);
static void sugar_activity_toolbar_button_set_keep (SugarActivityToolbarButton* self, SugarKeepButton* value);
static void sugar_activity_toolbar_button_finalize (GObject* obj);
static void _vala_sugar_activity_toolbar_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_activity_toolbar_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	SUGAR_STOP_BUTTON_DUMMY_PROPERTY
};
static GObject * sugar_stop_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	SUGAR_UNDO_BUTTON_DUMMY_PROPERTY
};
static GObject * sugar_undo_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	SUGAR_REDO_BUTTON_DUMMY_PROPERTY
};
static GObject * sugar_redo_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	SUGAR_COPY_BUTTON_DUMMY_PROPERTY
};
static GObject * sugar_copy_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	SUGAR_PASTE_BUTTON_DUMMY_PROPERTY
};
static GObject * sugar_paste_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define SUGAR_KEEP_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_KEEP_BUTTON, SugarKeepButtonPrivate))
enum  {
	SUGAR_KEEP_BUTTON_DUMMY_PROPERTY
};
static void _sugar_keep_button_clicked_cb (SugarKeepButton* self);
static void __sugar_keep_button_clicked_cb_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void sugar_keep_button_finalize (GObject* obj);
#define SUGAR_SHARE_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_SHARE_BUTTON, SugarShareButtonPrivate))
enum  {
	SUGAR_SHARE_BUTTON_DUMMY_PROPERTY
};
static void _sugar_share_button_scope_changed_cb (SugarShareButton* self, SugarShareScope prev_state, const gchar* _error_);
static void __sugar_share_button_scope_changed_cb_sugar_connection_scope_changed (SugarConnection* _sender, SugarShareScope prev_scope, const gchar* _error_, gpointer self);
static void _sugar_share_button_scope_changing_cb (SugarShareButton* self, GObject* sender, GParamSpec* param);
static void __sugar_share_button_scope_changing_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _sugar_share_button_changed_cb (SugarShareButton* self, GtkRadioAction* current);
static void __sugar_share_button_changed_cb_gtk_radio_action_changed (GtkRadioAction* _sender, GtkRadioAction* current, gpointer self);
static void sugar_share_button_finalize (GObject* obj);
#define SUGAR_TITLE_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_TITLE_ENTRY, SugarTitleEntryPrivate))
enum  {
	SUGAR_TITLE_ENTRY_DUMMY_PROPERTY,
	SUGAR_TITLE_ENTRY_ENTRY
};
#define SUGAR_TITLE_ENTRY__TIMEOUT_IN_SEC 1
static void sugar_title_entry_set_entry (SugarTitleEntry* self, GtkEntry* value);
static void _sugar_title_entry_entry_changed_cb (SugarTitleEntry* self);
static void __sugar_title_entry_entry_changed_cb_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _sugar_title_entry_notify_title_cb (SugarTitleEntry* self, GObject* sender, GParamSpec* param);
static void __sugar_title_entry_notify_title_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _sugar_title_entry_timeout_cb (SugarTitleEntry* self);
static gboolean __sugar_title_entry_timeout_cb_gsource_func (gpointer self);
static void sugar_title_entry_finalize (GObject* obj);
static void _vala_sugar_title_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_title_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * @param jobject   activity jobject to be based on
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __sugar_activity_button_notify_title_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_sugar_activity_button_notify_title_cb (self, _sender, pspec);
}


SugarActivityButton* sugar_activity_button_construct (GType object_type, SugarJobject* jobject) {
	SugarActivityButton * self = NULL;
	SugarJobject* _tmp0_;
	SugarActivityInfo _tmp1_ = {0};
	SugarIcon* _tmp2_ = NULL;
	SugarXoColor _tmp3_ = {0};
	const gchar* _tmp4_ = NULL;
	g_return_val_if_fail (jobject != NULL, NULL);
	self = (SugarActivityButton*) sugar_tool_button_construct (object_type);
	_tmp0_ = _g_object_ref0 (jobject);
	_g_object_unref0 (self->priv->_jobject);
	self->priv->_jobject = _tmp0_;
	sugar_environ_get_activity (&_tmp1_);
	sugar_tool_button_set_icon_name ((SugarToolButton*) self, _tmp1_.icon);
	_tmp2_ = sugar_tool_button_get_icon ((SugarToolButton*) self);
	sugar_jobject_get_icon_color (self->priv->_jobject, &_tmp3_);
	sugar_icon_set_xo_color (_tmp2_, &_tmp3_);
	_tmp4_ = sugar_jobject_get_title (self->priv->_jobject);
	sugar_tool_button_set_tooltip ((SugarToolButton*) self, _tmp4_);
	g_signal_connect_object ((GObject*) self->priv->_jobject, "notify::title", (GCallback) __sugar_activity_button_notify_title_cb_g_object_notify, self, 0);
	return self;
}


SugarActivityButton* sugar_activity_button_new (SugarJobject* jobject) {
	return sugar_activity_button_construct (SUGAR_TYPE_ACTIVITY_BUTTON, jobject);
}


static void _sugar_activity_button_notify_title_cb (SugarActivityButton* self, GObject* sender, GParamSpec* param) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = sugar_jobject_get_title (self->priv->_jobject);
	sugar_tool_button_set_tooltip ((SugarToolButton*) self, _tmp0_);
}


static void sugar_activity_button_class_init (SugarActivityButtonClass * klass) {
	sugar_activity_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarActivityButtonPrivate));
	G_OBJECT_CLASS (klass)->finalize = sugar_activity_button_finalize;
}


static void sugar_activity_button_instance_init (SugarActivityButton * self) {
	self->priv = SUGAR_ACTIVITY_BUTTON_GET_PRIVATE (self);
}


static void sugar_activity_button_finalize (GObject* obj) {
	SugarActivityButton * self;
	self = SUGAR_ACTIVITY_BUTTON (obj);
	_g_object_unref0 (self->priv->_jobject);
	G_OBJECT_CLASS (sugar_activity_button_parent_class)->finalize (obj);
}


/**
 * Tool button that represnts activity
 *
 * Button shows icon, color and tooltip of an activity.
 *
 * If activity has many tool items, use ActivityToolbarButton to save space
 * in toolbar by placing all activity related items to ActivityToolbarButton's
 * sub-toolbar.
 *
 * It is a good practice to have this button at leftmost position in a toolbar.
 */
GType sugar_activity_button_get_type (void) {
	static volatile gsize sugar_activity_button_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_activity_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarActivityButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_activity_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarActivityButton), 0, (GInstanceInitFunc) sugar_activity_button_instance_init, NULL };
		GType sugar_activity_button_type_id;
		sugar_activity_button_type_id = g_type_register_static (SUGAR_TYPE_TOOL_BUTTON, "SugarActivityButton", &g_define_type_info, 0);
		g_once_init_leave (&sugar_activity_button_type_id__volatile, sugar_activity_button_type_id);
	}
	return sugar_activity_button_type_id__volatile;
}


/**
     * @param activity  activity to create button for
     */
SugarActivityToolbarButton* sugar_activity_toolbar_button_construct (GType object_type, SugarActivity* activity) {
	SugarActivityToolbarButton * self = NULL;
	SugarActivityInfo _tmp0_ = {0};
	GtkToolbar* _tmp1_ = NULL;
	GtkToolbar* toolbar;
	SugarJobject* _tmp2_ = NULL;
	SugarConnection* _tmp14_ = NULL;
	g_return_val_if_fail (activity != NULL, NULL);
	self = (SugarActivityToolbarButton*) sugar_toolbar_button_construct (object_type);
	sugar_environ_get_activity (&_tmp0_);
	sugar_tool_button_set_icon_name ((SugarToolButton*) self, _tmp0_.icon);
	_tmp1_ = (GtkToolbar*) gtk_toolbar_new ();
	toolbar = g_object_ref_sink (_tmp1_);
	sugar_toolbar_button_set_page ((SugarToolbarButton*) self, (GtkWidget*) toolbar);
	_tmp2_ = sugar_activity_get_jobject (activity);
	if (_tmp2_ == NULL) {
		SugarIcon* _tmp3_ = NULL;
		SugarXoColor _tmp4_ = {0};
		_tmp3_ = sugar_tool_button_get_icon ((SugarToolButton*) self);
		sugar_profile_get_color (&_tmp4_);
		sugar_icon_set_xo_color (_tmp3_, &_tmp4_);
	} else {
		SugarIcon* _tmp5_ = NULL;
		SugarJobject* _tmp6_ = NULL;
		SugarXoColor _tmp7_ = {0};
		SugarJobject* _tmp8_ = NULL;
		SugarTitleEntry* _tmp9_ = NULL;
		SugarTitleEntry* _tmp10_;
		SugarJobject* _tmp11_ = NULL;
		SugarKeepButton* _tmp12_ = NULL;
		SugarKeepButton* _tmp13_;
		_tmp5_ = sugar_tool_button_get_icon ((SugarToolButton*) self);
		_tmp6_ = sugar_activity_get_jobject (activity);
		sugar_jobject_get_icon_color (_tmp6_, &_tmp7_);
		sugar_icon_set_xo_color (_tmp5_, &_tmp7_);
		_tmp8_ = sugar_activity_get_jobject (activity);
		_tmp9_ = sugar_title_entry_new (_tmp8_);
		_tmp10_ = g_object_ref_sink (_tmp9_);
		sugar_activity_toolbar_button_set_title (self, _tmp10_);
		_g_object_unref0 (_tmp10_);
		gtk_toolbar_insert (toolbar, (GtkToolItem*) self->priv->_title, -1);
		_tmp11_ = sugar_activity_get_jobject (activity);
		_tmp12_ = sugar_keep_button_new (_tmp11_);
		_tmp13_ = g_object_ref_sink (_tmp12_);
		sugar_activity_toolbar_button_set_keep (self, _tmp13_);
		_g_object_unref0 (_tmp13_);
		gtk_toolbar_insert (toolbar, (GtkToolItem*) self->priv->_keep, -1);
	}
	_tmp14_ = sugar_activity_get_connection (activity);
	if (_tmp14_ != NULL) {
		SugarConnection* _tmp15_ = NULL;
		SugarShareButton* _tmp16_ = NULL;
		SugarShareButton* share;
		_tmp15_ = sugar_activity_get_connection (activity);
		_tmp16_ = sugar_share_button_new (_tmp15_);
		share = g_object_ref_sink (_tmp16_);
		gtk_toolbar_insert (toolbar, (GtkToolItem*) share, 1);
		_g_object_unref0 (share);
	}
	gtk_widget_show_all ((GtkWidget*) toolbar);
	_g_object_unref0 (toolbar);
	return self;
}


SugarActivityToolbarButton* sugar_activity_toolbar_button_new (SugarActivity* activity) {
	return sugar_activity_toolbar_button_construct (SUGAR_TYPE_ACTIVITY_TOOLBAR_BUTTON, activity);
}


SugarTitleEntry* sugar_activity_toolbar_button_get_title (SugarActivityToolbarButton* self) {
	SugarTitleEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_title;
	return result;
}


static void sugar_activity_toolbar_button_set_title (SugarActivityToolbarButton* self, SugarTitleEntry* value) {
	SugarTitleEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_title);
	self->priv->_title = _tmp0_;
	g_object_notify ((GObject *) self, "title");
}


SugarKeepButton* sugar_activity_toolbar_button_get_keep (SugarActivityToolbarButton* self) {
	SugarKeepButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_keep;
	return result;
}


static void sugar_activity_toolbar_button_set_keep (SugarActivityToolbarButton* self, SugarKeepButton* value) {
	SugarKeepButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_keep);
	self->priv->_keep = _tmp0_;
	g_object_notify ((GObject *) self, "keep");
}


static void sugar_activity_toolbar_button_class_init (SugarActivityToolbarButtonClass * klass) {
	sugar_activity_toolbar_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarActivityToolbarButtonPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_activity_toolbar_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_activity_toolbar_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = sugar_activity_toolbar_button_finalize;
	/**
	     * Activity title widget
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ACTIVITY_TOOLBAR_BUTTON_TITLE, g_param_spec_object ("title", "title", "title", SUGAR_TYPE_TITLE_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Activity keep button
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ACTIVITY_TOOLBAR_BUTTON_KEEP, g_param_spec_object ("keep", "keep", "keep", SUGAR_TYPE_KEEP_BUTTON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void sugar_activity_toolbar_button_instance_init (SugarActivityToolbarButton * self) {
	self->priv = SUGAR_ACTIVITY_TOOLBAR_BUTTON_GET_PRIVATE (self);
}


static void sugar_activity_toolbar_button_finalize (GObject* obj) {
	SugarActivityToolbarButton * self;
	self = SUGAR_ACTIVITY_TOOLBAR_BUTTON (obj);
	_g_object_unref0 (self->priv->_title);
	_g_object_unref0 (self->priv->_keep);
	G_OBJECT_CLASS (sugar_activity_toolbar_button_parent_class)->finalize (obj);
}


/**
 * Tool button and sub-toolbar that represnt activity
 *
 * Button shows icon, color of an activity. Sub-toolbar provides default set
 * of activity related widgets thus it is a good method to save space in toolbar
 * for other activity tool items.
 *
 * It is a good practice to have this button at leftmost position in a toolbar.
 */
GType sugar_activity_toolbar_button_get_type (void) {
	static volatile gsize sugar_activity_toolbar_button_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_activity_toolbar_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarActivityToolbarButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_activity_toolbar_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarActivityToolbarButton), 0, (GInstanceInitFunc) sugar_activity_toolbar_button_instance_init, NULL };
		GType sugar_activity_toolbar_button_type_id;
		sugar_activity_toolbar_button_type_id = g_type_register_static (SUGAR_TYPE_TOOLBAR_BUTTON, "SugarActivityToolbarButton", &g_define_type_info, 0);
		g_once_init_leave (&sugar_activity_toolbar_button_type_id__volatile, sugar_activity_toolbar_button_type_id);
	}
	return sugar_activity_toolbar_button_type_id__volatile;
}


static void _vala_sugar_activity_toolbar_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarActivityToolbarButton * self;
	self = SUGAR_ACTIVITY_TOOLBAR_BUTTON (object);
	switch (property_id) {
		case SUGAR_ACTIVITY_TOOLBAR_BUTTON_TITLE:
		g_value_set_object (value, sugar_activity_toolbar_button_get_title (self));
		break;
		case SUGAR_ACTIVITY_TOOLBAR_BUTTON_KEEP:
		g_value_set_object (value, sugar_activity_toolbar_button_get_keep (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_activity_toolbar_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarActivityToolbarButton * self;
	self = SUGAR_ACTIVITY_TOOLBAR_BUTTON (object);
	switch (property_id) {
		case SUGAR_ACTIVITY_TOOLBAR_BUTTON_TITLE:
		sugar_activity_toolbar_button_set_title (self, g_value_get_object (value));
		break;
		case SUGAR_ACTIVITY_TOOLBAR_BUTTON_KEEP:
		sugar_activity_toolbar_button_set_keep (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


SugarStopButton* sugar_stop_button_construct (GType object_type) {
	SugarStopButton * self = NULL;
	self = (SugarStopButton*) sugar_tool_button_construct (object_type);
	return self;
}


SugarStopButton* sugar_stop_button_new (void) {
	return sugar_stop_button_construct (SUGAR_TYPE_STOP_BUTTON);
}


static GObject * sugar_stop_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarStopButton * self;
	const gchar* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (sugar_stop_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_STOP_BUTTON (obj);
	sugar_tool_button_set_icon_name ((SugarToolButton*) self, "activity-stop");
	_tmp0_ = _ ("Stop");
	sugar_tool_button_set_tooltip ((SugarToolButton*) self, _tmp0_);
	sugar_tool_button_set_accelerator ((SugarToolButton*) self, "<Ctrl>Q");
	return obj;
}


static void sugar_stop_button_class_init (SugarStopButtonClass * klass) {
	sugar_stop_button_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = sugar_stop_button_constructor;
}


static void sugar_stop_button_instance_init (SugarStopButton * self) {
}


/**
 * Tool button to close activity
 *
 * Class just presets defualt values for properties like icon and tooltip,
 * connect to clicked event to make button useful.
 *
 * It is a good practice to have this button at rightmost position in a toolbar
 * prepended by expanded separator.
 */
GType sugar_stop_button_get_type (void) {
	static volatile gsize sugar_stop_button_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_stop_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarStopButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_stop_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarStopButton), 0, (GInstanceInitFunc) sugar_stop_button_instance_init, NULL };
		GType sugar_stop_button_type_id;
		sugar_stop_button_type_id = g_type_register_static (SUGAR_TYPE_TOOL_BUTTON, "SugarStopButton", &g_define_type_info, 0);
		g_once_init_leave (&sugar_stop_button_type_id__volatile, sugar_stop_button_type_id);
	}
	return sugar_stop_button_type_id__volatile;
}


SugarUndoButton* sugar_undo_button_construct (GType object_type) {
	SugarUndoButton * self = NULL;
	self = (SugarUndoButton*) sugar_tool_button_construct (object_type);
	return self;
}


SugarUndoButton* sugar_undo_button_new (void) {
	return sugar_undo_button_construct (SUGAR_TYPE_UNDO_BUTTON);
}


static GObject * sugar_undo_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarUndoButton * self;
	const gchar* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (sugar_undo_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_UNDO_BUTTON (obj);
	sugar_tool_button_set_icon_name ((SugarToolButton*) self, "edit-undo");
	_tmp0_ = _ ("Undo");
	sugar_tool_button_set_tooltip ((SugarToolButton*) self, _tmp0_);
	sugar_tool_button_set_accelerator ((SugarToolButton*) self, "<Ctrl>Z");
	return obj;
}


static void sugar_undo_button_class_init (SugarUndoButtonClass * klass) {
	sugar_undo_button_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = sugar_undo_button_constructor;
}


static void sugar_undo_button_instance_init (SugarUndoButton * self) {
}


/**
 * Tool button to undo changes
 *
 * Class just presets defualt values for properties like icon and tooltip,
 * connect to clicked event to make button useful.
 */
GType sugar_undo_button_get_type (void) {
	static volatile gsize sugar_undo_button_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_undo_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarUndoButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_undo_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarUndoButton), 0, (GInstanceInitFunc) sugar_undo_button_instance_init, NULL };
		GType sugar_undo_button_type_id;
		sugar_undo_button_type_id = g_type_register_static (SUGAR_TYPE_TOOL_BUTTON, "SugarUndoButton", &g_define_type_info, 0);
		g_once_init_leave (&sugar_undo_button_type_id__volatile, sugar_undo_button_type_id);
	}
	return sugar_undo_button_type_id__volatile;
}


SugarRedoButton* sugar_redo_button_construct (GType object_type) {
	SugarRedoButton * self = NULL;
	self = (SugarRedoButton*) sugar_tool_button_construct (object_type);
	return self;
}


SugarRedoButton* sugar_redo_button_new (void) {
	return sugar_redo_button_construct (SUGAR_TYPE_REDO_BUTTON);
}


static GObject * sugar_redo_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarRedoButton * self;
	const gchar* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (sugar_redo_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_REDO_BUTTON (obj);
	sugar_tool_button_set_icon_name ((SugarToolButton*) self, "edit-redo");
	_tmp0_ = _ ("Redo");
	sugar_tool_button_set_tooltip ((SugarToolButton*) self, _tmp0_);
	return obj;
}


static void sugar_redo_button_class_init (SugarRedoButtonClass * klass) {
	sugar_redo_button_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = sugar_redo_button_constructor;
}


static void sugar_redo_button_instance_init (SugarRedoButton * self) {
}


/**
 * Tool button to redo changes
 *
 * Class just presets defualt values for properties like icon and tooltip,
 * connect to clicked event to make button useful.
 */
GType sugar_redo_button_get_type (void) {
	static volatile gsize sugar_redo_button_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_redo_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarRedoButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_redo_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarRedoButton), 0, (GInstanceInitFunc) sugar_redo_button_instance_init, NULL };
		GType sugar_redo_button_type_id;
		sugar_redo_button_type_id = g_type_register_static (SUGAR_TYPE_TOOL_BUTTON, "SugarRedoButton", &g_define_type_info, 0);
		g_once_init_leave (&sugar_redo_button_type_id__volatile, sugar_redo_button_type_id);
	}
	return sugar_redo_button_type_id__volatile;
}


SugarCopyButton* sugar_copy_button_construct (GType object_type) {
	SugarCopyButton * self = NULL;
	self = (SugarCopyButton*) sugar_tool_button_construct (object_type);
	return self;
}


SugarCopyButton* sugar_copy_button_new (void) {
	return sugar_copy_button_construct (SUGAR_TYPE_COPY_BUTTON);
}


static GObject * sugar_copy_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarCopyButton * self;
	const gchar* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (sugar_copy_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_COPY_BUTTON (obj);
	sugar_tool_button_set_icon_name ((SugarToolButton*) self, "edit-copy");
	_tmp0_ = _ ("Copy");
	sugar_tool_button_set_tooltip ((SugarToolButton*) self, _tmp0_);
	return obj;
}


static void sugar_copy_button_class_init (SugarCopyButtonClass * klass) {
	sugar_copy_button_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = sugar_copy_button_constructor;
}


static void sugar_copy_button_instance_init (SugarCopyButton * self) {
}


/**
 * Tool button to copy
 *
 * Class just presets defualt values for properties like icon and tooltip,
 * connect to clicked event to make button useful.
 */
GType sugar_copy_button_get_type (void) {
	static volatile gsize sugar_copy_button_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_copy_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarCopyButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_copy_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarCopyButton), 0, (GInstanceInitFunc) sugar_copy_button_instance_init, NULL };
		GType sugar_copy_button_type_id;
		sugar_copy_button_type_id = g_type_register_static (SUGAR_TYPE_TOOL_BUTTON, "SugarCopyButton", &g_define_type_info, 0);
		g_once_init_leave (&sugar_copy_button_type_id__volatile, sugar_copy_button_type_id);
	}
	return sugar_copy_button_type_id__volatile;
}


SugarPasteButton* sugar_paste_button_construct (GType object_type) {
	SugarPasteButton * self = NULL;
	self = (SugarPasteButton*) sugar_tool_button_construct (object_type);
	return self;
}


SugarPasteButton* sugar_paste_button_new (void) {
	return sugar_paste_button_construct (SUGAR_TYPE_PASTE_BUTTON);
}


static GObject * sugar_paste_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarPasteButton * self;
	const gchar* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (sugar_paste_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_PASTE_BUTTON (obj);
	sugar_tool_button_set_icon_name ((SugarToolButton*) self, "edit-paste");
	_tmp0_ = _ ("Paste");
	sugar_tool_button_set_tooltip ((SugarToolButton*) self, _tmp0_);
	return obj;
}


static void sugar_paste_button_class_init (SugarPasteButtonClass * klass) {
	sugar_paste_button_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = sugar_paste_button_constructor;
}


static void sugar_paste_button_instance_init (SugarPasteButton * self) {
}


/**
 * Tool button to paste
 *
 * Class just presets defualt values for properties like icon and tooltip,
 * connect to clicked event to make button useful.
 */
GType sugar_paste_button_get_type (void) {
	static volatile gsize sugar_paste_button_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_paste_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarPasteButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_paste_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarPasteButton), 0, (GInstanceInitFunc) sugar_paste_button_instance_init, NULL };
		GType sugar_paste_button_type_id;
		sugar_paste_button_type_id = g_type_register_static (SUGAR_TYPE_TOOL_BUTTON, "SugarPasteButton", &g_define_type_info, 0);
		g_once_init_leave (&sugar_paste_button_type_id__volatile, sugar_paste_button_type_id);
	}
	return sugar_paste_button_type_id__volatile;
}


/**
     * @param jobject   activity jobject to be based on
     */
static void __sugar_keep_button_clicked_cb_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	_sugar_keep_button_clicked_cb (self);
}


SugarKeepButton* sugar_keep_button_construct (GType object_type, SugarJobject* jobject) {
	SugarKeepButton * self = NULL;
	SugarJobject* _tmp0_;
	const gchar* _tmp1_ = NULL;
	SugarIcon* _tmp2_ = NULL;
	SugarXoColor _tmp3_ = {0};
	g_return_val_if_fail (jobject != NULL, NULL);
	self = (SugarKeepButton*) sugar_tool_button_construct (object_type);
	_tmp0_ = _g_object_ref0 (jobject);
	_g_object_unref0 (self->priv->_jobject);
	self->priv->_jobject = _tmp0_;
	_tmp1_ = _ ("Keep");
	sugar_tool_button_set_tooltip ((SugarToolButton*) self, _tmp1_);
	sugar_tool_button_set_accelerator ((SugarToolButton*) self, "<Ctrl>S");
	sugar_tool_button_set_icon_name ((SugarToolButton*) self, "document-save");
	_tmp2_ = sugar_tool_button_get_icon ((SugarToolButton*) self);
	sugar_profile_get_color (&_tmp3_);
	sugar_icon_set_xo_color (_tmp2_, &_tmp3_);
	g_signal_connect_object ((GtkToolButton*) self, "clicked", (GCallback) __sugar_keep_button_clicked_cb_gtk_tool_button_clicked, self, 0);
	return self;
}


SugarKeepButton* sugar_keep_button_new (SugarJobject* jobject) {
	return sugar_keep_button_construct (SUGAR_TYPE_KEEP_BUTTON, jobject);
}


static void _sugar_keep_button_clicked_cb (SugarKeepButton* self) {
	g_return_if_fail (self != NULL);
	sugar_jobject_cow (self->priv->_jobject);
}


static void sugar_keep_button_class_init (SugarKeepButtonClass * klass) {
	sugar_keep_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarKeepButtonPrivate));
	G_OBJECT_CLASS (klass)->finalize = sugar_keep_button_finalize;
}


static void sugar_keep_button_instance_init (SugarKeepButton * self) {
	self->priv = SUGAR_KEEP_BUTTON_GET_PRIVATE (self);
}


static void sugar_keep_button_finalize (GObject* obj) {
	SugarKeepButton * self;
	self = SUGAR_KEEP_BUTTON (obj);
	_g_object_unref0 (self->priv->_jobject);
	G_OBJECT_CLASS (sugar_keep_button_parent_class)->finalize (obj);
}


/**
 * Tool button to save a copy of journal entry
 *
 * On click event, button will save a copy of passed Jobject.
 */
GType sugar_keep_button_get_type (void) {
	static volatile gsize sugar_keep_button_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_keep_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarKeepButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_keep_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarKeepButton), 0, (GInstanceInitFunc) sugar_keep_button_instance_init, NULL };
		GType sugar_keep_button_type_id;
		sugar_keep_button_type_id = g_type_register_static (SUGAR_TYPE_TOOL_BUTTON, "SugarKeepButton", &g_define_type_info, 0);
		g_once_init_leave (&sugar_keep_button_type_id__volatile, sugar_keep_button_type_id);
	}
	return sugar_keep_button_type_id__volatile;
}


/**
     * @param connection    activity connection to be based on
     */
static void __sugar_share_button_scope_changed_cb_sugar_connection_scope_changed (SugarConnection* _sender, SugarShareScope prev_scope, const gchar* _error_, gpointer self) {
	_sugar_share_button_scope_changed_cb (self, prev_scope, _error_);
}


static void __sugar_share_button_scope_changing_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_sugar_share_button_scope_changing_cb (self, _sender, pspec);
}


static void __sugar_share_button_changed_cb_gtk_radio_action_changed (GtkRadioAction* _sender, GtkRadioAction* current, gpointer self) {
	_sugar_share_button_changed_cb (self, current);
}


SugarShareButton* sugar_share_button_construct (GType object_type, SugarConnection* connection) {
	SugarShareButton * self = NULL;
	SugarPalette* _tmp0_ = NULL;
	SugarPalette* palette;
	const gchar* _tmp1_ = NULL;
	SugarInvoker* _tmp2_ = NULL;
	SugarMenu* _tmp3_ = NULL;
	SugarMenu* menu;
	const gchar* _tmp4_ = NULL;
	GtkRadioAction* _tmp5_ = NULL;
	GtkRadioAction* _tmp6_;
	GtkRadioAction* _tmp7_ = NULL;
	GtkRadioAction* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkRadioAction* _tmp10_ = NULL;
	GtkRadioAction* public;
	GtkRadioAction* _tmp11_ = NULL;
	GSList* _tmp12_ = NULL;
	SugarConnection* _tmp13_;
	gint _tmp14_ = 0;
	SugarShareScope _tmp15_;
	GtkRadioAction* _tmp16_ = NULL;
	GtkRadioAction* _tmp17_ = NULL;
	g_return_val_if_fail (connection != NULL, NULL);
	self = (SugarShareButton*) sugar_combo_tool_button_construct (object_type);
	_tmp0_ = sugar_palette_new ();
	palette = g_object_ref_sink (_tmp0_);
	_tmp1_ = _ ("Share scope");
	sugar_palette_set_primary_text (palette, _tmp1_);
	_tmp2_ = sugar_tool_button_get_invoker ((SugarToolButton*) self);
	sugar_invoker_set_palette (_tmp2_, palette);
	_tmp3_ = sugar_menu_new ();
	menu = g_object_ref_sink (_tmp3_);
	sugar_palette_window_set_secondary ((SugarPaletteWindow*) palette, (GtkWidget*) menu);
	_tmp4_ = _ ("Private");
	_tmp5_ = gtk_radio_action_new ("", _tmp4_, NULL, NULL, 0);
	_tmp6_ = _tmp5_;
	sugar_combo_tool_button_set_action ((SugarComboToolButton*) self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = sugar_combo_tool_button_get_action ((SugarComboToolButton*) self);
	gtk_action_set_icon_name ((GtkAction*) _tmp7_, "zoom-home");
	_tmp8_ = sugar_combo_tool_button_get_action ((SugarComboToolButton*) self);
	sugar_menu_insert_action (menu, (GtkAction*) _tmp8_, NULL, -1);
	_tmp9_ = _ ("My Neighborhood");
	_tmp10_ = gtk_radio_action_new ("", _tmp9_, NULL, NULL, 1);
	public = _tmp10_;
	gtk_action_set_icon_name ((GtkAction*) public, "zoom-neighborhood");
	_tmp11_ = sugar_combo_tool_button_get_action ((SugarComboToolButton*) self);
	_tmp12_ = gtk_radio_action_get_group (_tmp11_);
	gtk_radio_action_set_group (public, _tmp12_);
	sugar_menu_insert_action (menu, (GtkAction*) public, NULL, -1);
	gtk_widget_show_all ((GtkWidget*) menu);
	_tmp13_ = _g_object_ref0 (connection);
	_g_object_unref0 (self->priv->_connection);
	self->priv->_connection = _tmp13_;
	g_signal_connect_object (self->priv->_connection, "scope-changed", (GCallback) __sugar_share_button_scope_changed_cb_sugar_connection_scope_changed, self, 0);
	g_signal_connect_object ((GObject*) self->priv->_connection, "notify::scope-changing", (GCallback) __sugar_share_button_scope_changing_cb_g_object_notify, self, 0);
	_tmp15_ = sugar_connection_get_scope (self->priv->_connection);
	if (_tmp15_ == SUGAR_SHARE_SCOPE_PRIVATE) {
		_tmp14_ = 0;
	} else {
		_tmp14_ = 1;
	}
	_tmp16_ = sugar_combo_tool_button_get_action ((SugarComboToolButton*) self);
	gtk_radio_action_set_current_value (_tmp16_, _tmp14_);
	_tmp17_ = sugar_combo_tool_button_get_action ((SugarComboToolButton*) self);
	g_signal_connect_object (_tmp17_, "changed", (GCallback) __sugar_share_button_changed_cb_gtk_radio_action_changed, self, 0);
	_g_object_unref0 (public);
	_g_object_unref0 (menu);
	_g_object_unref0 (palette);
	return self;
}


SugarShareButton* sugar_share_button_new (SugarConnection* connection) {
	return sugar_share_button_construct (SUGAR_TYPE_SHARE_BUTTON, connection);
}


static void _sugar_share_button_scope_changed_cb (SugarShareButton* self, SugarShareScope prev_state, const gchar* _error_) {
	gint _tmp3_ = 0;
	SugarShareScope _tmp4_;
	GtkRadioAction* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	if (_error_ != NULL) {
		const gchar* _tmp0_ = NULL;
		SugarNotifyAlert* _tmp1_ = NULL;
		SugarNotifyAlert* _tmp2_;
		_tmp0_ = _ ("Sharing error");
		_tmp1_ = sugar_notify_alert_new (_tmp0_, _error_, "emblem-warning", 7);
		_tmp2_ = g_object_ref_sink (_tmp1_);
		sugar_alert_bin_push ((SugarAlert*) _tmp2_);
		_g_object_unref0 (_tmp2_);
	}
	_tmp4_ = sugar_connection_get_scope (self->priv->_connection);
	if (_tmp4_ == SUGAR_SHARE_SCOPE_PRIVATE) {
		_tmp3_ = 0;
	} else {
		_tmp3_ = 1;
	}
	_tmp5_ = sugar_combo_tool_button_get_action ((SugarComboToolButton*) self);
	gtk_radio_action_set_current_value (_tmp5_, _tmp3_);
}


static void _sugar_share_button_scope_changing_cb (SugarShareButton* self, GObject* sender, GParamSpec* param) {
	GtkRadioAction* _tmp0_ = NULL;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = sugar_combo_tool_button_get_action ((SugarComboToolButton*) self);
	_tmp1_ = sugar_connection_get_scope_changing (self->priv->_connection);
	gtk_action_set_sensitive ((GtkAction*) _tmp0_, !_tmp1_);
}


static void _sugar_share_button_changed_cb (SugarShareButton* self, GtkRadioAction* current) {
	SugarShareScope _tmp0_ = 0;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current != NULL);
	_tmp1_ = gtk_radio_action_get_current_value (current);
	if (_tmp1_ == 0) {
		_tmp0_ = SUGAR_SHARE_SCOPE_PRIVATE;
	} else {
		_tmp0_ = SUGAR_SHARE_SCOPE_PUBLIC;
	}
	sugar_connection_set_scope (self->priv->_connection, _tmp0_);
}


static void sugar_share_button_class_init (SugarShareButtonClass * klass) {
	sugar_share_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarShareButtonPrivate));
	G_OBJECT_CLASS (klass)->finalize = sugar_share_button_finalize;
}


static void sugar_share_button_instance_init (SugarShareButton * self) {
	self->priv = SUGAR_SHARE_BUTTON_GET_PRIVATE (self);
}


static void sugar_share_button_finalize (GObject* obj) {
	SugarShareButton * self;
	self = SUGAR_SHARE_BUTTON (obj);
	_g_object_unref0 (self->priv->_connection);
	G_OBJECT_CLASS (sugar_share_button_parent_class)->finalize (obj);
}


/**
 * Tool button to change activity sharing status
 *
 * After choosing entry from button palette, it will set Connection.status
 * property value.
 */
GType sugar_share_button_get_type (void) {
	static volatile gsize sugar_share_button_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_share_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarShareButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_share_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarShareButton), 0, (GInstanceInitFunc) sugar_share_button_instance_init, NULL };
		GType sugar_share_button_type_id;
		sugar_share_button_type_id = g_type_register_static (SUGAR_TYPE_COMBO_TOOL_BUTTON, "SugarShareButton", &g_define_type_info, 0);
		g_once_init_leave (&sugar_share_button_type_id__volatile, sugar_share_button_type_id);
	}
	return sugar_share_button_type_id__volatile;
}


/**
     * @param jobject   activity jobject to be based on
     */
static void __sugar_title_entry_entry_changed_cb_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	_sugar_title_entry_entry_changed_cb (self);
}


static void __sugar_title_entry_notify_title_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_sugar_title_entry_notify_title_cb (self, _sender, pspec);
}


SugarTitleEntry* sugar_title_entry_construct (GType object_type, SugarJobject* jobject) {
	SugarTitleEntry * self = NULL;
	SugarJobject* _tmp0_;
	GtkEntry* _tmp1_ = NULL;
	GtkEntry* _tmp2_;
	gint _tmp3_;
	const gchar* _tmp4_ = NULL;
	g_return_val_if_fail (jobject != NULL, NULL);
	self = (SugarTitleEntry*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (jobject);
	_g_object_unref0 (self->priv->_jobject);
	self->priv->_jobject = _tmp0_;
	_tmp1_ = (GtkEntry*) gtk_entry_new ();
	_tmp2_ = g_object_ref_sink (_tmp1_);
	sugar_title_entry_set_entry (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = gdk_screen_width ();
	gtk_widget_set_size_request ((GtkWidget*) self->priv->_entry, _tmp3_ / 3, -1);
	_tmp4_ = sugar_jobject_get_title (self->priv->_jobject);
	gtk_entry_set_text (self->priv->_entry, _tmp4_);
	g_signal_connect_object ((GtkEditable*) self->priv->_entry, "changed", (GCallback) __sugar_title_entry_entry_changed_cb_gtk_editable_changed, self, 0);
	gtk_widget_show ((GtkWidget*) self->priv->_entry);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->_entry);
	g_signal_connect_object ((GObject*) self->priv->_jobject, "notify::title", (GCallback) __sugar_title_entry_notify_title_cb_g_object_notify, self, 0);
	return self;
}


SugarTitleEntry* sugar_title_entry_new (SugarJobject* jobject) {
	return sugar_title_entry_construct (SUGAR_TYPE_TITLE_ENTRY, jobject);
}


static void _sugar_title_entry_notify_title_cb (SugarTitleEntry* self, GObject* sender, GParamSpec* param) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = sugar_jobject_get_title (self->priv->_jobject);
	gtk_entry_set_text (self->priv->_entry, _tmp0_);
}


static gboolean __sugar_title_entry_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = _sugar_title_entry_timeout_cb (self);
	return result;
}


static void _sugar_title_entry_entry_changed_cb (SugarTitleEntry* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->_timeout != 0) {
		g_source_remove (self->priv->_timeout);
	}
	_tmp0_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) SUGAR_TITLE_ENTRY__TIMEOUT_IN_SEC, __sugar_title_entry_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->_timeout = _tmp0_;
}


static gboolean _sugar_title_entry_timeout_cb (SugarTitleEntry* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->_timeout = (guint) 0;
	_tmp0_ = gtk_entry_get_text (self->priv->_entry);
	sugar_jobject_set_title (self->priv->_jobject, _tmp0_);
	sugar_jobject_set_title_set_by_user (self->priv->_jobject, TRUE);
	sugar_jobject_write (self->priv->_jobject);
	result = FALSE;
	return result;
}


GtkEntry* sugar_title_entry_get_entry (SugarTitleEntry* self) {
	GtkEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_entry;
	return result;
}


static void sugar_title_entry_set_entry (SugarTitleEntry* self, GtkEntry* value) {
	GtkEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_entry);
	self->priv->_entry = _tmp0_;
	g_object_notify ((GObject *) self, "entry");
}


static void sugar_title_entry_class_init (SugarTitleEntryClass * klass) {
	sugar_title_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarTitleEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_title_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_title_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = sugar_title_entry_finalize;
	/**
	     * Entry widget which represnts title
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TITLE_ENTRY_ENTRY, g_param_spec_object ("entry", "entry", "entry", GTK_TYPE_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void sugar_title_entry_instance_init (SugarTitleEntry * self) {
	self->priv = SUGAR_TITLE_ENTRY_GET_PRIVATE (self);
}


static void sugar_title_entry_finalize (GObject* obj) {
	SugarTitleEntry * self;
	self = SUGAR_TITLE_ENTRY (obj);
	_g_object_unref0 (self->priv->_entry);
	_g_object_unref0 (self->priv->_jobject);
	G_OBJECT_CLASS (sugar_title_entry_parent_class)->finalize (obj);
}


/**
 * Tool item to change activity title
 *
 * Widget will change Jobject.title implicitly. Also it will reflect on Jobject
 * updates.
 */
GType sugar_title_entry_get_type (void) {
	static volatile gsize sugar_title_entry_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_title_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarTitleEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_title_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarTitleEntry), 0, (GInstanceInitFunc) sugar_title_entry_instance_init, NULL };
		GType sugar_title_entry_type_id;
		sugar_title_entry_type_id = g_type_register_static (GTK_TYPE_TOOL_ITEM, "SugarTitleEntry", &g_define_type_info, 0);
		g_once_init_leave (&sugar_title_entry_type_id__volatile, sugar_title_entry_type_id);
	}
	return sugar_title_entry_type_id__volatile;
}


static void _vala_sugar_title_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarTitleEntry * self;
	self = SUGAR_TITLE_ENTRY (object);
	switch (property_id) {
		case SUGAR_TITLE_ENTRY_ENTRY:
		g_value_set_object (value, sugar_title_entry_get_entry (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_title_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarTitleEntry * self;
	self = SUGAR_TITLE_ENTRY (object);
	switch (property_id) {
		case SUGAR_TITLE_ENTRY_ENTRY:
		sugar_title_entry_set_entry (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



