/* toolbarbox.c generated by valac 0.12.1, the Vala compiler
 * generated from toolbarbox.vala, do not modify */

/* toolbarbox.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/gui.h"
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <polyol/env.h>


#define SUGAR_TYPE__BUTTONPALETTE (sugar__buttonpalette_get_type ())
#define SUGAR__BUTTONPALETTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_TYPE__BUTTONPALETTE, Sugar_ButtonPalette))
#define SUGAR__BUTTONPALETTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_TYPE__BUTTONPALETTE, Sugar_ButtonPaletteClass))
#define SUGAR_IS__BUTTONPALETTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_TYPE__BUTTONPALETTE))
#define SUGAR_IS__BUTTONPALETTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_TYPE__BUTTONPALETTE))
#define SUGAR__BUTTONPALETTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_TYPE__BUTTONPALETTE, Sugar_ButtonPaletteClass))

typedef struct _Sugar_ButtonPalette Sugar_ButtonPalette;
typedef struct _Sugar_ButtonPaletteClass Sugar_ButtonPaletteClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SUGAR_TYPE__CONNECTOR (sugar__connector_get_type ())
#define SUGAR__CONNECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_TYPE__CONNECTOR, Sugar_Connector))
#define SUGAR__CONNECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_TYPE__CONNECTOR, Sugar_ConnectorClass))
#define SUGAR_IS__CONNECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_TYPE__CONNECTOR))
#define SUGAR_IS__CONNECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_TYPE__CONNECTOR))
#define SUGAR__CONNECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_TYPE__CONNECTOR, Sugar_ConnectorClass))

typedef struct _Sugar_Connector Sugar_Connector;
typedef struct _Sugar_ConnectorClass Sugar_ConnectorClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Sugar_ButtonPalettePrivate Sugar_ButtonPalettePrivate;

#define SUGAR_TYPE__EXPANDEDBIN (sugar__expandedbin_get_type ())
#define SUGAR__EXPANDEDBIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_TYPE__EXPANDEDBIN, Sugar_ExpandedBin))
#define SUGAR__EXPANDEDBIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_TYPE__EXPANDEDBIN, Sugar_ExpandedBinClass))
#define SUGAR_IS__EXPANDEDBIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_TYPE__EXPANDEDBIN))
#define SUGAR_IS__EXPANDEDBIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_TYPE__EXPANDEDBIN))
#define SUGAR__EXPANDEDBIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_TYPE__EXPANDEDBIN, Sugar_ExpandedBinClass))

typedef struct _Sugar_ExpandedBin Sugar_ExpandedBin;
typedef struct _Sugar_ExpandedBinClass Sugar_ExpandedBinClass;
typedef struct _Sugar_ExpandedBinPrivate Sugar_ExpandedBinPrivate;
typedef struct _Sugar_ConnectorPrivate Sugar_ConnectorPrivate;

struct _SugarToolbarButtonPrivate {
	Sugar_ButtonPalette* _palette;
	GtkWidget* _page;
};

struct _Sugar_ButtonPalette {
	SugarPaletteWindow parent_instance;
	Sugar_ButtonPalettePrivate * priv;
	SugarBin* bin;
};

struct _Sugar_ButtonPaletteClass {
	SugarPaletteWindowClass parent_class;
};

struct _SugarToolbarBoxPrivate {
	Sugar_ToolbarExpander* _toolbar;
	SugarPaintBin* _toolbar_bin;
	GtkPositionType _orientation;
	Sugar_ExpandedBin* _expanded_bin;
	gint _expanded_button;
};

struct _Sugar_ExpandedBin {
	SugarPaintBin parent_instance;
	Sugar_ExpandedBinPrivate * priv;
	gint gap_pos;
	gint gap_size;
};

struct _Sugar_ExpandedBinClass {
	SugarPaintBinClass parent_class;
};

struct _Sugar_Connector {
	SugarToolConnector parent_instance;
	Sugar_ConnectorPrivate * priv;
};

struct _Sugar_ConnectorClass {
	SugarToolConnectorClass parent_class;
};

struct _Sugar_ConnectorPrivate {
	GtkPositionType _orientation;
};


static gpointer sugar_toolbar_button_parent_class = NULL;
static gpointer sugar_toolbar_box_parent_class = NULL;
static gpointer sugar__toolbarexpander_parent_class = NULL;
static gpointer sugar__expandedbin_parent_class = NULL;
static gpointer sugar__buttonpalette_parent_class = NULL;
static gpointer sugar__connector_parent_class = NULL;

GType sugar__buttonpalette_get_type (void) G_GNUC_CONST;
#define SUGAR_TOOLBAR_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_TOOLBAR_BUTTON, SugarToolbarButtonPrivate))
enum  {
	SUGAR_TOOLBAR_BUTTON_DUMMY_PROPERTY,
	SUGAR_TOOLBAR_BUTTON_PAGE,
	SUGAR_TOOLBAR_BUTTON_POPPED,
	SUGAR_TOOLBAR_BUTTON_EXPANDED
};
static void sugar_toolbar_button_real_clicked (GtkToolButton* base);
static void sugar_toolbar_button_real_parent_set (GtkWidget* base, GtkWidget* previous_parent);
static SugarToolbarBox* sugar_toolbar_button_get__toolbox (SugarToolbarButton* self);
GType sugar__connector_get_type (void) G_GNUC_CONST;
void sugar__connector_set_orientation (Sugar_Connector* self, GtkPositionType value);
static gboolean sugar_toolbar_button_real_expose_event (GtkWidget* base, GdkEventExpose* event);
static void _sugar_toolbar_button_palette_request_cb (SugarToolbarButton* self);
void _sugar_prepare_page (GtkWidget* page, gint color);
static GObject * sugar_toolbar_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
Sugar_ButtonPalette* sugar__buttonpalette_new (void);
Sugar_ButtonPalette* sugar__buttonpalette_construct (GType object_type);
Sugar_Connector* sugar__connector_new (GtkToolItem* tool_item);
Sugar_Connector* sugar__connector_construct (GType object_type, GtkToolItem* tool_item);
static void __sugar_toolbar_button_palette_request_cb_sugar_invoker_palette_request (SugarInvoker* _sender, gpointer self);
static void sugar_toolbar_button_finalize (GObject* obj);
static void _vala_sugar_toolbar_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_toolbar_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType sugar__expandedbin_get_type (void) G_GNUC_CONST;
#define SUGAR_TOOLBAR_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_TOOLBAR_BOX, SugarToolbarBoxPrivate))
enum  {
	SUGAR_TOOLBAR_BOX_DUMMY_PROPERTY,
	SUGAR_TOOLBAR_BOX_TOOLBAR,
	SUGAR_TOOLBAR_BOX_ORIENTATION,
	SUGAR_TOOLBAR_BOX_PADDING
};
static void sugar_toolbar_box_set_toolbar (SugarToolbarBox* self, Sugar_ToolbarExpander* value);
static GObject * sugar_toolbar_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
Sugar_ExpandedBin* sugar__expandedbin_new (void);
Sugar_ExpandedBin* sugar__expandedbin_construct (GType object_type);
static void sugar_toolbar_box_finalize (GObject* obj);
static void _vala_sugar_toolbar_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_toolbar_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	SUGAR__TOOLBAREXPANDER_DUMMY_PROPERTY,
	SUGAR__TOOLBAREXPANDER_TOOLBOX
};
static void _vala_sugar__toolbarexpander_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
enum  {
	SUGAR__EXPANDEDBIN_DUMMY_PROPERTY
};
static gboolean sugar__expandedbin_real_expose_event (GtkWidget* base, GdkEventExpose* event);
static GObject * sugar__expandedbin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void sugar__expandedbin_finalize (GObject* obj);
enum  {
	SUGAR__BUTTONPALETTE_DUMMY_PROPERTY
};
static void sugar__buttonpalette_real_size_request (GtkWidget* base, GtkRequisition* requisition);
static GObject * sugar__buttonpalette_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void sugar__buttonpalette_finalize (GObject* obj);
#define SUGAR__CONNECTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE__CONNECTOR, Sugar_ConnectorPrivate))
enum  {
	SUGAR__CONNECTOR_DUMMY_PROPERTY,
	SUGAR__CONNECTOR_ORIENTATION
};
static SugarConnectorAlignment* sugar__connector_real_get_alignments (SugarConnector* base, int* result_length1);
GtkPositionType sugar__connector_get_orientation (Sugar_Connector* self);
static void sugar__connector_finalize (GObject* obj);
static void _vala_sugar__connector_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar__connector_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const SugarConnectorAlignment SUGAR__CONNECTOR__left[2] = {{-1.0f, 0.0f, 0.0f, 0.0f, (gint) GTK_POS_LEFT}, {-1.0f, -1.0f, 0.0f, 1.0f, (gint) GTK_POS_LEFT}};
static const SugarConnectorAlignment SUGAR__CONNECTOR__right[2] = {{0.0f, 0.0f, 1.0f, 0.0f, (gint) GTK_POS_RIGHT}, {0.0f, -1.0f, 1.0f, 1.0f, (gint) GTK_POS_RIGHT}};
static const SugarConnectorAlignment SUGAR__CONNECTOR__top[2] = {{0.0f, -1.0f, 0.0f, 0.0f, (gint) GTK_POS_TOP}, {-1.0f, -1.0f, 1.0f, 0.0f, (gint) GTK_POS_TOP}};
static const SugarConnectorAlignment SUGAR__CONNECTOR__bottom[2] = {{0.0f, 0.0f, 0.0f, 1.0f, (gint) GTK_POS_BOTTOM}, {-1.0f, 0.0f, 1.0f, 1.0f, (gint) GTK_POS_BOTTOM}};

static void sugar_toolbar_button_real_clicked (GtkToolButton* base) {
	SugarToolbarButton * self;
	gboolean _tmp0_;
	self = (SugarToolbarButton*) base;
	_tmp0_ = sugar_toolbar_button_get_expanded (self);
	sugar_toolbar_button_set_expanded (self, !_tmp0_);
}


static void sugar_toolbar_button_real_parent_set (GtkWidget* base, GtkWidget* previous_parent) {
	SugarToolbarButton * self;
	SugarToolbarBox* _tmp0_ = NULL;
	self = (SugarToolbarButton*) base;
	GTK_WIDGET_CLASS (sugar_toolbar_button_parent_class)->parent_set ((GtkWidget*) SUGAR_TOOL_BUTTON (self), previous_parent);
	_tmp0_ = sugar_toolbar_button_get__toolbox (self);
	if (_tmp0_ != NULL) {
		SugarInvoker* _tmp1_ = NULL;
		SugarConnector* _tmp2_ = NULL;
		SugarConnector* _tmp3_;
		SugarToolbarBox* _tmp4_ = NULL;
		GtkPositionType _tmp5_;
		_tmp1_ = sugar_tool_button_get_invoker ((SugarToolButton*) self);
		_tmp2_ = sugar_invoker_get_connector (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = sugar_toolbar_button_get__toolbox (self);
		_tmp5_ = sugar_toolbar_box_get_orientation (_tmp4_);
		sugar__connector_set_orientation (SUGAR_IS__CONNECTOR (_tmp3_) ? ((Sugar_Connector*) _tmp3_) : NULL, _tmp5_);
	}
	sugar_toolbar_button_set_expanded (self, FALSE);
	sugar_toolbar_button_set_popped (self, FALSE);
}


static gboolean sugar_toolbar_button_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	SugarToolbarButton * self;
	gboolean result = FALSE;
	GtkArrowType arrow_type;
	gboolean _tmp0_;
	gint _tmp6_;
	gint x;
	gint _tmp7_;
	gint y;
	GtkStyle* _tmp8_ = NULL;
	gint _tmp9_;
	gint _tmp10_;
	self = (SugarToolbarButton*) base;
	arrow_type = GTK_ARROW_DOWN;
	_tmp0_ = sugar_toolbar_button_get_expanded (self);
	if (_tmp0_) {
		GList* _tmp1_ = NULL;
		GtkStyle* _tmp2_ = NULL;
		GtkStyle* _tmp3_ = NULL;
		GtkStyle* _tmp4_ = NULL;
		gint _tmp5_;
		_tmp1_ = gtk_container_get_children ((GtkContainer*) self);
		{
			GList* child_collection;
			GList* child_it;
			child_collection = _tmp1_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* child;
				child = (GtkWidget*) child_it->data;
				{
					gtk_container_propagate_expose ((GtkContainer*) self, child, event);
				}
			}
			_g_list_free0 (child_collection);
		}
		_tmp2_ = gtk_widget_get_style ((GtkWidget*) self);
		gtk_paint_hline (_tmp2_, (*event).window, GTK_STATE_PRELIGHT, &(*event).area, (GtkWidget*) self, NULL, ((GtkWidget*) self)->allocation.x, ((GtkWidget*) self)->allocation.x + ((GtkWidget*) self)->allocation.width, ((GtkWidget*) self)->allocation.y);
		_tmp3_ = gtk_widget_get_style ((GtkWidget*) self);
		gtk_paint_vline (_tmp3_, (*event).window, GTK_STATE_PRELIGHT, &(*event).area, (GtkWidget*) self, NULL, ((GtkWidget*) self)->allocation.y, ((GtkWidget*) self)->allocation.y + ((GtkWidget*) self)->allocation.height, ((GtkWidget*) self)->allocation.x);
		_tmp4_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp5_ = sugar_metrics_get (SUGAR_FOCUS_LINE_WIDTH);
		gtk_paint_vline (_tmp4_, (*event).window, GTK_STATE_PRELIGHT, &(*event).area, (GtkWidget*) self, NULL, ((GtkWidget*) self)->allocation.y, ((GtkWidget*) self)->allocation.y + ((GtkWidget*) self)->allocation.height, (((GtkWidget*) self)->allocation.x + ((GtkWidget*) self)->allocation.width) - _tmp5_);
		arrow_type = GTK_ARROW_UP;
	} else {
		GTK_WIDGET_CLASS (sugar_toolbar_button_parent_class)->expose_event ((GtkWidget*) SUGAR_TOOL_BUTTON (self), event);
	}
	_tmp6_ = sugar_metrics_get (SUGAR_TOOLBAR_ARROW_SIZE);
	x = (((GtkWidget*) self)->allocation.x + (((GtkWidget*) self)->allocation.width / 2)) - (_tmp6_ / 2);
	_tmp7_ = sugar_metrics_get (SUGAR_TOOLBAR_ARROW_SIZE);
	y = (((GtkWidget*) self)->allocation.y + ((GtkWidget*) self)->allocation.height) - ((gint) (_tmp7_ * 0.85));
	_tmp8_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp9_ = sugar_metrics_get (SUGAR_TOOLBAR_ARROW_SIZE);
	_tmp10_ = sugar_metrics_get (SUGAR_TOOLBAR_ARROW_SIZE);
	gtk_paint_arrow (_tmp8_, (*event).window, GTK_STATE_NORMAL, GTK_SHADOW_NONE, &(*event).area, (GtkWidget*) self, NULL, arrow_type, TRUE, x, y, _tmp9_, _tmp10_);
	result = FALSE;
	return result;
}


static void _sugar_toolbar_button_palette_request_cb (SugarToolbarButton* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_toolbar_button_get_expanded (self);
	if (!_tmp0_) {
		GtkWidget* _tmp1_ = NULL;
		GtkContainer* _tmp2_ = NULL;
		GtkWidget* _tmp6_ = NULL;
		GtkWidget* _tmp7_ = NULL;
		SugarInvoker* _tmp8_ = NULL;
		_tmp1_ = sugar_toolbar_button_get_page (self);
		_tmp2_ = gtk_widget_get_parent (_tmp1_);
		if (_tmp2_ != NULL) {
			GtkWidget* _tmp3_ = NULL;
			GtkContainer* _tmp4_ = NULL;
			GtkWidget* _tmp5_ = NULL;
			_tmp3_ = sugar_toolbar_button_get_page (self);
			_tmp4_ = gtk_widget_get_parent (_tmp3_);
			_tmp5_ = sugar_toolbar_button_get_page (self);
			gtk_container_remove (_tmp4_, _tmp5_);
		}
		_tmp6_ = sugar_toolbar_button_get_page (self);
		_sugar_prepare_page (_tmp6_, SUGAR_COLOR_BLACK);
		_tmp7_ = sugar_toolbar_button_get_page (self);
		gtk_container_add ((GtkContainer*) self->priv->_palette->bin, _tmp7_);
		_tmp8_ = sugar_tool_button_get_invoker ((SugarToolButton*) self);
		sugar_invoker_set_palette_window (_tmp8_, (SugarPaletteWindow*) self->priv->_palette);
	}
}


SugarToolbarButton* sugar_toolbar_button_construct (GType object_type) {
	SugarToolbarButton * self = NULL;
	self = (SugarToolbarButton*) sugar_tool_button_construct (object_type);
	return self;
}


SugarToolbarButton* sugar_toolbar_button_new (void) {
	return sugar_toolbar_button_construct (SUGAR_TYPE_TOOLBAR_BUTTON);
}


GtkWidget* sugar_toolbar_button_get_page (SugarToolbarButton* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_page;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void sugar_toolbar_button_set_page (SugarToolbarButton* self, GtkWidget* value) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_toolbar_button_get_page (self);
	if (_tmp0_ == value) {
		return;
	}
	_tmp1_ = sugar_toolbar_button_get_page (self);
	if (_tmp1_ != NULL) {
		GtkWidget* _tmp2_ = NULL;
		GtkContainer* _tmp3_ = NULL;
		sugar_toolbar_button_set_popped (self, FALSE);
		sugar_toolbar_button_set_expanded (self, FALSE);
		_tmp2_ = sugar_toolbar_button_get_page (self);
		_tmp3_ = gtk_widget_get_parent (_tmp2_);
		if (_tmp3_ != NULL) {
			GtkWidget* _tmp4_ = NULL;
			GtkContainer* _tmp5_ = NULL;
			GtkWidget* _tmp6_ = NULL;
			_tmp4_ = sugar_toolbar_button_get_page (self);
			_tmp5_ = gtk_widget_get_parent (_tmp4_);
			_tmp6_ = sugar_toolbar_button_get_page (self);
			gtk_container_remove (_tmp5_, _tmp6_);
		}
	}
	_tmp7_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_page);
	self->priv->_page = _tmp7_;
	_tmp8_ = sugar_toolbar_button_get_page (self);
	if (_tmp8_ != NULL) {
		GtkWidget* _tmp9_ = NULL;
		_tmp9_ = sugar_toolbar_button_get_page (self);
		gtk_widget_show (_tmp9_);
	}
	g_object_notify ((GObject *) self, "page");
}


gboolean sugar_toolbar_button_get_popped (SugarToolbarButton* self) {
	gboolean result;
	SugarInvoker* _tmp0_ = NULL;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = sugar_tool_button_get_invoker ((SugarToolButton*) self);
	_tmp1_ = sugar_invoker_get_is_up (_tmp0_);
	result = _tmp1_;
	return result;
}


void sugar_toolbar_button_set_popped (SugarToolbarButton* self, gboolean value) {
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_toolbar_button_get_page (self);
	if (_tmp0_ == NULL) {
		return;
	}
	if (value) {
		SugarInvoker* _tmp1_ = NULL;
		sugar_toolbar_button_set_expanded (self, FALSE);
		_tmp1_ = sugar_tool_button_get_invoker ((SugarToolButton*) self);
		sugar_invoker_popup (_tmp1_);
	} else {
		SugarInvoker* _tmp2_ = NULL;
		SugarInvoker* _tmp3_ = NULL;
		_tmp2_ = sugar_tool_button_get_invoker ((SugarToolButton*) self);
		sugar_invoker_popdown (_tmp2_);
		_tmp3_ = sugar_tool_button_get_invoker ((SugarToolButton*) self);
		sugar_invoker_set_palette_window (_tmp3_, NULL);
	}
	g_object_notify ((GObject *) self, "popped");
}


gboolean sugar_toolbar_button_get_expanded (SugarToolbarButton* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkWidget* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = sugar_toolbar_button_get_page (self);
	if (_tmp2_ != NULL) {
		GtkWidget* _tmp3_ = NULL;
		GtkWidget* _tmp4_ = NULL;
		gboolean _tmp5_;
		_tmp3_ = sugar_toolbar_button_get_page (self);
		_tmp4_ = gtk_widget_get_toplevel (_tmp3_);
		_tmp5_ = GTK_WIDGET_TOPLEVEL (_tmp4_);
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkWidget* _tmp6_ = NULL;
		GtkWidget* _tmp7_ = NULL;
		_tmp6_ = sugar_toolbar_button_get_page (self);
		_tmp7_ = gtk_widget_get_toplevel (_tmp6_);
		_tmp0_ = _tmp7_ != GTK_WIDGET (self->priv->_palette);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


void sugar_toolbar_button_set_expanded (SugarToolbarButton* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = sugar_toolbar_button_get_page (self);
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = sugar_toolbar_button_get_expanded (self);
		_tmp0_ = _tmp2_ == value;
	}
	if (_tmp0_) {
		return;
	}
	if (value) {
		GtkWidget* _tmp3_ = NULL;
		GtkContainer* _tmp4_ = NULL;
		SugarToolbarBox* _tmp8_ = NULL;
		sugar_toolbar_button_set_popped (self, FALSE);
		_tmp3_ = sugar_toolbar_button_get_page (self);
		_tmp4_ = gtk_widget_get_parent (_tmp3_);
		if (_tmp4_ != NULL) {
			GtkWidget* _tmp5_ = NULL;
			GtkContainer* _tmp6_ = NULL;
			GtkWidget* _tmp7_ = NULL;
			_tmp5_ = sugar_toolbar_button_get_page (self);
			_tmp6_ = gtk_widget_get_parent (_tmp5_);
			_tmp7_ = sugar_toolbar_button_get_page (self);
			gtk_container_remove (_tmp6_, _tmp7_);
		}
		_tmp8_ = sugar_toolbar_button_get__toolbox (self);
		if (_tmp8_ != NULL) {
			SugarToolbarBox* _tmp9_ = NULL;
			_tmp9_ = sugar_toolbar_button_get__toolbox (self);
			sugar_toolbar_box_expand_button (_tmp9_, self);
		}
	} else {
		SugarToolbarBox* _tmp10_ = NULL;
		_tmp10_ = sugar_toolbar_button_get__toolbox (self);
		if (_tmp10_ != NULL) {
			SugarToolbarBox* _tmp11_ = NULL;
			_tmp11_ = sugar_toolbar_button_get__toolbox (self);
			sugar_toolbar_box_shrink_button (_tmp11_, self);
		}
	}
	g_object_notify ((GObject *) self, "expanded");
}


static SugarToolbarBox* sugar_toolbar_button_get__toolbox (SugarToolbarButton* self) {
	SugarToolbarBox* result;
	GtkContainer* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) self);
	if (SUGAR_IS__TOOLBAREXPANDER (_tmp0_)) {
		GtkContainer* _tmp1_ = NULL;
		GtkContainer* _tmp2_;
		SugarToolbarBox* _tmp3_ = NULL;
		_tmp1_ = gtk_widget_get_parent ((GtkWidget*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = sugar__toolbarexpander_get_toolbox (SUGAR_IS__TOOLBAREXPANDER (_tmp2_) ? ((Sugar_ToolbarExpander*) _tmp2_) : NULL);
		result = _tmp3_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}


static void __sugar_toolbar_button_palette_request_cb_sugar_invoker_palette_request (SugarInvoker* _sender, gpointer self) {
	_sugar_toolbar_button_palette_request_cb (self);
}


static GObject * sugar_toolbar_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarToolbarButton * self;
	Sugar_ButtonPalette* _tmp0_ = NULL;
	SugarInvoker* _tmp1_ = NULL;
	Sugar_Connector* _tmp2_ = NULL;
	Sugar_Connector* _tmp3_;
	SugarInvoker* _tmp4_ = NULL;
	GdkColor _tmp5_ = {0};
	GdkColor _tmp6_ = {0};
	parent_class = G_OBJECT_CLASS (sugar_toolbar_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_TOOLBAR_BUTTON (obj);
	_tmp0_ = sugar__buttonpalette_new ();
	_g_object_unref0 (self->priv->_palette);
	self->priv->_palette = g_object_ref_sink (_tmp0_);
	_tmp1_ = sugar_tool_button_get_invoker ((SugarToolButton*) self);
	_tmp2_ = sugar__connector_new ((GtkToolItem*) self);
	_tmp3_ = _tmp2_;
	sugar_invoker_set_connector (_tmp1_, (SugarConnector*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = sugar_tool_button_get_invoker ((SugarToolButton*) self);
	g_signal_connect_object (_tmp4_, "palette-request", (GCallback) __sugar_toolbar_button_palette_request_cb_sugar_invoker_palette_request, self, 0);
	sugar_color_type_to_rgb (SUGAR_COLOR_BUTTON_GREY, &_tmp5_);
	_tmp6_ = _tmp5_;
	gtk_widget_modify_bg ((GtkWidget*) self, GTK_STATE_PRELIGHT, &_tmp6_);
	return obj;
}


static void sugar_toolbar_button_class_init (SugarToolbarButtonClass * klass) {
	sugar_toolbar_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarToolbarButtonPrivate));
	GTK_TOOL_BUTTON_CLASS (klass)->clicked = sugar_toolbar_button_real_clicked;
	GTK_WIDGET_CLASS (klass)->parent_set = sugar_toolbar_button_real_parent_set;
	GTK_WIDGET_CLASS (klass)->expose_event = sugar_toolbar_button_real_expose_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_toolbar_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_toolbar_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = sugar_toolbar_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar_toolbar_button_finalize;
	/**
	     * Sub-toolbar widget
	     *
	     * There are not restictions to use only Gtk.ToolBar, page could be
	     * any widget.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOOLBAR_BUTTON_PAGE, g_param_spec_object ("page", "page", "page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Page is shown and in palette mode
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOOLBAR_BUTTON_POPPED, g_param_spec_boolean ("popped", "popped", "popped", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Page is shown and in imbeded mode
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOOLBAR_BUTTON_EXPANDED, g_param_spec_boolean ("expanded", "expanded", "expanded", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void sugar_toolbar_button_instance_init (SugarToolbarButton * self) {
	self->priv = SUGAR_TOOLBAR_BUTTON_GET_PRIVATE (self);
}


static void sugar_toolbar_button_finalize (GObject* obj) {
	SugarToolbarButton * self;
	self = SUGAR_TOOLBAR_BUTTON (obj);
	_g_object_unref0 (self->priv->_palette);
	_g_object_unref0 (self->priv->_page);
	G_OBJECT_CLASS (sugar_toolbar_button_parent_class)->finalize (obj);
}


/**
 * Tool button that could have sub-toolbar
 *
 * Such tool button could be placed only to ToolbarBox.toolbar widget.
 * Sub-toolbar widget should be assigned to page property before using button.
 *
 * Sub-toolbar could be opened in two ways:
 *
 * - Palette mode (popped property is true), activated by regular sugar
 *   workflow (right click on button or after delay) or by setting popped
 *   property directly. Sub-toolbar will appear in poped up palette.
 *
 * - Imbeded mode (expanded property is true), activated by left click or
 *   setting expanded property directly. Sub-toolbar will appear as a sub-widget
 *   in ToolbarBox ToolbarButton is a child of.
 */
GType sugar_toolbar_button_get_type (void) {
	static volatile gsize sugar_toolbar_button_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_toolbar_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarToolbarButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_toolbar_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarToolbarButton), 0, (GInstanceInitFunc) sugar_toolbar_button_instance_init, NULL };
		GType sugar_toolbar_button_type_id;
		sugar_toolbar_button_type_id = g_type_register_static (SUGAR_TYPE_TOOL_BUTTON, "SugarToolbarButton", &g_define_type_info, 0);
		g_once_init_leave (&sugar_toolbar_button_type_id__volatile, sugar_toolbar_button_type_id);
	}
	return sugar_toolbar_button_type_id__volatile;
}


static void _vala_sugar_toolbar_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarToolbarButton * self;
	self = SUGAR_TOOLBAR_BUTTON (object);
	switch (property_id) {
		case SUGAR_TOOLBAR_BUTTON_PAGE:
		g_value_set_object (value, sugar_toolbar_button_get_page (self));
		break;
		case SUGAR_TOOLBAR_BUTTON_POPPED:
		g_value_set_boolean (value, sugar_toolbar_button_get_popped (self));
		break;
		case SUGAR_TOOLBAR_BUTTON_EXPANDED:
		g_value_set_boolean (value, sugar_toolbar_button_get_expanded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_toolbar_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarToolbarButton * self;
	self = SUGAR_TOOLBAR_BUTTON (object);
	switch (property_id) {
		case SUGAR_TOOLBAR_BUTTON_PAGE:
		sugar_toolbar_button_set_page (self, g_value_get_object (value));
		break;
		case SUGAR_TOOLBAR_BUTTON_POPPED:
		sugar_toolbar_button_set_popped (self, g_value_get_boolean (value));
		break;
		case SUGAR_TOOLBAR_BUTTON_EXPANDED:
		sugar_toolbar_button_set_expanded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


/**
     * Used only by ToolbarButton internally
     */
void sugar_toolbar_box_expand_button (SugarToolbarBox* self, SugarToolbarButton* button) {
	GtkToolItem* _tmp0_ = NULL;
	GtkToolItem* _tmp1_;
	SugarToolbarButton* _tmp2_;
	SugarToolbarButton* prev;
	gint _tmp3_;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toolbar_get_nth_item ((GtkToolbar*) self->priv->_toolbar, self->priv->_expanded_button);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (SUGAR_IS_TOOLBAR_BUTTON (_tmp1_) ? ((SugarToolbarButton*) _tmp1_) : NULL);
	prev = _tmp2_;
	if (prev != NULL) {
		sugar_toolbar_button_set_expanded (prev, FALSE);
	}
	_tmp3_ = gtk_toolbar_get_item_index ((GtkToolbar*) self->priv->_toolbar, (GtkToolItem*) button);
	self->priv->_expanded_button = _tmp3_;
	_tmp4_ = sugar_toolbar_button_get_page (button);
	_sugar_prepare_page (_tmp4_, SUGAR_COLOR_TOOLBAR_GREY);
	self->priv->_expanded_bin->gap_pos = ((GtkWidget*) button)->allocation.x;
	self->priv->_expanded_bin->gap_size = ((GtkWidget*) button)->allocation.width;
	_tmp5_ = sugar_toolbar_button_get_page (button);
	gtk_container_add ((GtkContainer*) self->priv->_expanded_bin, _tmp5_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->_expanded_bin, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (prev);
}


/**
     * Used only by ToolbarButton internally
     */
void sugar_toolbar_box_shrink_button (SugarToolbarBox* self, SugarToolbarButton* button) {
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gtk_container_remove ((GtkContainer*) self, (GtkWidget*) self->priv->_expanded_bin);
	_tmp0_ = sugar_toolbar_button_get_page (button);
	gtk_container_remove ((GtkContainer*) self->priv->_expanded_bin, _tmp0_);
	self->priv->_expanded_button = -1;
	gtk_widget_queue_draw ((GtkWidget*) button);
}


SugarToolbarBox* sugar_toolbar_box_construct (GType object_type) {
	SugarToolbarBox * self = NULL;
	self = (SugarToolbarBox*) g_object_new (object_type, NULL);
	return self;
}


SugarToolbarBox* sugar_toolbar_box_new (void) {
	return sugar_toolbar_box_construct (SUGAR_TYPE_TOOLBAR_BOX);
}


Sugar_ToolbarExpander* sugar_toolbar_box_get_toolbar (SugarToolbarBox* self) {
	Sugar_ToolbarExpander* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_toolbar;
	return result;
}


static void sugar_toolbar_box_set_toolbar (SugarToolbarBox* self, Sugar_ToolbarExpander* value) {
	Sugar_ToolbarExpander* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_toolbar);
	self->priv->_toolbar = _tmp0_;
	g_object_notify ((GObject *) self, "toolbar");
}


GtkPositionType sugar_toolbar_box_get_orientation (SugarToolbarBox* self) {
	GtkPositionType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_orientation;
	return result;
}


void sugar_toolbar_box_set_orientation (SugarToolbarBox* self, GtkPositionType value) {
	gboolean _tmp0_ = FALSE;
	GtkPositionType _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_orientation = value;
	_tmp1_ = sugar_toolbar_box_get_orientation (self);
	if (_tmp1_ == GTK_POS_TOP) {
		_tmp0_ = TRUE;
	} else {
		GtkPositionType _tmp2_;
		_tmp2_ = sugar_toolbar_box_get_orientation (self);
		_tmp0_ = _tmp2_ == GTK_POS_BOTTOM;
	}
	if (_tmp0_) {
		((GtkToolbar*) self->priv->_toolbar)->orientation = GTK_ORIENTATION_HORIZONTAL;
	} else {
		((GtkToolbar*) self->priv->_toolbar)->orientation = GTK_ORIENTATION_VERTICAL;
	}
	g_object_notify ((GObject *) self, "orientation");
}


gint sugar_toolbar_box_get_padding (SugarToolbarBox* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = sugar_paint_bin_get_padding_left (self->priv->_toolbar_bin);
	result = _tmp0_;
	return result;
}


void sugar_toolbar_box_set_padding (SugarToolbarBox* self, gint value) {
	g_return_if_fail (self != NULL);
	sugar_paint_bin_set_padding_left (self->priv->_toolbar_bin, value);
	sugar_paint_bin_set_padding_right (self->priv->_toolbar_bin, value);
	g_object_notify ((GObject *) self, "padding");
}


static GObject * sugar_toolbar_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarToolbarBox * self;
	SugarPaintBin* _tmp0_ = NULL;
	GdkColor _tmp1_ = {0};
	GdkColor _tmp2_ = {0};
	Sugar_ToolbarExpander* _tmp3_ = NULL;
	Sugar_ToolbarExpander* _tmp4_;
	Sugar_ExpandedBin* _tmp5_ = NULL;
	gint _tmp6_;
	parent_class = G_OBJECT_CLASS (sugar_toolbar_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_TOOLBAR_BOX (obj);
	self->priv->_expanded_button = -1;
	_tmp0_ = sugar_paint_bin_new ();
	_g_object_unref0 (self->priv->_toolbar_bin);
	self->priv->_toolbar_bin = g_object_ref_sink (_tmp0_);
	sugar_paint_bin_set_radius (self->priv->_toolbar_bin, 0);
	sugar_color_type_to_rgb (SUGAR_COLOR_TOOLBAR_GREY, &_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_widget_modify_bg ((GtkWidget*) self->priv->_toolbar_bin, GTK_STATE_NORMAL, &_tmp2_);
	gtk_widget_show ((GtkWidget*) self->priv->_toolbar_bin);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->_toolbar_bin, TRUE, TRUE, (guint) 0);
	_tmp3_ = sugar__toolbarexpander_new ();
	_tmp4_ = g_object_ref_sink (_tmp3_);
	sugar_toolbar_box_set_toolbar (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	gtk_widget_show ((GtkWidget*) self->priv->_toolbar);
	gtk_container_add ((GtkContainer*) self->priv->_toolbar_bin, (GtkWidget*) self->priv->_toolbar);
	_tmp5_ = sugar__expandedbin_new ();
	_g_object_unref0 (self->priv->_expanded_bin);
	self->priv->_expanded_bin = g_object_ref_sink (_tmp5_);
	gtk_widget_show ((GtkWidget*) self->priv->_expanded_bin);
	sugar_toolbar_box_set_orientation (self, GTK_POS_TOP);
	_tmp6_ = sugar_metrics_get (SUGAR_TOOLBOX_HORIZONTAL_PADDING);
	sugar_toolbar_box_set_padding (self, _tmp6_);
	return obj;
}


static void sugar_toolbar_box_class_init (SugarToolbarBoxClass * klass) {
	sugar_toolbar_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarToolbarBoxPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_toolbar_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_toolbar_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = sugar_toolbar_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar_toolbar_box_finalize;
	/**
	     * Gtk.Toolbar to place children to
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOOLBAR_BOX_TOOLBAR, g_param_spec_object ("toolbar", "toolbar", "toolbar", SUGAR_TYPE__TOOLBAREXPANDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Toolbar orientation
	     *
	     * This property defines not only orientation of toolbar itself but also
	     * how ToolbarButton's pages should appear in imbeded mode.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOOLBAR_BOX_ORIENTATION, g_param_spec_enum ("orientation", "orientation", "orientation", GTK_TYPE_POSITION_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Padding size at the beginning and at the end of toolbar
	     *
	     * By default it is equal to padding of activity main toolbar.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOOLBAR_BOX_PADDING, g_param_spec_int ("padding", "padding", "padding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void sugar_toolbar_box_instance_init (SugarToolbarBox * self) {
	self->priv = SUGAR_TOOLBAR_BOX_GET_PRIVATE (self);
}


static void sugar_toolbar_box_finalize (GObject* obj) {
	SugarToolbarBox * self;
	self = SUGAR_TOOLBAR_BOX (obj);
	_g_object_unref0 (self->priv->_toolbar);
	_g_object_unref0 (self->priv->_toolbar_bin);
	_g_object_unref0 (self->priv->_expanded_bin);
	G_OBJECT_CLASS (sugar_toolbar_box_parent_class)->finalize (obj);
}


/**
 * Container to place ToolbarButton widgets
 *
 * Do not place widgets directly to this container, use toolbar property
 * instead. Toolbar property is a regualr Gtk.Toolbar and can contain not only
 * ToolbarButton widgets.
 *
 * Also see ToolbarButton for more information.
 */
GType sugar_toolbar_box_get_type (void) {
	static volatile gsize sugar_toolbar_box_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_toolbar_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarToolbarBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_toolbar_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarToolbarBox), 0, (GInstanceInitFunc) sugar_toolbar_box_instance_init, NULL };
		GType sugar_toolbar_box_type_id;
		sugar_toolbar_box_type_id = g_type_register_static (GTK_TYPE_VBOX, "SugarToolbarBox", &g_define_type_info, 0);
		g_once_init_leave (&sugar_toolbar_box_type_id__volatile, sugar_toolbar_box_type_id);
	}
	return sugar_toolbar_box_type_id__volatile;
}


static void _vala_sugar_toolbar_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarToolbarBox * self;
	self = SUGAR_TOOLBAR_BOX (object);
	switch (property_id) {
		case SUGAR_TOOLBAR_BOX_TOOLBAR:
		g_value_set_object (value, sugar_toolbar_box_get_toolbar (self));
		break;
		case SUGAR_TOOLBAR_BOX_ORIENTATION:
		g_value_set_enum (value, sugar_toolbar_box_get_orientation (self));
		break;
		case SUGAR_TOOLBAR_BOX_PADDING:
		g_value_set_int (value, sugar_toolbar_box_get_padding (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_toolbar_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarToolbarBox * self;
	self = SUGAR_TOOLBAR_BOX (object);
	switch (property_id) {
		case SUGAR_TOOLBAR_BOX_TOOLBAR:
		sugar_toolbar_box_set_toolbar (self, g_value_get_object (value));
		break;
		case SUGAR_TOOLBAR_BOX_ORIENTATION:
		sugar_toolbar_box_set_orientation (self, g_value_get_enum (value));
		break;
		case SUGAR_TOOLBAR_BOX_PADDING:
		sugar_toolbar_box_set_padding (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


Sugar_ToolbarExpander* sugar__toolbarexpander_construct (GType object_type) {
	Sugar_ToolbarExpander * self = NULL;
	self = (Sugar_ToolbarExpander*) g_object_new (object_type, NULL);
	return self;
}


Sugar_ToolbarExpander* sugar__toolbarexpander_new (void) {
	return sugar__toolbarexpander_construct (SUGAR_TYPE__TOOLBAREXPANDER);
}


SugarToolbarBox* sugar__toolbarexpander_get_toolbox (Sugar_ToolbarExpander* self) {
	SugarToolbarBox* result;
	GtkContainer* _tmp0_ = NULL;
	GtkContainer* _tmp1_ = NULL;
	GtkContainer* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_parent ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = SUGAR_IS_TOOLBAR_BOX (_tmp2_) ? ((SugarToolbarBox*) _tmp2_) : NULL;
	return result;
}


static void sugar__toolbarexpander_class_init (Sugar_ToolbarExpanderClass * klass) {
	sugar__toolbarexpander_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar__toolbarexpander_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR__TOOLBAREXPANDER_TOOLBOX, g_param_spec_object ("toolbox", "toolbox", "toolbox", SUGAR_TYPE_TOOLBAR_BOX, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void sugar__toolbarexpander_instance_init (Sugar_ToolbarExpander * self) {
}


GType sugar__toolbarexpander_get_type (void) {
	static volatile gsize sugar__toolbarexpander_type_id__volatile = 0;
	if (g_once_init_enter (&sugar__toolbarexpander_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (Sugar_ToolbarExpanderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar__toolbarexpander_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sugar_ToolbarExpander), 0, (GInstanceInitFunc) sugar__toolbarexpander_instance_init, NULL };
		GType sugar__toolbarexpander_type_id;
		sugar__toolbarexpander_type_id = g_type_register_static (GTK_TYPE_TOOLBAR, "Sugar_ToolbarExpander", &g_define_type_info, 0);
		g_once_init_leave (&sugar__toolbarexpander_type_id__volatile, sugar__toolbarexpander_type_id);
	}
	return sugar__toolbarexpander_type_id__volatile;
}


static void _vala_sugar__toolbarexpander_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Sugar_ToolbarExpander * self;
	self = SUGAR__TOOLBAREXPANDER (object);
	switch (property_id) {
		case SUGAR__TOOLBAREXPANDER_TOOLBOX:
		g_value_set_object (value, sugar__toolbarexpander_get_toolbox (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gboolean sugar__expandedbin_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	Sugar_ExpandedBin * self;
	gboolean result = FALSE;
	GtkStyle* _tmp0_ = NULL;
	gint _tmp1_;
	GtkStyle* _tmp2_ = NULL;
	gint _tmp3_;
	self = (Sugar_ExpandedBin*) base;
	GTK_WIDGET_CLASS (sugar__expandedbin_parent_class)->expose_event ((GtkWidget*) SUGAR_PAINT_BIN (self), event);
	_tmp0_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp1_ = sugar_metrics_get (SUGAR_FOCUS_LINE_WIDTH);
	gtk_paint_hline (_tmp0_, (*event).window, GTK_STATE_ACTIVE, &(*event).area, (GtkWidget*) self, NULL, 0, (self->gap_pos + _tmp1_) - 1, 0);
	_tmp2_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp3_ = sugar_metrics_get (SUGAR_FOCUS_LINE_WIDTH);
	gtk_paint_hline (_tmp2_, (*event).window, GTK_STATE_ACTIVE, &(*event).area, (GtkWidget*) self, NULL, (self->gap_pos + self->gap_size) - _tmp3_, ((GtkWidget*) self)->allocation.width, 0);
	result = FALSE;
	return result;
}


Sugar_ExpandedBin* sugar__expandedbin_construct (GType object_type) {
	Sugar_ExpandedBin * self = NULL;
	self = (Sugar_ExpandedBin*) sugar_paint_bin_construct (object_type);
	return self;
}


Sugar_ExpandedBin* sugar__expandedbin_new (void) {
	return sugar__expandedbin_construct (SUGAR_TYPE__EXPANDEDBIN);
}


static GObject * sugar__expandedbin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Sugar_ExpandedBin * self;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GdkColor _tmp3_ = {0};
	GdkColor _tmp4_ = {0};
	GdkColor _tmp5_ = {0};
	GdkColor _tmp6_ = {0};
	parent_class = G_OBJECT_CLASS (sugar__expandedbin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR__EXPANDEDBIN (obj);
	sugar_paint_bin_set_radius ((SugarPaintBin*) self, 0);
	_tmp0_ = sugar_metrics_get (SUGAR_TOOLBOX_HORIZONTAL_PADDING);
	sugar_paint_bin_set_padding_left ((SugarPaintBin*) self, _tmp0_);
	_tmp1_ = sugar_metrics_get (SUGAR_TOOLBOX_HORIZONTAL_PADDING);
	sugar_paint_bin_set_padding_right ((SugarPaintBin*) self, _tmp1_);
	_tmp2_ = sugar_metrics_get (SUGAR_GRID_CELL_SIZE);
	gtk_widget_set_size_request ((GtkWidget*) self, -1, _tmp2_);
	sugar_color_type_to_rgb (SUGAR_COLOR_TOOLBAR_GREY, &_tmp3_);
	_tmp4_ = _tmp3_;
	gtk_widget_modify_bg ((GtkWidget*) self, GTK_STATE_NORMAL, &_tmp4_);
	sugar_color_type_to_rgb (SUGAR_COLOR_BUTTON_GREY, &_tmp5_);
	_tmp6_ = _tmp5_;
	gtk_widget_modify_bg ((GtkWidget*) self, GTK_STATE_ACTIVE, &_tmp6_);
	return obj;
}


static void sugar__expandedbin_class_init (Sugar_ExpandedBinClass * klass) {
	sugar__expandedbin_parent_class = g_type_class_peek_parent (klass);
	GTK_WIDGET_CLASS (klass)->expose_event = sugar__expandedbin_real_expose_event;
	G_OBJECT_CLASS (klass)->constructor = sugar__expandedbin_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar__expandedbin_finalize;
}


static void sugar__expandedbin_instance_init (Sugar_ExpandedBin * self) {
}


static void sugar__expandedbin_finalize (GObject* obj) {
	Sugar_ExpandedBin * self;
	self = SUGAR__EXPANDEDBIN (obj);
	G_OBJECT_CLASS (sugar__expandedbin_parent_class)->finalize (obj);
}


GType sugar__expandedbin_get_type (void) {
	static volatile gsize sugar__expandedbin_type_id__volatile = 0;
	if (g_once_init_enter (&sugar__expandedbin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (Sugar_ExpandedBinClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar__expandedbin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sugar_ExpandedBin), 0, (GInstanceInitFunc) sugar__expandedbin_instance_init, NULL };
		GType sugar__expandedbin_type_id;
		sugar__expandedbin_type_id = g_type_register_static (SUGAR_TYPE_PAINT_BIN, "Sugar_ExpandedBin", &g_define_type_info, 0);
		g_once_init_leave (&sugar__expandedbin_type_id__volatile, sugar__expandedbin_type_id);
	}
	return sugar__expandedbin_type_id__volatile;
}


static void sugar__buttonpalette_real_size_request (GtkWidget* base, GtkRequisition* requisition) {
	Sugar_ButtonPalette * self;
	GtkRequisition _requisition = {0};
	GtkRequisition _tmp0_ = {0};
	gint _tmp1_;
	gint _tmp2_;
	self = (Sugar_ButtonPalette*) base;
	gtk_widget_size_request (((GtkBin*) self)->child, &_tmp0_);
	_requisition = _tmp0_;
	_tmp1_ = gdk_screen_width ();
	_requisition.width = _tmp1_;
	_tmp2_ = sugar_metrics_get (SUGAR_GRID_CELL_SIZE);
	_requisition.height = _tmp2_;
	if (requisition) {
		*requisition = _requisition;
	}
}


Sugar_ButtonPalette* sugar__buttonpalette_construct (GType object_type) {
	Sugar_ButtonPalette * self = NULL;
	self = (Sugar_ButtonPalette*) sugar_palette_window_construct (object_type);
	return self;
}


Sugar_ButtonPalette* sugar__buttonpalette_new (void) {
	return sugar__buttonpalette_construct (SUGAR_TYPE__BUTTONPALETTE);
}


static GObject * sugar__buttonpalette_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Sugar_ButtonPalette * self;
	GdkColor _tmp0_ = {0};
	GdkColor _tmp1_ = {0};
	GdkColor _tmp2_ = {0};
	GdkColor _tmp3_ = {0};
	SugarBin* _tmp4_ = NULL;
	gint _tmp5_;
	gint _tmp6_;
	parent_class = G_OBJECT_CLASS (sugar__buttonpalette_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR__BUTTONPALETTE (obj);
	sugar_color_type_to_rgb (SUGAR_COLOR_BLACK, &_tmp0_);
	_tmp1_ = _tmp0_;
	gtk_widget_modify_bg ((GtkWidget*) self, GTK_STATE_NORMAL, &_tmp1_);
	sugar_color_type_to_rgb (SUGAR_COLOR_BUTTON_GREY, &_tmp2_);
	_tmp3_ = _tmp2_;
	gtk_widget_modify_bg ((GtkWidget*) self, GTK_STATE_ACTIVE, &_tmp3_);
	_tmp4_ = sugar_bin_new ();
	_g_object_unref0 (self->bin);
	self->bin = g_object_ref_sink (_tmp4_);
	_tmp5_ = sugar_metrics_get (SUGAR_TOOLBOX_HORIZONTAL_PADDING);
	sugar_container_set_border_left ((SugarContainer*) self->bin, _tmp5_);
	_tmp6_ = sugar_metrics_get (SUGAR_TOOLBOX_HORIZONTAL_PADDING);
	sugar_container_set_border_right ((SugarContainer*) self->bin, _tmp6_);
	gtk_widget_show ((GtkWidget*) self->bin);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->bin);
	return obj;
}


static void sugar__buttonpalette_class_init (Sugar_ButtonPaletteClass * klass) {
	sugar__buttonpalette_parent_class = g_type_class_peek_parent (klass);
	GTK_WIDGET_CLASS (klass)->size_request = sugar__buttonpalette_real_size_request;
	G_OBJECT_CLASS (klass)->constructor = sugar__buttonpalette_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar__buttonpalette_finalize;
}


static void sugar__buttonpalette_instance_init (Sugar_ButtonPalette * self) {
}


static void sugar__buttonpalette_finalize (GObject* obj) {
	Sugar_ButtonPalette * self;
	self = SUGAR__BUTTONPALETTE (obj);
	_g_object_unref0 (self->bin);
	G_OBJECT_CLASS (sugar__buttonpalette_parent_class)->finalize (obj);
}


GType sugar__buttonpalette_get_type (void) {
	static volatile gsize sugar__buttonpalette_type_id__volatile = 0;
	if (g_once_init_enter (&sugar__buttonpalette_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (Sugar_ButtonPaletteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar__buttonpalette_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sugar_ButtonPalette), 0, (GInstanceInitFunc) sugar__buttonpalette_instance_init, NULL };
		GType sugar__buttonpalette_type_id;
		sugar__buttonpalette_type_id = g_type_register_static (SUGAR_TYPE_PALETTE_WINDOW, "Sugar_ButtonPalette", &g_define_type_info, 0);
		g_once_init_leave (&sugar__buttonpalette_type_id__volatile, sugar__buttonpalette_type_id);
	}
	return sugar__buttonpalette_type_id__volatile;
}


Sugar_Connector* sugar__connector_construct (GType object_type, GtkToolItem* tool_item) {
	Sugar_Connector * self = NULL;
	g_return_val_if_fail (tool_item != NULL, NULL);
	self = (Sugar_Connector*) sugar_tool_connector_construct (object_type, tool_item);
	return self;
}


Sugar_Connector* sugar__connector_new (GtkToolItem* tool_item) {
	return sugar__connector_construct (SUGAR_TYPE__CONNECTOR, tool_item);
}


static SugarConnectorAlignment* sugar__connector_real_get_alignments (SugarConnector* base, int* result_length1) {
	Sugar_Connector * self;
	SugarConnectorAlignment* result = NULL;
	self = (Sugar_Connector*) base;
	switch (self->priv->_orientation) {
		case GTK_POS_LEFT:
		{
			SugarConnectorAlignment* _tmp0_;
			_tmp0_ = SUGAR__CONNECTOR__right;
			if (result_length1) {
				*result_length1 = G_N_ELEMENTS (SUGAR__CONNECTOR__right);
			}
			result = _tmp0_;
			return result;
		}
		case GTK_POS_RIGHT:
		{
			SugarConnectorAlignment* _tmp1_;
			_tmp1_ = SUGAR__CONNECTOR__left;
			if (result_length1) {
				*result_length1 = G_N_ELEMENTS (SUGAR__CONNECTOR__left);
			}
			result = _tmp1_;
			return result;
		}
		case GTK_POS_TOP:
		{
			SugarConnectorAlignment* _tmp2_;
			_tmp2_ = SUGAR__CONNECTOR__bottom;
			if (result_length1) {
				*result_length1 = G_N_ELEMENTS (SUGAR__CONNECTOR__bottom);
			}
			result = _tmp2_;
			return result;
		}
		case GTK_POS_BOTTOM:
		{
			SugarConnectorAlignment* _tmp3_;
			_tmp3_ = SUGAR__CONNECTOR__top;
			if (result_length1) {
				*result_length1 = G_N_ELEMENTS (SUGAR__CONNECTOR__top);
			}
			result = _tmp3_;
			return result;
		}
		default:
		{
			gint _tmp4_;
			SugarConnectorAlignment* _tmp5_ = NULL;
			SugarConnectorAlignment* _tmp6_;
			_tmp5_ = SUGAR_CONNECTOR_CLASS (sugar__connector_parent_class)->get_alignments ((SugarConnector*) SUGAR_TOOL_CONNECTOR (self), &_tmp4_);
			_tmp6_ = _tmp5_;
			if (result_length1) {
				*result_length1 = _tmp4_;
			}
			result = _tmp6_;
			return result;
		}
	}
}


GtkPositionType sugar__connector_get_orientation (Sugar_Connector* self) {
	GtkPositionType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_orientation;
	return result;
}


void sugar__connector_set_orientation (Sugar_Connector* self, GtkPositionType value) {
	g_return_if_fail (self != NULL);
	self->priv->_orientation = value;
	g_object_notify ((GObject *) self, "orientation");
}


static void sugar__connector_class_init (Sugar_ConnectorClass * klass) {
	sugar__connector_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (Sugar_ConnectorPrivate));
	SUGAR_CONNECTOR_CLASS (klass)->get_alignments = sugar__connector_real_get_alignments;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar__connector_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar__connector_set_property;
	G_OBJECT_CLASS (klass)->finalize = sugar__connector_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR__CONNECTOR_ORIENTATION, g_param_spec_enum ("orientation", "orientation", "orientation", GTK_TYPE_POSITION_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void sugar__connector_instance_init (Sugar_Connector * self) {
	self->priv = SUGAR__CONNECTOR_GET_PRIVATE (self);
}


static void sugar__connector_finalize (GObject* obj) {
	Sugar_Connector * self;
	self = SUGAR__CONNECTOR (obj);
	G_OBJECT_CLASS (sugar__connector_parent_class)->finalize (obj);
}


GType sugar__connector_get_type (void) {
	static volatile gsize sugar__connector_type_id__volatile = 0;
	if (g_once_init_enter (&sugar__connector_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (Sugar_ConnectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar__connector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sugar_Connector), 0, (GInstanceInitFunc) sugar__connector_instance_init, NULL };
		GType sugar__connector_type_id;
		sugar__connector_type_id = g_type_register_static (SUGAR_TYPE_TOOL_CONNECTOR, "Sugar_Connector", &g_define_type_info, 0);
		g_once_init_leave (&sugar__connector_type_id__volatile, sugar__connector_type_id);
	}
	return sugar__connector_type_id__volatile;
}


static void _vala_sugar__connector_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Sugar_Connector * self;
	self = SUGAR__CONNECTOR (object);
	switch (property_id) {
		case SUGAR__CONNECTOR_ORIENTATION:
		g_value_set_enum (value, sugar__connector_get_orientation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar__connector_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Sugar_Connector * self;
	self = SUGAR__CONNECTOR (object);
	switch (property_id) {
		case SUGAR__CONNECTOR_ORIENTATION:
		sugar__connector_set_orientation (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void _sugar_prepare_page (GtkWidget* page, gint color) {
	GdkColor _tmp0_ = {0};
	GdkColor _tmp1_ = {0};
	GdkColor color_rgb;
	g_return_if_fail (page != NULL);
	sugar_color_type_to_rgb (color, &_tmp0_);
	_tmp1_ = _tmp0_;
	color_rgb = _tmp1_;
	if (GTK_IS_CONTAINER (page)) {
		GtkWidget* _tmp2_;
		GList* _tmp3_ = NULL;
		_tmp2_ = page;
		_tmp3_ = gtk_container_get_children (GTK_IS_CONTAINER (_tmp2_) ? ((GtkContainer*) _tmp2_) : NULL);
		{
			GList* i_collection;
			GList* i_it;
			i_collection = _tmp3_;
			for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
				GtkWidget* i;
				i = (GtkWidget*) i_it->data;
				{
					GtkWidget* _tmp4_;
					GtkToolItem* _tmp5_;
					GtkToolItem* item;
					gboolean _tmp6_ = FALSE;
					_tmp4_ = i;
					_tmp5_ = _g_object_ref0 (GTK_IS_TOOL_ITEM (_tmp4_) ? ((GtkToolItem*) _tmp4_) : NULL);
					item = _tmp5_;
					if (item != NULL) {
						_tmp6_ = ((GtkBin*) item)->child != NULL;
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						gtk_widget_modify_bg (((GtkBin*) item)->child, GTK_STATE_INSENSITIVE, &color_rgb);
					}
					_g_object_unref0 (item);
				}
			}
			_g_list_free0 (i_collection);
		}
	}
	gtk_widget_modify_bg (page, GTK_STATE_NORMAL, &color_rgb);
}



