# Copyright (C) 2012 Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import urllib
import logging
from gettext import dgettext

import gtk
import glib
import gobject

from sugar import wm
from sugar_network_webui import webui_port
from sugar_network.client import profile_path
from sugar.graphics.window import Window
from sugar.activity.activityfactory import create_activity_id
from jarabe.view.palettes import BasePalette
from jarabe.plugins.sn import SN_BROWSER_NAME, get_client

# HACK: Needed by http://dev.sugarlabs.org/ticket/456
try:
    import gnome
    gnome.init('Hulahop', '1.0')
except ImportError:
    pass

import hulahop
hulahop.startup(profile_path('network', 'webui'))
from xpcom import components
from hulahop.webview import WebView


_RETRY_TIMEOUT = 1

_ = lambda x: dgettext('sugar-plugin-sn', x)
_logger = logging.getLogger('plugins.sn.browser')


class Browser(Window):

    def __init__(self):
        Window.__init__(self)
        self._initial_load = True

        self.set_title(_('Sugar Network'))
        self.connect('realize', self.__realize_cb)
        self.iconify()

        self._webview = WebView()
        self.set_canvas(self._webview)
        self.show_all()

        get_client().connect('event', self.__Event_cb)

        gobject.timeout_add_seconds(_RETRY_TIMEOUT, self._open)

    def _open(self, *args, **kwargs):
        url = '/'.join(('http://127.0.0.1:%s' % webui_port.value,) + args)
        query = urllib.urlencode(kwargs)
        if query:
            url += '?' + query

        _logger.debug('Open %s', url)
        self._webview.load_uri(url)

    def __realize_cb(self, window):
        wm.set_bundle_id(window.window, SN_BROWSER_NAME)
        wm.set_activity_id(window.window, create_activity_id())
        self.disconnect_by_func(self.__realize_cb)

    def __Event_cb(self, sender, event, data):
        if event == 'inline' and data['state'] in ('offline', 'online'):
            self._open()


class Palette(BasePalette):

    def __init__(self, activity):
        self._activity = activity
        BasePalette.__init__(self, activity)

    def setup_palette(self):
        title = self._activity.get_title()
        self.set_primary_text(glib.markup_escape_text(title))
