# Copyright (C) 2012 Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import imp
import inspect
from os.path import dirname, basename

from sugar_stats.sniffer import Sniffer


def each():
    root = dirname(__file__)
    for filename in os.listdir(root):
        if filename == basename(__file__) or not filename.endswith('.py'):
            continue

        mod_name = basename(filename)[:-3]
        fp, pathname, description = imp.find_module(mod_name, [root])
        try:
            mod = imp.load_module(mod_name, fp, pathname, description)
        finally:
            if fp:
                fp.close()

        for __, cls in inspect.getmembers(mod):
            if inspect.isclass(cls) and issubclass(cls, Sniffer):
                yield cls
