# Copyright (C) 2010 Collabora Ltd. <http://www.collabora.co.uk/>
# Copyright (C) 2012 Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gobject


class ActivityModel(gobject.GObject):

    __gsignals__ = {
            'current-buddy-added': (
                gobject.SIGNAL_RUN_FIRST, gobject.TYPE_NONE, [object]),
            'current-buddy-removed': (
                gobject.SIGNAL_RUN_FIRST, gobject.TYPE_NONE, [object]),
            'buddy-added': (
                gobject.SIGNAL_RUN_FIRST, gobject.TYPE_NONE, [object]),
            'buddy-removed': (
                gobject.SIGNAL_RUN_FIRST, gobject.TYPE_NONE, [object]),
            }

    def __init__(self, activity_id, room_handle):
        gobject.GObject.__init__(self)

        self.activity_id = activity_id
        self.room_handle = room_handle
        self.shared = False
        self._bundle = None
        self._color = None
        self._private = True
        self._name = None
        self._current_buddies = []
        self._buddies = set()

    def get_color(self):
        return self._color

    def set_color(self, color):
        self._color = color

    color = gobject.property(type=object, getter=get_color, setter=set_color)

    def get_bundle(self):
        return self._bundle

    def set_bundle(self, bundle):
        self._bundle = bundle

    bundle = gobject.property(type=object, getter=get_bundle,
                              setter=set_bundle)

    def get_name(self):
        return self._name

    def set_name(self, name):
        self._name = name

    name = gobject.property(type=object, getter=get_name, setter=set_name)

    def is_private(self):
        return self._private

    def set_private(self, private):
        self._private = private

    private = gobject.property(type=object, getter=is_private,
                               setter=set_private)

    def get_buddies(self):
        return self._buddies

    def add_buddy(self, buddy):
        self._buddies.add(buddy)
        self.notify('buddies')
        self.emit('buddy-added', buddy)

    def remove_buddy(self, buddy):
        self._buddies.remove(buddy)
        self.notify('buddies')
        self.emit('buddy-removed', buddy)

    buddies = gobject.property(type=object, getter=get_buddies)

    def get_current_buddies(self):
        return self._current_buddies

    def add_current_buddy(self, buddy):
        self._current_buddies.append(buddy)
        self.notify('current-buddies')
        self.emit('current-buddy-added', buddy)

    def remove_current_buddy(self, buddy):
        self._current_buddies.remove(buddy)
        self.notify('current-buddies')
        self.emit('current-buddy-removed', buddy)

    current_buddies = gobject.property(type=object, getter=get_current_buddies)
