/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.tuple;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.tuple.TupleBinding;
import com.sleepycat.client.bind.tuple.TupleInput;
import com.sleepycat.client.bind.tuple.TupleOutput;

public class FloatBinding
extends TupleBinding<Float> {
    private static final int FLOAT_SIZE = 4;

    @Override
    public Float entryToObject(TupleInput tupleInput) {
        return Float.valueOf(tupleInput.readFloat());
    }

    @Override
    public void objectToEntry(Float f, TupleOutput tupleOutput) {
        tupleOutput.writeFloat(f.floatValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Float f) {
        return FloatBinding.sizedOutput();
    }

    public static float entryToFloat(SDatabaseEntry sDatabaseEntry) {
        return FloatBinding.entryToInput(sDatabaseEntry).readFloat();
    }

    public static void floatToEntry(float f, SDatabaseEntry sDatabaseEntry) {
        FloatBinding.outputToEntry(FloatBinding.sizedOutput().writeFloat(f), sDatabaseEntry);
    }

    static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[4]);
    }
}

