/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.collections;

import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.bind.EntryBinding;
import com.sleepycat.client.collections.BaseIterator;
import com.sleepycat.client.collections.DataCursor;
import com.sleepycat.client.collections.DataView;
import com.sleepycat.client.collections.StoredCollection;
import java.util.Set;

public class StoredKeySet<K>
extends StoredCollection<K>
implements Set<K> {
    public StoredKeySet(SDatabase sDatabase, EntryBinding<K> entryBinding, boolean bl) {
        super(new DataView(sDatabase, entryBinding, null, null, bl, null));
    }

    StoredKeySet(DataView dataView) {
        super(dataView);
    }

    @Override
    public boolean add(K k) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            SOperationStatus sOperationStatus = dataCursor.putNoOverwrite(k, null, false);
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return sOperationStatus == SOperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean remove(Object object) {
        return this.removeKey(object, null);
    }

    @Override
    public boolean contains(Object object) {
        return this.containsKey(object);
    }

    @Override
    boolean hasValues() {
        return false;
    }

    @Override
    K makeIteratorData(BaseIterator baseIterator, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3) {
        return (K)this.view.makeKey(sDatabaseEntry, sDatabaseEntry2);
    }

    @Override
    boolean iterateDuplicates() {
        return false;
    }
}

