/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist;

import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.persist.EntityCursor;
import com.sleepycat.client.persist.ForwardCursor;
import com.sleepycat.client.util.RuntimeExceptionWrapper;
import java.util.Iterator;
import java.util.NoSuchElementException;

class BasicIterator<V>
implements Iterator<V> {
    private EntityCursor<V> entityCursor;
    private ForwardCursor<V> forwardCursor;
    private SLockMode lockMode;
    private V nextValue;

    BasicIterator(EntityCursor<V> entityCursor, SLockMode sLockMode) {
        this.entityCursor = entityCursor;
        this.forwardCursor = entityCursor;
        this.lockMode = sLockMode;
    }

    BasicIterator(ForwardCursor<V> forwardCursor, SLockMode sLockMode) {
        this.forwardCursor = forwardCursor;
        this.lockMode = sLockMode;
    }

    @Override
    public boolean hasNext() {
        if (this.nextValue == null) {
            try {
                this.nextValue = this.forwardCursor.next(this.lockMode);
            }
            catch (SDatabaseException sDatabaseException) {
                throw RuntimeExceptionWrapper.wrapIfNeeded(sDatabaseException);
            }
            return this.nextValue != null;
        }
        return true;
    }

    @Override
    public V next() {
        if (this.hasNext()) {
            V v = this.nextValue;
            this.nextValue = null;
            return v;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.entityCursor == null) {
            throw new UnsupportedOperationException();
        }
        try {
            if (!this.entityCursor.delete()) {
                throw new IllegalStateException("Record at cursor position is already deleted");
            }
        }
        catch (SDatabaseException sDatabaseException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(sDatabaseException);
        }
    }
}

