/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.impl;

import com.sleepycat.client.persist.impl.Catalog;
import com.sleepycat.client.persist.impl.CollectionProxy;
import com.sleepycat.client.persist.impl.EntityInput;
import com.sleepycat.client.persist.impl.EntityOutput;
import com.sleepycat.client.persist.impl.Evolver;
import com.sleepycat.client.persist.impl.Format;
import com.sleepycat.client.persist.impl.Reader;
import com.sleepycat.client.persist.impl.RecordInput;
import com.sleepycat.client.persist.impl.RefreshException;
import com.sleepycat.client.persist.model.EntityModel;
import com.sleepycat.client.persist.model.PersistentProxy;
import com.sleepycat.client.persist.raw.RawObject;
import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class ProxiedFormat
extends Format {
    private static final long serialVersionUID = -1000032651995478768L;
    private Format proxyFormat;
    private transient String proxyClassName;

    ProxiedFormat(Catalog catalog, Class clazz, String string) {
        super(catalog, clazz);
        this.proxyClassName = string;
    }

    private String getProxyClassName() {
        if (this.proxyClassName != null) {
            return this.proxyClassName;
        }
        assert (this.proxyFormat != null);
        return this.proxyFormat.getClassName();
    }

    @Override
    boolean areNestedRefsProhibited() {
        return true;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> map) {
        assert (this.proxyClassName != null);
        catalog.createFormat(this.proxyClassName, map);
    }

    @Override
    void initialize(Catalog catalog, EntityModel entityModel, int n) {
        if (this.proxyFormat == null) {
            assert (this.proxyClassName != null);
            this.proxyFormat = catalog.getFormat(this.proxyClassName);
        }
        this.proxyFormat.setProxiedFormat(this);
    }

    @Override
    Object newArray(int n) {
        return Array.newInstance(this.getType(), n);
    }

    @Override
    public Object newInstance(EntityInput entityInput, boolean bl) throws RefreshException {
        Reader reader = this.proxyFormat.getReader();
        if (bl) {
            return reader.newInstance(null, true);
        }
        Object object = reader.readObject(reader.newInstance(null, false), entityInput, false);
        if (object instanceof PersistentProxy) {
            object = ((PersistentProxy)object).convertProxy();
        }
        return object;
    }

    @Override
    public Object readObject(Object object, EntityInput entityInput, boolean bl) throws RefreshException {
        if (bl) {
            object = this.proxyFormat.getReader().readObject(object, entityInput, true);
        }
        return object;
    }

    @Override
    void writeObject(Object object, EntityOutput entityOutput, boolean bl) throws RefreshException {
        if (bl) {
            this.proxyFormat.writeObject(object, entityOutput, true);
        } else {
            PersistentProxy persistentProxy = (PersistentProxy)this.proxyFormat.newInstance(null, false);
            persistentProxy.initializeProxy(object);
            this.proxyFormat.writeObject(persistentProxy, entityOutput, false);
        }
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean bl, RawObject rawObject, IdentityHashMap identityHashMap) throws RefreshException {
        PersistentProxy persistentProxy = (PersistentProxy)this.proxyFormat.convertRawObject(catalog, bl, rawObject, identityHashMap);
        Object t = persistentProxy.convertProxy();
        identityHashMap.put(rawObject, t);
        return t;
    }

    @Override
    void skipContents(RecordInput recordInput) throws RefreshException {
        this.proxyFormat.skipContents(recordInput);
    }

    @Override
    void copySecMultiKey(RecordInput recordInput, Format format, Set set) throws RefreshException {
        CollectionProxy.copyElements(recordInput, this, format, set);
    }

    @Override
    boolean evolve(Format format, Evolver evolver) {
        if (!(format instanceof ProxiedFormat)) {
            if (format.allowEvolveFromProxy()) {
                evolver.useEvolvedFormat(this, this, format);
                return true;
            }
            evolver.addEvolveError(this, format, null, "A proxied class may not be changed to a different type");
            return false;
        }
        ProxiedFormat proxiedFormat = (ProxiedFormat)format;
        if (!evolver.evolveFormat(this.proxyFormat)) {
            return false;
        }
        Format format2 = this.proxyFormat.getLatestVersion();
        if (!format2.getClassName().equals(proxiedFormat.getProxyClassName())) {
            evolver.addEvolveError(this, proxiedFormat, null, "The proxy class for this type has been changed from: " + format2.getClassName() + " to: " + proxiedFormat.getProxyClassName());
            return false;
        }
        if (format2 != this.proxyFormat) {
            evolver.useEvolvedFormat(this, this, proxiedFormat);
        } else {
            evolver.useOldFormat(this, proxiedFormat);
        }
        return true;
    }
}

