/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server;

import com.sleepycat.db.CacheFileStats;
import com.sleepycat.db.CheckpointConfig;
import com.sleepycat.db.CompactConfig;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.Environment;
import com.sleepycat.db.EnvironmentConfig;
import com.sleepycat.db.ForeignKeyDeleteAction;
import com.sleepycat.db.JoinConfig;
import com.sleepycat.db.JoinCursor;
import com.sleepycat.db.KeyRange;
import com.sleepycat.db.LockDetectMode;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.MemoryException;
import com.sleepycat.db.MultipleDataEntry;
import com.sleepycat.db.MultipleEntry;
import com.sleepycat.db.MultipleKeyDataEntry;
import com.sleepycat.db.MultipleRecnoDataEntry;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.SecondaryCursor;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.SecondaryMultiKeyCreator;
import com.sleepycat.db.Sequence;
import com.sleepycat.db.SequenceConfig;
import com.sleepycat.db.StatsConfig;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.TransactionConfig;
import com.sleepycat.server.callbacks.ServerKeyCreator;
import com.sleepycat.server.config.BdbServiceConfig;
import com.sleepycat.server.config.EnvDirType;
import com.sleepycat.server.function.BiFunctionEx;
import com.sleepycat.server.function.FunctionEx;
import com.sleepycat.server.function.SupplierEx;
import com.sleepycat.server.handle.CursorDescriptor;
import com.sleepycat.server.handle.DatabaseDescriptor;
import com.sleepycat.server.handle.DatabaseFileKey;
import com.sleepycat.server.handle.DatabaseKey;
import com.sleepycat.server.handle.EnvironmentDescriptor;
import com.sleepycat.server.handle.EnvironmentKey;
import com.sleepycat.server.handle.HandleDescriptor;
import com.sleepycat.server.handle.HandleManager;
import com.sleepycat.server.handle.JoinCursorDescriptor;
import com.sleepycat.server.handle.ResourceKey;
import com.sleepycat.server.handle.ResourceMembers;
import com.sleepycat.server.handle.SecondaryDatabaseDescriptor;
import com.sleepycat.server.handle.SequenceDescriptor;
import com.sleepycat.server.handle.SequenceKey;
import com.sleepycat.server.handle.TransactionDescriptor;
import com.sleepycat.server.util.Adapters;
import com.sleepycat.server.util.DelArgs;
import com.sleepycat.server.util.FileUtils;
import com.sleepycat.server.util.GetArgs;
import com.sleepycat.server.util.KeyDataPair;
import com.sleepycat.server.util.PutArgs;
import com.sleepycat.thrift.BdbService;
import com.sleepycat.thrift.TCachePriority;
import com.sleepycat.thrift.TCompactConfig;
import com.sleepycat.thrift.TCompactResult;
import com.sleepycat.thrift.TCursor;
import com.sleepycat.thrift.TCursorConfig;
import com.sleepycat.thrift.TCursorGetConfig;
import com.sleepycat.thrift.TCursorGetMode;
import com.sleepycat.thrift.TCursorPutConfig;
import com.sleepycat.thrift.TDatabase;
import com.sleepycat.thrift.TDatabaseConfig;
import com.sleepycat.thrift.TDatabaseStatResult;
import com.sleepycat.thrift.TDbGetConfig;
import com.sleepycat.thrift.TDbGetMode;
import com.sleepycat.thrift.TDbPutConfig;
import com.sleepycat.thrift.TDbt;
import com.sleepycat.thrift.TDurabilityPolicy;
import com.sleepycat.thrift.TEnvStatConfig;
import com.sleepycat.thrift.TEnvStatOption;
import com.sleepycat.thrift.TEnvStatResult;
import com.sleepycat.thrift.TEnvironment;
import com.sleepycat.thrift.TEnvironmentConfig;
import com.sleepycat.thrift.TGetResult;
import com.sleepycat.thrift.TGetWithPKeyResult;
import com.sleepycat.thrift.TJoinCursor;
import com.sleepycat.thrift.TJoinCursorGetConfig;
import com.sleepycat.thrift.TKeyData;
import com.sleepycat.thrift.TKeyDataWithPKey;
import com.sleepycat.thrift.TKeyDataWithSecondaryKeys;
import com.sleepycat.thrift.TKeyRangeResult;
import com.sleepycat.thrift.TOperationStatus;
import com.sleepycat.thrift.TProtocolVersionTestResult;
import com.sleepycat.thrift.TPutResult;
import com.sleepycat.thrift.TResourceInUseException;
import com.sleepycat.thrift.TSecondaryDatabaseConfig;
import com.sleepycat.thrift.TSequence;
import com.sleepycat.thrift.TSequenceConfig;
import com.sleepycat.thrift.TTransaction;
import com.sleepycat.thrift.TTransactionConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.thrift.TException;
import org.apache.thrift.server.TServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BdbServiceHandler
implements BdbService.Iface {
    private static final Logger logger = LoggerFactory.getLogger(BdbServiceHandler.class);
    private static final int INIT_BUFFER_SIZE = 0x400000;
    private static final int MIN_BUFFER_SIZE = 65536;
    private final HandleManager handleManager = new HandleManager();
    private TServer server = null;
    private BdbServiceConfig config;
    private volatile boolean shutdown = false;
    private ScheduledExecutorService cleanupWorker = null;

    public void setServerAndConfig(TServer tServer, BdbServiceConfig bdbServiceConfig) {
        this.server = Objects.requireNonNull(tServer, "server cannot be null.");
        this.config = Objects.requireNonNull(bdbServiceConfig, "config cannot be null.");
        int n = this.config.getCleanupIntervalInSeconds();
        this.cleanupWorker = Executors.newScheduledThreadPool(1);
        this.cleanupWorker.scheduleWithFixedDelay(() -> this.handleManager.closeInactiveHandles(this.config.getHandleTimeoutInSeconds()), n, n, TimeUnit.SECONDS);
    }

    public void ping() {
    }

    public TProtocolVersionTestResult isProtocolVersionSupported(String string) {
        String string2 = "1.1.0";
        boolean bl = string.equals(string2);
        return new TProtocolVersionTestResult(bl, string2, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
    }

    public String getBdbVersion() {
        return Environment.getVersionString();
    }

    public void shutdown() {
        if (!this.shutdown) {
            System.out.println("Shutting down the server...");
            this.shutdown = true;
            this.cleanupWorker.shutdown();
            this.server.stop();
            this.handleManager.shutdown();
            System.out.println("The server has been shut down successfully.");
        }
    }

    public TEnvironment openEnvironment(String string, TEnvironmentConfig tEnvironmentConfig) throws TException {
        ResourceMembers resourceMembers = null;
        boolean bl = false;
        try {
            EnvironmentConfig environmentConfig = Adapters.toBdbType(tEnvironmentConfig);
            Map<EnvDirType, File> map = this.config.getRootDirs();
            Map<EnvDirType, File> map2 = FileUtils.resolveDirectories(map, string, environmentConfig.getAllowCreate());
            File file = map2.get((Object)EnvDirType.HOME);
            EnvironmentKey environmentKey = new EnvironmentKey(file);
            if (environmentConfig.getRunRecovery()) {
                bl = true;
                resourceMembers = this.handleManager.writeLockResource(environmentKey);
                this.handleManager.closeHandles(resourceMembers.getMembers());
            } else {
                resourceMembers = this.readLock(environmentKey, "The environment is being recovered or deleted.");
            }
            this.addTransactionalSupport(environmentConfig);
            this.configureDirs(environmentConfig, map2);
            Environment environment = new Environment(file, environmentConfig);
            HandleDescriptor handleDescriptor = this.handleManager.register(new EnvironmentDescriptor(environment, environmentKey));
            TEnvironment tEnvironment = new TEnvironment(handleDescriptor.getId());
            if (bl) {
                this.handleManager.unlockWrite(resourceMembers);
            } else {
                this.handleManager.unlockRead(resourceMembers);
            }
            return tEnvironment;
        }
        catch (Exception exception) {
            try {
                throw this.error(this.buildLogMsg("openEnvironment", string, tEnvironmentConfig), exception);
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.handleManager.unlockWrite(resourceMembers);
                } else {
                    this.handleManager.unlockRead(resourceMembers);
                }
                throw throwable;
            }
        }
    }

    private void addTransactionalSupport(EnvironmentConfig environmentConfig) {
        environmentConfig.setInitializeCache(true);
        environmentConfig.setInitializeLocking(true);
        environmentConfig.setInitializeLogging(true);
        environmentConfig.setThreaded(true);
        environmentConfig.setTransactional(true);
        if (environmentConfig.getLockDetectMode() == LockDetectMode.NONE || environmentConfig.getLockDetectMode() == LockDetectMode.DEFAULT) {
            environmentConfig.setLockDetectMode(LockDetectMode.RANDOM);
        }
    }

    private void configureDirs(EnvironmentConfig environmentConfig, Map<EnvDirType, File> map) throws IOException {
        if (environmentConfig.getAllowCreate()) {
            FileUtils.createDirectories(map.values());
        }
        map.forEach((envDirType, file) -> {
            switch (envDirType) {
                case DATA: {
                    environmentConfig.addDataDir(file);
                    environmentConfig.setCreateDir(file);
                    break;
                }
                case LOG: {
                    environmentConfig.setLogDirectory(file);
                    break;
                }
                case BLOB: {
                    environmentConfig.setExternalFileDir(file);
                }
            }
        });
    }

    public void closeEnvironmentHandle(TEnvironment tEnvironment) throws TException {
        this.closeHandle(tEnvironment.handle, () -> "closeEnvironment(" + tEnvironment.handle + ")");
    }

    public void closeEnvironmentHandles(String string, long l) throws TException {
        this.closeAllResourceHandles(l, () -> {
            File file = this.resolveEnvDir(EnvDirType.HOME, string);
            return new EnvironmentKey(file);
        }, () -> this.buildLogMsg("closeAllEnvironmentHandles", string, l));
    }

    public void deleteEnvironmentAndDatabases(String string, boolean bl) throws TException {
        ResourceMembers resourceMembers = null;
        try {
            File file = this.resolveEnvDir(EnvDirType.HOME, string);
            EnvironmentKey environmentKey = new EnvironmentKey(file);
            resourceMembers = this.handleManager.writeLockResource(environmentKey);
            this.closeResource(resourceMembers, bl, "environment");
            Map<EnvDirType, File> map = FileUtils.resolveDirectories(this.config.getRootDirs(), string, false);
            for (File file2 : map.values()) {
                FileUtils.deleteFileTree(file2);
            }
            this.handleManager.unlockWrite(resourceMembers);
        }
        catch (Exception exception) {
            try {
                throw this.error(this.buildLogMsg("deleteEnvironmentAndDatabases", string, bl), exception);
            }
            catch (Throwable throwable) {
                this.handleManager.unlockWrite(resourceMembers);
                throw throwable;
            }
        }
    }

    private File resolveEnvDir(EnvDirType envDirType, String string) throws FileNotFoundException {
        File file;
        File file2 = this.config.getRootDirs().get((Object)envDirType);
        if (file2 == null) {
            file2 = this.config.getRootDirs().get((Object)EnvDirType.HOME);
        }
        if ((file = FileUtils.resolveDirectory(file2, string)) == null) {
            throw new FileNotFoundException(string);
        }
        return file;
    }

    private void closeResource(ResourceMembers resourceMembers, boolean bl, String string) throws TResourceInUseException {
        if (!resourceMembers.isEmpty() && !bl) {
            throw new TResourceInUseException("The " + string + " is in use.");
        }
        this.handleManager.closeHandles(resourceMembers.getMembers());
    }

    public TEnvironmentConfig getEnvironmentConfig(TEnvironment tEnvironment) throws TException {
        return this.handleOp(tEnvironment.handle, object -> Adapters.toThriftType(((Environment)object).getConfig()), () -> "getEnvironmentConfig(" + tEnvironment.handle + ")");
    }

    public void setEnvironmentConfig(TEnvironment tEnvironment, TEnvironmentConfig tEnvironmentConfig) throws TException {
        this.handleOp(tEnvironment.handle, object -> {
            Environment environment = (Environment)object;
            environment.setConfig(Adapters.update(environment.getConfig(), tEnvironmentConfig));
            return null;
        }, () -> this.buildLogMsg("setEnvironmentConfig", tEnvironment.handle, tEnvironmentConfig));
    }

    public void removeDatabase(TEnvironment tEnvironment, TTransaction tTransaction, String string, String string2, boolean bl) throws TException {
        this.dbResExclusiveOp(tEnvironment, tTransaction, string, string2, bl, (environment, transaction, string3, string4) -> {
            environment.removeDatabase(transaction, string, string2);
            try {
                environment.removeDatabase(transaction, string3, string4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }, () -> this.buildLogMsg("removeDatabase", tEnvironment.handle, tTransaction, string, string2, bl));
    }

    public void renameDatabase(TEnvironment tEnvironment, TTransaction tTransaction, String string, String string2, String string3, boolean bl) throws TException {
        this.dbResExclusiveOp(tEnvironment, tTransaction, string, string2, bl, (environment, transaction, string4, string5) -> {
            environment.renameDatabase(transaction, string, string2, string3);
            String string6 = string3;
            if (string4 == null || string5 == null) {
                string6 = ServerKeyCreator.getAuxiliaryName(string3);
            }
            try {
                environment.renameDatabase(transaction, string4, string5, string6);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }, () -> this.buildLogMsg("renameDatabase", tEnvironment.handle, tTransaction, string, string2, string3, bl));
    }

    private void dbResExclusiveOp(TEnvironment tEnvironment, TTransaction tTransaction, String string, String string2, boolean bl, DatabaseResourceOperation databaseResourceOperation, Supplier<String> supplier) throws TException {
        if (string == null && string2 == null) {
            throw new IllegalArgumentException("Rename or delete on temporary database is invalid.");
        }
        this.transactionalOp(tEnvironment.handle, tTransaction, (object, transaction2) -> {
            ResourceMembers resourceMembers = null;
            ResourceMembers resourceMembers2 = null;
            try {
                Environment environment = (Environment)object;
                DatabaseKey databaseKey = this.getDatabaseKey(environment, string, string2, false);
                DatabaseFileKey databaseFileKey = databaseKey.getDatabaseFile();
                if (string2 == null) {
                    resourceMembers = this.handleManager.writeLockResource(databaseFileKey);
                    this.closeResource(resourceMembers, bl, "database file");
                } else {
                    resourceMembers = this.readLock(databaseFileKey, "The database file is being deleted or renamed.");
                    resourceMembers2 = this.handleManager.writeLockResource(databaseKey);
                    this.closeResource(resourceMembers2, bl, "database");
                }
                DatabaseKey databaseKey2 = ServerKeyCreator.getAuxiliaryDbKey(databaseKey);
                DatabaseFileKey databaseFileKey2 = databaseKey2.getDatabaseFile();
                String string3 = databaseFileKey2.isInMemory() ? null : databaseFileKey2.getCanonicalPath();
                Object object2 = this.runWithAutoTxn(environment, (Transaction)transaction2, transaction -> {
                    databaseResourceOperation.run(environment, (Transaction)transaction, string3, databaseKey2.getDatabaseName());
                    return null;
                });
                this.handleManager.unlockWrite(resourceMembers2);
                if (string2 == null) {
                    this.handleManager.unlockWrite(resourceMembers);
                } else {
                    this.handleManager.unlockRead(resourceMembers);
                }
                return object2;
            }
            catch (Throwable throwable) {
                this.handleManager.unlockWrite(resourceMembers2);
                if (string2 == null) {
                    this.handleManager.unlockWrite(resourceMembers);
                } else {
                    this.handleManager.unlockRead(resourceMembers);
                }
                throw throwable;
            }
        }, supplier);
    }

    private <T> T runWithAutoTxn(Environment environment, Transaction transaction, FunctionEx<Transaction, T> functionEx) throws Exception {
        T t;
        Transaction transaction2 = transaction;
        if (transaction2 == null) {
            transaction2 = environment.beginTransaction(null, null);
        }
        try {
            t = functionEx.applyWithException(transaction2);
        }
        catch (Exception exception) {
            if (transaction == null) {
                transaction2.abort();
            }
            throw exception;
        }
        if (transaction == null) {
            transaction2.commit();
        }
        return t;
    }

    public void checkpoint(TEnvironment tEnvironment, int n, int n2, boolean bl) throws TException {
        this.handleOp(tEnvironment.handle, object -> {
            CheckpointConfig checkpointConfig = new CheckpointConfig();
            checkpointConfig.setForce(bl);
            checkpointConfig.setKBytes(n);
            checkpointConfig.setMinutes(n2);
            ((Environment)object).checkpoint(checkpointConfig);
            return null;
        }, () -> this.buildLogMsg("checkpoint", tEnvironment.handle, n, n2, bl));
    }

    public TDatabase openDatabase(TEnvironment tEnvironment, TTransaction tTransaction, String string, String string2, TDatabaseConfig tDatabaseConfig) throws TException {
        return this.transactionalDescOp(tEnvironment.handle, tTransaction, (handleDescriptor, transactionDescriptor) -> {
            EnvironmentDescriptor environmentDescriptor2 = (EnvironmentDescriptor)handleDescriptor;
            DatabaseConfig databaseConfig2 = Adapters.toBdbType(tDatabaseConfig);
            return this.createDatabaseHandle(environmentDescriptor2, (TransactionDescriptor)transactionDescriptor, string, string2, (DatabaseConfig)databaseConfig2, (environmentDescriptor, transaction, databaseKey, databaseConfig) -> {
                Environment environment = (Environment)environmentDescriptor.getHandle();
                Database database = environment.openDatabase(transaction, string, string2, databaseConfig);
                return new DatabaseDescriptor(database, databaseKey, environmentDescriptor);
            });
        }, () -> this.buildLogMsg("openDatabase", tEnvironment.handle, tTransaction, string, string2, tDatabaseConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends DatabaseConfig> TDatabase createDatabaseHandle(EnvironmentDescriptor environmentDescriptor, TransactionDescriptor transactionDescriptor, String string, String string2, T t, DatabaseDescriptorCreator<T> databaseDescriptorCreator) throws Exception {
        ResourceMembers resourceMembers = null;
        ResourceMembers resourceMembers2 = null;
        try {
            Environment environment = (Environment)environmentDescriptor.getHandle();
            Transaction transaction = transactionDescriptor == null ? null : (Transaction)transactionDescriptor.getHandle();
            DatabaseKey databaseKey = this.getDatabaseKey(environment, string, string2, t.getAllowCreate());
            resourceMembers = this.readLock(databaseKey.getDatabaseFile(), "The database file is being renamed or deleted.");
            if (string2 != null) {
                resourceMembers2 = this.readLock(databaseKey, "The database is being renamed or deleted.");
            }
            t.setTransactional(true);
            HandleDescriptor handleDescriptor = this.handleManager.register(databaseDescriptorCreator.open(environmentDescriptor, transaction, databaseKey, t));
            TDatabase tDatabase = new TDatabase(handleDescriptor.getId());
            this.handleManager.unlockRead(resourceMembers2);
            this.handleManager.unlockRead(resourceMembers);
            return tDatabase;
        }
        catch (Throwable throwable) {
            this.handleManager.unlockRead(resourceMembers2);
            this.handleManager.unlockRead(resourceMembers);
            throw throwable;
        }
    }

    private DatabaseKey getDatabaseKey(Environment environment, String string, String string2, boolean bl) throws Exception {
        File file = environment.getConfig().getCreateDir();
        if (file == null) {
            file = environment.getHome();
        }
        DatabaseFileKey databaseFileKey = this.resolveDbFileKey(file, string, bl);
        return new DatabaseKey(databaseFileKey, string2);
    }

    private DatabaseFileKey resolveDbFileKey(File file, String string, boolean bl) throws Exception {
        File file2;
        boolean bl2 = string == null;
        File file3 = file2 = bl2 ? file : FileUtils.resolveFile(file, string, bl);
        if (file2 == null) {
            throw new IOException("Cannot access database file.");
        }
        if (bl) {
            FileUtils.createDirectories(Collections.singleton(file2.getParentFile()));
        }
        return new DatabaseFileKey(file2, string, bl2);
    }

    public TDatabase openSecondaryDatabase(TEnvironment tEnvironment, TTransaction tTransaction, String string, String string2, TDatabase tDatabase, TSecondaryDatabaseConfig tSecondaryDatabaseConfig) throws TException {
        return this.transactionalDescOp(tEnvironment.handle, tTransaction, (handleDescriptor, transactionDescriptor) -> {
            DatabaseDescriptor databaseDescriptor = null;
            DatabaseDescriptor databaseDescriptor2 = null;
            try {
                databaseDescriptor = (DatabaseDescriptor)this.handleManager.readLockHandle(tDatabase.handle);
                if (((Database)databaseDescriptor.getHandle()).getConfig().getType() == DatabaseType.HEAP) {
                    throw new UnsupportedOperationException("Creating secondary databases on a Heap database is notsupported.");
                }
                if (tSecondaryDatabaseConfig.isSetForeignDb()) {
                    databaseDescriptor2 = (DatabaseDescriptor)this.handleManager.readLockHandle(tSecondaryDatabaseConfig.getForeignDb().handle);
                }
                EnvironmentDescriptor environmentDescriptor2 = (EnvironmentDescriptor)handleDescriptor;
                SecondaryConfig secondaryConfig2 = Adapters.toBdbType(tSecondaryDatabaseConfig);
                DatabaseDescriptor databaseDescriptor3 = databaseDescriptor;
                DatabaseDescriptor databaseDescriptor4 = databaseDescriptor2;
                TDatabase tDatabase2 = this.createDatabaseHandle(environmentDescriptor2, (TransactionDescriptor)transactionDescriptor, string, string2, (DatabaseConfig)secondaryConfig2, (environmentDescriptor, transaction2, databaseKey, secondaryConfig) -> {
                    Environment environment = (Environment)environmentDescriptor.getHandle();
                    ServerKeyCreator serverKeyCreator = new ServerKeyCreator(environment, databaseKey);
                    secondaryConfig.setMultiKeyCreator((SecondaryMultiKeyCreator)serverKeyCreator);
                    if (databaseDescriptor4 != null) {
                        secondaryConfig.setForeignKeyDatabase((Database)databaseDescriptor4.getHandle());
                    }
                    if (secondaryConfig.getForeignKeyDeleteAction() == ForeignKeyDeleteAction.NULLIFY) {
                        secondaryConfig.setForeignMultiKeyNullifier((secondaryDatabase, databaseEntry, databaseEntry2, databaseEntry3) -> false);
                    }
                    return this.runWithAutoTxn(environment, transaction2, transaction -> {
                        SecondaryDatabase secondaryDatabase = environment.openSecondaryDatabase(transaction, string, string2, (Database)databaseDescriptor3.getHandle(), secondaryConfig);
                        serverKeyCreator.setTransaction((Transaction)transaction);
                        serverKeyCreator.openAuxiliaryDb();
                        return new SecondaryDatabaseDescriptor(secondaryDatabase, databaseKey, environmentDescriptor, databaseDescriptor3, databaseDescriptor4, serverKeyCreator);
                    });
                });
                this.handleManager.unlockHandle(databaseDescriptor2);
                this.handleManager.unlockHandle(databaseDescriptor);
                return tDatabase2;
            }
            catch (Throwable throwable) {
                this.handleManager.unlockHandle(databaseDescriptor2);
                this.handleManager.unlockHandle(databaseDescriptor);
                throw throwable;
            }
        }, () -> this.buildLogMsg("openSecondaryDatabase", tEnvironment.handle, tTransaction, string, string2, tDatabase.handle, tSecondaryDatabaseConfig));
    }

    public void closeDatabaseHandle(TDatabase tDatabase) throws TException {
        this.closeHandle(tDatabase.handle, () -> "closeDatabase(" + tDatabase.handle + ")");
    }

    public void closeDatabaseHandles(String string, String string2, String string3, long l) throws TException {
        this.closeAllResourceHandles(l, () -> {
            File file = this.resolveEnvDir(EnvDirType.DATA, string);
            DatabaseFileKey databaseFileKey = this.resolveDbFileKey(file, string2, false);
            return string3 == null ? databaseFileKey : new DatabaseKey(databaseFileKey, string3);
        }, () -> this.buildLogMsg("closeAllDatabaseHandles", string, string2, string3, l));
    }

    public TDatabaseConfig getDatabaseConfig(TDatabase tDatabase) throws TException {
        return this.handleOp(tDatabase.handle, object -> Adapters.toThriftType(((Database)object).getConfig()), () -> this.buildLogMsg("getDatabaseConfig", tDatabase.handle));
    }

    public void setDatabaseConfig(TDatabase tDatabase, TDatabaseConfig tDatabaseConfig) throws TException {
        this.handleOp(tDatabase.handle, object -> {
            Database database = (Database)object;
            database.setConfig(Adapters.update(database.getConfig(), tDatabaseConfig));
            return null;
        }, () -> this.buildLogMsg("setDatabaseConfig", tDatabase.handle, tDatabaseConfig));
    }

    public TGetResult dbGet(TDatabase tDatabase, TTransaction tTransaction, TKeyData tKeyData, TDbGetConfig tDbGetConfig) throws TException {
        return this.transactionalOp(tDatabase.handle, tTransaction, (object, transaction) -> {
            Database database = (Database)object;
            GetArgs getArgs2 = new GetArgs(tKeyData, tDbGetConfig);
            Class<DatabaseEntry> clazz = DatabaseEntry.class;
            if (tDbGetConfig.isSetMultiple() && tDbGetConfig.multiple) {
                clazz = MultipleDataEntry.class;
            }
            OperationStatus operationStatus = this.getData(getArgs2, clazz, 0x400000, getArgs -> this.selectDbGetFunction(database, tDbGetConfig.mode).get((Transaction)transaction, getArgs.key, getArgs.data, getArgs.lockMode));
            TGetResult tGetResult = new TGetResult(Adapters.toThriftType(operationStatus));
            if (operationStatus == OperationStatus.SUCCESS) {
                tGetResult.setPairs(this.createPairs(this.filterDbGetOutput(getArgs2, tDbGetConfig.mode), database));
            }
            return tGetResult;
        }, () -> this.buildLogMsg("dbGet", tDatabase.handle, tTransaction, tKeyData, tDbGetConfig));
    }

    private DbGetFunction selectDbGetFunction(Database database, TDbGetMode tDbGetMode) {
        switch (tDbGetMode) {
            case CONSUME: {
                return (transaction, databaseEntry, databaseEntry2, lockMode) -> database.consume(transaction, databaseEntry, databaseEntry2, false);
            }
            case CONSUME_WAIT: {
                return (transaction, databaseEntry, databaseEntry2, lockMode) -> database.consume(transaction, databaseEntry, databaseEntry2, true);
            }
            case DEFAULT: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((Database)database).get(arg_0, arg_1, arg_2, arg_3);
            }
            case GET_BOTH: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((Database)database).getSearchBoth(arg_0, arg_1, arg_2, arg_3);
            }
            case SET_RECNO: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((Database)database).getSearchRecordNumber(arg_0, arg_1, arg_2, arg_3);
            }
        }
        throw new IllegalArgumentException("Invalid get mode.");
    }

    private GetArgs filterDbGetOutput(GetArgs getArgs, TDbGetMode tDbGetMode) {
        switch (tDbGetMode) {
            case GET_BOTH: {
                getArgs.data = null;
            }
            case DEFAULT: {
                getArgs.key = null;
            }
        }
        return getArgs;
    }

    private List<TKeyData> createPairs(GetArgs getArgs, Database database) throws DatabaseException {
        LinkedList<TKeyData> linkedList = new LinkedList<TKeyData>();
        if (getArgs.data instanceof MultipleKeyDataEntry) {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            while (((MultipleKeyDataEntry)getArgs.data).next(databaseEntry, databaseEntry2)) {
                TKeyData tKeyData = new TKeyData();
                tKeyData.setKey(Adapters.toThriftType(databaseEntry));
                tKeyData.setData(Adapters.toThriftType(databaseEntry2));
                tKeyData.getData().setPartial(false);
                linkedList.add(tKeyData);
            }
        } else if (getArgs.data instanceof MultipleRecnoDataEntry) {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry3 = new DatabaseEntry();
            while (((MultipleRecnoDataEntry)getArgs.data).next(databaseEntry, databaseEntry3)) {
                TKeyData tKeyData = new TKeyData();
                tKeyData.setKey(Adapters.toThriftType(databaseEntry));
                tKeyData.setData(Adapters.toThriftType(databaseEntry3));
                tKeyData.getData().setPartial(false);
                linkedList.add(tKeyData);
            }
        } else if (getArgs.data instanceof MultipleDataEntry) {
            TKeyData tKeyData = new TKeyData();
            if (getArgs.key != null) {
                tKeyData.setKey(Adapters.toThriftType(getArgs.key));
            }
            DatabaseEntry databaseEntry = new DatabaseEntry();
            while (((MultipleDataEntry)getArgs.data).next(databaseEntry)) {
                tKeyData.setData(Adapters.toThriftType(databaseEntry));
                tKeyData.getData().setPartial(false);
                linkedList.add(tKeyData);
                tKeyData = new TKeyData();
            }
        } else {
            TKeyData tKeyData = new TKeyData();
            if (getArgs.key != null) {
                tKeyData.setKey(Adapters.toThriftType(getArgs.key));
            }
            if (getArgs.data != null) {
                tKeyData.setData(Adapters.toThriftType(getArgs.data));
            }
            linkedList.add(tKeyData);
        }
        return linkedList;
    }

    private <T extends DatabaseEntry> OperationStatus getData(GetArgs getArgs, Class<T> clazz, int n, FunctionEx<GetArgs, OperationStatus> functionEx) throws Exception {
        if (MultipleEntry.class.isAssignableFrom(clazz)) {
            int n2 = n;
            if (n2 < 65536) {
                n2 = 65536;
            }
            OperationStatus operationStatus = null;
            while (operationStatus == null) {
                try {
                    getArgs.data = (DatabaseEntry)clazz.newInstance();
                    getArgs.data.setData(new byte[n2]);
                    getArgs.data.setUserBuffer(n2, true);
                    operationStatus = functionEx.applyWithException(getArgs);
                }
                catch (MemoryException memoryException) {
                    n2 *= 2;
                }
            }
            return operationStatus;
        }
        return functionEx.applyWithException(getArgs);
    }

    public TGetWithPKeyResult dbGetWithPKey(TDatabase tDatabase, TTransaction tTransaction, TKeyDataWithPKey tKeyDataWithPKey, TDbGetConfig tDbGetConfig) throws TException {
        return this.transactionalOp(tDatabase.handle, tTransaction, (object, transaction) -> {
            SecondaryDatabase secondaryDatabase = (SecondaryDatabase)object;
            GetArgs getArgs = new GetArgs(tKeyDataWithPKey, tDbGetConfig);
            OperationStatus operationStatus = this.selectDbPGetFunction(secondaryDatabase, tDbGetConfig.mode).get((Transaction)transaction, getArgs.key, getArgs.pKey, getArgs.data, getArgs.lockMode);
            TGetWithPKeyResult tGetWithPKeyResult = new TGetWithPKeyResult(Adapters.toThriftType(operationStatus));
            if (operationStatus == OperationStatus.SUCCESS) {
                tGetWithPKeyResult.setTuple(this.createTuple(this.filterDbPGetOutput(getArgs, tDbGetConfig.mode)));
            }
            return tGetWithPKeyResult;
        }, () -> this.buildLogMsg("dbGetWithPKey", tDatabase.handle, tTransaction, tKeyDataWithPKey, tDbGetConfig));
    }

    private DbPGetFunction selectDbPGetFunction(SecondaryDatabase secondaryDatabase, TDbGetMode tDbGetMode) {
        switch (tDbGetMode) {
            case SET_RECNO: {
                return (arg_0, arg_1, arg_2, arg_3, arg_4) -> ((SecondaryDatabase)secondaryDatabase).getSearchRecordNumber(arg_0, arg_1, arg_2, arg_3, arg_4);
            }
            case GET_BOTH: {
                return (arg_0, arg_1, arg_2, arg_3, arg_4) -> ((SecondaryDatabase)secondaryDatabase).getSearchBoth(arg_0, arg_1, arg_2, arg_3, arg_4);
            }
            case DEFAULT: {
                return (arg_0, arg_1, arg_2, arg_3, arg_4) -> ((SecondaryDatabase)secondaryDatabase).get(arg_0, arg_1, arg_2, arg_3, arg_4);
            }
        }
        throw new IllegalArgumentException("Invalid get mode.");
    }

    private GetArgs filterDbPGetOutput(GetArgs getArgs, TDbGetMode tDbGetMode) {
        switch (tDbGetMode) {
            case GET_BOTH: {
                getArgs.pKey = null;
            }
            case DEFAULT: {
                getArgs.key = null;
            }
        }
        return getArgs;
    }

    private TKeyDataWithPKey createTuple(GetArgs getArgs) throws DatabaseException {
        TKeyDataWithPKey tKeyDataWithPKey = new TKeyDataWithPKey();
        if (getArgs.key != null) {
            tKeyDataWithPKey.setSkey(Adapters.toThriftType(getArgs.key));
        }
        if (getArgs.pKey != null) {
            tKeyDataWithPKey.setPkey(Adapters.toThriftType(getArgs.pKey));
        }
        if (getArgs.data != null) {
            tKeyDataWithPKey.setPdata(Adapters.toThriftType(getArgs.data));
        }
        return tKeyDataWithPKey;
    }

    private boolean isRecordKey(Database database) throws DatabaseException {
        DatabaseType databaseType = database.getConfig().getType();
        return databaseType == DatabaseType.QUEUE || databaseType == DatabaseType.RECNO;
    }

    public TPutResult dbPut(TDatabase tDatabase, TTransaction tTransaction, List<TKeyDataWithSecondaryKeys> list, TDbPutConfig tDbPutConfig) throws TException {
        return this.transactionalDescOp(tDatabase.handle, tTransaction, (handleDescriptor, transactionDescriptor) -> {
            DatabaseDescriptor databaseDescriptor = (DatabaseDescriptor)handleDescriptor;
            if (databaseDescriptor.hasSecondaryDb() && tDbPutConfig == TDbPutConfig.APPEND) {
                throw new UnsupportedOperationException("Append is not supported for databases having secondary databases.");
            }
            Database database = (Database)databaseDescriptor.getHandle();
            Environment environment = database.getEnvironment();
            Map<Long, Map<KeyDataPair, List<DatabaseEntry>>> map = this.groupSecondaryKeysByDatabase(list);
            PutArgs putArgs = new PutArgs(list, this.isRecordKey(database), tDbPutConfig);
            Transaction transaction2 = transactionDescriptor == null ? null : (Transaction)transactionDescriptor.getHandle();
            OperationStatus operationStatus = this.runWithAutoTxn(environment, transaction2, transaction -> {
                databaseDescriptor.forEachSecondary(secondaryDatabaseDescriptor -> {
                    secondaryDatabaseDescriptor.setCurrentTxn((Transaction)transaction);
                    secondaryDatabaseDescriptor.setNewSecondaryKeys((Map)map.get(secondaryDatabaseDescriptor.getId()));
                });
                Database database = (Database)databaseDescriptor.getHandle();
                if (putArgs.key instanceof MultipleEntry) {
                    return database.putMultipleKey(transaction, (MultipleEntry)putArgs.key, tDbPutConfig == TDbPutConfig.OVERWRITE_DUP);
                }
                return this.selectDbPutFunction(database, tDbPutConfig).put((Transaction)transaction, putArgs.key, putArgs.data);
            });
            TPutResult tPutResult = new TPutResult();
            tPutResult.setStatus(Adapters.toThriftType(operationStatus));
            if (tDbPutConfig == TDbPutConfig.APPEND) {
                DatabaseEntry databaseEntry = new DatabaseEntry();
                databaseEntry.setRecordNumber(putArgs.key.getRecordNumber());
                tPutResult.setNewRecordNumber(databaseEntry.getData());
            }
            return tPutResult;
        }, () -> this.buildLogMsg("dbPut", tDatabase.handle, tTransaction, "pairs", tDbPutConfig));
    }

    private Map<Long, Map<KeyDataPair, List<DatabaseEntry>>> groupSecondaryKeysByDatabase(List<TKeyDataWithSecondaryKeys> list) {
        HashMap<Long, Map<KeyDataPair, List<DatabaseEntry>>> hashMap = new HashMap<Long, Map<KeyDataPair, List<DatabaseEntry>>>();
        list.stream().filter(tKeyDataWithSecondaryKeys -> tKeyDataWithSecondaryKeys.isSetSkeys() && tKeyDataWithSecondaryKeys.skeys != null).forEach(tKeyDataWithSecondaryKeys -> {
            DatabaseEntry databaseEntry = Adapters.toBdbType(tKeyDataWithSecondaryKeys.pkey);
            DatabaseEntry databaseEntry2 = Adapters.toBdbType(tKeyDataWithSecondaryKeys.pdata);
            KeyDataPair keyDataPair = new KeyDataPair(databaseEntry, databaseEntry2);
            for (TDatabase tDatabase : tKeyDataWithSecondaryKeys.skeys.keySet()) {
                Map map2 = hashMap.getOrDefault(tDatabase.handle, new HashMap());
                map2.put(keyDataPair, ((List)tKeyDataWithSecondaryKeys.skeys.get(tDatabase)).stream().map(Adapters::toBdbType).collect(Collectors.toList()));
                hashMap.put(tDatabase.handle, map2);
            }
        });
        return hashMap;
    }

    private DbPutFunction selectDbPutFunction(Database database, TDbPutConfig tDbPutConfig) {
        switch (tDbPutConfig) {
            case APPEND: {
                return (arg_0, arg_1, arg_2) -> ((Database)database).append(arg_0, arg_1, arg_2);
            }
            case DEFAULT: {
                return (arg_0, arg_1, arg_2) -> ((Database)database).put(arg_0, arg_1, arg_2);
            }
            case NO_DUP_DATA: {
                return (arg_0, arg_1, arg_2) -> ((Database)database).putNoDupData(arg_0, arg_1, arg_2);
            }
            case NO_OVERWRITE: {
                return (arg_0, arg_1, arg_2) -> ((Database)database).putNoOverwrite(arg_0, arg_1, arg_2);
            }
        }
        throw new IllegalArgumentException("Invalid put mode.");
    }

    public TOperationStatus dbDelete(TDatabase tDatabase, TTransaction tTransaction, List<TKeyData> list) throws TException {
        return this.transactionalDescOp(tDatabase.handle, tTransaction, (handleDescriptor, transactionDescriptor) -> {
            DatabaseDescriptor databaseDescriptor = (DatabaseDescriptor)handleDescriptor;
            Database database = (Database)databaseDescriptor.getHandle();
            Environment environment = database.getEnvironment();
            Transaction transaction2 = transactionDescriptor == null ? null : (Transaction)transactionDescriptor.getHandle();
            DelArgs delArgs = new DelArgs(list, this.isRecordKey(database));
            OperationStatus operationStatus = this.runWithAutoTxn(environment, transaction2, transaction -> {
                databaseDescriptor.forEachSecondary(secondaryDatabaseDescriptor -> secondaryDatabaseDescriptor.setCurrentTxn((Transaction)transaction));
                databaseDescriptor.forEachForeignSecondary(secondaryDatabaseDescriptor -> secondaryDatabaseDescriptor.setCurrentTxn((Transaction)transaction));
                if (((TKeyData)list.get(0)).isSetData()) {
                    return database.deleteMultipleKey(transaction, delArgs.key);
                }
                return database.deleteMultiple(transaction, delArgs.key);
            });
            return Adapters.toThriftType(operationStatus);
        }, () -> this.buildLogMsg("dbDelete", tDatabase.handle, tTransaction, "keyOrPairs"));
    }

    public TOperationStatus dbKeyExists(TDatabase tDatabase, TTransaction tTransaction, TDbt tDbt) throws TException {
        return this.transactionalOp(tDatabase.handle, tTransaction, (object, transaction) -> {
            DatabaseEntry databaseEntry = new DatabaseEntry(tDbt.data);
            return Adapters.toThriftType(((Database)object).exists(transaction, databaseEntry));
        }, () -> this.buildLogMsg("dbKeyExists", tDatabase.handle, tTransaction, tDbt));
    }

    public TKeyRangeResult dbKeyRange(TDatabase tDatabase, TTransaction tTransaction, TDbt tDbt) throws TException {
        return this.transactionalOp(tDatabase.handle, tTransaction, (object, transaction) -> {
            DatabaseEntry databaseEntry = new DatabaseEntry(tDbt.data);
            KeyRange keyRange = ((Database)object).getKeyRange(transaction, databaseEntry);
            return Adapters.toThriftType(keyRange);
        }, () -> this.buildLogMsg("dbKeyRange", tDatabase.handle, tTransaction, tDbt));
    }

    public TCompactResult dbCompact(TDatabase tDatabase, TTransaction tTransaction, TDbt tDbt, TDbt tDbt2, TCompactConfig tCompactConfig) throws TException {
        return this.transactionalOp(tDatabase.handle, tTransaction, (object, transaction) -> {
            DatabaseEntry databaseEntry = new DatabaseEntry(tDbt.data);
            DatabaseEntry databaseEntry2 = new DatabaseEntry(tDbt2.data);
            DatabaseEntry databaseEntry3 = new DatabaseEntry();
            CompactConfig compactConfig = Adapters.toBdbType(tCompactConfig);
            TCompactResult tCompactResult = Adapters.toThriftType(((Database)object).compact(transaction, databaseEntry, databaseEntry2, databaseEntry3, compactConfig));
            tCompactResult.setEndKey(new TDbt().setData(databaseEntry3.getData()));
            return tCompactResult;
        }, () -> this.buildLogMsg("dbCompact", tDatabase.handle, tTransaction, tDbt, tDbt2, tCompactConfig));
    }

    public int dbTruncate(TDatabase tDatabase, TTransaction tTransaction, boolean bl) throws TException {
        return this.transactionalDescOp(tDatabase.handle, tTransaction, (handleDescriptor, transactionDescriptor) -> {
            DatabaseDescriptor databaseDescriptor = (DatabaseDescriptor)handleDescriptor;
            Database database = (Database)databaseDescriptor.getHandle();
            Transaction transaction2 = transactionDescriptor == null ? null : (Transaction)transactionDescriptor.getHandle();
            return this.runWithAutoTxn(database.getEnvironment(), transaction2, transaction -> {
                int n = database.truncate(transaction, bl);
                databaseDescriptor.forEachSecondary(secondaryDatabaseDescriptor -> {
                    try {
                        ((Database)secondaryDatabaseDescriptor.getHandle()).truncate(transaction, false);
                    }
                    catch (DatabaseException databaseException) {
                        this.error("Failed to truncate an auxiliary database", (Exception)((Object)databaseException));
                    }
                });
                return n;
            });
        }, () -> this.buildLogMsg("dbTruncate", tDatabase.handle, tTransaction, bl));
    }

    public TCursor openCursor(TDatabase tDatabase, TTransaction tTransaction, TCursorConfig tCursorConfig) throws TException {
        return this.transactionalDescOp(tDatabase.handle, tTransaction, (handleDescriptor, transactionDescriptor) -> {
            DatabaseDescriptor databaseDescriptor = (DatabaseDescriptor)handleDescriptor;
            Transaction transaction = transactionDescriptor == null ? null : (Transaction)transactionDescriptor.getHandle();
            CursorConfig cursorConfig = Adapters.toBdbType(tCursorConfig);
            Cursor cursor = ((Database)databaseDescriptor.getHandle()).openCursor(transaction, cursorConfig);
            HandleDescriptor handleDescriptor2 = this.handleManager.register(new CursorDescriptor(cursor, databaseDescriptor, (TransactionDescriptor)transactionDescriptor));
            return new TCursor(handleDescriptor2.getId());
        }, () -> this.buildLogMsg("openCursor", tDatabase.handle, tTransaction, tCursorConfig));
    }

    public void closeCursorHandle(TCursor tCursor) throws TException {
        this.closeHandle(tCursor.handle, () -> "closeCursor(" + tCursor.handle + ")");
    }

    public TCursorConfig getCursorConfig(TCursor tCursor) throws TException {
        return this.handleOp(tCursor.handle, object -> Adapters.toThriftType(((Cursor)object).getConfig()), () -> this.buildLogMsg("getCursorConfig", tCursor.handle));
    }

    public TCachePriority getCursorCachePriority(TCursor tCursor) throws TException {
        return this.handleOp(tCursor.handle, object -> Adapters.toThriftType(((Cursor)object).getPriority()), () -> "getCursorCachePriority(" + tCursor.handle + ")");
    }

    public void setCursorCachePriority(TCursor tCursor, TCachePriority tCachePriority) throws TException {
        this.handleOp(tCursor.handle, object -> {
            ((Cursor)object).setPriority(Adapters.toBdbType(tCachePriority));
            return null;
        }, () -> this.buildLogMsg("setCursorCachePriority", tCursor.handle, tCachePriority));
    }

    public TGetResult cursorGet(TCursor tCursor, TKeyData tKeyData, TCursorGetConfig tCursorGetConfig) throws TException {
        return this.handleOp(tCursor.handle, object -> {
            Cursor cursor = (Cursor)object;
            GetArgs getArgs2 = new GetArgs(tKeyData, tCursorGetConfig);
            Class<DatabaseEntry> clazz = DatabaseEntry.class;
            if (tCursorGetConfig.isSetMultiple() && tCursorGetConfig.multiple) {
                clazz = MultipleDataEntry.class;
            } else if (tCursorGetConfig.isSetMultiKey() && tCursorGetConfig.multiKey) {
                clazz = this.isRecordKey(cursor.getDatabase()) ? MultipleRecnoDataEntry.class : MultipleKeyDataEntry.class;
            }
            OperationStatus operationStatus = this.getData(getArgs2, clazz, tCursorGetConfig.batchSize, getArgs -> this.selectCursorGetFunction(cursor, tCursorGetConfig.mode).get(getArgs.key, getArgs.data, getArgs.lockMode));
            TGetResult tGetResult = new TGetResult(Adapters.toThriftType(operationStatus));
            if (operationStatus == OperationStatus.SUCCESS) {
                tGetResult.setPairs(this.createPairs(this.filterCursorGetOutput(getArgs2, tCursorGetConfig.mode), cursor.getDatabase()));
            }
            return tGetResult;
        }, () -> this.buildLogMsg("cursorGet", tCursor.handle, tKeyData, tCursorGetConfig));
    }

    private CursorGetFunction selectCursorGetFunction(Cursor cursor, TCursorGetMode tCursorGetMode) {
        switch (tCursorGetMode) {
            case CURRENT: {
                return (arg_0, arg_1, arg_2) -> ((Cursor)cursor).getCurrent(arg_0, arg_1, arg_2);
            }
            case FIRST: {
                return (arg_0, arg_1, arg_2) -> ((Cursor)cursor).getFirst(arg_0, arg_1, arg_2);
            }
            case GET_BOTH: {
                return (arg_0, arg_1, arg_2) -> ((Cursor)cursor).getSearchBoth(arg_0, arg_1, arg_2);
            }
            case GET_BOTH_RANGE: {
                return (arg_0, arg_1, arg_2) -> ((Cursor)cursor).getSearchBothRange(arg_0, arg_1, arg_2);
            }
            case GET_RECNO: {
                return (databaseEntry, databaseEntry2, lockMode) -> cursor.getRecordNumber(databaseEntry2, lockMode);
            }
            case LAST: {
                return (arg_0, arg_1, arg_2) -> ((Cursor)cursor).getLast(arg_0, arg_1, arg_2);
            }
            case NEXT: {
                return (arg_0, arg_1, arg_2) -> ((Cursor)cursor).getNext(arg_0, arg_1, arg_2);
            }
            case NEXT_DUP: {
                return (arg_0, arg_1, arg_2) -> ((Cursor)cursor).getNextDup(arg_0, arg_1, arg_2);
            }
            case NEXT_NO_DUP: {
                return (arg_0, arg_1, arg_2) -> ((Cursor)cursor).getNextNoDup(arg_0, arg_1, arg_2);
            }
            case PREV: {
                return (arg_0, arg_1, arg_2) -> ((Cursor)cursor).getPrev(arg_0, arg_1, arg_2);
            }
            case PREV_DUP: {
                return (arg_0, arg_1, arg_2) -> ((Cursor)cursor).getPrevDup(arg_0, arg_1, arg_2);
            }
            case PREV_NO_DUP: {
                return (arg_0, arg_1, arg_2) -> ((Cursor)cursor).getPrevNoDup(arg_0, arg_1, arg_2);
            }
            case SET: {
                return (arg_0, arg_1, arg_2) -> ((Cursor)cursor).getSearchKey(arg_0, arg_1, arg_2);
            }
            case SET_RANGE: {
                return (arg_0, arg_1, arg_2) -> ((Cursor)cursor).getSearchKeyRange(arg_0, arg_1, arg_2);
            }
            case SET_RECNO: {
                return (arg_0, arg_1, arg_2) -> ((Cursor)cursor).getSearchRecordNumber(arg_0, arg_1, arg_2);
            }
        }
        throw new IllegalArgumentException("Invalid get mode.");
    }

    private GetArgs filterCursorGetOutput(GetArgs getArgs, TCursorGetMode tCursorGetMode) {
        switch (tCursorGetMode) {
            case GET_BOTH: {
                getArgs.data = null;
            }
            case GET_BOTH_RANGE: 
            case GET_RECNO: 
            case SET: {
                getArgs.key = null;
            }
        }
        return getArgs;
    }

    public TGetWithPKeyResult cursorGetWithPKey(TCursor tCursor, TKeyDataWithPKey tKeyDataWithPKey, TCursorGetConfig tCursorGetConfig) throws TException {
        return this.handleOp(tCursor.handle, object -> {
            SecondaryCursor secondaryCursor = (SecondaryCursor)object;
            GetArgs getArgs = new GetArgs(tKeyDataWithPKey, tCursorGetConfig);
            OperationStatus operationStatus = this.selectCursorPGetFunction(secondaryCursor, tCursorGetConfig.mode).get(getArgs.key, getArgs.pKey, getArgs.data, getArgs.lockMode);
            TGetWithPKeyResult tGetWithPKeyResult = new TGetWithPKeyResult(Adapters.toThriftType(operationStatus));
            if (operationStatus == OperationStatus.SUCCESS) {
                tGetWithPKeyResult.setTuple(this.createTuple(this.filterCursorPGetOutput(getArgs, tCursorGetConfig.mode)));
            }
            return tGetWithPKeyResult;
        }, () -> this.buildLogMsg("cursorGetWithPKey", tCursor.handle, tKeyDataWithPKey, tCursorGetConfig));
    }

    private CursorPGetFunction selectCursorPGetFunction(SecondaryCursor secondaryCursor, TCursorGetMode tCursorGetMode) {
        switch (tCursorGetMode) {
            case CURRENT: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((SecondaryCursor)secondaryCursor).getCurrent(arg_0, arg_1, arg_2, arg_3);
            }
            case FIRST: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((SecondaryCursor)secondaryCursor).getFirst(arg_0, arg_1, arg_2, arg_3);
            }
            case GET_BOTH: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((SecondaryCursor)secondaryCursor).getSearchBoth(arg_0, arg_1, arg_2, arg_3);
            }
            case GET_BOTH_RANGE: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((SecondaryCursor)secondaryCursor).getSearchBothRange(arg_0, arg_1, arg_2, arg_3);
            }
            case GET_RECNO: {
                return (databaseEntry, databaseEntry2, databaseEntry3, lockMode) -> secondaryCursor.getRecordNumber(databaseEntry2, databaseEntry3, lockMode);
            }
            case LAST: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((SecondaryCursor)secondaryCursor).getLast(arg_0, arg_1, arg_2, arg_3);
            }
            case NEXT: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((SecondaryCursor)secondaryCursor).getNext(arg_0, arg_1, arg_2, arg_3);
            }
            case NEXT_DUP: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((SecondaryCursor)secondaryCursor).getNextDup(arg_0, arg_1, arg_2, arg_3);
            }
            case NEXT_NO_DUP: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((SecondaryCursor)secondaryCursor).getNextNoDup(arg_0, arg_1, arg_2, arg_3);
            }
            case PREV: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((SecondaryCursor)secondaryCursor).getPrev(arg_0, arg_1, arg_2, arg_3);
            }
            case PREV_DUP: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((SecondaryCursor)secondaryCursor).getPrevDup(arg_0, arg_1, arg_2, arg_3);
            }
            case PREV_NO_DUP: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((SecondaryCursor)secondaryCursor).getPrevNoDup(arg_0, arg_1, arg_2, arg_3);
            }
            case SET: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((SecondaryCursor)secondaryCursor).getSearchKey(arg_0, arg_1, arg_2, arg_3);
            }
            case SET_RANGE: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((SecondaryCursor)secondaryCursor).getSearchKeyRange(arg_0, arg_1, arg_2, arg_3);
            }
            case SET_RECNO: {
                return (arg_0, arg_1, arg_2, arg_3) -> ((SecondaryCursor)secondaryCursor).getSearchRecordNumber(arg_0, arg_1, arg_2, arg_3);
            }
        }
        throw new IllegalArgumentException("Invalid get mode.");
    }

    private GetArgs filterCursorPGetOutput(GetArgs getArgs, TCursorGetMode tCursorGetMode) {
        switch (tCursorGetMode) {
            case GET_BOTH: {
                getArgs.pKey = null;
            }
            case GET_BOTH_RANGE: 
            case GET_RECNO: 
            case SET: {
                getArgs.key = null;
            }
        }
        return getArgs;
    }

    public TPutResult cursorPut(TCursor tCursor, TKeyDataWithSecondaryKeys tKeyDataWithSecondaryKeys, TCursorPutConfig tCursorPutConfig) throws TException {
        return this.cursorOp(tCursor, (cursorDescriptor, transaction) -> {
            Map<Long, Map<KeyDataPair, List<DatabaseEntry>>> map = this.groupSecondaryKeysByDatabase(Collections.singletonList(tKeyDataWithSecondaryKeys));
            PutArgs putArgs = new PutArgs(tKeyDataWithSecondaryKeys);
            DatabaseDescriptor databaseDescriptor = cursorDescriptor.getDb();
            databaseDescriptor.forEachSecondary(secondaryDatabaseDescriptor -> {
                secondaryDatabaseDescriptor.setCurrentTxn((Transaction)transaction);
                secondaryDatabaseDescriptor.setNewSecondaryKeys((Map)map.get(secondaryDatabaseDescriptor.getId()));
            });
            OperationStatus operationStatus = this.selectCursorPutFunction((Cursor)cursorDescriptor.getHandle(), tCursorPutConfig).put(putArgs.key, putArgs.data);
            TPutResult tPutResult = new TPutResult();
            tPutResult.setStatus(Adapters.toThriftType(operationStatus));
            DatabaseType databaseType = ((Database)databaseDescriptor.getHandle()).getConfig().getType();
            if (databaseType == DatabaseType.RECNO && (tCursorPutConfig == TCursorPutConfig.AFTER || tCursorPutConfig == TCursorPutConfig.BEFORE)) {
                DatabaseEntry databaseEntry = new DatabaseEntry();
                databaseEntry.setRecordNumber(putArgs.key.getRecordNumber());
                tPutResult.setNewRecordNumber(databaseEntry.getData());
            }
            return tPutResult;
        }, () -> this.buildLogMsg("cursorPut", tCursor.handle, tKeyDataWithSecondaryKeys, tCursorPutConfig));
    }

    private CursorPutFunction selectCursorPutFunction(Cursor cursor, TCursorPutConfig tCursorPutConfig) {
        switch (tCursorPutConfig) {
            case AFTER: {
                return (arg_0, arg_1) -> ((Cursor)cursor).putAfter(arg_0, arg_1);
            }
            case BEFORE: {
                return (arg_0, arg_1) -> ((Cursor)cursor).putBefore(arg_0, arg_1);
            }
            case CURRENT: {
                return (databaseEntry, databaseEntry2) -> cursor.putCurrent(databaseEntry2);
            }
            case DEFAULT: {
                return (arg_0, arg_1) -> ((Cursor)cursor).put(arg_0, arg_1);
            }
            case KEY_FIRST: {
                return (arg_0, arg_1) -> ((Cursor)cursor).putKeyFirst(arg_0, arg_1);
            }
            case KEY_LAST: {
                return (arg_0, arg_1) -> ((Cursor)cursor).putKeyLast(arg_0, arg_1);
            }
            case NO_DUP_DATA: {
                return (arg_0, arg_1) -> ((Cursor)cursor).putNoDupData(arg_0, arg_1);
            }
            case NO_OVERWRITE: {
                return (arg_0, arg_1) -> ((Cursor)cursor).putNoOverwrite(arg_0, arg_1);
            }
        }
        throw new IllegalArgumentException("Invalid put mode.");
    }

    public TOperationStatus cursorDelete(TCursor tCursor) throws TException {
        return this.cursorOp(tCursor, (cursorDescriptor, transaction) -> {
            DatabaseDescriptor databaseDescriptor = cursorDescriptor.getDb();
            databaseDescriptor.forEachSecondary(secondaryDatabaseDescriptor -> secondaryDatabaseDescriptor.setCurrentTxn((Transaction)transaction));
            databaseDescriptor.forEachForeignSecondary(secondaryDatabaseDescriptor -> secondaryDatabaseDescriptor.setCurrentTxn((Transaction)transaction));
            return Adapters.toThriftType(((Cursor)cursorDescriptor.getHandle()).delete());
        }, () -> this.buildLogMsg("cursorDelete", tCursor.handle));
    }

    private <T> T cursorOp(TCursor tCursor, BiFunctionEx<CursorDescriptor, Transaction, T> biFunctionEx, Supplier<String> supplier) throws TException {
        Object object;
        CursorDescriptor cursorDescriptor = null;
        try {
            cursorDescriptor = (CursorDescriptor)this.handleManager.readLockHandle(tCursor.handle);
            TransactionDescriptor transactionDescriptor = cursorDescriptor.getTransaction();
            DatabaseDescriptor databaseDescriptor = cursorDescriptor.getDb();
            Transaction transaction2 = transactionDescriptor == null ? null : (Transaction)transactionDescriptor.getHandle();
            Environment environment = ((Database)databaseDescriptor.getHandle()).getEnvironment();
            CursorDescriptor cursorDescriptor2 = cursorDescriptor;
            object = this.runWithAutoTxn(environment, transaction2, transaction -> biFunctionEx.applyWithException(cursorDescriptor2, (Transaction)transaction));
            this.handleManager.unlockHandle(cursorDescriptor);
        }
        catch (Exception exception) {
            try {
                throw this.error(supplier.get(), exception);
            }
            catch (Throwable throwable) {
                this.handleManager.unlockHandle(cursorDescriptor);
                throw throwable;
            }
        }
        return (T)object;
    }

    public TCursor cursorDup(TCursor tCursor, boolean bl) throws TException {
        CursorDescriptor cursorDescriptor = null;
        try {
            cursorDescriptor = (CursorDescriptor)this.handleManager.readLockHandle(tCursor.handle);
            Cursor cursor = ((Cursor)cursorDescriptor.getHandle()).dup(bl);
            HandleDescriptor handleDescriptor = this.handleManager.register(new CursorDescriptor(cursor, cursorDescriptor));
            TCursor tCursor2 = new TCursor(handleDescriptor.getId());
            this.handleManager.unlockHandle(cursorDescriptor);
            return tCursor2;
        }
        catch (Exception exception) {
            try {
                throw this.error(this.buildLogMsg("cursorDup", tCursor.handle, bl), exception);
            }
            catch (Throwable throwable) {
                this.handleManager.unlockHandle(cursorDescriptor);
                throw throwable;
            }
        }
    }

    public short cursorCompare(TCursor tCursor, TCursor tCursor2) throws TException {
        return this.handleOp(tCursor.handle, object -> {
            CursorDescriptor cursorDescriptor = null;
            try {
                cursorDescriptor = (CursorDescriptor)this.handleManager.readLockHandle(tCursor.handle);
                Short s = (short)((Cursor)object).compare((Cursor)cursorDescriptor.getHandle());
                this.handleManager.unlockHandle(cursorDescriptor);
                return s;
            }
            catch (Throwable throwable) {
                this.handleManager.unlockHandle(cursorDescriptor);
                throw throwable;
            }
        }, () -> this.buildLogMsg("cursorCompare", tCursor.handle, tCursor2.handle));
    }

    public int cursorCount(TCursor tCursor) throws TException {
        return this.handleOp(tCursor.handle, object -> ((Cursor)object).count(), () -> this.buildLogMsg("cursorCount", tCursor.handle));
    }

    public TJoinCursor openJoinCursor(TDatabase tDatabase, List<TCursor> list, boolean bl) throws TException {
        DatabaseDescriptor databaseDescriptor = null;
        LinkedList<CursorDescriptor> linkedList = new LinkedList<CursorDescriptor>();
        try {
            databaseDescriptor = (DatabaseDescriptor)this.handleManager.readLockHandle(tDatabase.handle);
            list.forEach(tCursor -> linkedList.add((CursorDescriptor)this.handleManager.readLockHandle(tCursor.handle)));
            Cursor[] cursorArray = (Cursor[])linkedList.stream().map(HandleDescriptor::getHandle).toArray(Cursor[]::new);
            JoinConfig joinConfig = new JoinConfig();
            joinConfig.setNoSort(!bl);
            JoinCursor joinCursor = ((Database)databaseDescriptor.getHandle()).join(cursorArray, joinConfig);
            HandleDescriptor handleDescriptor = this.handleManager.register(new JoinCursorDescriptor(joinCursor, databaseDescriptor, linkedList));
            TJoinCursor tJoinCursor = new TJoinCursor(handleDescriptor.getId());
            return tJoinCursor;
        }
        catch (Exception exception) {
            throw this.error(this.buildLogMsg("openJoinCursor", tDatabase.handle, list, bl), exception);
        }
        finally {
            linkedList.forEach(this.handleManager::unlockHandle);
            this.handleManager.unlockHandle(databaseDescriptor);
        }
    }

    public void closeJoinCursorHandle(TJoinCursor tJoinCursor) throws TException {
        this.closeHandle(tJoinCursor.handle, () -> this.buildLogMsg("closeJoinCursor", tJoinCursor.handle));
    }

    public TGetResult joinCursorGet(TJoinCursor tJoinCursor, TJoinCursorGetConfig tJoinCursorGetConfig) throws TException {
        return this.handleOp(tJoinCursor.handle, object -> {
            JoinCursor joinCursor = (JoinCursor)object;
            GetArgs getArgs = new GetArgs(tJoinCursorGetConfig);
            OperationStatus operationStatus = joinCursor.getNext(getArgs.key, getArgs.data, getArgs.lockMode);
            TGetResult tGetResult = new TGetResult(Adapters.toThriftType(operationStatus));
            if (operationStatus == OperationStatus.SUCCESS) {
                tGetResult.setPairs(this.createPairs(getArgs, joinCursor.getDatabase()));
            }
            return tGetResult;
        }, () -> this.buildLogMsg("joinCursorGet", tJoinCursor.handle, tJoinCursorGetConfig));
    }

    public TTransaction beginTransaction(TEnvironment tEnvironment, TTransaction tTransaction, TTransactionConfig tTransactionConfig) throws TException {
        return this.transactionalDescOp(tEnvironment.getHandle(), tTransaction, (handleDescriptor, transactionDescriptor) -> {
            EnvironmentDescriptor environmentDescriptor = (EnvironmentDescriptor)handleDescriptor;
            Transaction transaction = transactionDescriptor == null ? null : (Transaction)transactionDescriptor.getHandle();
            TransactionConfig transactionConfig = Adapters.toBdbType(tTransactionConfig);
            Transaction transaction2 = ((Environment)environmentDescriptor.getHandle()).beginTransaction(transaction, transactionConfig);
            HandleDescriptor handleDescriptor2 = this.handleManager.register(new TransactionDescriptor(transaction2, environmentDescriptor, (TransactionDescriptor)transactionDescriptor));
            return new TTransaction(handleDescriptor2.getId());
        }, () -> "beginTransaction(" + tEnvironment.handle + ", " + tTransaction + ", " + tTransactionConfig + ")");
    }

    public void txnAbort(TTransaction tTransaction) throws TException {
        this.resolveTxn(tTransaction, TransactionDescriptor.Status.ABORTED, () -> "txnAbort(" + tTransaction.handle + ")");
    }

    public void txnCommit(TTransaction tTransaction, TDurabilityPolicy tDurabilityPolicy) throws TException {
        this.resolveTxn(tTransaction, TransactionDescriptor.Status.toStatus(tDurabilityPolicy), () -> "txnCommit(" + tTransaction.handle + ", " + tDurabilityPolicy + ")");
    }

    private void resolveTxn(TTransaction tTransaction, TransactionDescriptor.Status status, Supplier<String> supplier) throws TException {
        try {
            this.handleManager.closeHandle(tTransaction.handle, (HandleDescriptor handleDescriptor) -> ((TransactionDescriptor)handleDescriptor).resolve(status));
        }
        catch (Exception exception) {
            throw this.error(supplier.get(), exception);
        }
    }

    public int txnGetPriority(TTransaction tTransaction) throws TException {
        return this.handleOp(tTransaction.handle, object -> ((Transaction)object).getPriority(), () -> "txnGetPriority(" + tTransaction.handle + ")");
    }

    public void txnSetPriority(TTransaction tTransaction, int n) throws TException {
        this.handleOp(tTransaction.handle, object -> {
            ((Transaction)object).setPriority(n);
            return null;
        }, () -> "txnSetPriority(" + tTransaction.handle + ", " + n + ")");
    }

    public TSequence openSequence(TDatabase tDatabase, TTransaction tTransaction, TDbt tDbt, TSequenceConfig tSequenceConfig) throws TException {
        return this.transactionalDescOp(tDatabase.handle, tTransaction, (handleDescriptor, transactionDescriptor) -> {
            ResourceMembers resourceMembers = null;
            try {
                DatabaseDescriptor databaseDescriptor = (DatabaseDescriptor)handleDescriptor;
                Database database = (Database)databaseDescriptor.getHandle();
                Transaction transaction = transactionDescriptor == null ? null : (Transaction)transactionDescriptor.getHandle();
                SequenceConfig sequenceConfig = Adapters.toBdbType(tSequenceConfig);
                DatabaseKey databaseKey = databaseDescriptor.getResourceKey();
                DatabaseEntry databaseEntry = new DatabaseEntry(tDbt.getData());
                SequenceKey sequenceKey = new SequenceKey(databaseKey, tDbt.getData());
                resourceMembers = this.readLock(sequenceKey, "The sequence is being deleted.");
                Sequence sequence = database.openSequence(transaction, databaseEntry, sequenceConfig);
                HandleDescriptor handleDescriptor2 = this.handleManager.register(new SequenceDescriptor(sequence, sequenceKey, databaseDescriptor));
                TSequence tSequence = new TSequence(handleDescriptor2.getId());
                this.handleManager.unlockRead(resourceMembers);
                return tSequence;
            }
            catch (Throwable throwable) {
                this.handleManager.unlockRead(resourceMembers);
                throw throwable;
            }
        }, () -> this.buildLogMsg("openSequence", tDatabase.handle, tTransaction, tDbt, tSequenceConfig));
    }

    public void closeSequenceHandle(TSequence tSequence) throws TException {
        this.closeHandle(tSequence.handle, () -> this.buildLogMsg("closeSequence", tSequence.handle));
    }

    public void removeSequence(TDatabase tDatabase, TTransaction tTransaction, TDbt tDbt, boolean bl, boolean bl2) throws TException {
        this.transactionalDescOp(tDatabase.handle, tTransaction, (handleDescriptor, transactionDescriptor) -> {
            ResourceMembers resourceMembers = null;
            try {
                DatabaseDescriptor databaseDescriptor = (DatabaseDescriptor)handleDescriptor;
                Database database = (Database)databaseDescriptor.getHandle();
                Transaction transaction = transactionDescriptor == null ? null : (Transaction)transactionDescriptor.getHandle();
                DatabaseKey databaseKey = databaseDescriptor.getResourceKey();
                SequenceKey sequenceKey = new SequenceKey(databaseKey, tDbt.getData());
                resourceMembers = this.handleManager.writeLockResource(sequenceKey);
                if (!resourceMembers.isEmpty() && !bl2) {
                    throw new TResourceInUseException("The sequence is in use.");
                }
                this.handleManager.closeHandles(resourceMembers.getMembers());
                SequenceConfig sequenceConfig = new SequenceConfig();
                sequenceConfig.setAutoCommitNoSync(bl);
                database.removeSequence(transaction, new DatabaseEntry(tDbt.getData()), sequenceConfig);
                Object var13_13 = null;
                this.handleManager.unlockWrite(resourceMembers);
                return var13_13;
            }
            catch (Throwable throwable) {
                this.handleManager.unlockWrite(resourceMembers);
                throw throwable;
            }
        }, () -> this.buildLogMsg("removeSequence", tDatabase.handle, tTransaction, tDbt, bl2));
    }

    public long sequenceGet(TSequence tSequence, TTransaction tTransaction, int n) throws TException {
        return this.transactionalOp(tSequence.handle, tTransaction, (object, transaction) -> ((Sequence)object).get(transaction, n), () -> this.buildLogMsg("sequenceGet", tSequence.handle, tTransaction, n));
    }

    public TEnvStatResult getEnvStatistics(TEnvironment tEnvironment, TEnvStatConfig tEnvStatConfig) throws TException {
        return this.handleOp(tEnvironment.handle, object -> {
            Environment environment = (Environment)object;
            TEnvStatOption tEnvStatOption = TEnvStatOption.EXCLUDE;
            TEnvStatResult tEnvStatResult = new TEnvStatResult();
            if (tEnvStatConfig.isSetCache() && tEnvStatConfig.cache != tEnvStatOption) {
                tEnvStatResult.setCacheStat(Adapters.toThriftType(this.getStat(tEnvStatConfig.cache, arg_0 -> ((Environment)environment).getCacheStats(arg_0))));
            }
            if (tEnvStatConfig.isSetCacheFile() && tEnvStatConfig.cacheFile != tEnvStatOption) {
                CacheFileStats[] cacheFileStatsArray = this.getStat(tEnvStatConfig.cacheFile, arg_0 -> ((Environment)environment).getCacheFileStats(arg_0));
                if (cacheFileStatsArray == null) {
                    cacheFileStatsArray = new CacheFileStats[]{};
                }
                tEnvStatResult.setCacheFileStat(Arrays.stream(cacheFileStatsArray).map(Adapters::toThriftType).collect(Collectors.toList()));
            }
            if (tEnvStatConfig.isSetLock() && tEnvStatConfig.lock != tEnvStatOption) {
                tEnvStatResult.setLockStat(Adapters.toThriftType(this.getStat(tEnvStatConfig.lock, arg_0 -> ((Environment)environment).getLockStats(arg_0))));
            }
            if (tEnvStatConfig.isSetLog() && tEnvStatConfig.log != tEnvStatOption) {
                tEnvStatResult.setLogStat(Adapters.toThriftType(this.getStat(tEnvStatConfig.log, arg_0 -> ((Environment)environment).getLogStats(arg_0))));
            }
            if (tEnvStatConfig.isSetMutex() && tEnvStatConfig.mutex != tEnvStatOption) {
                tEnvStatResult.setMutexStat(Adapters.toThriftType(this.getStat(tEnvStatConfig.mutex, arg_0 -> ((Environment)environment).getMutexStats(arg_0))));
            }
            if (tEnvStatConfig.isSetTransaction() && tEnvStatConfig.transaction != tEnvStatOption) {
                tEnvStatResult.setTxnStat(Adapters.toThriftType(this.getStat(tEnvStatConfig.transaction, arg_0 -> ((Environment)environment).getTransactionStats(arg_0))));
            }
            return tEnvStatResult;
        }, () -> this.buildLogMsg("getEnvStatistics", tEnvironment.handle, tEnvStatConfig));
    }

    private <R> R getStat(TEnvStatOption tEnvStatOption, FunctionEx<StatsConfig, R> functionEx) throws Exception {
        StatsConfig statsConfig = new StatsConfig();
        statsConfig.setClear(true);
        return functionEx.applyWithException((StatsConfig)(tEnvStatOption == TEnvStatOption.CLEAR ? statsConfig : null));
    }

    public TDatabaseStatResult getDatabaseStatistics(TDatabase tDatabase, TTransaction tTransaction, boolean bl) throws TException {
        return this.transactionalOp(tDatabase.handle, tTransaction, (object, transaction) -> {
            Database database = (Database)object;
            StatsConfig statsConfig = new StatsConfig();
            statsConfig.setFast(bl);
            return Adapters.toThriftType(database.getStats(transaction, statsConfig));
        }, () -> this.buildLogMsg("getDatabaseStatistics", tDatabase.handle, tTransaction, bl));
    }

    private <R> R handleOp(long l, FunctionEx<Object, R> functionEx, Supplier<String> supplier) throws TException {
        HandleDescriptor handleDescriptor = null;
        try {
            handleDescriptor = this.handleManager.readLockHandle(l);
            R r = functionEx.applyWithException(handleDescriptor.getHandle());
            return r;
        }
        catch (Exception exception) {
            throw this.error(supplier.get(), exception);
        }
        finally {
            this.handleManager.unlockHandle(handleDescriptor);
        }
    }

    private <R> R transactionalDescOp(long l, TTransaction tTransaction, BiFunctionEx<HandleDescriptor, TransactionDescriptor, R> biFunctionEx, Supplier<String> supplier) throws TException {
        R r;
        HandleDescriptor handleDescriptor = null;
        TransactionDescriptor transactionDescriptor = null;
        try {
            handleDescriptor = this.handleManager.readLockHandle(l);
            if (tTransaction != null) {
                transactionDescriptor = (TransactionDescriptor)this.handleManager.readLockHandle(tTransaction.handle);
            }
            r = biFunctionEx.applyWithException(handleDescriptor, transactionDescriptor);
            this.handleManager.unlockHandle(transactionDescriptor);
            this.handleManager.unlockHandle(handleDescriptor);
        }
        catch (Exception exception) {
            try {
                throw this.error(supplier.get(), exception);
            }
            catch (Throwable throwable) {
                this.handleManager.unlockHandle(transactionDescriptor);
                this.handleManager.unlockHandle(handleDescriptor);
                throw throwable;
            }
        }
        return r;
    }

    private <R> R transactionalOp(long l, TTransaction tTransaction, BiFunctionEx<Object, Transaction, R> biFunctionEx, Supplier<String> supplier) throws TException {
        return (R)this.transactionalDescOp(l, tTransaction, (handleDescriptor, transactionDescriptor) -> biFunctionEx.applyWithException(handleDescriptor.getHandle(), transactionDescriptor == null ? null : (Transaction)transactionDescriptor.getHandle()), supplier);
    }

    private ResourceMembers readLock(ResourceKey resourceKey, String string) throws TResourceInUseException {
        ResourceMembers resourceMembers = this.handleManager.readLockResource(resourceKey);
        if (resourceMembers == null) {
            throw new TResourceInUseException(string);
        }
        return resourceMembers;
    }

    private void closeHandle(long l, Supplier<String> supplier) throws TException {
        try {
            this.handleManager.closeHandle(l);
        }
        catch (Exception exception) {
            throw this.error(supplier.get(), exception);
        }
    }

    private void closeAllResourceHandles(long l, SupplierEx<ResourceKey> supplierEx, Supplier<String> supplier) throws TException {
        try {
            ResourceKey resourceKey = supplierEx.getWithException();
            long l2 = System.currentTimeMillis();
            List<HandleDescriptor> list = this.handleManager.getResourceMembers(resourceKey).getMembers().stream().filter(handleDescriptor -> handleDescriptor.isExpired(l2, l)).collect(Collectors.toList());
            DatabaseException databaseException = this.handleManager.closeHandles(list);
            if (databaseException != null) {
                throw databaseException;
            }
        }
        catch (Exception exception) {
            throw this.error(supplier.get(), exception);
        }
    }

    private String buildLogMsg(String string, Object ... objectArray) {
        return Arrays.stream(objectArray).map(Objects::toString).collect(Collectors.joining(", ", string + "(", ")"));
    }

    private TException error(String string, Exception exception) {
        logger.error(string, (Throwable)exception);
        return Adapters.toThriftType(exception);
    }

    @FunctionalInterface
    private static interface CursorPutFunction {
        public OperationStatus put(DatabaseEntry var1, DatabaseEntry var2) throws DatabaseException;
    }

    @FunctionalInterface
    private static interface DbPutFunction {
        public OperationStatus put(Transaction var1, DatabaseEntry var2, DatabaseEntry var3) throws DatabaseException;
    }

    @FunctionalInterface
    private static interface CursorPGetFunction {
        public OperationStatus get(DatabaseEntry var1, DatabaseEntry var2, DatabaseEntry var3, LockMode var4) throws DatabaseException;
    }

    @FunctionalInterface
    private static interface CursorGetFunction {
        public OperationStatus get(DatabaseEntry var1, DatabaseEntry var2, LockMode var3) throws DatabaseException;
    }

    @FunctionalInterface
    private static interface DbPGetFunction {
        public OperationStatus get(Transaction var1, DatabaseEntry var2, DatabaseEntry var3, DatabaseEntry var4, LockMode var5) throws DatabaseException;
    }

    @FunctionalInterface
    private static interface DbGetFunction {
        public OperationStatus get(Transaction var1, DatabaseEntry var2, DatabaseEntry var3, LockMode var4) throws DatabaseException;
    }

    @FunctionalInterface
    private static interface DatabaseDescriptorCreator<T extends DatabaseConfig> {
        public DatabaseDescriptor open(EnvironmentDescriptor var1, Transaction var2, DatabaseKey var3, T var4) throws Exception;
    }

    @FunctionalInterface
    private static interface DatabaseResourceOperation {
        public void run(Environment var1, Transaction var2, String var3, String var4) throws Exception;
    }
}

