/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.handle;

import com.sleepycat.server.handle.HandleDescriptor;
import com.sleepycat.server.handle.ResourceKey;
import com.sleepycat.server.handle.ResourceMembers;
import java.util.concurrent.ConcurrentHashMap;

class ResourceMemberManager {
    private ConcurrentHashMap<ResourceKey, ResourceMembers> resourceMap = new ConcurrentHashMap();

    ResourceMemberManager() {
    }

    public void register(HandleDescriptor handleDescriptor) {
        for (ResourceKey resourceKey : handleDescriptor.resourceOwners()) {
            this.getResourceMembers(resourceKey).add(handleDescriptor);
        }
    }

    public void remove(HandleDescriptor handleDescriptor) {
        for (ResourceKey resourceKey : handleDescriptor.resourceOwners()) {
            this.getResourceMembers(resourceKey).remove(handleDescriptor);
        }
    }

    public ResourceMembers getResourceMembers(ResourceKey resourceKey) {
        if (!this.resourceMap.containsKey(resourceKey)) {
            this.resourceMap.putIfAbsent(resourceKey, new ResourceMembers());
        }
        return this.resourceMap.get(resourceKey);
    }

    public ResourceMembers readLockResource(ResourceKey resourceKey) {
        ResourceMembers resourceMembers = this.getResourceMembers(resourceKey);
        if (resourceMembers.tryReadLock()) {
            return resourceMembers;
        }
        return null;
    }

    public void unlockRead(ResourceMembers resourceMembers) {
        if (resourceMembers != null) {
            resourceMembers.unlockRead();
        }
    }

    public ResourceMembers writeLockResource(ResourceKey resourceKey) {
        ResourceMembers resourceMembers = this.getResourceMembers(resourceKey);
        resourceMembers.writeLock();
        return resourceMembers;
    }

    public void unlockWrite(ResourceMembers resourceMembers) {
        if (resourceMembers != null) {
            resourceMembers.unlockWrite();
        }
    }
}

