/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.config;

import com.sleepycat.server.config.EnvDirType;
import com.sleepycat.server.config.PropertyHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;

public class BdbServiceConfig {
    public static final String ROOT_LOG = "root.log";
    public static final String ROOT_BLOB = "root.blob";
    public static final String ROOT_DATA = "root.data";
    public static final String ROOT_HOME = "root.home";
    public static final String HANDLE_TIMEOUT = "handle.timeout";
    public static final String CLEANUP_INTERVAL = "cleanup.interval";
    private PropertyHelper properties;
    private Map<EnvDirType, File> rootDirs = new EnumMap<EnvDirType, File>(EnvDirType.class);

    public BdbServiceConfig(Properties properties) {
        this.properties = new PropertyHelper(properties);
    }

    public void initRootDirs() throws IOException {
        this.initDir(ROOT_HOME, ".", EnvDirType.HOME);
        this.initDir(ROOT_DATA, null, EnvDirType.DATA);
        this.initDir(ROOT_BLOB, null, EnvDirType.BLOB);
        this.initDir(ROOT_LOG, null, EnvDirType.LOG);
    }

    private void initDir(String string, String string2, EnvDirType envDirType) throws IOException {
        String string3 = this.properties.getString(string, string2);
        if (string3 != null) {
            File file = new File(string3);
            Files.createDirectories(file.toPath(), new FileAttribute[0]);
            this.rootDirs.put(envDirType, file);
        }
    }

    public Map<EnvDirType, File> getRootDirs() {
        return this.rootDirs;
    }

    public int getHandleTimeoutInSeconds() {
        return this.properties.getInt(HANDLE_TIMEOUT, "600", 0, Integer.MAX_VALUE);
    }

    public int getCleanupIntervalInSeconds() {
        return this.properties.getInt(CLEANUP_INTERVAL, "300", 1, Integer.MAX_VALUE);
    }
}

