/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.impl;

import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.impl.Catalog;
import com.sleepycat.client.persist.impl.Format;
import com.sleepycat.client.persist.impl.NonPersistentFormat;
import com.sleepycat.client.persist.model.ClassMetadata;
import com.sleepycat.client.persist.model.EntityModel;
import com.sleepycat.client.persist.model.FieldMetadata;
import com.sleepycat.client.persist.raw.RawField;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class FieldInfo
implements RawField,
Serializable,
Comparable<FieldInfo> {
    private static final long serialVersionUID = 2062721100372306296L;
    private String name;
    private String className;
    private Format format;
    private transient Class cls;
    private transient Field field;

    /*
     * WARNING - void declaration
     */
    static List<FieldInfo> getInstanceFields(Class clazz, ClassMetadata classMetadata) {
        Field field;
        Object string;
        Field[] fieldArray;
        ArrayList<FieldInfo> arrayList = null;
        if (classMetadata != null && (fieldArray = classMetadata.getPersistentFields()) != null) {
            arrayList = new ArrayList<FieldInfo>(fieldArray.size());
            string = clazz.getName();
            for (FieldMetadata fieldMetadata : fieldArray) {
                if (!((String)string).equals(fieldMetadata.getDeclaringClassName())) {
                    throw new IllegalArgumentException("Persistent field " + fieldMetadata + " must be declared in " + (String)string);
                }
                try {
                    field = clazz.getDeclaredField(fieldMetadata.getName());
                }
                catch (NoSuchFieldException n) {
                    throw new IllegalArgumentException("Persistent field " + fieldMetadata + " is not declared in this class");
                }
                if (!field.getType().getName().equals(fieldMetadata.getClassName())) {
                    throw new IllegalArgumentException("Persistent field " + fieldMetadata + " must be of type " + field.getType().getName());
                }
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new IllegalArgumentException("Persistent field " + fieldMetadata + " may not be static");
                }
                arrayList.add(new FieldInfo(field));
            }
        }
        if (arrayList == null) {
            void var6_9;
            fieldArray = clazz.getDeclaredFields();
            arrayList = new ArrayList(fieldArray.length);
            string = fieldArray;
            int n = ((Field[])string).length;
            boolean bl = false;
            while (var6_9 < n) {
                field = string[var6_9];
                int n2 = field.getModifiers();
                if (!Modifier.isTransient(n2) && !Modifier.isStatic(n2)) {
                    arrayList.add(new FieldInfo(field));
                }
                ++var6_9;
            }
        }
        return arrayList;
    }

    static FieldInfo getField(List<FieldInfo> list, String string) {
        int n = FieldInfo.getFieldIndex(list, string);
        if (n >= 0) {
            return list.get(n);
        }
        return null;
    }

    static int getFieldIndex(List<FieldInfo> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            FieldInfo fieldInfo = list.get(i);
            if (!string.equals(fieldInfo.getName())) continue;
            return i;
        }
        return -1;
    }

    private FieldInfo(Field field) {
        this.name = field.getName();
        this.cls = field.getType();
        this.className = this.cls.getName();
        this.field = field;
    }

    void collectRelatedFormats(Catalog catalog, Map<String, Format> map) {
        this.format = catalog.createFormat(this.cls, map);
        Class<?> clazz = this.field.getType();
        if (this.format instanceof NonPersistentFormat && (Map.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz)) && this.field != null && this.field.getGenericType() instanceof ParameterizedType) {
            this.collectParameterizedTypeFormats(catalog, map, (ParameterizedType)this.field.getGenericType());
        }
    }

    private void collectParameterizedTypeFormats(Catalog catalog, Map<String, Format> map, ParameterizedType parameterizedType) {
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < typeArray.length; ++i) {
            if (typeArray[i] instanceof ParameterizedType) {
                this.collectParameterizedTypeFormats(catalog, map, (ParameterizedType)typeArray[i]);
                continue;
            }
            if (!(typeArray[i] instanceof Class)) continue;
            catalog.createFormat((Class)typeArray[i], map);
        }
    }

    void migrateFromBeta(Map<String, Format> map) {
        if (this.format == null) {
            this.format = map.get(this.className);
            if (this.format == null) {
                throw DbCompat.unexpectedState(this.className);
            }
        }
    }

    void initialize(Catalog catalog, EntityModel entityModel, int n) {
        if (this.format != null && this.format.isNew()) {
            this.format = catalog.getFormat(this.className);
        }
    }

    Class getFieldClass(Catalog catalog) {
        if (this.cls == null) {
            try {
                this.cls = catalog.resolveClass(this.className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw DbCompat.unexpectedException(classNotFoundException);
            }
        }
        return this.cls;
    }

    String getClassName() {
        return this.className;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Format getType() {
        return this.format;
    }

    @Override
    public int compareTo(FieldInfo fieldInfo) {
        return this.name.compareTo(fieldInfo.name);
    }

    public boolean equals(Object object) {
        if (object instanceof FieldInfo) {
            FieldInfo fieldInfo = (FieldInfo)object;
            return this.name.equals(fieldInfo.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "[Field name: " + this.name + " class: " + this.className + ']';
    }
}

