/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.impl;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SSequence;
import com.sleepycat.client.bind.tuple.TupleBase;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.impl.Catalog;
import com.sleepycat.client.persist.impl.Format;
import com.sleepycat.client.persist.impl.PersistCatalog;
import com.sleepycat.client.persist.impl.PersistEntityBinding;
import com.sleepycat.client.persist.impl.PersistKeyBinding;
import com.sleepycat.client.persist.impl.RecordInput;
import com.sleepycat.client.persist.impl.RecordOutput;
import com.sleepycat.client.persist.impl.RefreshException;

public class PersistKeyAssigner {
    private volatile Catalog catalog;
    private volatile Format keyFieldFormat;
    private volatile Format entityFormat;
    private final boolean rawAccess;
    private final SSequence sequence;

    PersistKeyAssigner(PersistKeyBinding persistKeyBinding, PersistEntityBinding persistEntityBinding, SSequence sSequence) {
        this.catalog = persistKeyBinding.catalog;
        this.keyFieldFormat = persistKeyBinding.keyFormat.getSequenceKeyFormat();
        this.entityFormat = persistEntityBinding.entityFormat;
        this.rawAccess = persistEntityBinding.rawAccess;
        this.sequence = sSequence;
    }

    public boolean assignPrimaryKey(Object object, SDatabaseEntry sDatabaseEntry) throws SDatabaseException {
        try {
            return this.assignPrimaryKeyInternal(object, sDatabaseEntry);
        }
        catch (RefreshException refreshException) {
            refreshException.refresh();
            try {
                return this.assignPrimaryKeyInternal(object, sDatabaseEntry);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
    }

    private boolean assignPrimaryKeyInternal(Object object, SDatabaseEntry sDatabaseEntry) throws SDatabaseException, RefreshException {
        if (this.entityFormat.isPriKeyNullOrZero(object, this.rawAccess)) {
            Long l = this.sequence.get(null, 1);
            RecordOutput recordOutput = new RecordOutput(this.catalog, this.rawAccess);
            this.keyFieldFormat.writeObject(l, recordOutput, this.rawAccess);
            TupleBase.outputToEntry(recordOutput, sDatabaseEntry);
            RecordInput recordInput = new RecordInput(this.catalog, this.rawAccess, null, 0, sDatabaseEntry.getData(), sDatabaseEntry.getOffset(), sDatabaseEntry.getSize());
            this.entityFormat.getReader().readPriKey(object, recordInput, this.rawAccess);
            return true;
        }
        return false;
    }

    void refresh(PersistCatalog persistCatalog) {
        this.catalog = persistCatalog;
        this.entityFormat = this.catalog.getFormat(this.entityFormat.getClassName());
        this.keyFieldFormat = this.catalog.getFormat(this.keyFieldFormat.getClassName());
    }
}

