/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.impl;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.EntryBinding;
import com.sleepycat.client.bind.tuple.TupleBase;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.impl.Catalog;
import com.sleepycat.client.persist.impl.CompositeKeyFormat;
import com.sleepycat.client.persist.impl.Format;
import com.sleepycat.client.persist.impl.PersistCatalog;
import com.sleepycat.client.persist.impl.PersistEntityBinding;
import com.sleepycat.client.persist.impl.RecordInput;
import com.sleepycat.client.persist.impl.RecordOutput;
import com.sleepycat.client.persist.impl.RefreshException;

public class PersistKeyBinding
implements EntryBinding {
    volatile Catalog catalog;
    volatile Format keyFormat;
    final boolean rawAccess;

    public PersistKeyBinding(Catalog catalog, String string, boolean bl) {
        this.catalog = catalog;
        try {
            this.keyFormat = PersistEntityBinding.getOrCreateFormat(this.catalog, string, bl);
        }
        catch (RefreshException refreshException) {
            this.catalog = refreshException.refresh();
            try {
                this.keyFormat = PersistEntityBinding.getOrCreateFormat(this.catalog, string, bl);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
        if (!(this.keyFormat.isSimple() || this.keyFormat.isEnum() || this.keyFormat.getClassMetadata() != null && this.keyFormat.getClassMetadata().getCompositeKeyFields() != null)) {
            throw new IllegalArgumentException("Key class is not a simple type, an enum, or a composite key class (composite keys must include @KeyField annotations): " + string);
        }
        this.rawAccess = bl;
    }

    PersistKeyBinding(Catalog catalog, Class clazz, String[] stringArray) {
        this.catalog = catalog;
        this.keyFormat = new CompositeKeyFormat(catalog, clazz, stringArray);
        this.keyFormat.initializeIfNeeded(catalog, null);
        this.rawAccess = false;
    }

    Object bytesToObject(byte[] byArray, int n, int n2) throws RefreshException {
        return PersistKeyBinding.readKey(this.keyFormat, this.catalog, byArray, n, n2, this.rawAccess);
    }

    static Object readKey(Format format, Catalog catalog, byte[] byArray, int n, int n2, boolean bl) throws RefreshException {
        RecordInput recordInput = new RecordInput(catalog, bl, null, 0, byArray, n, n2);
        return recordInput.readKeyObject(format);
    }

    public Object entryToObject(SDatabaseEntry sDatabaseEntry) {
        try {
            return this.entryToObjectInternal(sDatabaseEntry);
        }
        catch (RefreshException refreshException) {
            refreshException.refresh();
            try {
                return this.entryToObjectInternal(sDatabaseEntry);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
    }

    private Object entryToObjectInternal(SDatabaseEntry sDatabaseEntry) throws RefreshException {
        return this.bytesToObject(sDatabaseEntry.getData(), sDatabaseEntry.getOffset(), sDatabaseEntry.getSize());
    }

    public void objectToEntry(Object object, SDatabaseEntry sDatabaseEntry) {
        try {
            this.objectToEntryInternal(object, sDatabaseEntry);
        }
        catch (RefreshException refreshException) {
            refreshException.refresh();
            try {
                this.objectToEntryInternal(object, sDatabaseEntry);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
    }

    private void objectToEntryInternal(Object object, SDatabaseEntry sDatabaseEntry) throws RefreshException {
        RecordOutput recordOutput = new RecordOutput(this.catalog, this.rawAccess);
        recordOutput.writeKeyObject(object, this.keyFormat);
        TupleBase.outputToEntry(recordOutput, sDatabaseEntry);
    }

    void refresh(PersistCatalog persistCatalog) {
        this.catalog = persistCatalog;
        this.keyFormat = this.catalog.getFormat(this.keyFormat.getClassName());
    }
}

