#! /bin/sh
test ! -t 0 && exit
cd `dirname $0`
RUN_DIR=`pwd`

. /etc/init.d/tc-functions
LIST=`busybox --list`
for i in $LIST; do
	alias $i="busybox $i"
done

VERSION="2.9.1"
FILE="seamonkey-${VERSION}.tar.bz2"
URL="ftp://ftp.jaist.ac.jp/pub/mozilla.org/seamonkey/releases/2.9.1/linux-i686/ja/${FILE}"
SEATCZ="seamonkey.tcz"
NEWTCZ="seamonkey-ja.tcz"
LOAD="squashfs-tools-4.x"

myinstall(){
	echo "[Install] $1"
	if [ ! -f "/usr/local/tce.installed/$1" ]; then
		if [ ! -f "/etc/sysconfig/tcedir/optional/$1.tcz" ]; then
			tce-load -w "$1"
		fi
		tce-load -i "$1"
	fi
}

case "$1" in
	clean) rm -f "${FILE}" "${NEWTCZ}" "${NEWTCZ}.md5.txt"; exit;;
esac

for i in ${LOAD}; do
	myinstall "$i"
done

[ -f "${FILE}" ] || wget -c -O "${FILE}" "${URL}"
if [ ! -f "${FILE}" ]; then
	echo "[Error] ${FILE} not found."
	exit 1
fi

[ -d "squashfs-root" ] && sudo rm -rf "squashfs-root"
sudo mkdir -p "squashfs-root/usr/local/share/applications"
sudo mkdir -p "squashfs-root/usr/local/share/pixmaps"
sudo install -o root -g staff -m 644 "seamonkey-ja.desktop" "squashfs-root/usr/local/share/applications"
sudo install -o root -g staff -m 644 "seamonkey.png" "squashfs-root/usr/local/share/pixmaps"
sudo tar -C "squashfs-root/usr/local" -xvf "${FILE}"
[ -f "${NEWTCZ}" ] && sudo rm -f "${NEWTCZ}"
mksquashfs "squashfs-root" "${NEWTCZ}" -b 4096; \
md5sum "${NEWTCZ}" > "${NEWTCZ}".md5.txt
while read i; do
	myinstall $(getbasefile "$i" 1)
done < "${NEWTCZ}.dep"
cp -f "${NEWTCZ}" "${NEWTCZ}.dep" "${NEWTCZ}.md5.txt" "/etc/sysconfig/tcedir/optional"
[ -d "squashfs-root" ] && sudo rm -rf "squashfs-root"
echo "Done!"