/* auditive.c generated by valac 0.16.1, the Vala compiler
 * generated from auditive.vala, do not modify */

/*

This file is part of Auditive.

Copyright 2010-2012 Graeme Sheppard.

Auditive is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Auditive is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Auditive. If not, see <http://www.gnu.org/licenses/>.

*/

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <curses.h>
#include <gobject/gvaluecollector.h>


#define TYPE_AUDITIVE (auditive_get_type ())
#define AUDITIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUDITIVE, auditive))
#define AUDITIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUDITIVE, auditiveClass))
#define IS_AUDITIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUDITIVE))
#define IS_AUDITIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUDITIVE))
#define AUDITIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUDITIVE, auditiveClass))

typedef struct _auditive auditive;
typedef struct _auditiveClass auditiveClass;
typedef struct _auditivePrivate auditivePrivate;

#define TYPE_WORLD_WIDE (world_wide_get_type ())
#define WORLD_WIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORLD_WIDE, world_wide))
#define WORLD_WIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORLD_WIDE, world_wideClass))
#define IS_WORLD_WIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORLD_WIDE))
#define IS_WORLD_WIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORLD_WIDE))
#define WORLD_WIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORLD_WIDE, world_wideClass))

typedef struct _world_wide world_wide;
typedef struct _world_wideClass world_wideClass;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _world_widePrivate world_widePrivate;

#define TYPE_CONSOLE (console_get_type ())
#define CONSOLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONSOLE, console))
#define CONSOLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONSOLE, consoleClass))
#define IS_CONSOLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONSOLE))
#define IS_CONSOLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONSOLE))
#define CONSOLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONSOLE, consoleClass))

typedef struct _console console;
typedef struct _consoleClass consoleClass;

#define TYPE_KEY_MAPS (key_maps_get_type ())
#define KEY_MAPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_MAPS, key_maps))
#define KEY_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_MAPS, key_mapsClass))
#define IS_KEY_MAPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_MAPS))
#define IS_KEY_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_MAPS))
#define KEY_MAPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_MAPS, key_mapsClass))

typedef struct _key_maps key_maps;
typedef struct _key_mapsClass key_mapsClass;

#define TYPE_SCREEN (screen_get_type ())
#define SCREEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCREEN, screen))
#define SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCREEN, screenClass))
#define IS_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCREEN))
#define IS_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCREEN))
#define SCREEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCREEN, screenClass))

typedef struct _screen screen;
typedef struct _screenClass screenClass;

#define TYPE_PLAYLIST (playlist_get_type ())
#define PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYLIST, playlist))
#define PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYLIST, playlistClass))
#define IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYLIST))
#define IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYLIST))
#define PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYLIST, playlistClass))

typedef struct _playlist playlist;
typedef struct _playlistClass playlistClass;

#define TYPE_VIEWLIST (viewlist_get_type ())
#define VIEWLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEWLIST, viewlist))
#define VIEWLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEWLIST, viewlistClass))
#define IS_VIEWLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEWLIST))
#define IS_VIEWLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEWLIST))
#define VIEWLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEWLIST, viewlistClass))

typedef struct _viewlist viewlist;
typedef struct _viewlistClass viewlistClass;

#define TYPE_EXTERNAL (external_get_type ())
#define EXTERNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTERNAL, external))
#define EXTERNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXTERNAL, externalClass))
#define IS_EXTERNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTERNAL))
#define IS_EXTERNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXTERNAL))
#define EXTERNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXTERNAL, externalClass))

typedef struct _external external;
typedef struct _externalClass externalClass;

#define TYPE_DBG (dbg_get_type ())
#define DBG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DBG, dbg))
#define DBG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DBG, dbgClass))
#define IS_DBG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DBG))
#define IS_DBG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DBG))
#define DBG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DBG, dbgClass))

typedef struct _dbg dbg;
typedef struct _dbgClass dbgClass;

#define TYPE_HELP (help_get_type ())
#define HELP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HELP, help))
#define HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HELP, helpClass))
#define IS_HELP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HELP))
#define IS_HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HELP))
#define HELP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HELP, helpClass))

typedef struct _help help;
typedef struct _helpClass helpClass;

#define TYPE_FILES (files_get_type ())
#define FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILES, files))
#define FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILES, filesClass))
#define IS_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILES))
#define IS_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILES))
#define FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILES, filesClass))

typedef struct _files files;
typedef struct _filesClass filesClass;

#define TYPE_METHOD (method_get_type ())
#define METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METHOD, method))
#define METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METHOD, methodClass))
#define IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METHOD))
#define IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METHOD))
#define METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METHOD, methodClass))

typedef struct _method method;
typedef struct _methodClass methodClass;

#define WORLD_WIDE_TYPE_SCREEN_TYPE (world_wide_screen_type_get_type ())

#define WORLD_WIDE_TYPE_PLAYING_TYPE (world_wide_playing_type_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _gst_tag_list_free0(var) ((var == NULL) ? NULL : (var = (gst_tag_list_free (var), NULL)))

#define TYPE_FILE_TYPE (file_type_get_type ())
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
typedef struct _ParamSpecauditive ParamSpecauditive;
#define _auditive_unref0(var) ((var == NULL) ? NULL : (var = (auditive_unref (var), NULL)))

typedef void (*foreach_delegate) (GstTagList* list, const gchar* tag, void* user_data);
struct _auditive {
	GTypeInstance parent_instance;
	volatile int ref_count;
	auditivePrivate * priv;
	world_wide* world;
};

struct _auditiveClass {
	GTypeClass parent_class;
	void (*finalize) (auditive *self);
};

struct _auditivePrivate {
	GMainLoop* loop;
	GstElement* play;
	GstBus* bus;
	gint64 resume_position;
	gint64 gapless_duration;
	gchar* song_label;
	gchar* song_gapless_label;
	gchar* song_title;
	gchar* song_artist;
	gchar* song_album;
	gchar* song_short_file_name;
	gint screen_size;
	gint auto_start_number;
	gchar* auto_start_name;
};

typedef enum  {
	WORLD_WIDE_SCREEN_TYPE_none,
	WORLD_WIDE_SCREEN_TYPE_file_list,
	WORLD_WIDE_SCREEN_TYPE_view_list,
	WORLD_WIDE_SCREEN_TYPE_play_list,
	WORLD_WIDE_SCREEN_TYPE_ext_list,
	WORLD_WIDE_SCREEN_TYPE_debug,
	WORLD_WIDE_SCREEN_TYPE_help
} world_widescreen_type;

typedef enum  {
	WORLD_WIDE_PLAYING_TYPE_stop,
	WORLD_WIDE_PLAYING_TYPE_play,
	WORLD_WIDE_PLAYING_TYPE_pause
} world_wideplaying_type;

struct _world_wide {
	GTypeInstance parent_instance;
	volatile int ref_count;
	world_widePrivate * priv;
	console* con;
	key_maps* keys;
	auditive* player;
	playlist* play_screen;
	viewlist* view_screen;
	external* ext_screen;
	dbg* debug;
	help* help_screen;
	GList* files_array;
	GList* keys_array;
	world_widescreen_type screen_current;
	world_wideplaying_type playing_state;
	gint screen_files;
	gboolean play_advance;
	screen* playing_screen;
	gint playlist_position;
};

struct _world_wideClass {
	GTypeClass parent_class;
	void (*finalize) (world_wide *self);
};

typedef enum  {
	FILE_TYPE_dir,
	FILE_TYPE_file,
	FILE_TYPE_m3u,
	FILE_TYPE_not_exist
} file_type;

struct _ParamSpecauditive {
	GParamSpec parent_instance;
};


static gpointer auditive_parent_class = NULL;

void taglist_foreach_job (GstTagList* list, foreach_delegate func, void* func_target, void* user_data);
gboolean check_tag_exists (void* list, gchar* tag);
#define nsec ((gint64) 1000000000)
gchar* time_text (gint64 num);
gpointer auditive_ref (gpointer instance);
void auditive_unref (gpointer instance);
GParamSpec* param_spec_auditive (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_auditive (GValue* value, gpointer v_object);
void value_take_auditive (GValue* value, gpointer v_object);
gpointer value_get_auditive (const GValue* value);
GType auditive_get_type (void) G_GNUC_CONST;
gpointer world_wide_ref (gpointer instance);
void world_wide_unref (gpointer instance);
GParamSpec* param_spec_world_wide (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_world_wide (GValue* value, gpointer v_object);
void value_take_world_wide (GValue* value, gpointer v_object);
gpointer value_get_world_wide (const GValue* value);
GType world_wide_get_type (void) G_GNUC_CONST;
#define AUDITIVE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AUDITIVE, auditivePrivate))
enum  {
	AUDITIVE_DUMMY_PROPERTY
};
auditive* auditive_new (void);
auditive* auditive_construct (GType object_type);
world_wide* world_wide_new (void);
world_wide* world_wide_construct (GType object_type);
gpointer console_ref (gpointer instance);
void console_unref (gpointer instance);
GParamSpec* param_spec_console (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_console (GValue* value, gpointer v_object);
void value_take_console (GValue* value, gpointer v_object);
gpointer value_get_console (const GValue* value);
GType console_get_type (void) G_GNUC_CONST;
gpointer key_maps_ref (gpointer instance);
void key_maps_unref (gpointer instance);
GParamSpec* param_spec_key_maps (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_key_maps (GValue* value, gpointer v_object);
void value_take_key_maps (GValue* value, gpointer v_object);
gpointer value_get_key_maps (const GValue* value);
GType key_maps_get_type (void) G_GNUC_CONST;
gpointer screen_ref (gpointer instance);
void screen_unref (gpointer instance);
GParamSpec* param_spec_screen (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_screen (GValue* value, gpointer v_object);
void value_take_screen (GValue* value, gpointer v_object);
gpointer value_get_screen (const GValue* value);
GType screen_get_type (void) G_GNUC_CONST;
GType playlist_get_type (void) G_GNUC_CONST;
GType viewlist_get_type (void) G_GNUC_CONST;
GType external_get_type (void) G_GNUC_CONST;
GType dbg_get_type (void) G_GNUC_CONST;
GType help_get_type (void) G_GNUC_CONST;
GType files_get_type (void) G_GNUC_CONST;
gpointer method_ref (gpointer instance);
void method_unref (gpointer instance);
GParamSpec* param_spec_method (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_method (GValue* value, gpointer v_object);
void value_take_method (GValue* value, gpointer v_object);
gpointer value_get_method (const GValue* value);
GType method_get_type (void) G_GNUC_CONST;
GType world_wide_screen_type_get_type (void) G_GNUC_CONST;
GType world_wide_playing_type_get_type (void) G_GNUC_CONST;
key_maps* key_maps_new (void);
key_maps* key_maps_construct (GType object_type);
console* console_new (world_wide* w);
console* console_construct (GType object_type, world_wide* w);
dbg* dbg_new (world_wide* w);
dbg* dbg_construct (GType object_type, world_wide* w);
external* external_new (world_wide* w);
external* external_construct (GType object_type, world_wide* w);
help* help_new (world_wide* w);
help* help_construct (GType object_type, world_wide* w);
void config_setup (world_wide* world);
void auditive_set_playing (auditive* self, const gchar* source);
void auditive_stop (auditive* self);
gchar* get_file_from_path (const gchar* full_path);
void dbg_add (dbg* self, const gchar* text);
gchar* get_base_from_path (const gchar* full_path);
static inline void _dynamic_set_uri0 (GstElement* obj, gchar* value);
static gboolean auditive_bus_callback (auditive* self, GstBus* bus, GstMessage* message);
static gboolean _auditive_bus_callback_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
void auditive_playing (auditive* self);
void auditive_finish_callback (auditive* self, world_wide* world);
void auditive_continue_playing (auditive* self, const gchar* source);
gint64 auditive_get_duration (auditive* self);
static inline void _dynamic_set_uri1 (GstElement* obj, gchar* value);
void screen_reset_stop (screen* self);
void auditive_previous_song (auditive* self);
void screen_previous_song (screen* self);
void auditive_draw (auditive* self);
void auditive_advance_song (auditive* self);
void screen_advance_song (screen* self);
gint64 auditive_get_position (auditive* self);
void auditive_set_position (auditive* self, gint64 position);
void auditive_pause (auditive* self);
void auditive_adjust_position (auditive* self, gint signed_seconds);
void auditive_adjust_position_fraction (auditive* self, gint signed_decivar);
screen* auditive_index_screen (auditive* self, world_widescreen_type screen_type);
void dbg_alert (dbg* self, const gchar* text);
static gboolean auditive_key_callback (auditive* self, GIOChannel* src, GIOCondition cond);
gint console_get_key (console* self);
#define KEY_MAPS_key_f1 265
#define KEY_MAPS_key_k1 ((gint) '1')
#define KEY_MAPS_key_backspace ((gint) KEY_BACKSPACE)
void screen_draw (screen* self);
void screen_key_press (screen* self, gint key_num);
void auditive_draw_counter (auditive* self);
gboolean screen_has_title (screen* self);
void console_print_status (console* self, const gchar* text);
static gboolean auditive_tick_callback (auditive* self);
void files_play_a_song (files* self, const gchar* name);
void playlist_play_a_song (playlist* self, gint num);
gint console_calculate_screen_size (console* self);
void console_cls (console* self);
void auditive_tag_reciever (auditive* self, GstTagList* list, const gchar* tag);
void screen_continue_songs_draw (screen* self);
void console_refresh (console* self);
static void _auditive_tag_reciever_foreach_delegate (GstTagList* list, const gchar* tag, gpointer self);
void screen_continue_songs (screen* self);
void auditive_open_path (auditive* self, const gchar* path);
GType file_type_get_type (void) G_GNUC_CONST;
file_type determine_node (const gchar* path);
void start_from_new_path (world_wide* world, const gchar* full_path, gboolean do_draw, const gchar* zoom_into);
playlist* playlist_new_play_start (world_wide* w, const gchar* full_path);
playlist* playlist_construct_play_start (GType object_type, world_wide* w, const gchar* full_path);
void auditive_begin (auditive* self, const gchar* path);
static gboolean _auditive_tick_callback_gsource_func (gpointer self);
static gboolean _auditive_key_callback_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
void console_end (console* self);
static void auditive_finalize (auditive* obj);
gint _vala_main (gchar** args, int args_length1);
gchar* remove_slashes (const gchar* path);


gchar* time_text (gint64 num) {
	gchar* result = NULL;
	gint64 _tmp0_;
	gint64 total;
	gchar* _tmp1_ = NULL;
	_tmp0_ = num;
	total = _tmp0_ / nsec;
	_tmp1_ = g_strdup_printf ("%d:%02d", ((gint) total) / 60, ((gint) total) % 60);
	result = _tmp1_;
	return result;
}


auditive* auditive_construct (GType object_type) {
	auditive* self = NULL;
	world_wide* _tmp0_;
	world_wide* _tmp1_;
	world_wide* _tmp2_;
	key_maps* _tmp3_;
	world_wide* _tmp4_;
	world_wide* _tmp5_;
	console* _tmp6_;
	world_wide* _tmp7_;
	world_wide* _tmp8_;
	dbg* _tmp9_;
	world_wide* _tmp10_;
	world_wide* _tmp11_;
	external* _tmp12_;
	world_wide* _tmp13_;
	world_wide* _tmp14_;
	help* _tmp15_;
	world_wide* _tmp16_;
	world_wide* _tmp17_;
	world_wide* _tmp18_;
	self = (auditive*) g_type_create_instance (object_type);
	_tmp0_ = world_wide_new ();
	self->world = _tmp0_;
	_tmp1_ = self->world;
	_tmp1_->player = self;
	_tmp2_ = self->world;
	_tmp3_ = key_maps_new ();
	_tmp2_->keys = _tmp3_;
	_tmp4_ = self->world;
	_tmp5_ = self->world;
	_tmp6_ = console_new (_tmp5_);
	_tmp4_->con = _tmp6_;
	_tmp7_ = self->world;
	_tmp8_ = self->world;
	_tmp9_ = dbg_new (_tmp8_);
	_tmp7_->debug = _tmp9_;
	_tmp10_ = self->world;
	_tmp11_ = self->world;
	_tmp12_ = external_new (_tmp11_);
	_tmp10_->ext_screen = _tmp12_;
	_tmp13_ = self->world;
	_tmp14_ = self->world;
	_tmp15_ = help_new (_tmp14_);
	_tmp13_->help_screen = _tmp15_;
	_tmp16_ = self->world;
	_tmp16_->playing_state = WORLD_WIDE_PLAYING_TYPE_stop;
	_tmp17_ = self->world;
	_g_list_free0 (_tmp17_->files_array);
	_tmp17_->files_array = NULL;
	_tmp18_ = self->world;
	config_setup (_tmp18_);
	return self;
}


auditive* auditive_new (void) {
	return auditive_construct (TYPE_AUDITIVE);
}


static inline void _dynamic_set_uri0 (GstElement* obj, gchar* value) {
	g_object_set (obj, "uri", value, NULL);
}


static gboolean _auditive_bus_callback_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = auditive_bus_callback (self, bus, message);
	return result;
}


void auditive_set_playing (auditive* self, const gchar* source) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	world_wide* _tmp4_;
	dbg* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	world_wide* _tmp9_;
	dbg* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GstElement* _tmp16_ = NULL;
	GstElement* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GstElement* _tmp21_;
	GstBus* _tmp22_ = NULL;
	GstBus* _tmp23_;
	GstElement* _tmp24_;
	world_wide* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	auditive_stop (self);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->song_label);
	self->priv->song_label = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->song_gapless_label);
	self->priv->song_gapless_label = _tmp1_;
	_tmp2_ = source;
	_tmp3_ = get_file_from_path (_tmp2_);
	_g_free0 (self->priv->song_short_file_name);
	self->priv->song_short_file_name = _tmp3_;
	_tmp4_ = self->world;
	_tmp5_ = _tmp4_->debug;
	_tmp6_ = self->priv->song_short_file_name;
	_tmp7_ = g_strconcat ("play ", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	dbg_add (_tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->world;
	_tmp10_ = _tmp9_->debug;
	_tmp11_ = source;
	_tmp12_ = get_base_from_path (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat ("from ", _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	dbg_add (_tmp10_, _tmp15_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp16_ = gst_element_factory_make ("playbin2", "player");
	gst_object_ref_sink (_tmp16_);
	_gst_object_unref0 (self->priv->play);
	self->priv->play = _tmp16_;
	_tmp17_ = self->priv->play;
	_tmp18_ = source;
	_tmp19_ = g_strconcat ("file://", _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	_dynamic_set_uri0 (_tmp17_, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = self->priv->play;
	_tmp22_ = gst_element_get_bus (_tmp21_);
	_gst_object_unref0 (self->priv->bus);
	self->priv->bus = _tmp22_;
	_tmp23_ = self->priv->bus;
	gst_bus_add_watch_full (_tmp23_, G_PRIORITY_DEFAULT, _auditive_bus_callback_gst_bus_func, auditive_ref (self), auditive_unref);
	auditive_playing (self);
	_tmp24_ = self->priv->play;
	_tmp25_ = self->world;
	g_signal_connect (_tmp24_, "about-to-finish", (GCallback) auditive_finish_callback, _tmp25_);
}


static inline void _dynamic_set_uri1 (GstElement* obj, gchar* value) {
	g_object_set (obj, "uri", value, NULL);
}


void auditive_continue_playing (auditive* self, const gchar* source) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint64 _tmp3_ = 0LL;
	GstElement* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	world_wide* _tmp10_;
	dbg* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	world_wide* _tmp15_;
	dbg* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->song_label;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->song_gapless_label);
	self->priv->song_gapless_label = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->song_label);
	self->priv->song_label = _tmp2_;
	_tmp3_ = auditive_get_duration (self);
	self->priv->gapless_duration = _tmp3_;
	_tmp4_ = self->priv->play;
	_tmp5_ = source;
	_tmp6_ = g_strconcat ("file://", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_dynamic_set_uri1 (_tmp4_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = source;
	_tmp9_ = get_file_from_path (_tmp8_);
	_g_free0 (self->priv->song_short_file_name);
	self->priv->song_short_file_name = _tmp9_;
	_tmp10_ = self->world;
	_tmp11_ = _tmp10_->debug;
	_tmp12_ = self->priv->song_short_file_name;
	_tmp13_ = g_strconcat ("gapless play ", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	dbg_add (_tmp11_, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = self->world;
	_tmp16_ = _tmp15_->debug;
	_tmp17_ = source;
	_tmp18_ = get_base_from_path (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat ("from ", _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	dbg_add (_tmp16_, _tmp21_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
}


void auditive_stop (auditive* self) {
	world_wide* _tmp0_;
	screen* _tmp1_;
	GstElement* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	world_wide* _tmp12_;
	world_wideplaying_type _tmp13_;
	world_wide* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->world;
	_tmp1_ = _tmp0_->playing_screen;
	if (_tmp1_ != NULL) {
		world_wide* _tmp2_;
		screen* _tmp3_;
		_tmp2_ = self->world;
		_tmp3_ = _tmp2_->playing_screen;
		screen_reset_stop (_tmp3_);
	}
	_tmp4_ = self->priv->play;
	gst_element_set_state (_tmp4_, GST_STATE_NULL);
	_tmp5_ = g_strdup ("");
	_g_free0 (self->priv->song_album);
	self->priv->song_album = _tmp5_;
	_tmp6_ = self->priv->song_album;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->priv->song_artist);
	self->priv->song_artist = _tmp7_;
	_tmp8_ = self->priv->song_artist;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (self->priv->song_title);
	self->priv->song_title = _tmp9_;
	_tmp10_ = self->priv->song_title;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (self->priv->song_label);
	self->priv->song_label = _tmp11_;
	_tmp12_ = self->world;
	_tmp13_ = _tmp12_->playing_state;
	if (_tmp13_ != WORLD_WIDE_PLAYING_TYPE_stop) {
		world_wide* _tmp14_;
		dbg* _tmp15_;
		_tmp14_ = self->world;
		_tmp15_ = _tmp14_->debug;
		dbg_add (_tmp15_, "stop");
	}
	_tmp16_ = self->world;
	_tmp16_->playing_state = WORLD_WIDE_PLAYING_TYPE_stop;
}


void auditive_previous_song (auditive* self) {
	world_wide* _tmp0_;
	screen* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->world;
	_tmp1_ = _tmp0_->playing_screen;
	if (_tmp1_ == NULL) {
		auditive_stop (self);
	} else {
		world_wide* _tmp2_;
		screen* _tmp3_;
		_tmp2_ = self->world;
		_tmp3_ = _tmp2_->playing_screen;
		screen_previous_song (_tmp3_);
	}
	auditive_draw (self);
}


void auditive_advance_song (auditive* self) {
	world_wide* _tmp0_;
	screen* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->world;
	_tmp1_ = _tmp0_->playing_screen;
	if (_tmp1_ == NULL) {
		auditive_stop (self);
	} else {
		world_wide* _tmp2_;
		screen* _tmp3_;
		_tmp2_ = self->world;
		_tmp3_ = _tmp2_->playing_screen;
		screen_advance_song (_tmp3_);
	}
	auditive_draw (self);
}


gint64 auditive_get_position (auditive* self) {
	gint64 result = 0LL;
	gint64 position = 0LL;
	GstFormat fmt;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	fmt = GST_FORMAT_TIME;
	_tmp0_ = self->priv->play;
	gst_element_query_position (_tmp0_, &fmt, &_tmp1_);
	position = _tmp1_;
	result = position;
	return result;
}


gint64 auditive_get_duration (auditive* self) {
	gint64 result = 0LL;
	gint64 duration = 0LL;
	GstFormat fmt;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	fmt = GST_FORMAT_TIME;
	_tmp0_ = self->priv->play;
	gst_element_query_duration (_tmp0_, &fmt, &_tmp1_);
	duration = _tmp1_;
	result = duration;
	return result;
}


void auditive_set_position (auditive* self, gint64 position) {
	GstElement* _tmp0_;
	gint64 _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->play;
	_tmp1_ = position;
	gst_element_seek_simple (_tmp0_, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_KEY_UNIT, _tmp1_);
}


void auditive_pause (auditive* self) {
	GstElement* _tmp0_;
	world_wide* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->play;
	gst_element_set_state (_tmp0_, GST_STATE_PAUSED);
	_tmp1_ = self->world;
	_tmp1_->playing_state = WORLD_WIDE_PLAYING_TYPE_pause;
}


void auditive_playing (auditive* self) {
	GstElement* _tmp0_;
	world_wide* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->play;
	gst_element_set_state (_tmp0_, GST_STATE_PLAYING);
	_tmp1_ = self->world;
	_tmp1_->playing_state = WORLD_WIDE_PLAYING_TYPE_play;
}


void auditive_adjust_position (auditive* self, gint signed_seconds) {
	gint64 _tmp0_ = 0LL;
	gint _tmp1_;
	gint64 new_position;
	gboolean _tmp2_ = FALSE;
	gint64 _tmp3_;
	gboolean _tmp6_;
	gint64 _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = auditive_get_position (self);
	_tmp1_ = signed_seconds;
	new_position = _tmp0_ + (_tmp1_ * nsec);
	_tmp3_ = new_position;
	if (_tmp3_ < ((gint64) 0)) {
		_tmp2_ = TRUE;
	} else {
		gint64 _tmp4_;
		gint64 _tmp5_ = 0LL;
		_tmp4_ = new_position;
		_tmp5_ = auditive_get_duration (self);
		_tmp2_ = _tmp4_ >= _tmp5_;
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		return;
	}
	_tmp7_ = new_position;
	auditive_set_position (self, _tmp7_);
}


void auditive_adjust_position_fraction (auditive* self, gint signed_decivar) {
	gint64 _tmp0_ = 0LL;
	gint64 adjust;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = auditive_get_duration (self);
	adjust = _tmp0_ / (nsec * 10);
	_tmp1_ = adjust;
	if (_tmp1_ > ((gint64) 123000456)) {
		return;
	}
	_tmp2_ = adjust;
	_tmp3_ = signed_decivar;
	auditive_adjust_position (self, ((gint) _tmp2_) * _tmp3_);
}


screen* auditive_index_screen (auditive* self, world_widescreen_type screen_type) {
	screen* result = NULL;
	world_widescreen_type _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = screen_type;
	switch (_tmp0_) {
		case WORLD_WIDE_SCREEN_TYPE_file_list:
		{
			world_wide* _tmp1_;
			GList* _tmp2_;
			world_wide* _tmp3_;
			gint _tmp4_;
			gconstpointer _tmp5_ = NULL;
			_tmp1_ = self->world;
			_tmp2_ = _tmp1_->files_array;
			_tmp3_ = self->world;
			_tmp4_ = _tmp3_->screen_files;
			_tmp5_ = g_list_nth_data (_tmp2_, (guint) _tmp4_);
			result = (screen*) _tmp5_;
			return result;
		}
		case WORLD_WIDE_SCREEN_TYPE_view_list:
		{
			world_wide* _tmp6_;
			viewlist* _tmp7_;
			_tmp6_ = self->world;
			_tmp7_ = _tmp6_->view_screen;
			result = (screen*) _tmp7_;
			return result;
		}
		case WORLD_WIDE_SCREEN_TYPE_play_list:
		{
			world_wide* _tmp8_;
			playlist* _tmp9_;
			_tmp8_ = self->world;
			_tmp9_ = _tmp8_->play_screen;
			result = (screen*) _tmp9_;
			return result;
		}
		case WORLD_WIDE_SCREEN_TYPE_ext_list:
		{
			world_wide* _tmp10_;
			external* _tmp11_;
			_tmp10_ = self->world;
			_tmp11_ = _tmp10_->ext_screen;
			result = (screen*) _tmp11_;
			return result;
		}
		case WORLD_WIDE_SCREEN_TYPE_debug:
		{
			world_wide* _tmp12_;
			dbg* _tmp13_;
			_tmp12_ = self->world;
			_tmp13_ = _tmp12_->debug;
			result = (screen*) _tmp13_;
			return result;
		}
		case WORLD_WIDE_SCREEN_TYPE_help:
		{
			world_wide* _tmp14_;
			help* _tmp15_;
			_tmp14_ = self->world;
			_tmp15_ = _tmp14_->help_screen;
			result = (screen*) _tmp15_;
			return result;
		}
		default:
		{
			world_wide* _tmp16_;
			dbg* _tmp17_;
			world_wide* _tmp18_;
			dbg* _tmp19_;
			_tmp16_ = self->world;
			_tmp17_ = _tmp16_->debug;
			dbg_alert (_tmp17_, "Undetermined screen");
			_tmp18_ = self->world;
			_tmp19_ = _tmp18_->debug;
			result = (screen*) _tmp19_;
			return result;
		}
	}
}


static gboolean auditive_key_callback (auditive* self, GIOChannel* src, GIOCondition cond) {
	gboolean result = FALSE;
	world_wide* _tmp0_;
	console* _tmp1_;
	gint _tmp2_ = 0;
	gint key_num;
	gint _tmp3_;
	world_wide* _tmp4_;
	key_maps* _tmp5_;
	gint key_shifted;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gboolean _tmp9_;
	gint _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (src != NULL, FALSE);
	_tmp0_ = self->world;
	_tmp1_ = _tmp0_->con;
	_tmp2_ = console_get_key (_tmp1_);
	key_num = _tmp2_;
	_tmp3_ = key_num;
	_tmp4_ = self->world;
	_tmp5_ = _tmp4_->keys;
	key_shifted = _tmp3_ - KEY_MAPS_key_f1;
	_tmp7_ = key_shifted;
	if (_tmp7_ >= 0) {
		gint _tmp8_;
		_tmp8_ = key_shifted;
		_tmp6_ = _tmp8_ <= 8;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		gint _tmp10_;
		world_wide* _tmp11_;
		key_maps* _tmp12_;
		_tmp10_ = key_shifted;
		_tmp11_ = self->world;
		_tmp12_ = _tmp11_->keys;
		key_num = _tmp10_ + KEY_MAPS_key_k1;
	}
	_tmp13_ = key_num;
	switch (_tmp13_) {
		world_wide* _tmp15_;
		key_maps* _tmp16_;
		case 0:
		{
			break;
		}
		case 'q':
		{
			GMainLoop* _tmp14_;
			_tmp14_ = self->priv->loop;
			g_main_loop_quit (_tmp14_);
			break;
		}
		_tmp15_ = self->world;
		_tmp16_ = _tmp15_->keys;
		case KEY_MAPS_key_backspace:
		{
			world_wide* _tmp17_;
			auditive_stop (self);
			_tmp17_ = self->world;
			_tmp17_->playlist_position = -1;
			auditive_draw (self);
			break;
		}
		case '1':
		{
			world_wide* _tmp18_;
			help* _tmp19_;
			_tmp18_ = self->world;
			_tmp19_ = _tmp18_->help_screen;
			screen_draw ((screen*) _tmp19_);
			break;
		}
		case '2':
		{
			world_wide* _tmp20_;
			GList* _tmp21_;
			world_wide* _tmp22_;
			gint _tmp23_;
			gconstpointer _tmp24_ = NULL;
			_tmp20_ = self->world;
			_tmp21_ = _tmp20_->files_array;
			_tmp22_ = self->world;
			_tmp23_ = _tmp22_->screen_files;
			_tmp24_ = g_list_nth_data (_tmp21_, (guint) _tmp23_);
			screen_draw ((screen*) _tmp24_);
			break;
		}
		case '3':
		{
			world_wide* _tmp25_;
			playlist* _tmp26_;
			_tmp25_ = self->world;
			_tmp26_ = _tmp25_->play_screen;
			if (_tmp26_ != NULL) {
				world_wide* _tmp27_;
				playlist* _tmp28_;
				_tmp27_ = self->world;
				_tmp28_ = _tmp27_->play_screen;
				screen_draw ((screen*) _tmp28_);
			} else {
				world_wide* _tmp29_;
				viewlist* _tmp30_;
				_tmp29_ = self->world;
				_tmp30_ = _tmp29_->view_screen;
				if (_tmp30_ != NULL) {
					world_wide* _tmp31_;
					viewlist* _tmp32_;
					_tmp31_ = self->world;
					_tmp32_ = _tmp31_->view_screen;
					screen_draw ((screen*) _tmp32_);
				} else {
					world_wide* _tmp33_;
					dbg* _tmp34_;
					_tmp33_ = self->world;
					_tmp34_ = _tmp33_->debug;
					dbg_add (_tmp34_, "a .m3u list hasn\'t been loaded yet");
				}
			}
			break;
		}
		case '4':
		{
			world_wide* _tmp35_;
			external* _tmp36_;
			_tmp35_ = self->world;
			_tmp36_ = _tmp35_->ext_screen;
			screen_draw ((screen*) _tmp36_);
			break;
		}
		case '`':
		{
			world_wide* _tmp37_;
			dbg* _tmp38_;
			_tmp37_ = self->world;
			_tmp38_ = _tmp37_->debug;
			screen_draw ((screen*) _tmp38_);
			break;
		}
		case ' ':
		{
			world_wide* _tmp39_;
			world_wideplaying_type _tmp40_;
			_tmp39_ = self->world;
			_tmp40_ = _tmp39_->playing_state;
			switch (_tmp40_) {
				case WORLD_WIDE_PLAYING_TYPE_play:
				{
					gint64 _tmp41_ = 0LL;
					_tmp41_ = auditive_get_position (self);
					self->priv->resume_position = _tmp41_;
					auditive_pause (self);
					break;
				}
				case WORLD_WIDE_PLAYING_TYPE_pause:
				{
					GstElement* _tmp42_;
					gint64 _tmp43_;
					_tmp42_ = self->priv->play;
					_tmp43_ = self->priv->resume_position;
					gst_element_seek_simple (_tmp42_, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_KEY_UNIT, _tmp43_);
					auditive_playing (self);
					break;
				}
				default:
				break;
			}
			break;
		}
		case '|':
		{
			auditive_previous_song (self);
			break;
		}
		case '\\':
		{
			auditive_advance_song (self);
			break;
		}
		case ',':
		{
			auditive_adjust_position (self, -5);
			break;
		}
		case '.':
		{
			auditive_adjust_position (self, +5);
			break;
		}
		case '[':
		{
			auditive_adjust_position (self, -60);
			break;
		}
		case ']':
		{
			auditive_adjust_position (self, +60);
			break;
		}
		case '{':
		{
			auditive_adjust_position_fraction (self, -1);
			break;
		}
		case '}':
		{
			auditive_adjust_position_fraction (self, +1);
			break;
		}
		case '-':
		{
			world_wide* _tmp44_;
			world_wide* _tmp45_;
			gboolean _tmp46_;
			_tmp44_ = self->world;
			_tmp45_ = self->world;
			_tmp46_ = _tmp45_->play_advance;
			_tmp44_->play_advance = !_tmp46_;
			auditive_draw (self);
			break;
		}
		case '~':
		{
			world_wide* _tmp47_;
			_tmp47_ = self->world;
			config_setup (_tmp47_);
			break;
		}
		default:
		{
			world_wide* _tmp48_;
			world_widescreen_type _tmp49_;
			screen* _tmp50_ = NULL;
			gint _tmp51_;
			_tmp48_ = self->world;
			_tmp49_ = _tmp48_->screen_current;
			_tmp50_ = auditive_index_screen (self, _tmp49_);
			_tmp51_ = key_num;
			screen_key_press (_tmp50_, _tmp51_);
			break;
		}
	}
	result = TRUE;
	return result;
}


void auditive_draw (auditive* self) {
	world_wide* _tmp0_;
	world_widescreen_type _tmp1_;
	screen* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->world;
	_tmp1_ = _tmp0_->screen_current;
	_tmp2_ = auditive_index_screen (self, _tmp1_);
	screen_draw (_tmp2_);
	auditive_draw_counter (self);
}


void auditive_draw_counter (auditive* self) {
	world_wide* _tmp0_;
	world_widescreen_type _tmp1_;
	screen* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar* text = NULL;
	world_wide* _tmp4_;
	world_wideplaying_type _tmp5_;
	world_wide* _tmp52_;
	console* _tmp53_;
	const gchar* _tmp54_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->world;
	_tmp1_ = _tmp0_->screen_current;
	_tmp2_ = auditive_index_screen (self, _tmp1_);
	_tmp3_ = screen_has_title (_tmp2_);
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = self->world;
	_tmp5_ = _tmp4_->playing_state;
	if (_tmp5_ == WORLD_WIDE_PLAYING_TYPE_stop) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("  0:00");
		_g_free0 (text);
		text = _tmp6_;
	} else {
		gint64 _tmp7_ = 0LL;
		gint64 position;
		gint64 _tmp8_;
		gint64 _tmp9_;
		const gchar* _tmp10_;
		_tmp7_ = auditive_get_position (self);
		position = _tmp7_;
		_tmp8_ = position;
		if (_tmp8_ == ((gint64) 0)) {
			_g_free0 (text);
			return;
		}
		_tmp9_ = position;
		self->priv->resume_position = _tmp9_;
		_tmp10_ = self->priv->song_gapless_label;
		if (g_strcmp0 (_tmp10_, "") != 0) {
			gint64 _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gint64 _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp11_ = position;
			_tmp12_ = time_text (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat ("  ", _tmp13_, NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp15_, "/", NULL);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->priv->gapless_duration;
			_tmp19_ = time_text (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp17_, _tmp20_, NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strconcat (_tmp22_, " ", NULL);
			_tmp24_ = _tmp23_;
			_tmp25_ = self->priv->song_gapless_label;
			_tmp26_ = g_strconcat (_tmp24_, _tmp25_, NULL);
			_g_free0 (text);
			text = _tmp26_;
			_g_free0 (_tmp24_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
		} else {
			gint64 _tmp27_;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gint64 _tmp34_ = 0LL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			gchar* _tmp37_;
			const gchar* _tmp38_;
			_tmp27_ = position;
			_tmp28_ = time_text (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strconcat ("  ", _tmp29_, NULL);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strconcat (_tmp31_, "/", NULL);
			_tmp33_ = _tmp32_;
			_tmp34_ = auditive_get_duration (self);
			_tmp35_ = time_text (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_strconcat (_tmp33_, _tmp36_, NULL);
			_g_free0 (text);
			text = _tmp37_;
			_g_free0 (_tmp36_);
			_g_free0 (_tmp33_);
			_g_free0 (_tmp31_);
			_g_free0 (_tmp29_);
			_tmp38_ = self->priv->song_label;
			if (g_strcmp0 (_tmp38_, "") != 0) {
				const gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				const gchar* _tmp42_;
				gchar* _tmp43_;
				_tmp39_ = text;
				_tmp40_ = g_strconcat (_tmp39_, " ", NULL);
				_tmp41_ = _tmp40_;
				_tmp42_ = self->priv->song_label;
				_tmp43_ = g_strconcat (_tmp41_, _tmp42_, NULL);
				_g_free0 (text);
				text = _tmp43_;
				_g_free0 (_tmp41_);
			} else {
				gint64 _tmp44_;
				_tmp44_ = position;
				if (((_tmp44_ * 10) / nsec) > ((gint64) 2)) {
					const gchar* _tmp45_;
					gchar* _tmp46_;
					const gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					const gchar* _tmp50_;
					gchar* _tmp51_;
					_tmp45_ = self->priv->song_short_file_name;
					_tmp46_ = g_strdup (_tmp45_);
					_g_free0 (self->priv->song_label);
					self->priv->song_label = _tmp46_;
					_tmp47_ = text;
					_tmp48_ = g_strconcat (_tmp47_, " ", NULL);
					_tmp49_ = _tmp48_;
					_tmp50_ = self->priv->song_label;
					_tmp51_ = g_strconcat (_tmp49_, _tmp50_, NULL);
					_g_free0 (text);
					text = _tmp51_;
					_g_free0 (_tmp49_);
				}
			}
		}
	}
	_tmp52_ = self->world;
	_tmp53_ = _tmp52_->con;
	_tmp54_ = text;
	console_print_status (_tmp53_, _tmp54_);
	_g_free0 (text);
}


static gboolean auditive_tick_callback (auditive* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gint _tmp10_;
	world_wide* _tmp16_;
	console* _tmp17_;
	gint _tmp18_ = 0;
	gint new_screen_size;
	gint _tmp19_;
	gint _tmp20_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->auto_start_name;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		world_wide* _tmp1_;
		GList* _tmp2_;
		world_wide* _tmp3_;
		gint _tmp4_;
		gconstpointer _tmp5_ = NULL;
		files* a_file;
		files* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		files* _tmp9_;
		_tmp1_ = self->world;
		_tmp2_ = _tmp1_->files_array;
		_tmp3_ = self->world;
		_tmp4_ = _tmp3_->screen_files;
		_tmp5_ = g_list_nth_data (_tmp2_, (guint) _tmp4_);
		a_file = (files*) _tmp5_;
		_tmp6_ = a_file;
		_tmp7_ = self->priv->auto_start_name;
		files_play_a_song (_tmp6_, _tmp7_);
		_tmp8_ = g_strdup ("");
		_g_free0 (self->priv->auto_start_name);
		self->priv->auto_start_name = _tmp8_;
		_tmp9_ = a_file;
		screen_draw ((screen*) _tmp9_);
	}
	_tmp10_ = self->priv->auto_start_number;
	if (_tmp10_ >= 0) {
		world_wide* _tmp11_;
		playlist* _tmp12_;
		gint _tmp13_;
		world_wide* _tmp14_;
		playlist* _tmp15_;
		_tmp11_ = self->world;
		_tmp12_ = _tmp11_->play_screen;
		_tmp13_ = self->priv->auto_start_number;
		playlist_play_a_song (_tmp12_, _tmp13_);
		self->priv->auto_start_number = -1;
		_tmp14_ = self->world;
		_tmp15_ = _tmp14_->play_screen;
		screen_draw ((screen*) _tmp15_);
	}
	_tmp16_ = self->world;
	_tmp17_ = _tmp16_->con;
	_tmp18_ = console_calculate_screen_size (_tmp17_);
	new_screen_size = _tmp18_;
	_tmp19_ = new_screen_size;
	_tmp20_ = self->priv->screen_size;
	if (_tmp19_ != _tmp20_) {
		world_wide* _tmp21_;
		console* _tmp22_;
		gint _tmp23_;
		world_wide* _tmp24_;
		world_widescreen_type _tmp25_;
		screen* _tmp26_ = NULL;
		_tmp21_ = self->world;
		_tmp22_ = _tmp21_->con;
		console_cls (_tmp22_);
		_tmp23_ = new_screen_size;
		self->priv->screen_size = _tmp23_;
		_tmp24_ = self->world;
		_tmp25_ = _tmp24_->screen_current;
		_tmp26_ = auditive_index_screen (self, _tmp25_);
		screen_draw (_tmp26_);
	}
	auditive_draw_counter (self);
	result = TRUE;
	return result;
}


void auditive_tag_reciever (auditive* self, GstTagList* list, const gchar* tag) {
	gchar* field = NULL;
	gchar* data = NULL;
	GstTagList* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (list != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = list;
	_tmp1_ = tag;
	_tmp2_ = check_tag_exists ((void*) _tmp0_, (gchar*) _tmp1_);
	if (_tmp2_) {
		GstTagList* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_;
		const gchar* _tmp11_;
		const gchar* _tmp14_;
		const gchar* _tmp17_;
		world_wide* _tmp26_;
		dbg* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp3_ = list;
		_tmp4_ = tag;
		gst_tag_list_get_string (_tmp3_, _tmp4_, &_tmp5_);
		_g_free0 (data);
		data = _tmp5_;
		_tmp6_ = tag;
		_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) (-1));
		_g_free0 (field);
		field = _tmp7_;
		_tmp8_ = field;
		if (g_strcmp0 (_tmp8_, "title") == 0) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = data;
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (self->priv->song_title);
			self->priv->song_title = _tmp10_;
		}
		_tmp11_ = field;
		if (g_strcmp0 (_tmp11_, "artist") == 0) {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = data;
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (self->priv->song_artist);
			self->priv->song_artist = _tmp13_;
		}
		_tmp14_ = field;
		if (g_strcmp0 (_tmp14_, "album") == 0) {
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp15_ = data;
			_tmp16_ = g_strdup (_tmp15_);
			_g_free0 (self->priv->song_album);
			self->priv->song_album = _tmp16_;
		}
		_tmp17_ = self->priv->song_title;
		if (g_strcmp0 (_tmp17_, "") != 0) {
			const gchar* _tmp18_;
			_tmp18_ = self->priv->song_artist;
			if (g_strcmp0 (_tmp18_, "") != 0) {
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp19_ = self->priv->song_title;
				_tmp20_ = g_strconcat (_tmp19_, " - ", NULL);
				_tmp21_ = _tmp20_;
				_tmp22_ = self->priv->song_artist;
				_tmp23_ = g_strconcat (_tmp21_, _tmp22_, NULL);
				_g_free0 (self->priv->song_label);
				self->priv->song_label = _tmp23_;
				_g_free0 (_tmp21_);
			} else {
				const gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp24_ = self->priv->song_title;
				_tmp25_ = g_strdup (_tmp24_);
				_g_free0 (self->priv->song_label);
				self->priv->song_label = _tmp25_;
			}
		}
		_tmp26_ = self->world;
		_tmp27_ = _tmp26_->debug;
		_tmp28_ = tag;
		_tmp29_ = g_strconcat ("tag: ", _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat (_tmp30_, ": ", NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = data;
		_tmp34_ = g_strconcat (_tmp32_, _tmp33_, NULL);
		_tmp35_ = _tmp34_;
		dbg_add (_tmp27_, _tmp35_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp30_);
	}
	_g_free0 (data);
	_g_free0 (field);
}


static void _auditive_tag_reciever_foreach_delegate (GstTagList* list, const gchar* tag, gpointer self) {
	auditive_tag_reciever (self, list, tag);
}


static gboolean auditive_bus_callback (auditive* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	GstMessage* _tmp0_;
	GstMessageType _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	switch (_tmp1_) {
		case GST_MESSAGE_EOS:
		{
			world_wide* _tmp2_;
			dbg* _tmp3_;
			_tmp2_ = self->world;
			_tmp3_ = _tmp2_->debug;
			dbg_add (_tmp3_, "gst: EOS");
			auditive_stop (self);
			auditive_draw (self);
			break;
		}
		case GST_MESSAGE_ELEMENT:
		{
			world_wide* _tmp4_;
			dbg* _tmp5_;
			const gchar* _tmp6_;
			_tmp4_ = self->world;
			_tmp5_ = _tmp4_->debug;
			dbg_add (_tmp5_, "gst: element");
			_tmp6_ = self->priv->song_gapless_label;
			if (g_strcmp0 (_tmp6_, "") != 0) {
				gchar* _tmp7_;
				world_wide* _tmp8_;
				screen* _tmp9_;
				_tmp7_ = g_strdup ("");
				_g_free0 (self->priv->song_gapless_label);
				self->priv->song_gapless_label = _tmp7_;
				_tmp8_ = self->world;
				_tmp9_ = _tmp8_->playing_screen;
				screen_continue_songs_draw (_tmp9_);
			}
			break;
		}
		case GST_MESSAGE_ERROR:
		case GST_MESSAGE_WARNING:
		{
			world_wide* _tmp10_;
			dbg* _tmp11_;
			GstMessage* _tmp12_;
			GstMessageType _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			world_wide* _tmp16_;
			console* _tmp17_;
			world_wide* _tmp18_;
			console* _tmp19_;
			_tmp10_ = self->world;
			_tmp11_ = _tmp10_->debug;
			_tmp12_ = message;
			_tmp13_ = _tmp12_->type;
			_tmp14_ = g_strdup_printf ("Stop: %x", (guint) _tmp13_);
			_tmp15_ = _tmp14_;
			dbg_add (_tmp11_, _tmp15_);
			_g_free0 (_tmp15_);
			auditive_stop (self);
			_tmp16_ = self->world;
			_tmp17_ = _tmp16_->con;
			console_cls (_tmp17_);
			_tmp18_ = self->world;
			_tmp19_ = _tmp18_->con;
			console_refresh (_tmp19_);
			auditive_draw (self);
			break;
		}
		case GST_MESSAGE_TAG:
		{
			GstTagList* tag_list = NULL;
			GstMessage* _tmp20_;
			GstTagList* _tmp21_ = NULL;
			GstTagList* _tmp22_;
			_tmp20_ = message;
			gst_message_parse_tag (_tmp20_, &_tmp21_);
			_gst_tag_list_free0 (tag_list);
			tag_list = _tmp21_;
			_tmp22_ = tag_list;
			taglist_foreach_job (_tmp22_, _auditive_tag_reciever_foreach_delegate, self, self);
			_gst_tag_list_free0 (tag_list);
			break;
		}
		default:
		break;
	}
	result = TRUE;
	return result;
}


void auditive_finish_callback (auditive* self, world_wide* world) {
	world_wide* _tmp0_;
	dbg* _tmp1_;
	world_wide* _tmp2_;
	auditive* _tmp3_;
	gchar* _tmp4_;
	world_wide* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = world;
	_tmp1_ = _tmp0_->debug;
	dbg_add (_tmp1_, "gst: about-to-finish");
	_tmp2_ = world;
	_tmp3_ = _tmp2_->player;
	_tmp4_ = g_strdup ("");
	_g_free0 (_tmp3_->priv->song_gapless_label);
	_tmp3_->priv->song_gapless_label = _tmp4_;
	_tmp5_ = world;
	_tmp6_ = _tmp5_->play_advance;
	if (_tmp6_) {
		world_wide* _tmp7_;
		screen* _tmp8_;
		_tmp7_ = world;
		_tmp8_ = _tmp7_->playing_screen;
		screen_continue_songs (_tmp8_);
	}
}


void auditive_open_path (auditive* self, const gchar* path) {
	const gchar* _tmp0_;
	file_type _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	_tmp1_ = determine_node (_tmp0_);
	switch (_tmp1_) {
		case FILE_TYPE_dir:
		{
			world_wide* _tmp2_;
			const gchar* _tmp3_;
			_tmp2_ = self->world;
			_tmp3_ = path;
			start_from_new_path (_tmp2_, _tmp3_, TRUE, "");
			break;
		}
		case FILE_TYPE_file:
		{
			const gchar* _tmp4_;
			gchar* _tmp5_ = NULL;
			world_wide* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp4_ = path;
			_tmp5_ = get_file_from_path (_tmp4_);
			_g_free0 (self->priv->auto_start_name);
			self->priv->auto_start_name = _tmp5_;
			_tmp6_ = self->world;
			_tmp7_ = path;
			_tmp8_ = get_base_from_path (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = self->priv->auto_start_name;
			start_from_new_path (_tmp6_, _tmp9_, TRUE, _tmp10_);
			_g_free0 (_tmp9_);
			break;
		}
		case FILE_TYPE_m3u:
		{
			world_wide* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			world_wide* _tmp15_;
			world_wide* _tmp16_;
			GList* _tmp17_;
			guint _tmp18_ = 0U;
			world_wide* _tmp19_;
			world_wide* _tmp20_;
			const gchar* _tmp21_;
			playlist* _tmp22_;
			_tmp11_ = self->world;
			_tmp12_ = path;
			_tmp13_ = get_base_from_path (_tmp12_);
			_tmp14_ = _tmp13_;
			start_from_new_path (_tmp11_, _tmp14_, FALSE, "");
			_g_free0 (_tmp14_);
			_tmp15_ = self->world;
			_tmp16_ = self->world;
			_tmp17_ = _tmp16_->files_array;
			_tmp18_ = g_list_length (_tmp17_);
			_tmp15_->screen_files = ((gint) _tmp18_) - 1;
			_tmp19_ = self->world;
			_tmp20_ = self->world;
			_tmp21_ = path;
			_tmp22_ = playlist_new_play_start (_tmp20_, _tmp21_);
			_tmp19_->play_screen = _tmp22_;
			self->priv->auto_start_number = 0;
			break;
		}
		case FILE_TYPE_not_exist:
		{
			world_wide* _tmp23_;
			dbg* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			world_wide* _tmp28_;
			dbg* _tmp29_;
			world_wide* _tmp30_;
			world_wide* _tmp31_;
			dbg* _tmp32_;
			_tmp23_ = self->world;
			_tmp24_ = _tmp23_->debug;
			_tmp25_ = path;
			_tmp26_ = g_strconcat ("bad path: ", _tmp25_, NULL);
			_tmp27_ = _tmp26_;
			dbg_add (_tmp24_, _tmp27_);
			_g_free0 (_tmp27_);
			_tmp28_ = self->world;
			_tmp29_ = _tmp28_->debug;
			dbg_add (_tmp29_, "press F1 for the help screen, F2 for files.");
			_tmp30_ = self->world;
			start_from_new_path (_tmp30_, "/", FALSE, "");
			_tmp31_ = self->world;
			_tmp32_ = _tmp31_->debug;
			screen_draw ((screen*) _tmp32_);
			break;
		}
		default:
		break;
	}
}


static gboolean _auditive_tick_callback_gsource_func (gpointer self) {
	gboolean result;
	result = auditive_tick_callback (self);
	return result;
}


static gboolean _auditive_key_callback_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = auditive_key_callback (self, source, condition);
	return result;
}


void auditive_begin (auditive* self, const gchar* path) {
	GIOChannel* _tmp0_;
	GIOChannel* ioc;
	const gchar* _tmp1_;
	GstElement* _tmp2_ = NULL;
	GMainLoop* _tmp3_;
	world_wide* _tmp4_;
	console* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _auditive_tick_callback_gsource_func, auditive_ref (self), auditive_unref);
	_tmp0_ = g_io_channel_unix_new (0);
	ioc = _tmp0_;
	g_io_add_watch (ioc, G_IO_IN, _auditive_key_callback_gio_func, self);
	_tmp1_ = path;
	auditive_open_path (self, _tmp1_);
	_tmp2_ = gst_element_factory_make ("playbin2", "player");
	gst_object_ref_sink (_tmp2_);
	_gst_object_unref0 (self->priv->play);
	self->priv->play = _tmp2_;
	_tmp3_ = self->priv->loop;
	g_main_loop_run (_tmp3_);
	_tmp4_ = self->world;
	_tmp5_ = _tmp4_->con;
	console_end (_tmp5_);
	_g_io_channel_unref0 (ioc);
}


static void value_auditive_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_auditive_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		auditive_unref (value->data[0].v_pointer);
	}
}


static void value_auditive_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = auditive_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_auditive_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_auditive_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		auditive* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = auditive_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_auditive_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	auditive** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = auditive_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_auditive (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecauditive* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AUDITIVE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_auditive (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUDITIVE), NULL);
	return value->data[0].v_pointer;
}


void value_set_auditive (GValue* value, gpointer v_object) {
	auditive* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUDITIVE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUDITIVE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		auditive_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		auditive_unref (old);
	}
}


void value_take_auditive (GValue* value, gpointer v_object) {
	auditive* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUDITIVE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUDITIVE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		auditive_unref (old);
	}
}


static void auditive_class_init (auditiveClass * klass) {
	auditive_parent_class = g_type_class_peek_parent (klass);
	AUDITIVE_CLASS (klass)->finalize = auditive_finalize;
	g_type_class_add_private (klass, sizeof (auditivePrivate));
}


static void auditive_instance_init (auditive * self) {
	GMainLoop* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = AUDITIVE_GET_PRIVATE (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	self->priv->loop = _tmp0_;
	self->priv->resume_position = (gint64) 0;
	_tmp1_ = g_strdup ("");
	self->priv->song_label = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->song_gapless_label = _tmp2_;
	self->priv->screen_size = 0;
	self->priv->auto_start_number = -1;
	_tmp3_ = g_strdup ("");
	self->priv->auto_start_name = _tmp3_;
	self->ref_count = 1;
}


static void auditive_finalize (auditive* obj) {
	auditive * self;
	self = AUDITIVE (obj);
	_g_main_loop_unref0 (self->priv->loop);
	_gst_object_unref0 (self->priv->play);
	_gst_object_unref0 (self->priv->bus);
	_g_free0 (self->priv->song_label);
	_g_free0 (self->priv->song_gapless_label);
	_g_free0 (self->priv->song_title);
	_g_free0 (self->priv->song_artist);
	_g_free0 (self->priv->song_album);
	_g_free0 (self->priv->song_short_file_name);
	_g_free0 (self->priv->auto_start_name);
}


GType auditive_get_type (void) {
	static volatile gsize auditive_type_id__volatile = 0;
	if (g_once_init_enter (&auditive_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_auditive_init, value_auditive_free_value, value_auditive_copy_value, value_auditive_peek_pointer, "p", value_auditive_collect_value, "p", value_auditive_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (auditiveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) auditive_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (auditive), 0, (GInstanceInitFunc) auditive_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType auditive_type_id;
		auditive_type_id = g_type_register_fundamental (g_type_fundamental_next (), "auditive", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&auditive_type_id__volatile, auditive_type_id);
	}
	return auditive_type_id__volatile;
}


gpointer auditive_ref (gpointer instance) {
	auditive* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void auditive_unref (gpointer instance) {
	auditive* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AUDITIVE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	auditive* _tmp0_;
	auditive* player;
	gchar* path = NULL;
	gboolean _tmp1_ = FALSE;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean _tmp5_;
	auditive* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	gst_init (&args_length1, &args);
	_tmp0_ = auditive_new ();
	player = _tmp0_;
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	if (_tmp2__length1 > 1) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
		_tmp3_ = args;
		_tmp3__length1 = args_length1;
		_tmp4_ = _tmp3_[1];
		_tmp1_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar _tmp8_ = '\0';
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[1];
		_tmp8_ = string_get (_tmp7_, (glong) 0);
		if (_tmp8_ == '/') {
			gchar** _tmp9_;
			gint _tmp9__length1;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = args;
			_tmp9__length1 = args_length1;
			_tmp10_ = _tmp9_[1];
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (path);
			path = _tmp11_;
		} else {
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar** _tmp16_;
			gint _tmp16__length1;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp12_ = g_get_current_dir ();
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat (_tmp13_, "/", NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = args;
			_tmp16__length1 = args_length1;
			_tmp17_ = _tmp16_[1];
			_tmp18_ = g_strconcat (_tmp15_, _tmp17_, NULL);
			_g_free0 (path);
			path = _tmp18_;
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
		}
	} else {
		gchar* _tmp19_ = NULL;
		_tmp19_ = g_get_current_dir ();
		_g_free0 (path);
		path = _tmp19_;
	}
	_tmp20_ = player;
	_tmp21_ = path;
	_tmp22_ = remove_slashes (_tmp21_);
	_tmp23_ = _tmp22_;
	auditive_begin (_tmp20_, _tmp23_);
	_g_free0 (_tmp23_);
	result = 0;
	_g_free0 (path);
	_auditive_unref0 (player);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



