/* debug.c generated by valac 0.16.1, the Vala compiler
 * generated from debug.vala, do not modify */

/*

This file is part of Auditive.

Copyright 2010-2012 Graeme Sheppard.

Auditive is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Auditive is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Auditive. If not, see <http://www.gnu.org/licenses/>.

*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_SCREEN (screen_get_type ())
#define SCREEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCREEN, screen))
#define SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCREEN, screenClass))
#define IS_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCREEN))
#define IS_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCREEN))
#define SCREEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCREEN, screenClass))

typedef struct _screen screen;
typedef struct _screenClass screenClass;
typedef struct _screenPrivate screenPrivate;

#define WORLD_WIDE_TYPE_SCREEN_TYPE (world_wide_screen_type_get_type ())

#define TYPE_WORLD_WIDE (world_wide_get_type ())
#define WORLD_WIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORLD_WIDE, world_wide))
#define WORLD_WIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORLD_WIDE, world_wideClass))
#define IS_WORLD_WIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORLD_WIDE))
#define IS_WORLD_WIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORLD_WIDE))
#define WORLD_WIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORLD_WIDE, world_wideClass))

typedef struct _world_wide world_wide;
typedef struct _world_wideClass world_wideClass;

#define TYPE_DBG (dbg_get_type ())
#define DBG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DBG, dbg))
#define DBG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DBG, dbgClass))
#define IS_DBG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DBG))
#define IS_DBG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DBG))
#define DBG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DBG, dbgClass))

typedef struct _dbg dbg;
typedef struct _dbgClass dbgClass;
typedef struct _dbgPrivate dbgPrivate;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _world_widePrivate world_widePrivate;

#define TYPE_CONSOLE (console_get_type ())
#define CONSOLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONSOLE, console))
#define CONSOLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONSOLE, consoleClass))
#define IS_CONSOLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONSOLE))
#define IS_CONSOLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONSOLE))
#define CONSOLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONSOLE, consoleClass))

typedef struct _console console;
typedef struct _consoleClass consoleClass;

#define TYPE_KEY_MAPS (key_maps_get_type ())
#define KEY_MAPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_MAPS, key_maps))
#define KEY_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_MAPS, key_mapsClass))
#define IS_KEY_MAPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_MAPS))
#define IS_KEY_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_MAPS))
#define KEY_MAPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_MAPS, key_mapsClass))

typedef struct _key_maps key_maps;
typedef struct _key_mapsClass key_mapsClass;

#define TYPE_AUDITIVE (auditive_get_type ())
#define AUDITIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUDITIVE, auditive))
#define AUDITIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUDITIVE, auditiveClass))
#define IS_AUDITIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUDITIVE))
#define IS_AUDITIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUDITIVE))
#define AUDITIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUDITIVE, auditiveClass))

typedef struct _auditive auditive;
typedef struct _auditiveClass auditiveClass;

#define TYPE_PLAYLIST (playlist_get_type ())
#define PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYLIST, playlist))
#define PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYLIST, playlistClass))
#define IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYLIST))
#define IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYLIST))
#define PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYLIST, playlistClass))

typedef struct _playlist playlist;
typedef struct _playlistClass playlistClass;

#define TYPE_VIEWLIST (viewlist_get_type ())
#define VIEWLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEWLIST, viewlist))
#define VIEWLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEWLIST, viewlistClass))
#define IS_VIEWLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEWLIST))
#define IS_VIEWLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEWLIST))
#define VIEWLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEWLIST, viewlistClass))

typedef struct _viewlist viewlist;
typedef struct _viewlistClass viewlistClass;

#define TYPE_EXTERNAL (external_get_type ())
#define EXTERNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTERNAL, external))
#define EXTERNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXTERNAL, externalClass))
#define IS_EXTERNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTERNAL))
#define IS_EXTERNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXTERNAL))
#define EXTERNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXTERNAL, externalClass))

typedef struct _external external;
typedef struct _externalClass externalClass;

#define TYPE_HELP (help_get_type ())
#define HELP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HELP, help))
#define HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HELP, helpClass))
#define IS_HELP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HELP))
#define IS_HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HELP))
#define HELP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HELP, helpClass))

typedef struct _help help;
typedef struct _helpClass helpClass;

#define TYPE_FILES (files_get_type ())
#define FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILES, files))
#define FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILES, filesClass))
#define IS_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILES))
#define IS_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILES))
#define FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILES, filesClass))

typedef struct _files files;
typedef struct _filesClass filesClass;

#define TYPE_METHOD (method_get_type ())
#define METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METHOD, method))
#define METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METHOD, methodClass))
#define IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METHOD))
#define IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METHOD))
#define METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METHOD, methodClass))

typedef struct _method method;
typedef struct _methodClass methodClass;

#define WORLD_WIDE_TYPE_PLAYING_TYPE (world_wide_playing_type_get_type ())

typedef enum  {
	WORLD_WIDE_SCREEN_TYPE_none,
	WORLD_WIDE_SCREEN_TYPE_file_list,
	WORLD_WIDE_SCREEN_TYPE_view_list,
	WORLD_WIDE_SCREEN_TYPE_play_list,
	WORLD_WIDE_SCREEN_TYPE_ext_list,
	WORLD_WIDE_SCREEN_TYPE_debug,
	WORLD_WIDE_SCREEN_TYPE_help
} world_widescreen_type;

struct _screen {
	GTypeInstance parent_instance;
	volatile int ref_count;
	screenPrivate * priv;
	world_wide* world;
	gint screen_pos;
	gint row_pos;
	gint key_handled;
};

struct _screenClass {
	GTypeClass parent_class;
	void (*finalize) (screen *self);
	gboolean (*has_title) (screen* self);
	gchar* (*get_title) (screen* self);
	void (*previous_song) (screen* self);
	void (*advance_song) (screen* self);
	void (*continue_songs) (screen* self);
	void (*continue_songs_draw) (screen* self);
	gint (*get_size) (screen* self);
	gchar* (*calc_target) (screen* self, guint num);
	gchar* (*get_line) (screen* self, guint num);
	world_widescreen_type (*get_screen_type) (screen* self);
	void (*reset_stop) (screen* self);
	void (*draw) (screen* self);
	void (*key_press) (screen* self, gint key_num);
};

struct _dbg {
	screen parent_instance;
	dbgPrivate * priv;
	GList* lines;
};

struct _dbgClass {
	screenClass parent_class;
};

typedef enum  {
	WORLD_WIDE_PLAYING_TYPE_stop,
	WORLD_WIDE_PLAYING_TYPE_play,
	WORLD_WIDE_PLAYING_TYPE_pause
} world_wideplaying_type;

struct _world_wide {
	GTypeInstance parent_instance;
	volatile int ref_count;
	world_widePrivate * priv;
	console* con;
	key_maps* keys;
	auditive* player;
	playlist* play_screen;
	viewlist* view_screen;
	external* ext_screen;
	dbg* debug;
	help* help_screen;
	GList* files_array;
	GList* keys_array;
	world_widescreen_type screen_current;
	world_wideplaying_type playing_state;
	gint screen_files;
	gboolean play_advance;
	screen* playing_screen;
	gint playlist_position;
};

struct _world_wideClass {
	GTypeClass parent_class;
	void (*finalize) (world_wide *self);
};


static gpointer dbg_parent_class = NULL;

gpointer screen_ref (gpointer instance);
void screen_unref (gpointer instance);
GParamSpec* param_spec_screen (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_screen (GValue* value, gpointer v_object);
void value_take_screen (GValue* value, gpointer v_object);
gpointer value_get_screen (const GValue* value);
GType screen_get_type (void) G_GNUC_CONST;
GType world_wide_screen_type_get_type (void) G_GNUC_CONST;
gpointer world_wide_ref (gpointer instance);
void world_wide_unref (gpointer instance);
GParamSpec* param_spec_world_wide (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_world_wide (GValue* value, gpointer v_object);
void value_take_world_wide (GValue* value, gpointer v_object);
gpointer value_get_world_wide (const GValue* value);
GType world_wide_get_type (void) G_GNUC_CONST;
GType dbg_get_type (void) G_GNUC_CONST;
enum  {
	DBG_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
#define DBG_max_lines 100
dbg* dbg_new (world_wide* w);
dbg* dbg_construct (GType object_type, world_wide* w);
screen* screen_construct (GType object_type);
static gboolean dbg_real_has_title (screen* base);
static gint dbg_real_get_size (screen* base);
static gchar* dbg_real_get_line (screen* base, guint num);
static world_widescreen_type dbg_real_get_screen_type (screen* base);
static void dbg_real_key_press (screen* base, gint key_num);
void screen_key_press (screen* self, gint key_num);
void dbg_add (dbg* self, const gchar* text);
void screen_draw (screen* self);
void dbg_alert (dbg* self, const gchar* text);
gpointer console_ref (gpointer instance);
void console_unref (gpointer instance);
GParamSpec* param_spec_console (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_console (GValue* value, gpointer v_object);
void value_take_console (GValue* value, gpointer v_object);
gpointer value_get_console (const GValue* value);
GType console_get_type (void) G_GNUC_CONST;
gpointer key_maps_ref (gpointer instance);
void key_maps_unref (gpointer instance);
GParamSpec* param_spec_key_maps (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_key_maps (GValue* value, gpointer v_object);
void value_take_key_maps (GValue* value, gpointer v_object);
gpointer value_get_key_maps (const GValue* value);
GType key_maps_get_type (void) G_GNUC_CONST;
gpointer auditive_ref (gpointer instance);
void auditive_unref (gpointer instance);
GParamSpec* param_spec_auditive (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_auditive (GValue* value, gpointer v_object);
void value_take_auditive (GValue* value, gpointer v_object);
gpointer value_get_auditive (const GValue* value);
GType auditive_get_type (void) G_GNUC_CONST;
GType playlist_get_type (void) G_GNUC_CONST;
GType viewlist_get_type (void) G_GNUC_CONST;
GType external_get_type (void) G_GNUC_CONST;
GType help_get_type (void) G_GNUC_CONST;
GType files_get_type (void) G_GNUC_CONST;
gpointer method_ref (gpointer instance);
void method_unref (gpointer instance);
GParamSpec* param_spec_method (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_method (GValue* value, gpointer v_object);
void value_take_method (GValue* value, gpointer v_object);
gpointer value_get_method (const GValue* value);
GType method_get_type (void) G_GNUC_CONST;
GType world_wide_playing_type_get_type (void) G_GNUC_CONST;
void console_print_inverse_at (console* self, gint x, gint y, const gchar* text);
static void dbg_finalize (screen* obj);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


dbg* dbg_construct (GType object_type, world_wide* w) {
	dbg* self = NULL;
	world_wide* _tmp0_;
	self = (dbg*) screen_construct (object_type);
	_tmp0_ = w;
	((screen*) self)->world = _tmp0_;
	return self;
}


dbg* dbg_new (world_wide* w) {
	return dbg_construct (TYPE_DBG, w);
}


static gboolean dbg_real_has_title (screen* base) {
	dbg * self;
	gboolean result = FALSE;
	self = (dbg*) base;
	result = FALSE;
	return result;
}


static gint dbg_real_get_size (screen* base) {
	dbg * self;
	gint result = 0;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	self = (dbg*) base;
	_tmp0_ = self->lines;
	_tmp1_ = g_list_length (_tmp0_);
	result = (gint) _tmp1_;
	return result;
}


static gchar* dbg_real_get_line (screen* base, guint num) {
	dbg * self;
	gchar* result = NULL;
	GList* _tmp0_;
	guint _tmp1_;
	gconstpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	self = (dbg*) base;
	_tmp0_ = self->lines;
	_tmp1_ = num;
	_tmp2_ = g_list_nth_data (_tmp0_, _tmp1_);
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	result = _tmp3_;
	return result;
}


static world_widescreen_type dbg_real_get_screen_type (screen* base) {
	dbg * self;
	world_widescreen_type result = 0;
	self = (dbg*) base;
	result = WORLD_WIDE_SCREEN_TYPE_debug;
	return result;
}


static void dbg_real_key_press (screen* base, gint key_num) {
	dbg * self;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	self = (dbg*) base;
	_tmp0_ = key_num;
	SCREEN_CLASS (dbg_parent_class)->key_press (SCREEN (self), _tmp0_);
	_tmp1_ = ((screen*) self)->key_handled;
	if (_tmp1_ == (-1)) {
		return;
	}
	_tmp2_ = key_num;
	_tmp3_ = g_strdup_printf ("Keycode: %d", _tmp2_);
	_tmp4_ = _tmp3_;
	dbg_add (self, _tmp4_);
	_g_free0 (_tmp4_);
	screen_draw ((screen*) self);
}


void dbg_add (dbg* self, const gchar* text) {
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	while (TRUE) {
		GList* _tmp0_;
		guint _tmp1_ = 0U;
		GList* _tmp2_;
		GList* _tmp3_ = NULL;
		_tmp0_ = self->lines;
		_tmp1_ = g_list_length (_tmp0_);
		if (!(_tmp1_ >= ((guint) DBG_max_lines))) {
			break;
		}
		_tmp2_ = self->lines;
		_tmp3_ = g_list_first (_tmp2_);
		self->lines = g_list_delete_link (self->lines, _tmp3_);
	}
	_tmp4_ = text;
	_tmp5_ = g_strdup (_tmp4_);
	self->lines = g_list_append (self->lines, _tmp5_);
}


void dbg_alert (dbg* self, const gchar* text) {
	world_wide* _tmp0_;
	console* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = ((screen*) self)->world;
	_tmp1_ = _tmp0_->con;
	_tmp2_ = text;
	_tmp3_ = g_strconcat ("  ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	console_print_inverse_at (_tmp1_, 0, 1, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = text;
	dbg_add (self, _tmp5_);
}


static void dbg_class_init (dbgClass * klass) {
	dbg_parent_class = g_type_class_peek_parent (klass);
	SCREEN_CLASS (klass)->finalize = dbg_finalize;
	SCREEN_CLASS (klass)->has_title = dbg_real_has_title;
	SCREEN_CLASS (klass)->get_size = dbg_real_get_size;
	SCREEN_CLASS (klass)->get_line = dbg_real_get_line;
	SCREEN_CLASS (klass)->get_screen_type = dbg_real_get_screen_type;
	SCREEN_CLASS (klass)->key_press = dbg_real_key_press;
}


static void dbg_instance_init (dbg * self) {
}


static void dbg_finalize (screen* obj) {
	dbg * self;
	self = DBG (obj);
	__g_list_free__g_free0_0 (self->lines);
	SCREEN_CLASS (dbg_parent_class)->finalize (obj);
}


GType dbg_get_type (void) {
	static volatile gsize dbg_type_id__volatile = 0;
	if (g_once_init_enter (&dbg_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (dbgClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dbg_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (dbg), 0, (GInstanceInitFunc) dbg_instance_init, NULL };
		GType dbg_type_id;
		dbg_type_id = g_type_register_static (TYPE_SCREEN, "dbg", &g_define_type_info, 0);
		g_once_init_leave (&dbg_type_id__volatile, dbg_type_id);
	}
	return dbg_type_id__volatile;
}



