
! Copyright (C) 2023 J. K. Dewhurst and S. Sharma.
! This file is distributed under the terms of the GNU General Public License.
! See the file COPYING for license details.

complex(8) function zcfinp(cfmt1,cfir1,cfmt2,cfir2)
use modmain
use modomp
implicit none
! arguments
complex(4), intent(in) :: cfmt1(npcmtmax,natmtot),cfir1(ngtc)
complex(4), intent(in) :: cfmt2(npcmtmax,natmtot),cfir2(ngtc)
! local variables
integer is,ias,nthd
! external functions
complex(4), external :: cdotc
complex(8), external :: zcfmtinp
! interstitial contribution (requires that one of the functions has been
! multiplied by the characteristic function)
zcfinp=cdotc(ngtc,cfir1,1,cfir2,1)
zcfinp=zcfinp*omega/dble(ngtc)
! muffin-tin contribution
call holdthd(natmtot,nthd)
!$OMP PARALLEL DO DEFAULT(SHARED) &
!$OMP PRIVATE(is) REDUCTION(+:zcfinp) &
!$OMP NUM_THREADS(nthd)
do ias=1,natmtot
  is=idxis(ias)
  zcfinp=zcfinp+zcfmtinp(nrcmt(is),nrcmti(is),wrcmt(:,is),cfmt1(:,ias), &
   cfmt2(:,ias))
end do
!$OMP END PARALLEL DO
call freethd(nthd)
end function

