/*
 * @(#)IScreenScraper.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.uicapture.v1;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;


/**
 * This interface defines a class which can save an Image to a file.  The
 * writing may be compressed, lossy, or whatever, just as long as a proper
 * file Diff of the same Image (but different files) will result in no
 * differences.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   Jan 7, 2002
 */
public interface IScreenScraper
{

    //-------------------------------------------------------------------------
    // Public methods
    
    /**
     * Write the given image to the given file.
     *
     * @param image The screen image to write to disk.
     * @param file The File to save the image as.
     * @exception IOException thrown if there was a problem saving the image to
     *		the file.
     */
    public void writeImageToFile( BufferedImage image, File file )
            throws IOException;
    
    
    /**
     * Discover the file extention for images created by this scraper.
     * This does not include a '.'.
     *
     * @return the extention for files this scraper writes.
     */
    public String getFileExtention();
}

