# -*- coding: utf-8 -*-
"""
Pygments (light) version of the sublime Mariana theme.

Pygments template by Jan T. Sott (https://github.com/idleberg)
"""

from pygments.style import Style
from pygments.token import (
    Keyword,
    Name,
    Comment,
    String,
    Error,
    Text,
    Number,
    Operator,
    Generic,
    Whitespace,
    Punctuation,
    Other,
    Literal,
)


BACKGROUND = "#f8f9fb"
CURRENT_LINE = "#b7c0c8"
SELECTION = "#d0d6dc"
FOREGROUND = "#161c27"
COMMENT = "#8d95a5"
RED = "#e7323b"
ORANGE = "#f79626"
YELLOW = "#f9b52f"
GREEN = "#70b069"
AQUA = "#3d8f88"
BLUE = "#407fbf"
PURPLE = "#b474b4"


class MarianaLight(Style):
    default_style = ""

    background_color = BACKGROUND
    highlight_color = SELECTION

    background_color = BACKGROUND
    highlight_color = SELECTION

    styles = {
        # No corresponding class for the following:
        Text: FOREGROUND,  # class:  ''
        Whitespace: "",  # class: 'w'
        Error: RED,  # class: 'err'
        Other: "",  # class 'x'
        Comment: COMMENT,  # class: 'c'
        Comment.Multiline: "",  # class: 'cm'
        Comment.Preproc: "",  # class: 'cp'
        Comment.Single: "",  # class: 'c1'
        Comment.Special: "",  # class: 'cs'
        Keyword: PURPLE,  # class: 'k'
        Keyword.Constant: RED,  # class: 'kc'
        Keyword.Declaration: "",  # class: 'kd'
        Keyword.Namespace: PURPLE,  # class: 'kn'
        Keyword.Pseudo: RED,  # class: 'kp'
        Keyword.Reserved: "",  # class: 'kr'
        Keyword.Type: YELLOW,  # class: 'kt'
        Operator: RED,  # class: 'o'
        Operator.Word: "",  # class: 'ow' - like keywords
        Punctuation: AQUA,  # class: 'p'
        Name: FOREGROUND,  # class: 'n'
        Name.Attribute: BLUE,  # class: 'na' - to be revised
        Name.Builtin: BLUE,  # class: 'nb'
        Name.Builtin.Pseudo: RED,  # class: 'bp'
        Name.Class: ORANGE,  # class: 'nc' - to be revised
        Name.Constant: RED,  # class: 'no' - to be revised
        Name.Decorator: AQUA,  # class: 'nd' - to be revised
        Name.Entity: BLUE,  # class: 'ni'
        Name.Exception: RED,  # class: 'ne'
        Name.Function: AQUA,  # class: 'nf'
        Name.Function.Magic: BLUE,  # class: 'nf'
        Name.Property: BLUE,  # class: 'py'
        Name.Label: BLUE,  # class: 'nl'
        Name.Namespace: BLUE,  # class: 'nn' - to be revised
        Name.Other: BLUE,  # class: 'nx'
        Name.Tag: AQUA,  # class: 'nt' - like a keyword
        Name.Variable: RED,  # class: 'nv' - to be revised
        Name.Variable.Class: "",  # class: 'vc' - to be revised
        Name.Variable.Global: "",  # class: 'vg' - to be revised
        Name.Variable.Instance: "",  # class: 'vi' - to be revised
        Number: ORANGE,  # class: 'm'
        Number.Float: "",  # class: 'mf'
        Number.Hex: "",  # class: 'mh'
        Number.Integer: "",  # class: 'mi'
        Number.Integer.Long: "",  # class: 'il'
        Number.Oct: "",  # class: 'mo'
        Literal: ORANGE,  # class: 'l'
        Literal.Date: GREEN,  # class: 'ld'
        String: GREEN,  # class: 's'
        String.Backtick: "",  # class: 'sb'
        String.Char: FOREGROUND,  # class: 'sc'
        String.Doc: COMMENT,  # class: 'sd' - like a comment
        String.Double: "",  # class: 's2'
        String.Escape: ORANGE,  # class: 'se'
        String.Heredoc: "",  # class: 'sh'
        String.Interpol: ORANGE,  # class: 'si'
        String.Other: "",  # class: 'sx'
        String.Regex: "",  # class: 'sr'
        String.Single: "",  # class: 's1'
        String.Symbol: "",  # class: 'ss'
        Generic: "",  # class: 'g'
        Generic.Deleted: RED,  # class: 'gd',
        Generic.Emph: "italic",  # class: 'ge'
        Generic.Error: "",  # class: 'gr'
        Generic.Heading: "bold " + FOREGROUND,  # class: 'gh'
        Generic.Inserted: GREEN,  # class: 'gi'
        Generic.Output: "",  # class: 'go'
        Generic.Prompt: "bold " + COMMENT,  # class: 'gp'
        Generic.Strong: "bold",  # class: 'gs'
        Generic.Subheading: "bold " + AQUA,  # class: 'gu'
        Generic.Traceback: "",  # class: 'gt'
    }
