# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AssetItem(Model):
    """Information about an asset associated with the web service.

    :param name: Asset's friendly name.
    :type name: str
    :param id: Asset's Id.
    :type id: str
    :param type: Asset's type. Possible values include: 'Module', 'Resource'
    :type type: str or :class:`AssetType
     <azure.mgmt.machinelearning.models.AssetType>`
    :param location_info: Access information for the asset.
    :type location_info: :class:`AssetLocation
     <azure.mgmt.machinelearning.models.AssetLocation>`
    :param input_ports: Information about the asset's input ports.
    :type input_ports: dict
    :param output_ports: Information about the asset's output ports.
    :type output_ports: dict
    :param metadata: If the asset is a custom module, this holds the module's
     metadata.
    :type metadata: dict
    :param parameters: If the asset is a custom module, this holds the
     module's parameters.
    :type parameters: list of :class:`ModuleAssetParameter
     <azure.mgmt.machinelearning.models.ModuleAssetParameter>`
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'location_info': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location_info': {'key': 'locationInfo', 'type': 'AssetLocation'},
        'input_ports': {'key': 'inputPorts', 'type': '{InputPort}'},
        'output_ports': {'key': 'outputPorts', 'type': '{OutputPort}'},
        'metadata': {'key': 'metadata', 'type': '{str}'},
        'parameters': {'key': 'parameters', 'type': '[ModuleAssetParameter]'},
    }

    def __init__(self, name, type, location_info, id=None, input_ports=None, output_ports=None, metadata=None, parameters=None):
        self.name = name
        self.id = id
        self.type = type
        self.location_info = location_info
        self.input_ports = input_ports
        self.output_ports = output_ports
        self.metadata = metadata
        self.parameters = parameters
