# -*- coding: utf-8 -*-
# Auto-generated by Stone, do not modify.
# @generated
# flake8: noqa
# pylint: skip-file
"""
This namespace contains helpers for property and template metadata endpoints.

These endpoints enable you to tag arbitrary key/value data to Dropbox files.

The most basic unit in this namespace is the :type:`PropertyField`. These fields encapsulate the actual key/value data.

Fields are added to a Dropbox file using a :type:`PropertyGroup`. Property groups contain a reference to a Dropbox file and a :type:`PropertyGroupTemplate`. Property groups are uniquely identified by the combination of their associated Dropbox file and template.

The :type:`PropertyGroupTemplate` is a way of restricting the possible key names and value types of the data within a property group. The possible key names and value types are explicitly enumerated using :type:`PropertyFieldTemplate` objects.

You can think of a property group template as a class definition for a particular key/value metadata object, and the property groups themselves as the instantiations of these objects.

Templates are owned either by a user/app pair or team/app pair. Templates and their associated properties can't be accessed by any app other than the app that created them, and even then, only when the app is linked with the owner of the template (either a user or team).

User-owned templates are accessed via the user-auth template/*_for_user endpoints, while team-owned templates are accessed via the team-auth template/*_for_team endpoints. Properties associated with either type of template can be accessed via the user-auth properties/* endpoints.

Finally, properties can be accessed from a number of endpoints that return metadata, including `files/get_metadata`, and `files/list_folder`. Properties can also be added during upload, using `files/upload`.
"""

try:
    from . import stone_validators as bv
    from . import stone_base as bb
except (ImportError, SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import stone_validators as bv
    import stone_base as bb

class AddPropertiesArg(object):
    """
    :ivar path: A unique identifier for the file or folder.
    :ivar property_groups: The property groups which are to be added to a
        Dropbox file.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_property_groups_value',
        '_property_groups_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 property_groups=None):
        self._path_value = None
        self._path_present = False
        self._property_groups_value = None
        self._property_groups_present = False
        if path is not None:
            self.path = path
        if property_groups is not None:
            self.property_groups = property_groups

    @property
    def path(self):
        """
        A unique identifier for the file or folder.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def property_groups(self):
        """
        The property groups which are to be added to a Dropbox file.

        :rtype: list of [PropertyGroup]
        """
        if self._property_groups_present:
            return self._property_groups_value
        else:
            raise AttributeError("missing required field 'property_groups'")

    @property_groups.setter
    def property_groups(self, val):
        val = self._property_groups_validator.validate(val)
        self._property_groups_value = val
        self._property_groups_present = True

    @property_groups.deleter
    def property_groups(self):
        self._property_groups_value = None
        self._property_groups_present = False

    def __repr__(self):
        return 'AddPropertiesArg(path={!r}, property_groups={!r})'.format(
            self._path_value,
            self._property_groups_value,
        )

AddPropertiesArg_validator = bv.Struct(AddPropertiesArg)

class TemplateError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar str template_not_found: Template does not exist for the given
        identifier.
    :ivar restricted_content: You do not have permission to modify this
        template.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    restricted_content = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def template_not_found(cls, val):
        """
        Create an instance of this class set to the ``template_not_found`` tag
        with value ``val``.

        :param str val:
        :rtype: TemplateError
        """
        return cls('template_not_found', val)

    def is_template_not_found(self):
        """
        Check if the union tag is ``template_not_found``.

        :rtype: bool
        """
        return self._tag == 'template_not_found'

    def is_restricted_content(self):
        """
        Check if the union tag is ``restricted_content``.

        :rtype: bool
        """
        return self._tag == 'restricted_content'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_template_not_found(self):
        """
        Template does not exist for the given identifier.

        Only call this if :meth:`is_template_not_found` is true.

        :rtype: str
        """
        if not self.is_template_not_found():
            raise AttributeError("tag 'template_not_found' not set")
        return self._value

    def __repr__(self):
        return 'TemplateError(%r, %r)' % (self._tag, self._value)

TemplateError_validator = bv.Union(TemplateError)

class PropertiesError(TemplateError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar unsupported_folder: This folder cannot be tagged. Tagging folders is
        not supported for team-owned templates.
    """

    # Attribute is overwritten below the class definition
    unsupported_folder = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: PropertiesError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_unsupported_folder(self):
        """
        Check if the union tag is ``unsupported_folder``.

        :rtype: bool
        """
        return self._tag == 'unsupported_folder'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'PropertiesError(%r, %r)' % (self._tag, self._value)

PropertiesError_validator = bv.Union(PropertiesError)

class InvalidPropertyGroupError(PropertiesError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar property_field_too_large: One or more of the supplied property field
        values is too large.
    :ivar does_not_fit_template: One or more of the supplied property fields
        does not conform to the template specifications.
    """

    # Attribute is overwritten below the class definition
    property_field_too_large = None
    # Attribute is overwritten below the class definition
    does_not_fit_template = None

    def is_property_field_too_large(self):
        """
        Check if the union tag is ``property_field_too_large``.

        :rtype: bool
        """
        return self._tag == 'property_field_too_large'

    def is_does_not_fit_template(self):
        """
        Check if the union tag is ``does_not_fit_template``.

        :rtype: bool
        """
        return self._tag == 'does_not_fit_template'

    def __repr__(self):
        return 'InvalidPropertyGroupError(%r, %r)' % (self._tag, self._value)

InvalidPropertyGroupError_validator = bv.Union(InvalidPropertyGroupError)

class AddPropertiesError(InvalidPropertyGroupError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar property_group_already_exists: A property group associated with this
        template and file already exists.
    """

    # Attribute is overwritten below the class definition
    property_group_already_exists = None

    def is_property_group_already_exists(self):
        """
        Check if the union tag is ``property_group_already_exists``.

        :rtype: bool
        """
        return self._tag == 'property_group_already_exists'

    def __repr__(self):
        return 'AddPropertiesError(%r, %r)' % (self._tag, self._value)

AddPropertiesError_validator = bv.Union(AddPropertiesError)

class PropertyGroupTemplate(object):
    """
    Defines how a property group may be structured.

    :ivar name: Display name for the template. Template names can be up to 256
        bytes.
    :ivar description: Description for the template. Template descriptions can
        be up to 1024 bytes.
    :ivar fields: Definitions of the property fields associated with this
        template. There can be up to 32 properties in a single template.
    """

    __slots__ = [
        '_name_value',
        '_name_present',
        '_description_value',
        '_description_present',
        '_fields_value',
        '_fields_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 name=None,
                 description=None,
                 fields=None):
        self._name_value = None
        self._name_present = False
        self._description_value = None
        self._description_present = False
        self._fields_value = None
        self._fields_present = False
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if fields is not None:
            self.fields = fields

    @property
    def name(self):
        """
        Display name for the template. Template names can be up to 256 bytes.

        :rtype: str
        """
        if self._name_present:
            return self._name_value
        else:
            raise AttributeError("missing required field 'name'")

    @name.setter
    def name(self, val):
        val = self._name_validator.validate(val)
        self._name_value = val
        self._name_present = True

    @name.deleter
    def name(self):
        self._name_value = None
        self._name_present = False

    @property
    def description(self):
        """
        Description for the template. Template descriptions can be up to 1024
        bytes.

        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    @property
    def fields(self):
        """
        Definitions of the property fields associated with this template. There
        can be up to 32 properties in a single template.

        :rtype: list of [PropertyFieldTemplate]
        """
        if self._fields_present:
            return self._fields_value
        else:
            raise AttributeError("missing required field 'fields'")

    @fields.setter
    def fields(self, val):
        val = self._fields_validator.validate(val)
        self._fields_value = val
        self._fields_present = True

    @fields.deleter
    def fields(self):
        self._fields_value = None
        self._fields_present = False

    def __repr__(self):
        return 'PropertyGroupTemplate(name={!r}, description={!r}, fields={!r})'.format(
            self._name_value,
            self._description_value,
            self._fields_value,
        )

PropertyGroupTemplate_validator = bv.Struct(PropertyGroupTemplate)

class AddTemplateArg(PropertyGroupTemplate):

    __slots__ = [
    ]

    _has_required_fields = True

    def __init__(self,
                 name=None,
                 description=None,
                 fields=None):
        super(AddTemplateArg, self).__init__(name,
                                             description,
                                             fields)

    def __repr__(self):
        return 'AddTemplateArg(name={!r}, description={!r}, fields={!r})'.format(
            self._name_value,
            self._description_value,
            self._fields_value,
        )

AddTemplateArg_validator = bv.Struct(AddTemplateArg)

class AddTemplateResult(object):
    """
    :ivar template_id: An identifier for template added by  See
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_user`
        or
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_team`.
    """

    __slots__ = [
        '_template_id_value',
        '_template_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 template_id=None):
        self._template_id_value = None
        self._template_id_present = False
        if template_id is not None:
            self.template_id = template_id

    @property
    def template_id(self):
        """
        An identifier for template added by  See
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_user`
        or
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_team`.

        :rtype: str
        """
        if self._template_id_present:
            return self._template_id_value
        else:
            raise AttributeError("missing required field 'template_id'")

    @template_id.setter
    def template_id(self, val):
        val = self._template_id_validator.validate(val)
        self._template_id_value = val
        self._template_id_present = True

    @template_id.deleter
    def template_id(self):
        self._template_id_value = None
        self._template_id_present = False

    def __repr__(self):
        return 'AddTemplateResult(template_id={!r})'.format(
            self._template_id_value,
        )

AddTemplateResult_validator = bv.Struct(AddTemplateResult)

class GetTemplateArg(object):
    """
    :ivar template_id: An identifier for template added by route  See
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_user`
        or
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_team`.
    """

    __slots__ = [
        '_template_id_value',
        '_template_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 template_id=None):
        self._template_id_value = None
        self._template_id_present = False
        if template_id is not None:
            self.template_id = template_id

    @property
    def template_id(self):
        """
        An identifier for template added by route  See
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_user`
        or
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_team`.

        :rtype: str
        """
        if self._template_id_present:
            return self._template_id_value
        else:
            raise AttributeError("missing required field 'template_id'")

    @template_id.setter
    def template_id(self, val):
        val = self._template_id_validator.validate(val)
        self._template_id_value = val
        self._template_id_present = True

    @template_id.deleter
    def template_id(self):
        self._template_id_value = None
        self._template_id_present = False

    def __repr__(self):
        return 'GetTemplateArg(template_id={!r})'.format(
            self._template_id_value,
        )

GetTemplateArg_validator = bv.Struct(GetTemplateArg)

class GetTemplateResult(PropertyGroupTemplate):

    __slots__ = [
    ]

    _has_required_fields = True

    def __init__(self,
                 name=None,
                 description=None,
                 fields=None):
        super(GetTemplateResult, self).__init__(name,
                                                description,
                                                fields)

    def __repr__(self):
        return 'GetTemplateResult(name={!r}, description={!r}, fields={!r})'.format(
            self._name_value,
            self._description_value,
            self._fields_value,
        )

GetTemplateResult_validator = bv.Struct(GetTemplateResult)

class ListTemplateResult(object):
    """
    :ivar template_ids: List of identifiers for templates added by  See
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_user`
        or
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_team`.
    """

    __slots__ = [
        '_template_ids_value',
        '_template_ids_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 template_ids=None):
        self._template_ids_value = None
        self._template_ids_present = False
        if template_ids is not None:
            self.template_ids = template_ids

    @property
    def template_ids(self):
        """
        List of identifiers for templates added by  See
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_user`
        or
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_team`.

        :rtype: list of [str]
        """
        if self._template_ids_present:
            return self._template_ids_value
        else:
            raise AttributeError("missing required field 'template_ids'")

    @template_ids.setter
    def template_ids(self, val):
        val = self._template_ids_validator.validate(val)
        self._template_ids_value = val
        self._template_ids_present = True

    @template_ids.deleter
    def template_ids(self):
        self._template_ids_value = None
        self._template_ids_present = False

    def __repr__(self):
        return 'ListTemplateResult(template_ids={!r})'.format(
            self._template_ids_value,
        )

ListTemplateResult_validator = bv.Struct(ListTemplateResult)

class LogicalOperator(bb.Union):
    """
    Logical operator to join search queries together.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar or_operator: Append a query with an "or" operator.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    or_operator = None
    # Attribute is overwritten below the class definition
    other = None

    def is_or_operator(self):
        """
        Check if the union tag is ``or_operator``.

        :rtype: bool
        """
        return self._tag == 'or_operator'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'LogicalOperator(%r, %r)' % (self._tag, self._value)

LogicalOperator_validator = bv.Union(LogicalOperator)

class LookUpPropertiesError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar property_group_not_found: No property group was found.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    property_group_not_found = None
    # Attribute is overwritten below the class definition
    other = None

    def is_property_group_not_found(self):
        """
        Check if the union tag is ``property_group_not_found``.

        :rtype: bool
        """
        return self._tag == 'property_group_not_found'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'LookUpPropertiesError(%r, %r)' % (self._tag, self._value)

LookUpPropertiesError_validator = bv.Union(LookUpPropertiesError)

class LookupError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar not_found: There is nothing at the given path.
    :ivar not_file: We were expecting a file, but the given path refers to
        something that isn't a file.
    :ivar not_folder: We were expecting a folder, but the given path refers to
        something that isn't a folder.
    :ivar restricted_content: The file cannot be transferred because the content
        is restricted.  For example, sometimes there are legal restrictions due
        to copyright claims.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    not_found = None
    # Attribute is overwritten below the class definition
    not_file = None
    # Attribute is overwritten below the class definition
    not_folder = None
    # Attribute is overwritten below the class definition
    restricted_content = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def malformed_path(cls, val):
        """
        Create an instance of this class set to the ``malformed_path`` tag with
        value ``val``.

        :param str val:
        :rtype: LookupError
        """
        return cls('malformed_path', val)

    def is_malformed_path(self):
        """
        Check if the union tag is ``malformed_path``.

        :rtype: bool
        """
        return self._tag == 'malformed_path'

    def is_not_found(self):
        """
        Check if the union tag is ``not_found``.

        :rtype: bool
        """
        return self._tag == 'not_found'

    def is_not_file(self):
        """
        Check if the union tag is ``not_file``.

        :rtype: bool
        """
        return self._tag == 'not_file'

    def is_not_folder(self):
        """
        Check if the union tag is ``not_folder``.

        :rtype: bool
        """
        return self._tag == 'not_folder'

    def is_restricted_content(self):
        """
        Check if the union tag is ``restricted_content``.

        :rtype: bool
        """
        return self._tag == 'restricted_content'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_malformed_path(self):
        """
        Only call this if :meth:`is_malformed_path` is true.

        :rtype: str
        """
        if not self.is_malformed_path():
            raise AttributeError("tag 'malformed_path' not set")
        return self._value

    def __repr__(self):
        return 'LookupError(%r, %r)' % (self._tag, self._value)

LookupError_validator = bv.Union(LookupError)

class ModifyTemplateError(TemplateError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar conflicting_property_names: A property field key with that name
        already exists in the template.
    :ivar too_many_properties: There are too many properties in the changed
        template. The maximum number of properties per template is 32.
    :ivar too_many_templates: There are too many templates for the team.
    :ivar template_attribute_too_large: The template name, description or one or
        more of the property field keys is too large.
    """

    # Attribute is overwritten below the class definition
    conflicting_property_names = None
    # Attribute is overwritten below the class definition
    too_many_properties = None
    # Attribute is overwritten below the class definition
    too_many_templates = None
    # Attribute is overwritten below the class definition
    template_attribute_too_large = None

    def is_conflicting_property_names(self):
        """
        Check if the union tag is ``conflicting_property_names``.

        :rtype: bool
        """
        return self._tag == 'conflicting_property_names'

    def is_too_many_properties(self):
        """
        Check if the union tag is ``too_many_properties``.

        :rtype: bool
        """
        return self._tag == 'too_many_properties'

    def is_too_many_templates(self):
        """
        Check if the union tag is ``too_many_templates``.

        :rtype: bool
        """
        return self._tag == 'too_many_templates'

    def is_template_attribute_too_large(self):
        """
        Check if the union tag is ``template_attribute_too_large``.

        :rtype: bool
        """
        return self._tag == 'template_attribute_too_large'

    def __repr__(self):
        return 'ModifyTemplateError(%r, %r)' % (self._tag, self._value)

ModifyTemplateError_validator = bv.Union(ModifyTemplateError)

class OverwritePropertyGroupArg(object):
    """
    :ivar path: A unique identifier for the file or folder.
    :ivar property_groups: The property groups "snapshot" updates to force
        apply.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_property_groups_value',
        '_property_groups_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 property_groups=None):
        self._path_value = None
        self._path_present = False
        self._property_groups_value = None
        self._property_groups_present = False
        if path is not None:
            self.path = path
        if property_groups is not None:
            self.property_groups = property_groups

    @property
    def path(self):
        """
        A unique identifier for the file or folder.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def property_groups(self):
        """
        The property groups "snapshot" updates to force apply.

        :rtype: list of [PropertyGroup]
        """
        if self._property_groups_present:
            return self._property_groups_value
        else:
            raise AttributeError("missing required field 'property_groups'")

    @property_groups.setter
    def property_groups(self, val):
        val = self._property_groups_validator.validate(val)
        self._property_groups_value = val
        self._property_groups_present = True

    @property_groups.deleter
    def property_groups(self):
        self._property_groups_value = None
        self._property_groups_present = False

    def __repr__(self):
        return 'OverwritePropertyGroupArg(path={!r}, property_groups={!r})'.format(
            self._path_value,
            self._property_groups_value,
        )

OverwritePropertyGroupArg_validator = bv.Struct(OverwritePropertyGroupArg)

class PropertiesSearchArg(object):
    """
    :ivar queries: Queries to search.
    :ivar template_filter: Filter results to contain only properties associated
        with these template IDs.
    """

    __slots__ = [
        '_queries_value',
        '_queries_present',
        '_template_filter_value',
        '_template_filter_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 queries=None,
                 template_filter=None):
        self._queries_value = None
        self._queries_present = False
        self._template_filter_value = None
        self._template_filter_present = False
        if queries is not None:
            self.queries = queries
        if template_filter is not None:
            self.template_filter = template_filter

    @property
    def queries(self):
        """
        Queries to search.

        :rtype: list of [PropertiesSearchQuery]
        """
        if self._queries_present:
            return self._queries_value
        else:
            raise AttributeError("missing required field 'queries'")

    @queries.setter
    def queries(self, val):
        val = self._queries_validator.validate(val)
        self._queries_value = val
        self._queries_present = True

    @queries.deleter
    def queries(self):
        self._queries_value = None
        self._queries_present = False

    @property
    def template_filter(self):
        """
        Filter results to contain only properties associated with these template
        IDs.

        :rtype: TemplateFilter
        """
        if self._template_filter_present:
            return self._template_filter_value
        else:
            return TemplateFilter.filter_none

    @template_filter.setter
    def template_filter(self, val):
        self._template_filter_validator.validate_type_only(val)
        self._template_filter_value = val
        self._template_filter_present = True

    @template_filter.deleter
    def template_filter(self):
        self._template_filter_value = None
        self._template_filter_present = False

    def __repr__(self):
        return 'PropertiesSearchArg(queries={!r}, template_filter={!r})'.format(
            self._queries_value,
            self._template_filter_value,
        )

PropertiesSearchArg_validator = bv.Struct(PropertiesSearchArg)

class PropertiesSearchContinueArg(object):
    """
    :ivar cursor: The cursor returned by your last call to
        :meth:`dropbox.dropbox.Dropbox.file_properties_properties_search` or
        :meth:`dropbox.dropbox.Dropbox.file_properties_properties_search_continue`.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None):
        self._cursor_value = None
        self._cursor_present = False
        if cursor is not None:
            self.cursor = cursor

    @property
    def cursor(self):
        """
        The cursor returned by your last call to
        :meth:`dropbox.dropbox.Dropbox.file_properties_properties_search` or
        :meth:`dropbox.dropbox.Dropbox.file_properties_properties_search_continue`.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'PropertiesSearchContinueArg(cursor={!r})'.format(
            self._cursor_value,
        )

PropertiesSearchContinueArg_validator = bv.Struct(PropertiesSearchContinueArg)

class PropertiesSearchContinueError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar reset: Indicates that the cursor has been invalidated. Call
        :meth:`dropbox.dropbox.Dropbox.file_properties_properties_search` to
        obtain a new cursor.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    reset = None
    # Attribute is overwritten below the class definition
    other = None

    def is_reset(self):
        """
        Check if the union tag is ``reset``.

        :rtype: bool
        """
        return self._tag == 'reset'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'PropertiesSearchContinueError(%r, %r)' % (self._tag, self._value)

PropertiesSearchContinueError_validator = bv.Union(PropertiesSearchContinueError)

class PropertiesSearchError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def property_group_lookup(cls, val):
        """
        Create an instance of this class set to the ``property_group_lookup``
        tag with value ``val``.

        :param LookUpPropertiesError val:
        :rtype: PropertiesSearchError
        """
        return cls('property_group_lookup', val)

    def is_property_group_lookup(self):
        """
        Check if the union tag is ``property_group_lookup``.

        :rtype: bool
        """
        return self._tag == 'property_group_lookup'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_property_group_lookup(self):
        """
        Only call this if :meth:`is_property_group_lookup` is true.

        :rtype: LookUpPropertiesError
        """
        if not self.is_property_group_lookup():
            raise AttributeError("tag 'property_group_lookup' not set")
        return self._value

    def __repr__(self):
        return 'PropertiesSearchError(%r, %r)' % (self._tag, self._value)

PropertiesSearchError_validator = bv.Union(PropertiesSearchError)

class PropertiesSearchMatch(object):
    """
    :ivar id: The ID for the matched file or folder.
    :ivar path: The path for the matched file or folder.
    :ivar is_deleted: Whether the file or folder is deleted.
    :ivar property_groups: List of custom property groups associated with the
        file.
    """

    __slots__ = [
        '_id_value',
        '_id_present',
        '_path_value',
        '_path_present',
        '_is_deleted_value',
        '_is_deleted_present',
        '_property_groups_value',
        '_property_groups_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 id=None,
                 path=None,
                 is_deleted=None,
                 property_groups=None):
        self._id_value = None
        self._id_present = False
        self._path_value = None
        self._path_present = False
        self._is_deleted_value = None
        self._is_deleted_present = False
        self._property_groups_value = None
        self._property_groups_present = False
        if id is not None:
            self.id = id
        if path is not None:
            self.path = path
        if is_deleted is not None:
            self.is_deleted = is_deleted
        if property_groups is not None:
            self.property_groups = property_groups

    @property
    def id(self):
        """
        The ID for the matched file or folder.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def path(self):
        """
        The path for the matched file or folder.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def is_deleted(self):
        """
        Whether the file or folder is deleted.

        :rtype: bool
        """
        if self._is_deleted_present:
            return self._is_deleted_value
        else:
            raise AttributeError("missing required field 'is_deleted'")

    @is_deleted.setter
    def is_deleted(self, val):
        val = self._is_deleted_validator.validate(val)
        self._is_deleted_value = val
        self._is_deleted_present = True

    @is_deleted.deleter
    def is_deleted(self):
        self._is_deleted_value = None
        self._is_deleted_present = False

    @property
    def property_groups(self):
        """
        List of custom property groups associated with the file.

        :rtype: list of [PropertyGroup]
        """
        if self._property_groups_present:
            return self._property_groups_value
        else:
            raise AttributeError("missing required field 'property_groups'")

    @property_groups.setter
    def property_groups(self, val):
        val = self._property_groups_validator.validate(val)
        self._property_groups_value = val
        self._property_groups_present = True

    @property_groups.deleter
    def property_groups(self):
        self._property_groups_value = None
        self._property_groups_present = False

    def __repr__(self):
        return 'PropertiesSearchMatch(id={!r}, path={!r}, is_deleted={!r}, property_groups={!r})'.format(
            self._id_value,
            self._path_value,
            self._is_deleted_value,
            self._property_groups_value,
        )

PropertiesSearchMatch_validator = bv.Struct(PropertiesSearchMatch)

class PropertiesSearchMode(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar str field_name: Search for a value associated with this field name.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def field_name(cls, val):
        """
        Create an instance of this class set to the ``field_name`` tag with
        value ``val``.

        :param str val:
        :rtype: PropertiesSearchMode
        """
        return cls('field_name', val)

    def is_field_name(self):
        """
        Check if the union tag is ``field_name``.

        :rtype: bool
        """
        return self._tag == 'field_name'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_field_name(self):
        """
        Search for a value associated with this field name.

        Only call this if :meth:`is_field_name` is true.

        :rtype: str
        """
        if not self.is_field_name():
            raise AttributeError("tag 'field_name' not set")
        return self._value

    def __repr__(self):
        return 'PropertiesSearchMode(%r, %r)' % (self._tag, self._value)

PropertiesSearchMode_validator = bv.Union(PropertiesSearchMode)

class PropertiesSearchQuery(object):
    """
    :ivar query: The property field value for which to search across templates.
    :ivar mode: The mode with which to perform the search.
    :ivar logical_operator: The logical operator with which to append the query.
    """

    __slots__ = [
        '_query_value',
        '_query_present',
        '_mode_value',
        '_mode_present',
        '_logical_operator_value',
        '_logical_operator_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 query=None,
                 mode=None,
                 logical_operator=None):
        self._query_value = None
        self._query_present = False
        self._mode_value = None
        self._mode_present = False
        self._logical_operator_value = None
        self._logical_operator_present = False
        if query is not None:
            self.query = query
        if mode is not None:
            self.mode = mode
        if logical_operator is not None:
            self.logical_operator = logical_operator

    @property
    def query(self):
        """
        The property field value for which to search across templates.

        :rtype: str
        """
        if self._query_present:
            return self._query_value
        else:
            raise AttributeError("missing required field 'query'")

    @query.setter
    def query(self, val):
        val = self._query_validator.validate(val)
        self._query_value = val
        self._query_present = True

    @query.deleter
    def query(self):
        self._query_value = None
        self._query_present = False

    @property
    def mode(self):
        """
        The mode with which to perform the search.

        :rtype: PropertiesSearchMode
        """
        if self._mode_present:
            return self._mode_value
        else:
            raise AttributeError("missing required field 'mode'")

    @mode.setter
    def mode(self, val):
        self._mode_validator.validate_type_only(val)
        self._mode_value = val
        self._mode_present = True

    @mode.deleter
    def mode(self):
        self._mode_value = None
        self._mode_present = False

    @property
    def logical_operator(self):
        """
        The logical operator with which to append the query.

        :rtype: LogicalOperator
        """
        if self._logical_operator_present:
            return self._logical_operator_value
        else:
            return LogicalOperator.or_operator

    @logical_operator.setter
    def logical_operator(self, val):
        self._logical_operator_validator.validate_type_only(val)
        self._logical_operator_value = val
        self._logical_operator_present = True

    @logical_operator.deleter
    def logical_operator(self):
        self._logical_operator_value = None
        self._logical_operator_present = False

    def __repr__(self):
        return 'PropertiesSearchQuery(query={!r}, mode={!r}, logical_operator={!r})'.format(
            self._query_value,
            self._mode_value,
            self._logical_operator_value,
        )

PropertiesSearchQuery_validator = bv.Struct(PropertiesSearchQuery)

class PropertiesSearchResult(object):
    """
    :ivar matches: A list (possibly empty) of matches for the query.
    :ivar cursor: Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.file_properties_properties_search_continue`
        to continue to receive search results. Cursor will be null when there
        are no more results.
    """

    __slots__ = [
        '_matches_value',
        '_matches_present',
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 matches=None,
                 cursor=None):
        self._matches_value = None
        self._matches_present = False
        self._cursor_value = None
        self._cursor_present = False
        if matches is not None:
            self.matches = matches
        if cursor is not None:
            self.cursor = cursor

    @property
    def matches(self):
        """
        A list (possibly empty) of matches for the query.

        :rtype: list of [PropertiesSearchMatch]
        """
        if self._matches_present:
            return self._matches_value
        else:
            raise AttributeError("missing required field 'matches'")

    @matches.setter
    def matches(self, val):
        val = self._matches_validator.validate(val)
        self._matches_value = val
        self._matches_present = True

    @matches.deleter
    def matches(self):
        self._matches_value = None
        self._matches_present = False

    @property
    def cursor(self):
        """
        Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.file_properties_properties_search_continue`
        to continue to receive search results. Cursor will be null when there
        are no more results.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            return None

    @cursor.setter
    def cursor(self, val):
        if val is None:
            del self.cursor
            return
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'PropertiesSearchResult(matches={!r}, cursor={!r})'.format(
            self._matches_value,
            self._cursor_value,
        )

PropertiesSearchResult_validator = bv.Struct(PropertiesSearchResult)

class PropertyField(object):
    """
    Raw key/value data to be associated with a Dropbox file. Property fields are
    added to Dropbox files as a :class:`PropertyGroup`.

    :ivar name: Key of the property field associated with a file and template.
        Keys can be up to 256 bytes.
    :ivar value: Value of the property field associated with a file and
        template. Values can be up to 1024 bytes.
    """

    __slots__ = [
        '_name_value',
        '_name_present',
        '_value_value',
        '_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 name=None,
                 value=None):
        self._name_value = None
        self._name_present = False
        self._value_value = None
        self._value_present = False
        if name is not None:
            self.name = name
        if value is not None:
            self.value = value

    @property
    def name(self):
        """
        Key of the property field associated with a file and template. Keys can
        be up to 256 bytes.

        :rtype: str
        """
        if self._name_present:
            return self._name_value
        else:
            raise AttributeError("missing required field 'name'")

    @name.setter
    def name(self, val):
        val = self._name_validator.validate(val)
        self._name_value = val
        self._name_present = True

    @name.deleter
    def name(self):
        self._name_value = None
        self._name_present = False

    @property
    def value(self):
        """
        Value of the property field associated with a file and template. Values
        can be up to 1024 bytes.

        :rtype: str
        """
        if self._value_present:
            return self._value_value
        else:
            raise AttributeError("missing required field 'value'")

    @value.setter
    def value(self, val):
        val = self._value_validator.validate(val)
        self._value_value = val
        self._value_present = True

    @value.deleter
    def value(self):
        self._value_value = None
        self._value_present = False

    def __repr__(self):
        return 'PropertyField(name={!r}, value={!r})'.format(
            self._name_value,
            self._value_value,
        )

PropertyField_validator = bv.Struct(PropertyField)

class PropertyFieldTemplate(object):
    """
    Defines how a single property field may be structured. Used exclusively by
    :class:`PropertyGroupTemplate`.

    :ivar name: Key of the property field being described. Property field keys
        can be up to 256 bytes.
    :ivar description: Description of the property field. Property field
        descriptions can be up to 1024 bytes.
    :ivar type: Data type of the value of this property field. This type will be
        enforced upon property creation and modifications.
    """

    __slots__ = [
        '_name_value',
        '_name_present',
        '_description_value',
        '_description_present',
        '_type_value',
        '_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 name=None,
                 description=None,
                 type=None):
        self._name_value = None
        self._name_present = False
        self._description_value = None
        self._description_present = False
        self._type_value = None
        self._type_present = False
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if type is not None:
            self.type = type

    @property
    def name(self):
        """
        Key of the property field being described. Property field keys can be up
        to 256 bytes.

        :rtype: str
        """
        if self._name_present:
            return self._name_value
        else:
            raise AttributeError("missing required field 'name'")

    @name.setter
    def name(self, val):
        val = self._name_validator.validate(val)
        self._name_value = val
        self._name_present = True

    @name.deleter
    def name(self):
        self._name_value = None
        self._name_present = False

    @property
    def description(self):
        """
        Description of the property field. Property field descriptions can be up
        to 1024 bytes.

        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    @property
    def type(self):
        """
        Data type of the value of this property field. This type will be
        enforced upon property creation and modifications.

        :rtype: PropertyType
        """
        if self._type_present:
            return self._type_value
        else:
            raise AttributeError("missing required field 'type'")

    @type.setter
    def type(self, val):
        self._type_validator.validate_type_only(val)
        self._type_value = val
        self._type_present = True

    @type.deleter
    def type(self):
        self._type_value = None
        self._type_present = False

    def __repr__(self):
        return 'PropertyFieldTemplate(name={!r}, description={!r}, type={!r})'.format(
            self._name_value,
            self._description_value,
            self._type_value,
        )

PropertyFieldTemplate_validator = bv.Struct(PropertyFieldTemplate)

class PropertyGroup(object):
    """
    A subset of the property fields described by the corresponding
    :class:`PropertyGroupTemplate`. Properties are always added to a Dropbox
    file as a :class:`PropertyGroup`. The possible key names and value types in
    this group are defined by the corresponding :class:`PropertyGroupTemplate`.

    :ivar template_id: A unique identifier for the associated template.
    :ivar fields: The actual properties associated with the template. There can
        be up to 32 property types per template.
    """

    __slots__ = [
        '_template_id_value',
        '_template_id_present',
        '_fields_value',
        '_fields_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 template_id=None,
                 fields=None):
        self._template_id_value = None
        self._template_id_present = False
        self._fields_value = None
        self._fields_present = False
        if template_id is not None:
            self.template_id = template_id
        if fields is not None:
            self.fields = fields

    @property
    def template_id(self):
        """
        A unique identifier for the associated template.

        :rtype: str
        """
        if self._template_id_present:
            return self._template_id_value
        else:
            raise AttributeError("missing required field 'template_id'")

    @template_id.setter
    def template_id(self, val):
        val = self._template_id_validator.validate(val)
        self._template_id_value = val
        self._template_id_present = True

    @template_id.deleter
    def template_id(self):
        self._template_id_value = None
        self._template_id_present = False

    @property
    def fields(self):
        """
        The actual properties associated with the template. There can be up to
        32 property types per template.

        :rtype: list of [PropertyField]
        """
        if self._fields_present:
            return self._fields_value
        else:
            raise AttributeError("missing required field 'fields'")

    @fields.setter
    def fields(self, val):
        val = self._fields_validator.validate(val)
        self._fields_value = val
        self._fields_present = True

    @fields.deleter
    def fields(self):
        self._fields_value = None
        self._fields_present = False

    def __repr__(self):
        return 'PropertyGroup(template_id={!r}, fields={!r})'.format(
            self._template_id_value,
            self._fields_value,
        )

PropertyGroup_validator = bv.Struct(PropertyGroup)

class PropertyGroupUpdate(object):
    """
    :ivar template_id: A unique identifier for a property template.
    :ivar add_or_update_fields: Property fields to update. If the property field
        already exists, it is updated. If the property field doesn't exist, the
        property group is added.
    :ivar remove_fields: Property fields to remove (by name), provided they
        exist.
    """

    __slots__ = [
        '_template_id_value',
        '_template_id_present',
        '_add_or_update_fields_value',
        '_add_or_update_fields_present',
        '_remove_fields_value',
        '_remove_fields_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 template_id=None,
                 add_or_update_fields=None,
                 remove_fields=None):
        self._template_id_value = None
        self._template_id_present = False
        self._add_or_update_fields_value = None
        self._add_or_update_fields_present = False
        self._remove_fields_value = None
        self._remove_fields_present = False
        if template_id is not None:
            self.template_id = template_id
        if add_or_update_fields is not None:
            self.add_or_update_fields = add_or_update_fields
        if remove_fields is not None:
            self.remove_fields = remove_fields

    @property
    def template_id(self):
        """
        A unique identifier for a property template.

        :rtype: str
        """
        if self._template_id_present:
            return self._template_id_value
        else:
            raise AttributeError("missing required field 'template_id'")

    @template_id.setter
    def template_id(self, val):
        val = self._template_id_validator.validate(val)
        self._template_id_value = val
        self._template_id_present = True

    @template_id.deleter
    def template_id(self):
        self._template_id_value = None
        self._template_id_present = False

    @property
    def add_or_update_fields(self):
        """
        Property fields to update. If the property field already exists, it is
        updated. If the property field doesn't exist, the property group is
        added.

        :rtype: list of [PropertyField]
        """
        if self._add_or_update_fields_present:
            return self._add_or_update_fields_value
        else:
            return None

    @add_or_update_fields.setter
    def add_or_update_fields(self, val):
        if val is None:
            del self.add_or_update_fields
            return
        val = self._add_or_update_fields_validator.validate(val)
        self._add_or_update_fields_value = val
        self._add_or_update_fields_present = True

    @add_or_update_fields.deleter
    def add_or_update_fields(self):
        self._add_or_update_fields_value = None
        self._add_or_update_fields_present = False

    @property
    def remove_fields(self):
        """
        Property fields to remove (by name), provided they exist.

        :rtype: list of [str]
        """
        if self._remove_fields_present:
            return self._remove_fields_value
        else:
            return None

    @remove_fields.setter
    def remove_fields(self, val):
        if val is None:
            del self.remove_fields
            return
        val = self._remove_fields_validator.validate(val)
        self._remove_fields_value = val
        self._remove_fields_present = True

    @remove_fields.deleter
    def remove_fields(self):
        self._remove_fields_value = None
        self._remove_fields_present = False

    def __repr__(self):
        return 'PropertyGroupUpdate(template_id={!r}, add_or_update_fields={!r}, remove_fields={!r})'.format(
            self._template_id_value,
            self._add_or_update_fields_value,
            self._remove_fields_value,
        )

PropertyGroupUpdate_validator = bv.Struct(PropertyGroupUpdate)

class PropertyType(bb.Union):
    """
    Data type of the given property field added.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar string: The associated property field will be of type string. Unicode
        is supported.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    string = None
    # Attribute is overwritten below the class definition
    other = None

    def is_string(self):
        """
        Check if the union tag is ``string``.

        :rtype: bool
        """
        return self._tag == 'string'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'PropertyType(%r, %r)' % (self._tag, self._value)

PropertyType_validator = bv.Union(PropertyType)

class RemovePropertiesArg(object):
    """
    :ivar path: A unique identifier for the file or folder.
    :ivar property_template_ids: A list of identifiers for a template created by
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_user`
        or
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_team`.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_property_template_ids_value',
        '_property_template_ids_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 property_template_ids=None):
        self._path_value = None
        self._path_present = False
        self._property_template_ids_value = None
        self._property_template_ids_present = False
        if path is not None:
            self.path = path
        if property_template_ids is not None:
            self.property_template_ids = property_template_ids

    @property
    def path(self):
        """
        A unique identifier for the file or folder.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def property_template_ids(self):
        """
        A list of identifiers for a template created by
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_user`
        or
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_team`.

        :rtype: list of [str]
        """
        if self._property_template_ids_present:
            return self._property_template_ids_value
        else:
            raise AttributeError("missing required field 'property_template_ids'")

    @property_template_ids.setter
    def property_template_ids(self, val):
        val = self._property_template_ids_validator.validate(val)
        self._property_template_ids_value = val
        self._property_template_ids_present = True

    @property_template_ids.deleter
    def property_template_ids(self):
        self._property_template_ids_value = None
        self._property_template_ids_present = False

    def __repr__(self):
        return 'RemovePropertiesArg(path={!r}, property_template_ids={!r})'.format(
            self._path_value,
            self._property_template_ids_value,
        )

RemovePropertiesArg_validator = bv.Struct(RemovePropertiesArg)

class RemovePropertiesError(PropertiesError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    @classmethod
    def property_group_lookup(cls, val):
        """
        Create an instance of this class set to the ``property_group_lookup``
        tag with value ``val``.

        :param LookUpPropertiesError val:
        :rtype: RemovePropertiesError
        """
        return cls('property_group_lookup', val)

    def is_property_group_lookup(self):
        """
        Check if the union tag is ``property_group_lookup``.

        :rtype: bool
        """
        return self._tag == 'property_group_lookup'

    def get_property_group_lookup(self):
        """
        Only call this if :meth:`is_property_group_lookup` is true.

        :rtype: LookUpPropertiesError
        """
        if not self.is_property_group_lookup():
            raise AttributeError("tag 'property_group_lookup' not set")
        return self._value

    def __repr__(self):
        return 'RemovePropertiesError(%r, %r)' % (self._tag, self._value)

RemovePropertiesError_validator = bv.Union(RemovePropertiesError)

class RemoveTemplateArg(object):
    """
    :ivar template_id: An identifier for a template created by
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_user`
        or
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_team`.
    """

    __slots__ = [
        '_template_id_value',
        '_template_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 template_id=None):
        self._template_id_value = None
        self._template_id_present = False
        if template_id is not None:
            self.template_id = template_id

    @property
    def template_id(self):
        """
        An identifier for a template created by
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_user`
        or
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_team`.

        :rtype: str
        """
        if self._template_id_present:
            return self._template_id_value
        else:
            raise AttributeError("missing required field 'template_id'")

    @template_id.setter
    def template_id(self, val):
        val = self._template_id_validator.validate(val)
        self._template_id_value = val
        self._template_id_present = True

    @template_id.deleter
    def template_id(self):
        self._template_id_value = None
        self._template_id_present = False

    def __repr__(self):
        return 'RemoveTemplateArg(template_id={!r})'.format(
            self._template_id_value,
        )

RemoveTemplateArg_validator = bv.Struct(RemoveTemplateArg)

class TemplateFilterBase(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar list of [str] filter_some: Only templates with an ID in the supplied
        list will be returned (a subset of templates will be returned).
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def filter_some(cls, val):
        """
        Create an instance of this class set to the ``filter_some`` tag with
        value ``val``.

        :param list of [str] val:
        :rtype: TemplateFilterBase
        """
        return cls('filter_some', val)

    def is_filter_some(self):
        """
        Check if the union tag is ``filter_some``.

        :rtype: bool
        """
        return self._tag == 'filter_some'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_filter_some(self):
        """
        Only templates with an ID in the supplied list will be returned (a
        subset of templates will be returned).

        Only call this if :meth:`is_filter_some` is true.

        :rtype: list of [str]
        """
        if not self.is_filter_some():
            raise AttributeError("tag 'filter_some' not set")
        return self._value

    def __repr__(self):
        return 'TemplateFilterBase(%r, %r)' % (self._tag, self._value)

TemplateFilterBase_validator = bv.Union(TemplateFilterBase)

class TemplateFilter(TemplateFilterBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar filter_none: No templates will be filtered from the result (all
        templates will be returned).
    """

    # Attribute is overwritten below the class definition
    filter_none = None

    def is_filter_none(self):
        """
        Check if the union tag is ``filter_none``.

        :rtype: bool
        """
        return self._tag == 'filter_none'

    def __repr__(self):
        return 'TemplateFilter(%r, %r)' % (self._tag, self._value)

TemplateFilter_validator = bv.Union(TemplateFilter)

class TemplateOwnerType(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar user: Template will be associated with a user.
    :ivar team: Template will be associated with a team.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    user = None
    # Attribute is overwritten below the class definition
    team = None
    # Attribute is overwritten below the class definition
    other = None

    def is_user(self):
        """
        Check if the union tag is ``user``.

        :rtype: bool
        """
        return self._tag == 'user'

    def is_team(self):
        """
        Check if the union tag is ``team``.

        :rtype: bool
        """
        return self._tag == 'team'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'TemplateOwnerType(%r, %r)' % (self._tag, self._value)

TemplateOwnerType_validator = bv.Union(TemplateOwnerType)

class UpdatePropertiesArg(object):
    """
    :ivar path: A unique identifier for the file or folder.
    :ivar update_property_groups: The property groups "delta" updates to apply.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_update_property_groups_value',
        '_update_property_groups_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 update_property_groups=None):
        self._path_value = None
        self._path_present = False
        self._update_property_groups_value = None
        self._update_property_groups_present = False
        if path is not None:
            self.path = path
        if update_property_groups is not None:
            self.update_property_groups = update_property_groups

    @property
    def path(self):
        """
        A unique identifier for the file or folder.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def update_property_groups(self):
        """
        The property groups "delta" updates to apply.

        :rtype: list of [PropertyGroupUpdate]
        """
        if self._update_property_groups_present:
            return self._update_property_groups_value
        else:
            raise AttributeError("missing required field 'update_property_groups'")

    @update_property_groups.setter
    def update_property_groups(self, val):
        val = self._update_property_groups_validator.validate(val)
        self._update_property_groups_value = val
        self._update_property_groups_present = True

    @update_property_groups.deleter
    def update_property_groups(self):
        self._update_property_groups_value = None
        self._update_property_groups_present = False

    def __repr__(self):
        return 'UpdatePropertiesArg(path={!r}, update_property_groups={!r})'.format(
            self._path_value,
            self._update_property_groups_value,
        )

UpdatePropertiesArg_validator = bv.Struct(UpdatePropertiesArg)

class UpdatePropertiesError(InvalidPropertyGroupError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    @classmethod
    def property_group_lookup(cls, val):
        """
        Create an instance of this class set to the ``property_group_lookup``
        tag with value ``val``.

        :param LookUpPropertiesError val:
        :rtype: UpdatePropertiesError
        """
        return cls('property_group_lookup', val)

    def is_property_group_lookup(self):
        """
        Check if the union tag is ``property_group_lookup``.

        :rtype: bool
        """
        return self._tag == 'property_group_lookup'

    def get_property_group_lookup(self):
        """
        Only call this if :meth:`is_property_group_lookup` is true.

        :rtype: LookUpPropertiesError
        """
        if not self.is_property_group_lookup():
            raise AttributeError("tag 'property_group_lookup' not set")
        return self._value

    def __repr__(self):
        return 'UpdatePropertiesError(%r, %r)' % (self._tag, self._value)

UpdatePropertiesError_validator = bv.Union(UpdatePropertiesError)

class UpdateTemplateArg(object):
    """
    :ivar template_id: An identifier for template added by  See
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_user`
        or
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_team`.
    :ivar name: A display name for the template. template names can be up to 256
        bytes.
    :ivar description: Description for the new template. Template descriptions
        can be up to 1024 bytes.
    :ivar add_fields: Property field templates to be added to the group
        template. There can be up to 32 properties in a single template.
    """

    __slots__ = [
        '_template_id_value',
        '_template_id_present',
        '_name_value',
        '_name_present',
        '_description_value',
        '_description_present',
        '_add_fields_value',
        '_add_fields_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 template_id=None,
                 name=None,
                 description=None,
                 add_fields=None):
        self._template_id_value = None
        self._template_id_present = False
        self._name_value = None
        self._name_present = False
        self._description_value = None
        self._description_present = False
        self._add_fields_value = None
        self._add_fields_present = False
        if template_id is not None:
            self.template_id = template_id
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if add_fields is not None:
            self.add_fields = add_fields

    @property
    def template_id(self):
        """
        An identifier for template added by  See
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_user`
        or
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_team`.

        :rtype: str
        """
        if self._template_id_present:
            return self._template_id_value
        else:
            raise AttributeError("missing required field 'template_id'")

    @template_id.setter
    def template_id(self, val):
        val = self._template_id_validator.validate(val)
        self._template_id_value = val
        self._template_id_present = True

    @template_id.deleter
    def template_id(self):
        self._template_id_value = None
        self._template_id_present = False

    @property
    def name(self):
        """
        A display name for the template. template names can be up to 256 bytes.

        :rtype: str
        """
        if self._name_present:
            return self._name_value
        else:
            return None

    @name.setter
    def name(self, val):
        if val is None:
            del self.name
            return
        val = self._name_validator.validate(val)
        self._name_value = val
        self._name_present = True

    @name.deleter
    def name(self):
        self._name_value = None
        self._name_present = False

    @property
    def description(self):
        """
        Description for the new template. Template descriptions can be up to
        1024 bytes.

        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            return None

    @description.setter
    def description(self, val):
        if val is None:
            del self.description
            return
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    @property
    def add_fields(self):
        """
        Property field templates to be added to the group template. There can be
        up to 32 properties in a single template.

        :rtype: list of [PropertyFieldTemplate]
        """
        if self._add_fields_present:
            return self._add_fields_value
        else:
            return None

    @add_fields.setter
    def add_fields(self, val):
        if val is None:
            del self.add_fields
            return
        val = self._add_fields_validator.validate(val)
        self._add_fields_value = val
        self._add_fields_present = True

    @add_fields.deleter
    def add_fields(self):
        self._add_fields_value = None
        self._add_fields_present = False

    def __repr__(self):
        return 'UpdateTemplateArg(template_id={!r}, name={!r}, description={!r}, add_fields={!r})'.format(
            self._template_id_value,
            self._name_value,
            self._description_value,
            self._add_fields_value,
        )

UpdateTemplateArg_validator = bv.Struct(UpdateTemplateArg)

class UpdateTemplateResult(object):
    """
    :ivar template_id: An identifier for template added by route  See
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_user`
        or
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_team`.
    """

    __slots__ = [
        '_template_id_value',
        '_template_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 template_id=None):
        self._template_id_value = None
        self._template_id_present = False
        if template_id is not None:
            self.template_id = template_id

    @property
    def template_id(self):
        """
        An identifier for template added by route  See
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_user`
        or
        :meth:`dropbox.dropbox.Dropbox.file_properties_templates_add_for_team`.

        :rtype: str
        """
        if self._template_id_present:
            return self._template_id_value
        else:
            raise AttributeError("missing required field 'template_id'")

    @template_id.setter
    def template_id(self, val):
        val = self._template_id_validator.validate(val)
        self._template_id_value = val
        self._template_id_present = True

    @template_id.deleter
    def template_id(self):
        self._template_id_value = None
        self._template_id_present = False

    def __repr__(self):
        return 'UpdateTemplateResult(template_id={!r})'.format(
            self._template_id_value,
        )

UpdateTemplateResult_validator = bv.Struct(UpdateTemplateResult)

Id_validator = bv.String(min_length=1)
PathOrId_validator = bv.String(pattern=u'/(.|[\\r\\n])*|id:.*|(ns:[0-9]+(/.*)?)')
PropertiesSearchCursor_validator = bv.String(min_length=1)
TemplateId_validator = bv.String(min_length=1, pattern=u'(/|ptid:).*')
AddPropertiesArg._path_validator = PathOrId_validator
AddPropertiesArg._property_groups_validator = bv.List(PropertyGroup_validator)
AddPropertiesArg._all_field_names_ = set([
    'path',
    'property_groups',
])
AddPropertiesArg._all_fields_ = [
    ('path', AddPropertiesArg._path_validator),
    ('property_groups', AddPropertiesArg._property_groups_validator),
]

TemplateError._template_not_found_validator = TemplateId_validator
TemplateError._restricted_content_validator = bv.Void()
TemplateError._other_validator = bv.Void()
TemplateError._tagmap = {
    'template_not_found': TemplateError._template_not_found_validator,
    'restricted_content': TemplateError._restricted_content_validator,
    'other': TemplateError._other_validator,
}

TemplateError.restricted_content = TemplateError('restricted_content')
TemplateError.other = TemplateError('other')

PropertiesError._path_validator = LookupError_validator
PropertiesError._unsupported_folder_validator = bv.Void()
PropertiesError._tagmap = {
    'path': PropertiesError._path_validator,
    'unsupported_folder': PropertiesError._unsupported_folder_validator,
}
PropertiesError._tagmap.update(TemplateError._tagmap)

PropertiesError.unsupported_folder = PropertiesError('unsupported_folder')

InvalidPropertyGroupError._property_field_too_large_validator = bv.Void()
InvalidPropertyGroupError._does_not_fit_template_validator = bv.Void()
InvalidPropertyGroupError._tagmap = {
    'property_field_too_large': InvalidPropertyGroupError._property_field_too_large_validator,
    'does_not_fit_template': InvalidPropertyGroupError._does_not_fit_template_validator,
}
InvalidPropertyGroupError._tagmap.update(PropertiesError._tagmap)

InvalidPropertyGroupError.property_field_too_large = InvalidPropertyGroupError('property_field_too_large')
InvalidPropertyGroupError.does_not_fit_template = InvalidPropertyGroupError('does_not_fit_template')

AddPropertiesError._property_group_already_exists_validator = bv.Void()
AddPropertiesError._tagmap = {
    'property_group_already_exists': AddPropertiesError._property_group_already_exists_validator,
}
AddPropertiesError._tagmap.update(InvalidPropertyGroupError._tagmap)

AddPropertiesError.property_group_already_exists = AddPropertiesError('property_group_already_exists')

PropertyGroupTemplate._name_validator = bv.String()
PropertyGroupTemplate._description_validator = bv.String()
PropertyGroupTemplate._fields_validator = bv.List(PropertyFieldTemplate_validator)
PropertyGroupTemplate._all_field_names_ = set([
    'name',
    'description',
    'fields',
])
PropertyGroupTemplate._all_fields_ = [
    ('name', PropertyGroupTemplate._name_validator),
    ('description', PropertyGroupTemplate._description_validator),
    ('fields', PropertyGroupTemplate._fields_validator),
]

AddTemplateArg._all_field_names_ = PropertyGroupTemplate._all_field_names_.union(set([]))
AddTemplateArg._all_fields_ = PropertyGroupTemplate._all_fields_ + []

AddTemplateResult._template_id_validator = TemplateId_validator
AddTemplateResult._all_field_names_ = set(['template_id'])
AddTemplateResult._all_fields_ = [('template_id', AddTemplateResult._template_id_validator)]

GetTemplateArg._template_id_validator = TemplateId_validator
GetTemplateArg._all_field_names_ = set(['template_id'])
GetTemplateArg._all_fields_ = [('template_id', GetTemplateArg._template_id_validator)]

GetTemplateResult._all_field_names_ = PropertyGroupTemplate._all_field_names_.union(set([]))
GetTemplateResult._all_fields_ = PropertyGroupTemplate._all_fields_ + []

ListTemplateResult._template_ids_validator = bv.List(TemplateId_validator)
ListTemplateResult._all_field_names_ = set(['template_ids'])
ListTemplateResult._all_fields_ = [('template_ids', ListTemplateResult._template_ids_validator)]

LogicalOperator._or_operator_validator = bv.Void()
LogicalOperator._other_validator = bv.Void()
LogicalOperator._tagmap = {
    'or_operator': LogicalOperator._or_operator_validator,
    'other': LogicalOperator._other_validator,
}

LogicalOperator.or_operator = LogicalOperator('or_operator')
LogicalOperator.other = LogicalOperator('other')

LookUpPropertiesError._property_group_not_found_validator = bv.Void()
LookUpPropertiesError._other_validator = bv.Void()
LookUpPropertiesError._tagmap = {
    'property_group_not_found': LookUpPropertiesError._property_group_not_found_validator,
    'other': LookUpPropertiesError._other_validator,
}

LookUpPropertiesError.property_group_not_found = LookUpPropertiesError('property_group_not_found')
LookUpPropertiesError.other = LookUpPropertiesError('other')

LookupError._malformed_path_validator = bv.String()
LookupError._not_found_validator = bv.Void()
LookupError._not_file_validator = bv.Void()
LookupError._not_folder_validator = bv.Void()
LookupError._restricted_content_validator = bv.Void()
LookupError._other_validator = bv.Void()
LookupError._tagmap = {
    'malformed_path': LookupError._malformed_path_validator,
    'not_found': LookupError._not_found_validator,
    'not_file': LookupError._not_file_validator,
    'not_folder': LookupError._not_folder_validator,
    'restricted_content': LookupError._restricted_content_validator,
    'other': LookupError._other_validator,
}

LookupError.not_found = LookupError('not_found')
LookupError.not_file = LookupError('not_file')
LookupError.not_folder = LookupError('not_folder')
LookupError.restricted_content = LookupError('restricted_content')
LookupError.other = LookupError('other')

ModifyTemplateError._conflicting_property_names_validator = bv.Void()
ModifyTemplateError._too_many_properties_validator = bv.Void()
ModifyTemplateError._too_many_templates_validator = bv.Void()
ModifyTemplateError._template_attribute_too_large_validator = bv.Void()
ModifyTemplateError._tagmap = {
    'conflicting_property_names': ModifyTemplateError._conflicting_property_names_validator,
    'too_many_properties': ModifyTemplateError._too_many_properties_validator,
    'too_many_templates': ModifyTemplateError._too_many_templates_validator,
    'template_attribute_too_large': ModifyTemplateError._template_attribute_too_large_validator,
}
ModifyTemplateError._tagmap.update(TemplateError._tagmap)

ModifyTemplateError.conflicting_property_names = ModifyTemplateError('conflicting_property_names')
ModifyTemplateError.too_many_properties = ModifyTemplateError('too_many_properties')
ModifyTemplateError.too_many_templates = ModifyTemplateError('too_many_templates')
ModifyTemplateError.template_attribute_too_large = ModifyTemplateError('template_attribute_too_large')

OverwritePropertyGroupArg._path_validator = PathOrId_validator
OverwritePropertyGroupArg._property_groups_validator = bv.List(PropertyGroup_validator, min_items=1)
OverwritePropertyGroupArg._all_field_names_ = set([
    'path',
    'property_groups',
])
OverwritePropertyGroupArg._all_fields_ = [
    ('path', OverwritePropertyGroupArg._path_validator),
    ('property_groups', OverwritePropertyGroupArg._property_groups_validator),
]

PropertiesSearchArg._queries_validator = bv.List(PropertiesSearchQuery_validator, min_items=1)
PropertiesSearchArg._template_filter_validator = TemplateFilter_validator
PropertiesSearchArg._all_field_names_ = set([
    'queries',
    'template_filter',
])
PropertiesSearchArg._all_fields_ = [
    ('queries', PropertiesSearchArg._queries_validator),
    ('template_filter', PropertiesSearchArg._template_filter_validator),
]

PropertiesSearchContinueArg._cursor_validator = PropertiesSearchCursor_validator
PropertiesSearchContinueArg._all_field_names_ = set(['cursor'])
PropertiesSearchContinueArg._all_fields_ = [('cursor', PropertiesSearchContinueArg._cursor_validator)]

PropertiesSearchContinueError._reset_validator = bv.Void()
PropertiesSearchContinueError._other_validator = bv.Void()
PropertiesSearchContinueError._tagmap = {
    'reset': PropertiesSearchContinueError._reset_validator,
    'other': PropertiesSearchContinueError._other_validator,
}

PropertiesSearchContinueError.reset = PropertiesSearchContinueError('reset')
PropertiesSearchContinueError.other = PropertiesSearchContinueError('other')

PropertiesSearchError._property_group_lookup_validator = LookUpPropertiesError_validator
PropertiesSearchError._other_validator = bv.Void()
PropertiesSearchError._tagmap = {
    'property_group_lookup': PropertiesSearchError._property_group_lookup_validator,
    'other': PropertiesSearchError._other_validator,
}

PropertiesSearchError.other = PropertiesSearchError('other')

PropertiesSearchMatch._id_validator = Id_validator
PropertiesSearchMatch._path_validator = bv.String()
PropertiesSearchMatch._is_deleted_validator = bv.Boolean()
PropertiesSearchMatch._property_groups_validator = bv.List(PropertyGroup_validator)
PropertiesSearchMatch._all_field_names_ = set([
    'id',
    'path',
    'is_deleted',
    'property_groups',
])
PropertiesSearchMatch._all_fields_ = [
    ('id', PropertiesSearchMatch._id_validator),
    ('path', PropertiesSearchMatch._path_validator),
    ('is_deleted', PropertiesSearchMatch._is_deleted_validator),
    ('property_groups', PropertiesSearchMatch._property_groups_validator),
]

PropertiesSearchMode._field_name_validator = bv.String()
PropertiesSearchMode._other_validator = bv.Void()
PropertiesSearchMode._tagmap = {
    'field_name': PropertiesSearchMode._field_name_validator,
    'other': PropertiesSearchMode._other_validator,
}

PropertiesSearchMode.other = PropertiesSearchMode('other')

PropertiesSearchQuery._query_validator = bv.String()
PropertiesSearchQuery._mode_validator = PropertiesSearchMode_validator
PropertiesSearchQuery._logical_operator_validator = LogicalOperator_validator
PropertiesSearchQuery._all_field_names_ = set([
    'query',
    'mode',
    'logical_operator',
])
PropertiesSearchQuery._all_fields_ = [
    ('query', PropertiesSearchQuery._query_validator),
    ('mode', PropertiesSearchQuery._mode_validator),
    ('logical_operator', PropertiesSearchQuery._logical_operator_validator),
]

PropertiesSearchResult._matches_validator = bv.List(PropertiesSearchMatch_validator)
PropertiesSearchResult._cursor_validator = bv.Nullable(PropertiesSearchCursor_validator)
PropertiesSearchResult._all_field_names_ = set([
    'matches',
    'cursor',
])
PropertiesSearchResult._all_fields_ = [
    ('matches', PropertiesSearchResult._matches_validator),
    ('cursor', PropertiesSearchResult._cursor_validator),
]

PropertyField._name_validator = bv.String()
PropertyField._value_validator = bv.String()
PropertyField._all_field_names_ = set([
    'name',
    'value',
])
PropertyField._all_fields_ = [
    ('name', PropertyField._name_validator),
    ('value', PropertyField._value_validator),
]

PropertyFieldTemplate._name_validator = bv.String()
PropertyFieldTemplate._description_validator = bv.String()
PropertyFieldTemplate._type_validator = PropertyType_validator
PropertyFieldTemplate._all_field_names_ = set([
    'name',
    'description',
    'type',
])
PropertyFieldTemplate._all_fields_ = [
    ('name', PropertyFieldTemplate._name_validator),
    ('description', PropertyFieldTemplate._description_validator),
    ('type', PropertyFieldTemplate._type_validator),
]

PropertyGroup._template_id_validator = TemplateId_validator
PropertyGroup._fields_validator = bv.List(PropertyField_validator)
PropertyGroup._all_field_names_ = set([
    'template_id',
    'fields',
])
PropertyGroup._all_fields_ = [
    ('template_id', PropertyGroup._template_id_validator),
    ('fields', PropertyGroup._fields_validator),
]

PropertyGroupUpdate._template_id_validator = TemplateId_validator
PropertyGroupUpdate._add_or_update_fields_validator = bv.Nullable(bv.List(PropertyField_validator))
PropertyGroupUpdate._remove_fields_validator = bv.Nullable(bv.List(bv.String()))
PropertyGroupUpdate._all_field_names_ = set([
    'template_id',
    'add_or_update_fields',
    'remove_fields',
])
PropertyGroupUpdate._all_fields_ = [
    ('template_id', PropertyGroupUpdate._template_id_validator),
    ('add_or_update_fields', PropertyGroupUpdate._add_or_update_fields_validator),
    ('remove_fields', PropertyGroupUpdate._remove_fields_validator),
]

PropertyType._string_validator = bv.Void()
PropertyType._other_validator = bv.Void()
PropertyType._tagmap = {
    'string': PropertyType._string_validator,
    'other': PropertyType._other_validator,
}

PropertyType.string = PropertyType('string')
PropertyType.other = PropertyType('other')

RemovePropertiesArg._path_validator = PathOrId_validator
RemovePropertiesArg._property_template_ids_validator = bv.List(TemplateId_validator)
RemovePropertiesArg._all_field_names_ = set([
    'path',
    'property_template_ids',
])
RemovePropertiesArg._all_fields_ = [
    ('path', RemovePropertiesArg._path_validator),
    ('property_template_ids', RemovePropertiesArg._property_template_ids_validator),
]

RemovePropertiesError._property_group_lookup_validator = LookUpPropertiesError_validator
RemovePropertiesError._tagmap = {
    'property_group_lookup': RemovePropertiesError._property_group_lookup_validator,
}
RemovePropertiesError._tagmap.update(PropertiesError._tagmap)

RemoveTemplateArg._template_id_validator = TemplateId_validator
RemoveTemplateArg._all_field_names_ = set(['template_id'])
RemoveTemplateArg._all_fields_ = [('template_id', RemoveTemplateArg._template_id_validator)]

TemplateFilterBase._filter_some_validator = bv.List(TemplateId_validator, min_items=1)
TemplateFilterBase._other_validator = bv.Void()
TemplateFilterBase._tagmap = {
    'filter_some': TemplateFilterBase._filter_some_validator,
    'other': TemplateFilterBase._other_validator,
}

TemplateFilterBase.other = TemplateFilterBase('other')

TemplateFilter._filter_none_validator = bv.Void()
TemplateFilter._tagmap = {
    'filter_none': TemplateFilter._filter_none_validator,
}
TemplateFilter._tagmap.update(TemplateFilterBase._tagmap)

TemplateFilter.filter_none = TemplateFilter('filter_none')

TemplateOwnerType._user_validator = bv.Void()
TemplateOwnerType._team_validator = bv.Void()
TemplateOwnerType._other_validator = bv.Void()
TemplateOwnerType._tagmap = {
    'user': TemplateOwnerType._user_validator,
    'team': TemplateOwnerType._team_validator,
    'other': TemplateOwnerType._other_validator,
}

TemplateOwnerType.user = TemplateOwnerType('user')
TemplateOwnerType.team = TemplateOwnerType('team')
TemplateOwnerType.other = TemplateOwnerType('other')

UpdatePropertiesArg._path_validator = PathOrId_validator
UpdatePropertiesArg._update_property_groups_validator = bv.List(PropertyGroupUpdate_validator)
UpdatePropertiesArg._all_field_names_ = set([
    'path',
    'update_property_groups',
])
UpdatePropertiesArg._all_fields_ = [
    ('path', UpdatePropertiesArg._path_validator),
    ('update_property_groups', UpdatePropertiesArg._update_property_groups_validator),
]

UpdatePropertiesError._property_group_lookup_validator = LookUpPropertiesError_validator
UpdatePropertiesError._tagmap = {
    'property_group_lookup': UpdatePropertiesError._property_group_lookup_validator,
}
UpdatePropertiesError._tagmap.update(InvalidPropertyGroupError._tagmap)

UpdateTemplateArg._template_id_validator = TemplateId_validator
UpdateTemplateArg._name_validator = bv.Nullable(bv.String())
UpdateTemplateArg._description_validator = bv.Nullable(bv.String())
UpdateTemplateArg._add_fields_validator = bv.Nullable(bv.List(PropertyFieldTemplate_validator))
UpdateTemplateArg._all_field_names_ = set([
    'template_id',
    'name',
    'description',
    'add_fields',
])
UpdateTemplateArg._all_fields_ = [
    ('template_id', UpdateTemplateArg._template_id_validator),
    ('name', UpdateTemplateArg._name_validator),
    ('description', UpdateTemplateArg._description_validator),
    ('add_fields', UpdateTemplateArg._add_fields_validator),
]

UpdateTemplateResult._template_id_validator = TemplateId_validator
UpdateTemplateResult._all_field_names_ = set(['template_id'])
UpdateTemplateResult._all_fields_ = [('template_id', UpdateTemplateResult._template_id_validator)]

properties_add = bb.Route(
    'properties/add',
    False,
    AddPropertiesArg_validator,
    bv.Void(),
    AddPropertiesError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_overwrite = bb.Route(
    'properties/overwrite',
    False,
    OverwritePropertyGroupArg_validator,
    bv.Void(),
    InvalidPropertyGroupError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_remove = bb.Route(
    'properties/remove',
    False,
    RemovePropertiesArg_validator,
    bv.Void(),
    RemovePropertiesError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_search = bb.Route(
    'properties/search',
    False,
    PropertiesSearchArg_validator,
    PropertiesSearchResult_validator,
    PropertiesSearchError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_search_continue = bb.Route(
    'properties/search/continue',
    False,
    PropertiesSearchContinueArg_validator,
    PropertiesSearchResult_validator,
    PropertiesSearchContinueError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_update = bb.Route(
    'properties/update',
    False,
    UpdatePropertiesArg_validator,
    bv.Void(),
    UpdatePropertiesError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
templates_add_for_team = bb.Route(
    'templates/add_for_team',
    False,
    AddTemplateArg_validator,
    AddTemplateResult_validator,
    ModifyTemplateError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
templates_add_for_user = bb.Route(
    'templates/add_for_user',
    False,
    AddTemplateArg_validator,
    AddTemplateResult_validator,
    ModifyTemplateError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
templates_get_for_team = bb.Route(
    'templates/get_for_team',
    False,
    GetTemplateArg_validator,
    GetTemplateResult_validator,
    TemplateError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
templates_get_for_user = bb.Route(
    'templates/get_for_user',
    False,
    GetTemplateArg_validator,
    GetTemplateResult_validator,
    TemplateError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
templates_list_for_team = bb.Route(
    'templates/list_for_team',
    False,
    bv.Void(),
    ListTemplateResult_validator,
    TemplateError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
templates_list_for_user = bb.Route(
    'templates/list_for_user',
    False,
    bv.Void(),
    ListTemplateResult_validator,
    TemplateError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
templates_remove_for_team = bb.Route(
    'templates/remove_for_team',
    False,
    RemoveTemplateArg_validator,
    bv.Void(),
    TemplateError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
templates_remove_for_user = bb.Route(
    'templates/remove_for_user',
    False,
    RemoveTemplateArg_validator,
    bv.Void(),
    TemplateError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
templates_update_for_team = bb.Route(
    'templates/update_for_team',
    False,
    UpdateTemplateArg_validator,
    UpdateTemplateResult_validator,
    ModifyTemplateError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
templates_update_for_user = bb.Route(
    'templates/update_for_user',
    False,
    UpdateTemplateArg_validator,
    UpdateTemplateResult_validator,
    ModifyTemplateError_validator,
    {'host': u'api',
     'style': u'rpc'},
)

ROUTES = {
    'properties/add': properties_add,
    'properties/overwrite': properties_overwrite,
    'properties/remove': properties_remove,
    'properties/search': properties_search,
    'properties/search/continue': properties_search_continue,
    'properties/update': properties_update,
    'templates/add_for_team': templates_add_for_team,
    'templates/add_for_user': templates_add_for_user,
    'templates/get_for_team': templates_get_for_team,
    'templates/get_for_user': templates_get_for_user,
    'templates/list_for_team': templates_list_for_team,
    'templates/list_for_user': templates_list_for_user,
    'templates/remove_for_team': templates_remove_for_team,
    'templates/remove_for_user': templates_remove_for_user,
    'templates/update_for_team': templates_update_for_team,
    'templates/update_for_user': templates_update_for_user,
}

