
////////(Copyright)/////////////////////////
//
//     Autor: Antonio Castro Snurmacher 
//     (E-mail <acastro@ctv.es> )
//
//  Este fuente puede ser utilizado, distri-
//  buido, y modificado libremente pero
//  siempre se deber respetar la propiedad
//  intelectual de su autor. El autor renun-
//  cia a todo tipo de beneficio econmico y
//  no se hace responsable de los posibles
//  perjuicios derivados del uso del mismo.
//  Toda modificacin queda sujeta a las
//  mismas condiciones de uso que el origi-
//  nal. En caso de traduccin deber con-
//  servarse el texto original de esta cabe-
//  cera y aadirse la traduccin a conti-
//  nuacin de ella. 
//  
////////////////////////////////////////////

//------------------------------------------
//  BasicSamples.inc     Jun 21 1998
//------------------------------------------
//  Esta versin esta dedicada a su inclu-
//  sin en la revista LinuxFocus.
//------------------------------------------

#declare Finish  = finish  { 
    ambient 0.3 
    diffuse 0.6 
    reflection 0.1 
    phong 0.2 
    phong_size  40 
}

#declare FinishRe  = finish  { 
    ambient 0.2 
    diffuse 0.2 
    reflection 0.6 
    phong 0.9 
    phong_size 200 
}

#declare Turbulence = texture { 
    pigment {
        checker color Yellow color Blue 
            turbulence 0.75
        }
    finish { Finish }
}

#declare Checker = texture { 
    pigment {
        checker color Yellow color Blue 
    }
    finish { Finish }
}

#declare Hexagon = texture { 
    pigment {
        hexagon color Yellow color Blue 
                color Red 
    }
    finish { Finish }
    scale 1.1
}

#declare Brick   = texture { 
    pigment {
        brick Gray, Red
        brick_size <8, 3, 4.5> mortar 0.5
    }
    finish { Finish }
    scale 0.5
}

#declare Complex = texture {
    hexagon 
        texture {Hexagon scale 0.25 }
        texture {Brick   scale 0.25 }
        texture {Checker scale 0.25 }
    }

#declare ColorMap = color_map {
      [0.0  color Yellow]
      [0.2  color Red]
      [0.5  color Black]
      [0.7  color Blue]
      [0.8  color Orange]
      [1.0  color Cyan]
    }

#declare ColorMapBW = color_map {
      [0.0  color Black]
      [1.0  color White]
    }

#declare Gradient = texture {
      pigment {
          gradient x
          color_map { ColorMap }
          scale 1.5
      }
      finish { Finish }
   }
#declare Marble = texture {
      pigment {
          marble 
          color_map { ColorMap }
          scale 1.5
      }
      finish { Finish }
   }
#declare Agate = texture {
      pigment {
          agate 
          color_map { ColorMap }
          scale 1.5
       }
       finish { Finish }
    }
#declare Wood = texture {
       pigment {
           wood  
           color_map { ColorMap }
           scale 0.6
       }
       finish { Finish }
    }
#declare Onion = texture {
       pigment {
           onion 
           color_map { ColorMap }
           scale 0.6
       }
       finish { Finish }
    }
#declare Granite = texture {
       pigment {
           granite 
           color_map { ColorMap }
           scale 1.5
       }
       finish { Finish }
   }
#declare Bozo = texture {
       pigment {
           bozo
           color_map { ColorMap }
           scale 0.6
       }
       finish { Finish }
   }
#declare Leopard = texture {
       pigment {
           leopard
           color_map { ColorMap }
           scale 0.2
       }
       finish { Finish }
   }
#declare Spotted = texture {
       pigment {
           spotted
           color_map { ColorMap }
           scale 0.6
       }
       finish { Finish }
   }
#declare Crackle = texture {
       pigment {
           crackle
           color_map { ColorMap }
           scale 0.6
       }
       finish { Finish }
   }
//------------------------------------------
//------------- LB BS_Normals --------------
//------------------------------------------
#declare Waves = texture {
       pigment {
           waves
           color_map { ColorMapBW }
           scale 0.2
       }
       finish { Finish }
   }
#declare Bump = texture {
       pigment {
           bumps
           color_map { ColorMapBW }
           scale 0.4
       }
       finish { Finish }
   }
#declare Dents = texture {
       pigment {
           dents
           color_map { ColorMapBW }
           scale 0.4
       }
       finish { Finish }
   }
#declare Ripples = texture {
       pigment {
           ripples 
           color_map { ColorMapBW }
           scale 0.4
       }
       finish { Finish }
    }
#declare RipplesTurb = texture {
       pigment {
           ripples 
           turbulence 0.5
           color_map { ColorMapBW }
           scale 0.4
       }
       finish { Finish }
    }
#declare Quilted = texture {
       pigment {
           quilted
           color_map { ColorMapBW }
           scale 0.4
       }
       finish { Finish }
    }
#declare Spiral1 = texture {
       pigment {
           spiral1 3
           color_map { ColorMapBW }
           scale 0.4
       }
       finish { Finish }
    }
#declare Spiral2 = texture {
       pigment {
           spiral2 3
           color_map { ColorMapBW }
           scale 0.4
       }
       finish { Finish }
   }
#declare Wrinkles = texture {
       pigment {
           wrinkles 
           color_map { ColorMapBW }
           scale 0.4
       }
       finish { Finish }
   }

//------------------------------------------
#declare FWaves = texture {
       pigment { color Orange }
           normal {
           waves 0.15
           scale 0.2
       }
       finish { FinishRe }
    }
#declare FBump = texture {
       pigment { color Orange }
           normal  {
           bumps 0.15
           scale 0.4
       }
       finish { FinishRe }
    }
#declare FDents = texture {
       pigment { color Orange }
           normal  {
           dents 0.15
           scale 0.4
       }
       finish { FinishRe }
    }
#declare FRipples = texture {
       pigment { color Orange }
           normal  {
           ripples  0.15
           scale 0.4
       }
       finish { FinishRe }
    }
#declare FRipplesTurb = texture {
       pigment { color Orange }
           normal  {
           ripples  0.15
           turbulence 0.5
           scale 0.4
       }
       finish { FinishRe }
    }
#declare FQuilted = texture {
       pigment { color Orange }
           normal  {
           quilted 0.15
           scale 0.4
       }
       finish { FinishRe }
    }
#declare FSpiral1 = texture {
       pigment { color Orange }
       normal  {
           spiral1 3 0.15
           scale 0.4
       }
       finish { FinishRe }
    }
#declare FSpiral2 = texture {
       pigment { color Orange }
       normal  {
           spiral2 3 0.15
           scale 0.4
       }
       finish { FinishRe }
    }
#declare FWrinkles = texture {
       pigment { color Orange }
       normal  {
           wrinkles  0.15
           scale 0.4
       }
       finish { FinishRe }
    }

