
////////(Copyright)/////////////////////////
//
//     Autor: Antonio Castro Snurmacher 
//     (E-mail <acastro@ctv.es> )
//
//  Este fuente puede ser utilizado, distri-
//  buido, y modificado libremente pero
//  siempre se deber respetar la propiedad
//  intelectual de su autor. El autor renun-
//  cia a todo tipo de beneficio econmico y
//  no se hace responsable de los posibles
//  perjuicios derivados del uso del mismo.
//  Toda modificacin queda sujeta a las
//  mismas condiciones de uso que el origi-
//  nal. En caso de traduccin deber con-
//  servarse el texto original de esta cabe-
//  cera y aadirse la traduccin a conti-
//  nuacin de ella. 
//  
////////////////////////////////////////////

//------------------------------------------
//  catalog.c  Sat Jun 20 20:36:16 CEST 1998
//------------------------------------------
//  Esta versin esta dedicada a su inclu-
//  sin en la revista LinuxFocus.
//------------------------------------------

#include <stdio.h>
#include <stdlib.h>

#define MAXLENTOK 40
#define COLS 5   
#define ROWS 3  

#define SCALETEXTURE "<0.3, 0.3, 0.3>"
#define SCALETEXT    "<0.3, 0.3, 0.3>"
#define SCALEITEM    "<1.4, 1.4, 1.4>"
#define SCALEMAINTEXT    "<0.8, 0.8, 0.8>"
#define FONTLABEL    "timrom.ttf"

int i;
char LineInput[200];
char cadTexture[300];
char cadLabel[MAXLENTOK];
char MainLabel[MAXLENTOK];
char tok0[MAXLENTOK];
char tok1[MAXLENTOK];
char tok2[MAXLENTOK];
char TypeItem='S';
char *pt;
int n;
int Page;
int ItemPendiente;
int cont=0;
FILE *fi;
FILE *fo;

/******************************************/
Texture(char *tok){
  sprintf(cadTexture, 
         "texture{ %s scale %s}\n", 
         tok, SCALETEXTURE);
  strcpy(cadLabel, tok);
}

/******************************************/
void PigmentFinish(char *pigm,char *finish){
  sprintf(cadTexture, 
          "texture{ pigment{ %s }"
          " finish{ %s } rotate <25, 25, 0>"
          " scale %s }", 
          pigm, finish, SCALETEXTURE);
  if (strlen(finish)> strlen(pigm)){
     strcpy(cadLabel, finish);
  }
  else{
     strcpy(cadLabel, pigm);
  }
}

/******************************************/
void MakeLabel(){
    fprintf(fo, "// *********** New page"
           " ************\n");
    fprintf(fo, "text { ttf \"%s\" \"%s"
            " (%d)\" 0.5, 0\n",
       FONTLABEL, MainLabel, Page );
    fprintf(fo, "texture { Br }\n");
    fprintf(fo, "translate <-2.2, 5.5, 
                 -1.5>\n");
    fprintf(fo, "scale %s\n",SCALEMAINTEXT);
    fprintf(fo, "}\n");
}

/******************************************/
void ItemBox(float fCol, float fRow){
    fprintf(fo, "union{\n");
    fprintf(fo, "  union{\n");
    fprintf(fo, "     sphere { <1, 1, 0>"
           " 0.45  %s}\n", cadTexture);
    fprintf(fo, "     box { <0, 0, 0>"
           " <1, 1, 1>\n");
    fprintf(fo, "     %s\n", cadTexture);
    fprintf(fo, "   }\n");
    fprintf(fo, "   translate <-0.5,-0.5,"
           "-0.5>\n");
    fprintf(fo, "   rotate y*45 rotate "
           "x*45 rotate z*10\n");
    fprintf(fo, "   }\n\n");
    fprintf(fo, "   text { ttf \"%s\" "
           " \"%s\" 0.5, 0\n", FONTLABEL, 
           cadLabel);
    fprintf(fo, "   texture { Br }\n");
    fprintf(fo, "   translate <-1.2,"
           " -2, 0>\n"); 
    fprintf(fo, "   scale %s\n", 
           SCALETEXT);
    fprintf(fo, "   translate <0, 0,"
           " -1.3>\n");
    fprintf(fo, "}\n");
    fprintf(fo, "rotate z*15\n");
    fprintf(fo, "scale %s\n", SCALEITEM);
    fprintf(fo, "translate <%4.2f, %4.2f,"
           " 0>\n", fCol, fRow);
    fprintf(fo, "}\n\n");
}

/******************************************/
void ItemSphere(float fCol, float fRow){
    fprintf(fo, "union{\n");
    fprintf(fo, "   sphere { <0, 0, 0>"
          " 1\n");
    fprintf(fo, "   %s\n", cadTexture);
    fprintf(fo, "   }\n\n");
    fprintf(fo, "   text { ttf \"%s\" "
          " \"%s\" 0.5, 0\n", 
          FONTLABEL, cadLabel);
    fprintf(fo, "   texture { Br }\n");
    fprintf(fo, "   translate <-1.2, -1.2,"
          " 0>\n"); 
    fprintf(fo, "   scale %s\n",SCALETEXT);
    fprintf(fo, "   translate<0,0,-1.2>"
                "\n");
    fprintf(fo, "}\n");
    fprintf(fo, "rotate z*15\n");
    fprintf(fo, "translate <%4.2f, %4.2f,"
          " 0>\n", fCol, fRow);
    fprintf(fo, "}\n\n");
}

/******************************************/
void MakeItem(){
    int Row, Col, Frame;
// Generara tantos paneles COLS*ROWS como i
// sean necesarios.
// Se va variando el valor de clock()
  float fRow, fCol;

                   //COLS ==5
  Col= cont % COLS;// 0  1  2  3  4
  Col -=(COLS-1)/2;//-2 -1  0  1  2 (center)
  Col *=2;         //-4 -2  0  2  4  (scale)
  fCol = Col;

  Row=(cont/COLS)%ROWS; // 0   1 2
  Row -= (ROWS-1)/2;    //-1   0 1  (center)
  fRow = Row * 2.7;     //-2.5 0 2.5 (scale)

  Frame = cont / (COLS*ROWS); // cont / 15
  Frame++;

  fprintf(fo, "#debug \"%5d,%3d,%4.2f,%4d"
         "\\n\"\n", cont, Frame, fRow, Col);
  fprintf(fo, "#if ( clock = %d) \n",Frame);

  if (ItemPendiente){
      if (cont % (COLS*ROWS) ==0){
           Page++;
        MakeLabel();
      }
      switch (TypeItem){
         case 'S': ItemSphere(fCol,fRow);
                   break;
         case 'B': ItemBox(fCol, fRow); 
                   break;
         default: fprintf(stderr, 
                 "\nUnexpected type of Item"
                 " in '%s'\n", LineInput);
      }   

      cont++;
      ItemPendiente=0;
  }
  fprintf(fo, "#end\n");
}

/******************************************/
void NewLabel(char *Label){
   strcpy(MainLabel, Label);
   Page=0;
   for(;;){
       if (cont%(COLS*ROWS)==0) break;
       cont++;
   }
}


/******************************************/
/******************************************/
void main(){
   MainLabel[0]='\0';
   Page=0;
   fi=fopen("texture.dat", "r");
   if (fi==NULL){
      perror("Imposible abir"
                         " 'texture.dat'");
      exit(-1);
   }   
   fo=fopen("catalog.inc", "w");
   if (fo==NULL){
      perror("Imposible abir"
                         " 'catalago.inc'");
      exit(-1);
   }   
        fprintf(fo, "#declare Br = texture"
             " { pigment { White } "
             " finish { ambient 1  "
             " diffuse 1 } }\n");

   while (!feof(fi)){
      pt=fgets(LineInput, 
           sizeof(LineInput), fi);
      if (pt!=NULL){
         LineInput[strlen(LineInput)-1]= 
                              '\0';
         n=0;
         tok0[0]=tok1[0]=tok2[0]='\0';
         n=sscanf(LineInput, "%s %s %s", 
                  tok0, tok1, tok2);   
         switch(tok0[0]){
         case '#' : 
         case ' ' : 
         case '\t' : 
            break; /** Ignore line **/
         case 'T': 
            if (n==2){
               ItemPendiente=1;
               Texture(tok1); break;
            }
            else{
               fprintf(stderr, 
                    "Sintax Error: '%s'\n",
                     LineInput);
               exit(-1);
            }
            break;
         case 'P': 
         case 'F': 
            if (n==3){
               ItemPendiente=1;
               PigmentFinish(tok2, tok1);
               break;
            }
            else{
               fprintf(stderr, 
                   "Sintax Error: '%s'\n", 
                    LineInput);
               exit(-1);
            }
            break;
         case 'L': /** New Label **/
            TypeItem=tok0[1];
            NewLabel( tok1);break;
            break;
         default: 
            fprintf(stderr, 
                    "Error : '%s'\n", 
                     LineInput);
            exit(-1);
                  
         }
       
        //cont,cadTexture,cadLabel,ROWS,COLS
         MakeItem();
      }
      else {
         break;
      }
   }
}
