#ifndef HP_CURSES_H
#define HP_CURSES_H

// Things we need for the ncurses interface.

extern "C" {
#include <curses.h>
}

#ifndef ESC
#define ESC '\e'
#endif


#define TAB '\t'

#define RUBOUT 0177   // Delete key

#define REDRAWKEY 014    // CTRL-L forces a redraw

#define KPSPECIAL1 '\e'           // Keypad numbers might start with this
#define KPSPECIAL2 'O'            // Followed by this
#define KPSPECIAL3 "npqrstuvwxyojmkM"   // Then the character in 3 maps into
#define KPSPECIAL4 ".0123456789/*-+\n"   // the corresponding character in 4

#define OPERATORS "+-*/"     // Special operators, always produce a
                             // carriage return if at beginning of line

#define QUIT 4              // CTRL-D ends input

#define MAX_SIMPLE_CHAR 255

#define NEWLINE 10

#define MOUSE_FLASH_PAUSE 0.05   // 0.05 second pause

#define CURRENTCELLPTR "===>"    // Pointer to the current cell.

#define BARRIERSTR "<<< END OF PROGRAM SPACE >>>"

#define NUMERICPREFIX '{'  // Character which in position 0 indicates that the curses interface should not complete numbers

// #define beep() do { beep() ; wrefresh(mainwin) ; } while (0)

#endif  /* !HP_CURSES_H */
