/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.postgresql;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.AggregateFunction;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.EscapeSyntaxModifier;
import org.teiid.translator.jdbc.ExtractFunctionModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.ModFunctionModifier;
import org.teiid.translator.jdbc.oracle.LeftOrRightFunctionModifier;
import org.teiid.translator.jdbc.oracle.MonthOrDayNameFunctionModifier;
import org.teiid.translator.jdbc.oracle.OracleFormatFunctionModifier;
import org.teiid.translator.jdbc.postgresql.LocateFunctionModifier;

@Translator(name="postgresql", description="A translator for postgreSQL Database")
public class PostgreSQLExecutionFactory
extends JDBCExecutionFactory {
    public static final String EIGHT_0 = "8.0";
    public static final String EIGHT_1 = "8.1";
    public static final String EIGHT_2 = "8.2";
    public static final String EIGHT_3 = "8.3";
    public static final String EIGHT_4 = "8.4";

    public PostgreSQLExecutionFactory() {
        this.setDatabaseVersion(EIGHT_0);
        this.setMaxDependentInPredicates(1);
        this.setMaxInCriteriaSize(32717);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("log", new AliasModifier("ln"));
        this.registerFunctionModifier("log10", new AliasModifier("log"));
        this.registerFunctionModifier("bitand", new AliasModifier("&"));
        this.registerFunctionModifier("bitnot", new AliasModifier("~"));
        this.registerFunctionModifier("bitor", new AliasModifier("|"));
        this.registerFunctionModifier("bitxor", new AliasModifier("#"));
        this.registerFunctionModifier("char", new AliasModifier("chr"));
        this.registerFunctionModifier("concat", new AliasModifier("||"));
        this.registerFunctionModifier("lcase", new AliasModifier("lower"));
        this.registerFunctionModifier("left", new LeftOrRightFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("right", new LeftOrRightFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("substring", new AliasModifier("substr"));
        this.registerFunctionModifier("ucase", new AliasModifier("upper"));
        this.registerFunctionModifier("dayname", new MonthOrDayNameFunctionModifier(this.getLanguageFactory(), "Day"));
        this.registerFunctionModifier("dayofweek", new ExtractFunctionModifier());
        this.registerFunctionModifier("dayofmonth", new ExtractFunctionModifier());
        this.registerFunctionModifier("dayofyear", new ExtractFunctionModifier());
        this.registerFunctionModifier("hour", new ExtractFunctionModifier());
        this.registerFunctionModifier("minute", new ExtractFunctionModifier());
        this.registerFunctionModifier("month", new ExtractFunctionModifier());
        this.registerFunctionModifier("monthname", new MonthOrDayNameFunctionModifier(this.getLanguageFactory(), "Month"));
        this.registerFunctionModifier("quarter", new ExtractFunctionModifier());
        this.registerFunctionModifier("second", new ExtractFunctionModifier());
        this.registerFunctionModifier("week", new ExtractFunctionModifier());
        this.registerFunctionModifier("year", new ExtractFunctionModifier());
        this.registerFunctionModifier("locate", new LocateFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("ifnull", new AliasModifier("coalesce"));
        this.registerFunctionModifier("parsetimestamp", new OracleFormatFunctionModifier("TO_TIMESTAMP("));
        this.registerFunctionModifier("formattimestamp", new OracleFormatFunctionModifier("TO_CHAR("));
        this.registerFunctionModifier("mod", new ModFunctionModifier("%", this.getLanguageFactory(), Arrays.asList(TypeFacility.RUNTIME_TYPES.BIG_INTEGER, TypeFacility.RUNTIME_TYPES.BIG_DECIMAL)));
        this.registerFunctionModifier("timestampadd", new EscapeSyntaxModifier());
        this.registerFunctionModifier("timestampdiff", new EscapeSyntaxModifier());
        this.registerFunctionModifier("array_get", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList(function.getParameters().get(0), Character.valueOf('['), function.getParameters().get(1), Character.valueOf(']'));
            }
        });
        this.registerFunctionModifier("array_length", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                if (function.getParameters().size() == 1) {
                    function.getParameters().add(new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER));
                }
                return null;
            }
        });
        ConvertModifier convertModifier = new ConvertModifier();
        convertModifier.addTypeMapping("boolean", 2);
        convertModifier.addTypeMapping("smallint", 3, 4);
        convertModifier.addTypeMapping("integer", 5);
        convertModifier.addTypeMapping("bigint", 6);
        convertModifier.addTypeMapping("real", 8);
        convertModifier.addTypeMapping("float8", 9);
        convertModifier.addTypeMapping("numeric(38)", 7);
        convertModifier.addTypeMapping("decimal", 10);
        convertModifier.addTypeMapping("char(1)", 1);
        convertModifier.addTypeMapping("varchar(4000)", 0);
        convertModifier.addTypeMapping("date", 11);
        convertModifier.addTypeMapping("time", 12);
        convertModifier.addTypeMapping("timestamp", 13);
        convertModifier.addConvert(12, 13, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList(function.getParameters().get(0), " + TIMESTAMP '1970-01-01'");
            }
        });
        convertModifier.addConvert(13, 12, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("cast(date_trunc('second', ", function.getParameters().get(0), ") AS time)");
            }
        });
        convertModifier.addConvert(11, 0, new ConvertModifier.FormatModifier("to_char", "YYYY-MM-DD"));
        convertModifier.addConvert(12, 0, new ConvertModifier.FormatModifier("to_char", "HH24:MI:SS"));
        convertModifier.addConvert(13, 0, new ConvertModifier.FormatModifier("to_char", "YYYY-MM-DD HH24:MI:SS.US"));
        convertModifier.addConvert(2, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                Expression stringValue = (Expression)function.getParameters().get(0);
                return Arrays.asList("CASE WHEN ", stringValue, " THEN 'true' WHEN not(", stringValue, ") THEN 'false' END");
            }
        });
        convertModifier.addSourceConversion(new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                ((Literal)function.getParameters().get(1)).setValue((Object)"integer");
                return null;
            }
        }, 2);
        this.registerFunctionModifier("convert", convertModifier);
    }

    @Override
    public String translateLiteralBoolean(Boolean booleanValue) {
        if (booleanValue.booleanValue()) {
            return "TRUE";
        }
        return "FALSE";
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        return "DATE '" + this.formatDateValue(dateValue) + "'";
    }

    @Override
    public String translateLiteralTime(Time timeValue) {
        return "TIME '" + this.formatDateValue(timeValue) + "'";
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "TIMESTAMP '" + this.formatDateValue(timestampValue) + "'";
    }

    @Override
    public int getTimestampNanoPrecision() {
        return 6;
    }

    @Override
    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        if (limit.getRowOffset() > 0) {
            return Arrays.asList("LIMIT ", limit.getRowLimit(), " OFFSET ", limit.getRowOffset());
        }
        return null;
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        Like like;
        if (obj instanceof AggregateFunction) {
            AggregateFunction agg = (AggregateFunction)obj;
            if (agg.getParameters().size() == 1 && TypeFacility.RUNTIME_TYPES.BOOLEAN.equals(((Expression)agg.getParameters().get(0)).getType())) {
                if (agg.getName().equalsIgnoreCase("MIN")) {
                    agg.setName("bool_and");
                } else if (agg.getName().equalsIgnoreCase("MAX")) {
                    agg.setName("bool_or");
                }
            }
        } else if (obj instanceof Like && (like = (Like)obj).getMode() == Like.MatchMode.REGEX) {
            return Arrays.asList(like.getLeftExpression(), like.isNegated() ? " !~ " : " ~ ", like.getRightExpression());
        }
        return super.translate(obj, context);
    }

    @Override
    public ExecutionFactory.NullOrder getDefaultNullOrder() {
        return ExecutionFactory.NullOrder.HIGH;
    }

    public boolean supportsOrderByNullOrdering() {
        return this.getDatabaseVersion().compareTo(EIGHT_4) >= 0;
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("ABS");
        supportedFunctions.add("ACOS");
        supportedFunctions.add("ASIN");
        supportedFunctions.add("ATAN");
        supportedFunctions.add("ATAN2");
        supportedFunctions.add("BITAND");
        supportedFunctions.add("BITNOT");
        supportedFunctions.add("BITOR");
        supportedFunctions.add("BITXOR");
        supportedFunctions.add("CEILING");
        supportedFunctions.add("COS");
        supportedFunctions.add("COT");
        supportedFunctions.add("DEGREES");
        supportedFunctions.add("EXP");
        supportedFunctions.add("FLOOR");
        supportedFunctions.add("LOG");
        supportedFunctions.add("LOG10");
        supportedFunctions.add("MOD");
        supportedFunctions.add("PI");
        supportedFunctions.add("POWER");
        supportedFunctions.add("RADIANS");
        supportedFunctions.add("ROUND");
        supportedFunctions.add("SIGN");
        supportedFunctions.add("SIN");
        supportedFunctions.add("SQRT");
        supportedFunctions.add("TAN");
        supportedFunctions.add("ASCII");
        supportedFunctions.add("CHR");
        supportedFunctions.add("CHAR");
        supportedFunctions.add("||");
        supportedFunctions.add("CONCAT");
        supportedFunctions.add("INITCAP");
        supportedFunctions.add("LCASE");
        supportedFunctions.add("LEFT");
        supportedFunctions.add("LENGTH");
        supportedFunctions.add("LOCATE");
        supportedFunctions.add("LOWER");
        supportedFunctions.add("LPAD");
        supportedFunctions.add("LTRIM");
        supportedFunctions.add("REPEAT");
        supportedFunctions.add("REPLACE");
        supportedFunctions.add("RIGHT");
        supportedFunctions.add("RPAD");
        supportedFunctions.add("RTRIM");
        supportedFunctions.add("SUBSTRING");
        supportedFunctions.add("trim");
        supportedFunctions.add("UCASE");
        supportedFunctions.add("UPPER");
        supportedFunctions.add("DAYNAME");
        supportedFunctions.add("DAYOFMONTH");
        supportedFunctions.add("DAYOFWEEK");
        supportedFunctions.add("DAYOFYEAR");
        supportedFunctions.add("HOUR");
        supportedFunctions.add("MINUTE");
        supportedFunctions.add("MONTH");
        supportedFunctions.add("MONTHNAME");
        supportedFunctions.add("QUARTER");
        supportedFunctions.add("SECOND");
        if (this.getDatabaseVersion().compareTo(EIGHT_2) >= 0) {
            supportedFunctions.add("TIMESTAMPADD");
            supportedFunctions.add("TIMESTAMPDIFF");
        }
        supportedFunctions.add("WEEK");
        supportedFunctions.add("YEAR");
        supportedFunctions.add("CAST");
        supportedFunctions.add("CONVERT");
        supportedFunctions.add("IFNULL");
        supportedFunctions.add("NVL");
        supportedFunctions.add("COALESCE");
        supportedFunctions.add("array_get");
        supportedFunctions.add("array_length");
        supportedFunctions.add("formattimestamp");
        supportedFunctions.add("parsetimestamp");
        return supportedFunctions;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return this.getDatabaseVersion().compareTo(EIGHT_2) >= 0;
    }

    public boolean supportsCommonTableExpressions() {
        return this.getDatabaseVersion().compareTo(EIGHT_4) >= 0;
    }

    public boolean supportsArrayAgg() {
        return this.getDatabaseVersion().compareTo(EIGHT_4) >= 0;
    }

    public boolean supportsElementaryOlapOperations() {
        return this.getDatabaseVersion().compareTo(EIGHT_4) >= 0;
    }

    public boolean supportsWindowDistinctAggregates() {
        return false;
    }

    public boolean supportsSimilarTo() {
        return true;
    }

    public boolean supportsLikeRegex() {
        return true;
    }

    public boolean supportsOnlyFormatLiterals() {
        return true;
    }

    public boolean supportsFormatLiteral(String literal, ExecutionFactory.Format format) {
        if (format == ExecutionFactory.Format.NUMBER) {
            return false;
        }
        return OracleFormatFunctionModifier.supportsLiteral(literal);
    }

    public boolean supportsArrayType() {
        return true;
    }
}

