/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common;

import java.util.LinkedList;
import java.util.List;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.ParameterizedBatchHandler;
import org.mariadb.jdbc.internal.common.Protocol;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.query.ParameterizedQuery;
import org.mariadb.jdbc.internal.common.queryresults.ModifyQueryResult;
import org.mariadb.jdbc.internal.common.queryresults.QueryResult;

public final class DefaultParameterizedBatchHandler
implements ParameterizedBatchHandler {
    private final List<ParameterizedQuery> queries = new LinkedList<ParameterizedQuery>();
    private final Protocol protocol;

    public DefaultParameterizedBatchHandler(Protocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public void addToBatch(ParameterizedQuery query) {
        this.queries.add(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws QueryException {
        Protocol protocol = this.protocol;
        synchronized (protocol) {
            int[] retArray = new int[this.queries.size()];
            int i = 0;
            for (ParameterizedQuery query : this.queries) {
                QueryResult qr = this.protocol.executeQuery(query);
                if (qr instanceof ModifyQueryResult) {
                    retArray[i++] = (int)((ModifyQueryResult)qr).getUpdateCount();
                    continue;
                }
                throw new QueryException("One of the queries in the batch returned a result set", -1, SQLExceptionMapper.SQLStates.UNDEFINED_SQLSTATE.getSqlState());
            }
            this.queries.clear();
            return retArray;
        }
    }
}

