/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CustomReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.CustomDataSourceDefinition;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.BeanReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.VirtualReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.common.JdkTimeZonesList;
import com.jaspersoft.jasperserver.war.dto.ReportDataSourceWrapper;
import com.jaspersoft.jasperserver.war.dto.StringOption;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class ReportDataSourceAction
extends FormAction
implements ApplicationContextAware {
    private static final String ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS = "resourceIdNotSupportedSymbols";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String FORM_OBJECT_KEY = "dataResource";
    public static final String DATASOURCEURI_PARAM = "resource";
    public static final String PARENT_FOLDER_ATTR = "parentFolder";
    private static final String DATASOURCE_TREE_DATA_PROVIDER = "dsTreeDataProvider";
    private RepositoryService repository;
    private ResourceFactory dataSourceMappings;
    private JdkTimeZonesList timezones;
    private ConfigurationBean configuration;
    private JasperServerConstImpl constants = new JasperServerConstImpl();
    private EngineService engine;
    private String queryLanguageFlowAttribute;
    private MessageSource messageSource;
    private CustomReportDataSourceServiceFactory customDataSourceFactory;
    ApplicationContext ctx;
    private TreeDataProvider typedTreeDataProvider;

    public ReportDataSourceAction() {
        this.setFormObjectClass(ReportDataSourceWrapper.class);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.ctx = arg0;
    }

    public Event initAction(RequestContext context) throws Exception {
        ReportDataSourceWrapper formObject = (ReportDataSourceWrapper)this.getFormObject(context);
        if (formObject.isSubflowMode() && formObject.getAllDatasources() == null) {
            ArrayList<String> allDataSources = null;
            String dataSourceType = this.getQueryLanguage(context);
            if (dataSourceType != null && dataSourceType.trim().equalsIgnoreCase("olapClientConnection")) {
                FilterCriteria criteria = FilterCriteria.createFilter(JdbcReportDataSource.class);
                ResourceLookup[] jdbcLookups = this.repository.findResource(JasperServerUtil.getExecutionContext(context), criteria);
                criteria = FilterCriteria.createFilter(JndiJdbcReportDataSource.class);
                ResourceLookup[] jndiLookups = this.repository.findResource(JasperServerUtil.getExecutionContext(context), criteria);
                if (jdbcLookups != null && jdbcLookups.length != 0) {
                    this.log("Found Jdbc DataSource lookups size= " + jdbcLookups.length);
                    allDataSources = new ArrayList(jdbcLookups.length);
                    for (ResourceLookup lookup : jdbcLookups) {
                        allDataSources.add(lookup.getURIString());
                    }
                }
                if (jndiLookups != null && jndiLookups.length != 0) {
                    this.log("Found JndiJdbc DataSource lookups size= " + jndiLookups.length);
                    if (allDataSources == null) {
                        allDataSources = new ArrayList(jndiLookups.length);
                    }
                    for (ResourceLookup lookup : jndiLookups) {
                        allDataSources.add(lookup.getURIString());
                    }
                }
                Collections.sort(allDataSources, String.CASE_INSENSITIVE_ORDER);
            } else {
                ResourceLookup[] lookups = this.engine.getDataSources(JasperServerUtil.getExecutionContext(context), dataSourceType);
                if (lookups != null && lookups.length != 0) {
                    allDataSources = new ArrayList<String>(lookups.length);
                    this.log("Found ReportDataSource lookups size=" + lookups.length);
                    for (ResourceLookup dr : lookups) {
                        allDataSources.add(dr.getURIString());
                    }
                }
            }
            formObject.setAllDatasources(allDataSources);
            this.getAllFolders(formObject);
            String folderURI = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (folderURI == null) {
                folderURI = "/";
            }
            if (formObject.getReportDataSource() != null) {
                formObject.getReportDataSource().setParentFolder((String)context.getFlowScope().get(PARENT_FOLDER_ATTR));
            }
        }
        this.log("Type of datasource=" + formObject.getType() + " Mode=" + formObject.getMode());
        context.getFlowScope().put("constants", (Object)this.constants);
        context.getExternalContext().getSessionMap().put(DATASOURCE_TREE_DATA_PROVIDER, (Object)this.typedTreeDataProvider);
        context.getFlowScope().put(ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS, (Object)this.configuration.getResourceIdNotSupportedSymbols());
        return this.success();
    }

    private void getAllFolders(ReportDataSourceWrapper wrapper) {
        List allFolders = this.repository.getAllFolders(null);
        wrapper.setAllFolders(new ArrayList());
        for (int i = 0; i < allFolders.size(); ++i) {
            String folderUri = ((Folder)allFolders.get(i)).getURIString();
            wrapper.getAllFolders().add(folderUri);
        }
    }

    public Event handleTypeSelection(RequestContext context) throws Exception {
        ReportDataSourceWrapper formObject = (ReportDataSourceWrapper)this.getFormObject(context);
        this.log("Type=" + formObject.getType());
        String dsType = formObject.getType();
        ReportDataSource ds = formObject.getReportDataSource();
        if (ds == null) {
            ds = this.newReportDataSource(dsType);
            formObject.setReportDataSource(ds);
        }
        if (JdbcReportDataSource.class.isAssignableFrom(ds.getClass())) {
            if (dsType.equals(JasperServerConstImpl.getJDBCDatasourceType())) {
                formObject.setReportDataSource(this.newReportDataSource(dsType, ds));
            } else {
                formObject.setReportDataSource(this.newReportDataSource(dsType));
            }
        } else if (JndiJdbcReportDataSource.class.isAssignableFrom(ds.getClass())) {
            if (dsType.equals(JasperServerConstImpl.getJNDIDatasourceType())) {
                formObject.setReportDataSource(this.newReportDataSource(dsType, ds));
            } else {
                formObject.setReportDataSource(this.newReportDataSource(dsType));
            }
        } else if (VirtualReportDataSource.class.isAssignableFrom(ds.getClass())) {
            if (dsType.equals(JasperServerConstImpl.getVirtualDatasourceType())) {
                formObject.setReportDataSource(this.newReportDataSource(dsType, ds));
            } else {
                formObject.setReportDataSource(this.newReportDataSource(dsType));
            }
        } else if (dsType.equals(JasperServerConstImpl.getBeanDatasourceType())) {
            formObject.setReportDataSource(this.newReportDataSource(dsType, ds));
        } else {
            formObject.setReportDataSource(this.newReportDataSource(dsType));
        }
        formObject.getReportDataSource().setParentFolder((String)context.getFlowScope().get(PARENT_FOLDER_ATTR));
        return this.success();
    }

    public Event prepareChooseType(RequestContext context) throws Exception {
        List dataSourceTypes = this.configuration.getDataSourceTypes();
        String queryLanguage = this.getQueryLanguage(context);
        if (queryLanguage != null) {
            Set supportedTypes = this.engine.getDataSourceTypes(JasperServerUtil.getExecutionContext(context), queryLanguage);
            Iterator iter = dataSourceTypes.iterator();
            while (iter.hasNext()) {
                ConfigurationBean.DataSourceType type = (ConfigurationBean.DataSourceType)iter.next();
                if (supportedTypes.contains(type.getType())) continue;
                iter.remove();
            }
        }
        HashMap<String, String> typeMap = new HashMap<String, String>();
        for (ConfigurationBean.DataSourceType type : dataSourceTypes) {
            typeMap.put(type.getTypeValue(), this.messageSource.getMessage(type.getLabelMessage(), null, type.getTypeValue(), LocaleContextHolder.getLocale()));
        }
        for (CustomDataSourceDefinition cds : this.customDataSourceFactory.getDefinitions()) {
            typeMap.put(cds.getName(), this.messageSource.getMessage(cds.getLabelName(), null, LocaleContextHolder.getLocale()));
        }
        context.getRequestScope().put("allTypes", typeMap);
        return this.success();
    }

    public Event preparePropsForm(RequestContext context) throws Exception {
        TimeZone zone;
        StringOption option;
        ReportDataSourceWrapper formObject = (ReportDataSourceWrapper)this.getFormObject(context);
        ReportDataSource ds = formObject.getReportDataSource();
        Locale displayLocale = LocaleContextHolder.getLocale();
        String selectedTimezone = null;
        if (ds instanceof JdbcReportDataSource) {
            selectedTimezone = ((JdbcReportDataSource)ds).getTimezone();
        }
        if (ds instanceof JndiJdbcReportDataSource) {
            selectedTimezone = ((JndiJdbcReportDataSource)ds).getTimezone();
        }
        ArrayList<StringOption> timezoneList = this.timezones.getTimeZones(displayLocale);
        timezoneList = new ArrayList<StringOption>(timezoneList);
        if (selectedTimezone != null && selectedTimezone.length() > 0 && !timezoneList.contains(option = new StringOption(selectedTimezone, (zone = TimeZone.getTimeZone(selectedTimezone)).getDisplayName(displayLocale)))) {
            timezoneList.add(0, option);
        }
        context.getFlowScope().put("timezones", timezoneList);
        context.getFlowScope().put("selectedTimezone", (Object)selectedTimezone);
        if (ds instanceof CustomReportDataSource) {
            CustomReportDataSource cds = (CustomReportDataSource)ds;
            CustomDataSourceDefinition customDef = this.customDataSourceFactory.getDefinition(cds);
            customDef.setDefaultValues(cds);
            formObject.setCustomProperties(customDef.getEditablePropertyDefinitions());
            formObject.setCustomDatasourceLabel(customDef.getLabelName());
        }
        return this.success();
    }

    public Event saveLookup(RequestContext context) throws Exception {
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        this.log("user selected a reusable ReportDataSource");
        String selectedUri = wrapper.getSelectedUri();
        if (selectedUri != null && !selectedUri.equals("")) {
            Resource resource = this.repository.getResource(null, selectedUri);
            wrapper.setReportDataSource((ReportDataSource)resource);
        }
        return this.success();
    }

    public Event saveNone(RequestContext context) throws Exception {
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        this.log("user selected no ReportDataSource");
        wrapper.setReportDataSource(null);
        return this.success();
    }

    public Event saveDatasource(RequestContext context) throws Exception {
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        this.log("Saving the datasource back ");
        if (wrapper.isStandAloneMode()) {
            if (wrapper.getType() != null) {
                ReportDataSource ds = wrapper.getReportDataSource();
                this.log("Saving DataSource name=" + ds.getName() + " datasource desc=" + ds.getDescription() + " in folder=" + ds.getParentFolder());
                if (ds.getName() != null) {
                    try {
                        this.repository.saveResource(null, (Resource)ds);
                    }
                    catch (JSDuplicateResourceException e) {
                        this.getFormErrors(context).rejectValue("reportDataSource.name", "ReportDataSourceValidator.error.duplicate");
                        return this.error();
                    }
                }
            }
            return this.yes();
        }
        return this.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event testJdbcDataSource(RequestContext context) throws Exception {
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        JdbcReportDataSource ds = (JdbcReportDataSource)wrapper.getReportDataSource();
        Connection conn = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("CreateConnection about to load Driver class '" + ds.getDriverClass() + "' at com.jaspersoft.jasperserver.war.action.ReportDataSourceAction.testJdbcDataSource\n"));
            }
            Class.forName(ds.getDriverClass());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("CreateConnection loaded Driver class '" + ds.getDriverClass() + "' at com.jaspersoft.jasperserver.war.action.ReportDataSourceAction.testJdbcDataSource\n"));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("CreateConnection about to getConnection URL='" + ds.getConnectionUrl() + ", User Name='" + ds.getUsername() + "' Password='" + ds.getPassword() + "', at com.jaspersoft.jasperserver.war.action.ReportDataSourceAction.testJdbcDataSource\n"));
            }
            conn = DriverManager.getConnection(ds.getConnectionUrl(), ds.getUsername(), ds.getPassword());
            context.getRequestScope().put("connection.test", (Object)(conn != null ? 1 : 0));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"CreateConnection successful at com.jaspersoft.jasperserver.war.action.ReportDataSourceAction.testJdbcDataSource\n");
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"exception testing jdbc data source", (Throwable)e);
            context.getRequestScope().put("connection.test", (Object)Boolean.FALSE);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return this.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event testJndiDataSource(RequestContext context) throws Exception {
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)wrapper.getReportDataSource();
        Connection conn = null;
        try {
            InitialContext ctx = new InitialContext();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("com.jaspersoft.jasperserver.war.action.ReportDataSourceAction.testJndiDataSource  About to look up DataSource at JNDI location: 'java:comp/env/" + ds.getJndiName() + "' \n"));
            }
            DataSource dataSource = (DataSource)ctx.lookup("java:comp/env/" + ds.getJndiName());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("com.jaspersoft.jasperserver.war.action.ReportDataSourceAction.testJndiDataSource  look up success: DataSource at JNDI location: 'java:comp/env/" + ds.getJndiName() + "' \n" + " About to do:  DataSource.getConnection \n"));
            }
            conn = dataSource.getConnection();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"com.jaspersoft.jasperserver.war.action.ReportDataSourceAction.testJndiDataSource  DataSource.getConnection success. \n");
            }
            context.getRequestScope().put("connection.test", (Object)(conn != null ? 1 : 0));
        }
        catch (Exception e) {
            context.getRequestScope().put("connection.test", (Object)Boolean.FALSE);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return this.success();
    }

    public Event testBeanDataSource(RequestContext context) throws Exception {
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        BeanReportDataSource ds = (BeanReportDataSource)wrapper.getReportDataSource();
        try {
            Object bean = this.ctx.getBean(ds.getBeanName());
            if (bean == null) {
                context.getRequestScope().put("connection.test", (Object)Boolean.FALSE);
                return this.success();
            }
            if (ds.getBeanMethod() == null) {
                context.getRequestScope().put("connection.test", (Object)(bean instanceof ReportDataSourceService));
            } else {
                try {
                    Method serviceMethod = bean.getClass().getMethod(ds.getBeanMethod(), null);
                    Object obj = serviceMethod.invoke(bean, null);
                    context.getRequestScope().put("connection.test", (Object)(obj != null ? 1 : 0));
                }
                catch (SecurityException e) {
                    context.getRequestScope().put("connection.test", (Object)Boolean.FALSE);
                }
            }
        }
        catch (Exception e) {
            context.getRequestScope().put("connection.test", (Object)Boolean.FALSE);
        }
        return this.success();
    }

    public Event validateDataSource(RequestContext context) throws Exception {
        Errors errors = this.getFormErrors(context);
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        this.getValidator().validate((Object)wrapper, errors);
        List fieldErrors = errors.getFieldErrors();
        if (fieldErrors != null && !fieldErrors.isEmpty()) {
            FieldError error = (FieldError)fieldErrors.get(0);
            String field = error.getField();
            if ("source".equals(field) || "selectedUri".equals(field)) {
                return this.result("chooseSource");
            }
            if ("type".equals(field)) {
                return this.result("chooseType");
            }
            if (JasperServerConstImpl.getJDBCDatasourceType().equals(wrapper.getType())) {
                return this.result("jdbcPropsForm");
            }
            if (JasperServerConstImpl.getJNDIDatasourceType().equals(wrapper.getType())) {
                return this.result("jndiPropsForm");
            }
            if (JasperServerConstImpl.getVirtualDatasourceType().equals(wrapper.getType())) {
                return this.result("virtualPropsForm");
            }
            if (JasperServerConstImpl.getBeanDatasourceType().equals(wrapper.getType())) {
                return this.result("beanPropsForm");
            }
            return this.result("customPropsForm");
        }
        return this.success();
    }

    public Object createFormObject(RequestContext context) {
        ReportDataSourceWrapper formObject = new ReportDataSourceWrapper();
        String resourceUri = context.getRequestParameters().get(DATASOURCEURI_PARAM);
        if (resourceUri != null && resourceUri.trim().length() != 0) {
            Resource resource = this.repository.getResource(null, resourceUri);
            if (resource == null) {
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{resourceUri});
            }
            this.log("Found resource with uri=" + resourceUri);
            formObject.setMode((byte)2);
            ReportDataSource dataSource = (ReportDataSource)resource;
            formObject.setType(this.getDataSourceMappings().getIdForClass(dataSource.getClass()));
            formObject.setReportDataSource(dataSource);
        }
        if (formObject.getReportDataSource() == null) {
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (parentFolder == null) {
                parentFolder = context.getRequestParameters().get("ParentFolderUri");
                context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)parentFolder);
            }
            if (parentFolder == null || parentFolder.trim().length() == 0) {
                parentFolder = "/";
            }
            this.log("Datasource flow: Stand alone new mode");
            formObject.setMode((byte)1);
            formObject.setType(JasperServerConstImpl.getJNDIDatasourceType());
            formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
            ReportDataSource jndiSource = this.newReportDataSource(JasperServerConstImpl.getJNDIDatasourceType());
            jndiSource.setParentFolder(parentFolder);
            jndiSource.setVersion(-1);
            formObject.setReportDataSource(jndiSource);
        }
        return formObject;
    }

    private ReportDataSource newReportDataSource(String dsType) {
        CustomDataSourceDefinition cdsd;
        if (this.customDataSourceFactory != null && (cdsd = this.customDataSourceFactory.getDefinitionByName(dsType)) != null) {
            return this.customDataSourceFactory.createDataSource(dsType);
        }
        return (ReportDataSource)this.getDataSourceMappings().newResource(null, dsType);
    }

    private ReportDataSource newReportDataSource(String dsType, ReportDataSource oldDS) {
        ReportDataSource newDS = this.newReportDataSource(dsType);
        newDS.setParentFolder(oldDS.getParentFolder());
        newDS.setName(oldDS.getName());
        newDS.setLabel(oldDS.getLabel());
        newDS.setDescription(oldDS.getDescription());
        newDS.setVersion(oldDS.getVersion());
        if (oldDS instanceof JdbcReportDataSource) {
            JdbcReportDataSource oldJdbc = (JdbcReportDataSource)oldDS;
            JdbcReportDataSource newJdbc = (JdbcReportDataSource)newDS;
            newJdbc.setDriverClass(oldJdbc.getDriverClass());
            newJdbc.setConnectionUrl(oldJdbc.getConnectionUrl());
            newJdbc.setPassword(oldJdbc.getPassword());
            newJdbc.setTimezone(oldJdbc.getTimezone());
            newJdbc.setUsername(oldJdbc.getUsername());
        } else if (oldDS instanceof JndiJdbcReportDataSource) {
            JndiJdbcReportDataSource oldJndi = (JndiJdbcReportDataSource)oldDS;
            JndiJdbcReportDataSource newJndi = (JndiJdbcReportDataSource)newDS;
            newJndi.setJndiName(oldJndi.getJndiName());
            newJndi.setTimezone(oldJndi.getTimezone());
        } else if (oldDS instanceof BeanReportDataSource) {
            BeanReportDataSource oldBean = (BeanReportDataSource)oldDS;
            BeanReportDataSource newBean = (BeanReportDataSource)newDS;
            newBean.setBeanMethod(oldBean.getBeanMethod());
            newBean.setBeanName(oldBean.getBeanName());
        }
        return newDS;
    }

    public JdkTimeZonesList getTimezones() {
        return this.timezones;
    }

    public void setTimezones(JdkTimeZonesList timezones) {
        this.timezones = timezones;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public ConfigurationBean getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    public ResourceFactory getDataSourceMappings() {
        return this.dataSourceMappings;
    }

    public void setDataSourceMappings(ResourceFactory dataSourceMappings) {
        this.dataSourceMappings = dataSourceMappings;
    }

    private void log(String text) {
        this.log.debug((Object)text);
    }

    public static String getDATASOURCEURI_PARAM() {
        return DATASOURCEURI_PARAM;
    }

    public static String getFORM_OBJECT_KEY() {
        return FORM_OBJECT_KEY;
    }

    protected void initBinder(RequestContext requestContext, DataBinder binder) {
        super.initBinder(requestContext, binder);
        binder.registerCustomEditor(String.class, "reportDataSource.beanMethod", (PropertyEditor)new StringTrimmerEditor(true));
        binder.registerCustomEditor(String.class, "reportDataSource.timezone", (PropertyEditor)new StringTrimmerEditor(true));
    }

    protected String getQueryLanguage(RequestContext context) {
        return context.getFlowScope().getString(this.getQueryLanguageFlowAttribute());
    }

    public String getQueryLanguageFlowAttribute() {
        return this.queryLanguageFlowAttribute;
    }

    public void setQueryLanguageFlowAttribute(String queryLanguageFlowAttribute) {
        this.queryLanguageFlowAttribute = queryLanguageFlowAttribute;
    }

    public EngineService getEngine() {
        return this.engine;
    }

    public void setEngine(EngineService engine) {
        this.engine = engine;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public CustomReportDataSourceServiceFactory getCustomDataSourceFactory() {
        return this.customDataSourceFactory;
    }

    public void setCustomDataSourceFactory(CustomReportDataSourceServiceFactory customDataSourceFactory) {
        this.customDataSourceFactory = customDataSourceFactory;
    }

    public void setDataSourceTreeDataProvider(TreeDataProvider typedTreeDataProvider) {
        this.typedTreeDataProvider = typedTreeDataProvider;
    }
}

