/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.amazon.client;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.rds.AmazonRDSClient;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.redshift.AmazonRedshiftClient;
import com.amazonaws.services.redshift.model.Cluster;
import com.jaspersoft.jasperserver.api.JSShowOnlyErrorMessage;
import com.jaspersoft.jasperserver.war.amazon.client.AwsDataSourceService;
import com.jaspersoft.jasperserver.war.dto.AwsDBInstanceDTO;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class AwsDataSourceServiceImpl
implements AwsDataSourceService {
    public static final String RDS = "rds";
    public static final String Redshift = "redshift";
    public static final String jdbcUrl = "jdbcUrl";
    public static final String jdbcDriverClass = "jdbcDriverClass";
    public static final String ACCESS_DENIED = "accessdenied";
    public static final String INVALID_CLIENT_TOKEN_ID = "invalidclienttokenid";
    public static final String SIGNATURE_DOES_NOT_MATCH = "signaturedoesnotmatch";
    private String awsDataSourceActiveStatus;
    private MessageSource messageSource;
    private Map<String, Map<String, Object>> jdbcConnectionMap;
    private static final Log log = LogFactory.getLog(AwsDataSourceServiceImpl.class);

    @Override
    public List<AwsDBInstanceDTO> getAwsDBInstances(AWSCredentials awsCredentials, String amazonDBService, String endpoint) {
        try {
            if (amazonDBService.toLowerCase().equals(RDS)) {
                AmazonRDSClient rdsClient = new AmazonRDSClient(awsCredentials);
                if (endpoint != null) {
                    rdsClient.setEndpoint("rds." + endpoint);
                }
                return this.toRDSInstancesDTOs(this.getRdsInstances(rdsClient), amazonDBService);
            }
            if (amazonDBService.toLowerCase().equals(Redshift)) {
                AmazonRedshiftClient redshiftClient = new AmazonRedshiftClient(awsCredentials);
                if (endpoint != null) {
                    redshiftClient.setEndpoint("redshift." + endpoint);
                }
                return this.toRedshiftInstancesDTOs(this.getRedshiftInstances(redshiftClient), amazonDBService);
            }
            return new ArrayList<AwsDBInstanceDTO>();
        }
        catch (AmazonServiceException ex) {
            log.warn((Object)("Loading AWS data source metadata for " + amazonDBService + ": " + ex.getMessage()));
            String errorCode = ex.getErrorCode();
            if (ex.getStatusCode() == 403 && errorCode != null) {
                if ((errorCode = errorCode.toLowerCase()).equals(ACCESS_DENIED)) {
                    return this.generateDBServiceInfoStatus(amazonDBService, "resource.dataSource.aws.access.denied");
                }
                if (errorCode.equals(INVALID_CLIENT_TOKEN_ID)) {
                    throw new JSShowOnlyErrorMessage(this.messageSource.getMessage("aws.exception.datasource.accessKey.invalid", null, LocaleContextHolder.getLocale()));
                }
                if (errorCode.equals(SIGNATURE_DOES_NOT_MATCH)) {
                    throw new JSShowOnlyErrorMessage(this.messageSource.getMessage("aws.exception.datasource.secretKey.invalid", null, LocaleContextHolder.getLocale()));
                }
            }
            return this.generateDBServiceInfoStatus(amazonDBService, "[" + ex.getMessage() + "]");
        }
        catch (AmazonClientException ex) {
            if (ex.getCause() instanceof UnknownHostException) {
                return this.generateDBServiceInfoStatus(endpoint, "resource.dataSource.aws.unknown.host");
            }
            return this.generateDBServiceInfoStatus(amazonDBService, "[" + ex.getMessage() + "]");
        }
    }

    protected List<DBInstance> getRdsInstances(AmazonRDSClient rdsClient) {
        return rdsClient.describeDBInstances().getDBInstances();
    }

    protected List<Cluster> getRedshiftInstances(AmazonRedshiftClient redshiftClient) {
        return redshiftClient.describeClusters().getClusters();
    }

    private List<AwsDBInstanceDTO> toRDSInstancesDTOs(List<DBInstance> dbInstances, String amazonDBService) {
        ArrayList<AwsDBInstanceDTO> awsDBInstanceDTOs = new ArrayList<AwsDBInstanceDTO>();
        if (dbInstances != null && dbInstances.size() > 0) {
            for (DBInstance dbInstance : dbInstances) {
                if (!dbInstance.getDBInstanceStatus().toLowerCase().equals(this.awsDataSourceActiveStatus)) continue;
                AwsDBInstanceDTO awsDBInstanceDTO = new AwsDBInstanceDTO();
                awsDBInstanceDTO.setdBInstanceIdentifier(dbInstance.getDBInstanceIdentifier());
                awsDBInstanceDTO.setdBName(dbInstance.getDBName());
                awsDBInstanceDTO.setEngine(dbInstance.getEngine());
                awsDBInstanceDTO.setEngineVersion(dbInstance.getEngineVersion());
                awsDBInstanceDTO.setAddress(dbInstance.getEndpoint().getAddress());
                awsDBInstanceDTO.setPort(dbInstance.getEndpoint().getPort());
                awsDBInstanceDTO.setAmazonDbService(amazonDBService.toLowerCase());
                this.updateWithConnectionUrl(awsDBInstanceDTO);
                awsDBInstanceDTOs.add(awsDBInstanceDTO);
            }
        } else {
            return this.generateDBServiceInfoStatus(amazonDBService, "resource.dataSource.aws.empty");
        }
        return awsDBInstanceDTOs;
    }

    private List<AwsDBInstanceDTO> toRedshiftInstancesDTOs(List<Cluster> dbClusters, String amazonDBService) {
        ArrayList<AwsDBInstanceDTO> awsDBInstanceDTOs = new ArrayList<AwsDBInstanceDTO>();
        if (dbClusters != null && dbClusters.size() > 0) {
            for (Cluster dbCluster : dbClusters) {
                if (!dbCluster.getClusterStatus().toLowerCase().equals(this.awsDataSourceActiveStatus)) continue;
                AwsDBInstanceDTO awsDBInstanceDTO = new AwsDBInstanceDTO();
                awsDBInstanceDTO.setdBInstanceIdentifier(dbCluster.getClusterIdentifier());
                awsDBInstanceDTO.setdBName(dbCluster.getDBName());
                awsDBInstanceDTO.setEngine("postgresql");
                awsDBInstanceDTO.setEngineVersion(null);
                awsDBInstanceDTO.setAddress(dbCluster.getEndpoint().getAddress());
                awsDBInstanceDTO.setPort(dbCluster.getEndpoint().getPort());
                awsDBInstanceDTO.setAmazonDbService(amazonDBService.toLowerCase());
                this.updateWithConnectionUrl(awsDBInstanceDTO);
                awsDBInstanceDTOs.add(awsDBInstanceDTO);
            }
        } else {
            return this.generateDBServiceInfoStatus(amazonDBService, "resource.dataSource.aws.empty");
        }
        return awsDBInstanceDTOs;
    }

    private List<AwsDBInstanceDTO> generateDBServiceInfoStatus(String amazonDBService, String statusMessageKey) {
        ArrayList<AwsDBInstanceDTO> awsDBInstanceDTOs = new ArrayList<AwsDBInstanceDTO>();
        AwsDBInstanceDTO awsDBInstanceDTO = new AwsDBInstanceDTO();
        String statusMessage = this.messageSource.getMessage(statusMessageKey, (Object[])new String[]{amazonDBService}, LocaleContextHolder.getLocale());
        awsDBInstanceDTO.setdBInstanceIdentifier(statusMessage);
        awsDBInstanceDTO.setAmazonDbService(amazonDBService);
        awsDBInstanceDTOs.add(awsDBInstanceDTO);
        return awsDBInstanceDTOs;
    }

    private void updateWithConnectionUrl(AwsDBInstanceDTO awsDBInstanceDTO) {
        for (String dbType : this.jdbcConnectionMap.keySet()) {
            if (!awsDBInstanceDTO.getEngine().startsWith(dbType)) continue;
            Map<String, Object> dbProperties = this.jdbcConnectionMap.get(dbType);
            awsDBInstanceDTO.setJdbcTemplate((String)dbProperties.get(jdbcUrl));
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("dbHost", awsDBInstanceDTO.getAddress());
            values.put("dbPort", String.valueOf(awsDBInstanceDTO.getPort()));
            values.put("dbName", awsDBInstanceDTO.getdBName());
            StrSubstitutor sub = new StrSubstitutor(values, "$[", "]");
            awsDBInstanceDTO.setJdbcUrl(sub.replace(dbProperties.get(jdbcUrl)));
            awsDBInstanceDTO.setJdbcDriverClass((String)dbProperties.get(jdbcDriverClass));
            break;
        }
    }

    public void setJdbcConnectionMap(Map<String, Map<String, Object>> jdbcConnectionMap) {
        this.jdbcConnectionMap = jdbcConnectionMap;
    }

    public void setAwsDataSourceActiveStatus(String awsDataSourceActiveStatus) {
        this.awsDataSourceActiveStatus = awsDataSourceActiveStatus;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

