/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.cache;

import com.jaspersoft.jasperserver.war.cascade.cache.SessionCache;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;

public class CacheCleaner
extends TimerTask {
    private volatile Map<String, SessionCache> userCachePool;
    private long userCacheTimeout;

    public CacheCleaner(Map<String, SessionCache> userCachePool, long userCacheTimeout) {
        this.userCachePool = userCachePool;
        this.userCacheTimeout = userCacheTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long curTime = System.currentTimeMillis();
        Map<String, SessionCache> map = this.userCachePool;
        synchronized (map) {
            Iterator<String> keyIterator = this.userCachePool.keySet().iterator();
            while (keyIterator.hasNext()) {
                String key = keyIterator.next();
                SessionCache cache = this.userCachePool.get(key);
                if (curTime - cache.getLastInteraction() <= this.userCacheTimeout) continue;
                keyIterator.remove();
            }
        }
    }
}

